/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.SourceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifyCommand
extends SourceCommand {
    private Object newValue;
    private Map<Object, Object> oldValues = null;

    protected ModifyCommand(Object source, Object newValue) {
        super(source);
        this.newValue = newValue;
    }

    protected ModifyCommand(Collection<?> sources, Object newValue) {
        super(sources);
        this.newValue = newValue;
    }

    protected ModifyCommand(ISourceProvider sourceProvider, Object newValue) {
        super(sourceProvider);
        this.newValue = newValue;
    }

    @Override
    public int getType() {
        return 3;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Map<Object, Object> getOldValues() {
        if (this.oldValues == null) {
            this.oldValues = new HashMap<Object, Object>();
            for (Object source : this.getSources()) {
                this.oldValues.put(source, this.getValue(source));
            }
        }
        return this.oldValues;
    }

    public Object getOldValue(Object source) {
        return this.getOldValues().get(source);
    }

    protected abstract Object getValue(Object var1);

    @Override
    public boolean canExecute() {
        return !this.isSameValue();
    }

    protected boolean isSameValue() {
        for (Object source : this.getSources()) {
            Object oldValue = this.getOldValue(source);
            if (this.isSameValue(oldValue, this.newValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        this.getOldValues();
        super.execute();
    }

    @Override
    public void redo() {
        this.setNewValues();
        super.redo();
    }

    @Override
    public void undo() {
        this.setOldValues();
        super.undo();
    }

    protected void setNewValues() {
        for (Object source : this.getSources()) {
            this.setValue(source, this.newValue);
        }
    }

    protected void setOldValues() {
        for (Object source : this.getSources()) {
            this.setValue(source, this.getOldValue(source));
        }
    }

    protected abstract void setValue(Object var1, Object var2);

    @Override
    public void dispose() {
        this.newValue = null;
        this.oldValues = null;
        super.dispose();
    }

    protected boolean isSameValue(Object oldValue, Object newValue) {
        return oldValue == newValue || oldValue != null && oldValue.equals(newValue);
    }

    protected void setNewValue(Object newValue) {
        if (this.newValue != null) {
            return;
        }
        this.newValue = newValue;
    }
}

