/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.IWorkbook;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesPropertiesDialog;
import org.xmind.ui.internal.audionotes.AudioNotesUtils;
import org.xmind.ui.internal.audionotes.AudioNotesViewer2;
import org.xmind.ui.internal.audionotes.AudioNotesViewerPage;
import org.xmind.ui.internal.audionotes.ConfirmCloseDialog;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;

public class InsertAudioNotesDialog
extends Dialog
implements ISelectionChangedListener,
IPartListener,
IAudioNotesAgentListener {
    private static final List<Object> EMPTY_TOPICS = Collections.emptyList();
    private IWorkbenchWindow activeWindow;
    private IWorkbenchPage thisPage;
    private IWorkbenchPart contributingPart;
    private ITopic parentTopic;
    private ITopic sourceTopic;
    private ITopic selectedTopic;
    private StartRecordingCommand command;
    private RecordPage page;

    protected InsertAudioNotesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
        this.setBlockOnOpen(false);
    }

    protected void initializeBounds() {
        Rectangle rect = this.getParentShell().getBounds();
        this.getShell().setBounds(rect.x + rect.width * 3 / 5, rect.y + rect.height / 7, 410, 340);
        super.initializeBounds();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.InsertAudioNotesDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        VerifyUI20141031.getUsageDataCollector().increase("InsertAudioNotesCount");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 255;
        composite.setLayoutData((Object)data);
        this.page = new RecordPage(null);
        this.page.createControl(composite);
        this.thisPage = this.activeWindow.getActivePage();
        this.partActivated((IWorkbenchPart)this.thisPage.getActiveEditor());
        this.thisPage.addPartListener((IPartListener)this);
        this.command = new StartRecordingCommand(this.selectedTopic);
        this.getCommandStack().execute((Command)this.command);
        this.sourceTopic = (ITopic)this.command.getSource();
        this.page.setSourceTopic(this.sourceTopic);
        this.page.imageLabel.setText(Messages.AudioNotesDialog_Button_Start);
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        agent.addAudioListener(this);
        if (this.sourceTopic != null) {
            try {
                agent.createRecordClientAndStartSession(this.sourceTopic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return composite;
    }

    public void setContributedWorkbenchWindow(IWorkbenchWindow activeWindow) {
        this.activeWindow = activeWindow;
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.contributingPart == null && part instanceof IEditorPart) {
            this.setContributingPart((IEditorPart)part);
        }
    }

    private void setContributingPart(IEditorPart part) {
        DelegatedSelectionProvider selectionProvider;
        if (part == this.contributingPart) {
            return;
        }
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.contributingPart = part;
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.addAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.selectedTopic = this.findTopic(this.getSelection(part));
    }

    private ITopic findTopic(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            return (ITopic)o;
        }
        return null;
    }

    private ISelection getSelection(IEditorPart part) {
        ISelectionProvider selectionProvider;
        if (part != null && (selectionProvider = part.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingPart) {
            this.setContributingPart(null);
            AudioNotesPlugin.getDefault().getAgent().stop();
            this.close();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedTopic = this.findTopic(event.getSelection());
    }

    public void started(ITopic topic, boolean recordOrPlayback) {
        if (recordOrPlayback) {
            if (this.parentTopic != null) {
                boolean shouldTransferSourceTopic;
                boolean bl = shouldTransferSourceTopic = !this.parentTopic.equals(this.selectedTopic) && !this.selectedTopic.equals(this.sourceTopic);
                if (shouldTransferSourceTopic) {
                    this.parentTopic.remove(this.sourceTopic);
                    this.selectedTopic.add(this.sourceTopic);
                    this.parentTopic = this.sourceTopic;
                }
            }
            this.page.update(2, null);
        }
    }

    public void stopped(ITopic topic, boolean recordOrPlayback) {
        if (recordOrPlayback) {
            this.page.update(4, null);
            this.close(false);
        }
    }

    public void valuesChanged(ITopic topic, AudioValues values, boolean recordOrPlayback) {
        if (recordOrPlayback) {
            this.page.update(8, values);
        }
    }

    public boolean close(boolean checkExtension) {
        ITopicExtension extension;
        AudioNotesPlugin.getDefault().getAgent().removeAudioListener(this);
        if (this.sourceTopic != null && (extension = this.sourceTopic.getExtension("org.xmind.ui.audionotes")) != null) {
            String recording = extension.getContent().getAttribute("recording");
            if (checkExtension && recording != null) {
                this.sourceTopic.getParent().remove(this.sourceTopic);
                this.sourceTopic = null;
            } else {
                this.showDisplayPage();
            }
        }
        return this.close();
    }

    private void showDisplayPage() {
        if (this.contributingPart == null) {
            return;
        }
        final Shell shell = this.getParentShell();
        final IWorkbenchWindow window = this.activeWindow;
        this.contributingPart.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.sourceTopic));
        Shell activeShell = this.getShell();
        if (activeShell == null) {
            activeShell = Display.getCurrent().getActiveShell();
        }
        activeShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                AudioNotesPropertiesDialog dialog = new AudioNotesPropertiesDialog(shell);
                dialog.setContributedWorkbenchWindow(window);
                dialog.open();
            }
        });
    }

    private ICommandStack getCommandStack() {
        IGraphicalEditor editor = (IGraphicalEditor)this.contributingPart;
        if (editor != null) {
            return editor.getCommandStack();
        }
        return ICommandStack.NULL;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        GridLayout layout = (GridLayout)buttonBar.getLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.horizontalSpacing = 15;
        layout.marginHeight = 0;
        layout.marginRight = 15;
        GridData data = (GridData)buttonBar.getLayoutData();
        data.heightHint = 50;
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AudioNotesPlugin.getDefault().getAgent().isRecording()) {
                    ConfirmCloseDialog confirmDialog = new ConfirmCloseDialog(InsertAudioNotesDialog.this.getShell());
                    int retValue = confirmDialog.open();
                    if (1025 == retValue) {
                        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                        agent.stop();
                    }
                } else {
                    InsertAudioNotesDialog.this.close(true);
                }
            }
        });
    }

    public int open() {
        AudioNotesPlugin.getDefault().getAgent().windowOpened = true;
        return super.open();
    }

    public boolean close() {
        AudioNotesPlugin.getDefault().getAgent().windowOpened = false;
        this.thisPage.removePartListener((IPartListener)this);
        return super.close();
    }

    private class LevelMeter
    implements AudioNotesViewerPage.ContentComposite {
        private int selection;
        Canvas canvas;
        int cellNums = 40;
        final Color blueBackground = new Color((Device)Display.getDefault(), 88, 214, 58);
        final Color greyBackground = new Color((Device)Display.getDefault(), 220, 217, 213);
        private int hHint;

        public LevelMeter(Composite parent, int style) {
            this.canvas = new Canvas(parent, style);
            this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    LevelMeter.this.drawBackground(e.gc, e.x, e.y, e.width, e.height, 0, 0);
                }
            });
        }

        public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
            int realHeight = Math.min(this.hHint, height);
            int ySpacing = (height - realHeight) / 2;
            int blueSelected = this.selection * this.cellNums / 100;
            Color background = gc.getBackground();
            gc.setBackground(this.blueBackground);
            int cellWidth = width / this.cellNums;
            int i = 0;
            while (i < this.cellNums) {
                int offset = i * cellWidth;
                if (i >= blueSelected) {
                    gc.setBackground(this.greyBackground);
                }
                gc.fillRectangle(x + offset, y + ySpacing, cellWidth / 2, realHeight);
                ++i;
            }
            gc.setBackground(background);
        }

        public Object getSelection() {
            return this.selection;
        }

        public void setSelection(Object selection) {
            this.selection = (Integer)selection;
            if (this.canvas != null && !this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        }

        public void setLayoutData(GridData layoutData) {
            this.canvas.setLayoutData((Object)layoutData);
        }

        public void setBackground(Color background) {
            this.canvas.setBackground(background);
        }

        public void setHeightHint(int hHint) {
            this.hHint = hHint;
        }

        public Control getControl() {
            return this.canvas;
        }
    }

    class RecordPage
    extends AudioNotesViewerPage {
        public RecordPage(AudioNotesViewer2 viewer) {
            this.type = 2;
            this.viewer = viewer;
        }

        protected AudioNotesViewerPage.ContentComposite createContentComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, true);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 10;
            composite.setLayout((Layout)gridLayout);
            GridData layoutData = new GridData(4, 4, false, true);
            layoutData.heightHint = 30;
            layoutData.widthHint = 200;
            composite.setLayoutData((Object)layoutData);
            LevelMeter levelMeter = new LevelMeter(composite, 0);
            levelMeter.setBackground(parent.getBackground());
            levelMeter.setSelection(0);
            levelMeter.setLayoutData(new GridData(4, 0x1000000, true, true));
            levelMeter.setHeightHint(12);
            return levelMeter;
        }

        protected void configImageButton() {
            super.configImageButton();
            this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/stop_record.png"));
            this.imageButton.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                    if (RecordPage.isRecording() || RecordPage.isPlaying()) {
                        agent.stop();
                    } else {
                        ITopic topic = RecordPage.this.sourceTopic;
                        if (topic != null) {
                            try {
                                agent.createRecordClientAndStartSession(topic);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }

        public void update(int eventType, Object source) {
            if (!((1 & eventType) == 0 || this.mainLabel.isDisposed() || this.secondaryLabel.isDisposed() || this.leftLabel.isDisposed() || this.rightLabel.isDisposed())) {
                this.mainLabel.setText(this.sourceTopic.getTitleText());
                this.secondaryLabel.setText(new Date(new Date().getTime()).toLocaleString());
                this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                this.rightLabel.setText(AudioNotesUtils.formatFileSize("0"));
            }
            if ((2 & eventType) != 0 && !this.rightLabel.isDisposed() && !this.imageLabel.isDisposed()) {
                this.rightLabel.setText(Messages.AudioNotesDialog_RightLabel_mp3);
                this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/stop_record.png"));
                this.imageLabel.setText(Messages.AudioNotesDialog_Button_Stop);
            }
            if ((8 & eventType) != 0 && !this.leftLabel.isDisposed() && source != null) {
                AudioValues value = (AudioValues)source;
                this.content.setSelection(value.level);
                this.leftLabel.setText(AudioNotesUtils.formatTime(value.duration));
            }
        }

        public void dispose() {
            super.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartRecordingCommand
    extends Command
    implements ISourceProvider {
        private ITopic parent;
        private ITopic subtopic;
        private boolean evetStarted;
        private boolean executing;

        public StartRecordingCommand(ITopic parent) {
            super(Messages.Command_Record);
            this.evetStarted = false;
            this.executing = false;
            this.parent = parent;
        }

        public int getType() {
            return 1;
        }

        public void execute() {
            this.executing = true;
            this.createNewAudioNotesTopic();
            super.execute();
            this.executing = false;
        }

        private void createNewAudioNotesTopic() {
            if (this.parent == null) {
                return;
            }
            this.subtopic = this.parent.getOwnedWorkbook().createTopic();
            ITopicExtension extension = this.subtopic.createExtension("org.xmind.ui.audionotes");
            extension.getContent().setAttribute("recording", "true");
            int num = this.getExistingAudioCount();
            this.subtopic.setTitleText(NLS.bind((String)Messages.AudioTitle, (Object)(num + 1)));
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    StartRecordingCommand.this.parent.add(StartRecordingCommand.this.subtopic);
                    StartRecordingCommand.this.addPreSaveActions(StartRecordingCommand.this.subtopic);
                    StartRecordingCommand.this.evetStarted = true;
                }
            });
        }

        public boolean canUndo() {
            return super.canUndo() && this.evetStarted;
        }

        public boolean canRedo() {
            return super.canRedo() && this.evetStarted;
        }

        private int getExistingAudioCount() {
            int num = 0;
            for (ITopic t : this.parent.getChildren("attached")) {
                if (AudioNotesUtils.getAudioEntryPath(t) == null) continue;
                ++num;
            }
            return num;
        }

        public void redo() {
            if (!this.executing) {
                this.parent.add(this.subtopic);
            }
            super.redo();
        }

        public void undo() {
            if (this.subtopic != null) {
                this.parent.remove(this.subtopic);
            }
            super.undo();
        }

        public Object getSource() {
            return this.subtopic;
        }

        public List<Object> getSources() {
            return this.subtopic == null ? EMPTY_TOPICS : Arrays.asList(this.subtopic);
        }

        public boolean hasSource() {
            return true;
        }

        private void addPreSaveActions(ITopic topic) {
            if (topic == null) {
                return;
            }
            IWorkbook workbook = topic.getOwnedWorkbook();
            if (workbook instanceof ICoreEventSource2) {
                ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
            }
        }
    }
}

