/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.ui.internal.presentation.Button;
import org.xmind.ui.internal.presentation.Slider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPanel
extends SizeableImageFigure
implements PropertyChangeListener {
    public static final int NEXT_ID = 0;
    public static final int INTO_ID = 1;
    public static final int LIGHT_ID = 2;
    public static final int ZOOM_ID = 3;
    public static final int SLIDER_ID = 4;
    public static final int SIDEBAR_ID = 5;
    public static final int QUIT_ID = 6;
    public static final float MIN_SLIDER_VALUE = 0.0f;
    public static final float MAX_SLIDER_VALUE = 1.0f;
    private static final Rectangle VIEWPORT_AREA = new Rectangle();
    private Map<Integer, Button> buttons = null;
    private Map<Integer, Slider> sliders = null;
    private Viewport viewport;
    private int locationOffset = 0;

    public ControlPanel(Dimension prefSize) {
        if (prefSize != null) {
            this.setPreferredSize(prefSize);
        }
    }

    protected void paintClientArea(Graphics graphics) {
        Graphics g = this.createAlphaGraphics(graphics, this.getAlpha());
        super.paintClientArea(g);
        g.dispose();
    }

    private Graphics createAlphaGraphics(Graphics graphics, int alpha) {
        AlphaGraphics ag = new AlphaGraphics(graphics);
        ag.setMainAlpha(alpha);
        return ag;
    }

    protected void layout() {
        super.layout();
        if (this.viewport != null) {
            this.layout(this.viewport.getClientArea(VIEWPORT_AREA));
        }
        Rectangle panelBounds = this.getBounds();
        if (this.buttons != null) {
            for (Button button : this.buttons.values()) {
                if (this.isSlider(button.getId())) continue;
                button.layout(panelBounds);
            }
        }
        if (this.sliders != null) {
            for (Slider slider : this.sliders.values()) {
                slider.layout(panelBounds);
            }
        }
    }

    private void layout(Rectangle viewportBounds) {
        Dimension size = this.getPreferredSize();
        Point pos = viewportBounds.getTopRight();
        pos.x -= size.width + 20;
        pos.y += 20;
        this.setBounds(new Rectangle(pos, size));
    }

    private Viewport findViewport() {
        IFigure p = this.getParent();
        while (p != null) {
            if (p instanceof Viewport) {
                return (Viewport)p;
            }
            p = p.getParent();
        }
        return null;
    }

    public void addNotify() {
        this.viewport = this.findViewport();
        if (this.viewport != null) {
            this.viewport.getHorizontalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
            this.viewport.getVerticalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.viewport != null) {
            this.viewport.getHorizontalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
            this.viewport.getVerticalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setLocationOffset(int locationOffset) {
        if (locationOffset == this.locationOffset) {
            return;
        }
        this.locationOffset = locationOffset;
        this.revalidate();
        this.repaint();
    }

    public int getLocationOffset() {
        return this.locationOffset;
    }

    private Button doFindButton(Point p) {
        if (this.buttons != null) {
            for (Button button : this.buttons.values()) {
                if (!button.containsPoint(p)) continue;
                return button;
            }
        }
        return null;
    }

    public void addButton(Button button) {
        if (this.buttons == null) {
            this.buttons = new HashMap<Integer, Button>();
        }
        this.buttons.put(button.getId(), button);
        this.add((IFigure)button);
    }

    public void addSlider(Slider slider) {
        if (this.sliders == null) {
            this.sliders = new HashMap<Integer, Slider>();
        }
        this.sliders.put(slider.getId(), slider);
        this.addButton(slider.getSliderWay());
        this.addButton(slider.getButton());
    }

    public Button getButton(int id) {
        return this.buttons == null ? null : this.buttons.get(id);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.revalidate();
    }

    public Collection<Button> getButtons() {
        return this.buttons.values();
    }

    public Slider getSlider(int id) {
        return this.sliders == null ? null : this.sliders.get(id);
    }

    private boolean isSlider(int id) {
        return this.sliders != null && id >= 0 && this.sliders.containsKey(id);
    }

    public Button findButton(Point p) {
        return this.doFindButton(p);
    }

    public void setSliderValue(int id, Point p) {
        Slider slider = this.getSlider(id);
        if (slider != null) {
            Rectangle panelBounds = this.getBounds();
            slider.setValue(slider.calcValue(p));
            slider.layout(panelBounds);
        }
    }

    public void setSliderValue(int id, float value) {
        Slider slider = this.getSlider(id);
        if (slider != null) {
            slider.setValue(value);
            slider.layout(this.getBounds());
        }
    }

    public float getSliderValue(int id) {
        Slider slider = this.getSlider(id);
        return slider == null ? 0.0f : slider.getValue();
    }
}

