/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.ui.workbench.addons.minmax;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class XTrimStack {
    public static String CONTRIBUTION_URI_XTRIMSTACK = "bundleclass://org.xmind.cathy/org.xmind.cathy.internal.ui.workbench.addons.minmax.XTrimStack";
    private ToolBar trimStackTB;
    private MUIElement mGenericStack;
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                XTrimStack.this.setStateForShowStack(false);
                XTrimStack.this.partService.requestActivation();
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private SelectionListener toolItemSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ToolItem toolItem = (ToolItem)e.widget;
            MUIElement uiElement = (MUIElement)toolItem.getData();
            if (!toolItem.getSelection()) {
                XTrimStack.this.partService.requestActivation();
                XTrimStack.this.setStateForShowStack(false);
                return;
            }
            if (uiElement instanceof MPart) {
                XTrimStack.this.partService.activate((MPart)uiElement);
            } else if (uiElement instanceof MPerspective) {
                uiElement.getParent().setSelectedElement(uiElement);
            }
            XTrimStack.this.setStateForShowStack(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };

    @Inject
    @Optional
    private void handleTransientDataEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") org.osgi.service.event.Event event) {
        ToolItem toolItem;
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MUIElement)) {
            return;
        }
        String key = UIEvents.isREMOVE((org.osgi.service.event.Event)event) ? (String)((Map.Entry)event.getProperty("OldValue")).getKey() : (String)((Map.Entry)event.getProperty("NewValue")).getKey();
        if (key.equals("e4_override_icon_image_key")) {
            ToolItem toolItem2 = this.getChangedToolItem((MUIElement)changedElement);
            if (toolItem2 != null) {
                toolItem2.setImage(this.getImage((MUILabel)toolItem2.getData()));
            }
        } else if (key.equals("e4_override_title_tool_tip_key") && (toolItem = this.getChangedToolItem((MUIElement)changedElement)) != null) {
            toolItem.setToolTipText(this.getLabelText((MUILabel)toolItem.getData()));
        }
    }

    private ToolItem getChangedToolItem(MUIElement changedElement) {
        ToolItem[] toolItems;
        ToolItem[] toolItemArray = toolItems = this.trimStackTB.getItems();
        int n = toolItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if (changedElement.equals(toolItem.getData())) {
                return toolItem;
            }
            ++n2;
        }
        return null;
    }

    @Inject
    @Optional
    private void handleChildrenEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") org.osgi.service.event.Event event) {
        if (this.mGenericStack == null || this.trimStackTB == null) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj == this.mGenericStack) {
            this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XTrimStack.this.updateTrimStackItems();
                }
            });
        }
    }

    @Inject
    @Optional
    private void handleToBeRenderedEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") org.osgi.service.event.Event event) {
        if (this.mGenericStack == null || this.trimStackTB == null) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MElementContainer parentElement = changedElement.getParent();
        if (parentElement == this.mGenericStack) {
            this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XTrimStack.this.updateTrimStackItems();
                }
            });
        }
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") org.osgi.service.event.Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj != this.mGenericStack) {
            return;
        }
        if (UIEvents.isADD((org.osgi.service.event.Event)event)) {
            if (UIEvents.contains((org.osgi.service.event.Event)event, (String)"NewValue", (Object)"StackHidden")) {
                this.fixToolItemSelection();
            } else if (UIEvents.contains((org.osgi.service.event.Event)event, (String)"NewValue", (Object)"StackVisible")) {
                this.fixToolItemSelection();
            }
        }
    }

    @Inject
    @Optional
    private void handleWidgeEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") org.osgi.service.event.Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj != this.mGenericStack) {
            return;
        }
        if (this.mGenericStack.getWidget() != null) {
            this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XTrimStack.this.updateTrimStackItems();
                }
            });
        }
    }

    @Inject
    @Optional
    private void handleBringToTopEvents(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") org.osgi.service.event.Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (this.getLeafPart(this.mGenericStack) == changedElement && !(this.mGenericStack instanceof MPerspectiveStack)) {
            this.setStateForShowStack(true);
            return;
        }
        MUIElement selectedElement = null;
        if (this.mGenericStack instanceof MPlaceholder) {
            selectedElement = ((MPlaceholder)this.mGenericStack).getRef();
        } else if (this.mGenericStack instanceof MPartStack) {
            selectedElement = ((MPartStack)this.mGenericStack).getSelectedElement();
        }
        if (selectedElement == null) {
            return;
        }
        if (selectedElement instanceof MPlaceholder) {
            selectedElement = ((MPlaceholder)selectedElement).getRef();
        }
        if (changedElement != selectedElement) {
            return;
        }
        this.setStateForShowStack(true);
    }

    @Inject
    @Optional
    private void handleAppShutDownAndStartedEvents(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appShutdownStarted") org.osgi.service.event.Event event) {
        this.setStateForShowStack(false);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me, CSSRenderingUtils cssUtils) {
        MTrimBar bar;
        if (this.mGenericStack == null) {
            this.mGenericStack = this.findElement();
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar && ((bar = (MTrimBar)meParent).getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT)) {
            orientation = 512;
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        this.trimStackTB.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XTrimStack.this.setStateForShowStack(false);
                XTrimStack.this.trimStackTB = null;
            }
        });
        this.updateTrimStackItems();
    }

    @PreDestroy
    void destroy() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
    }

    public MUIElement getMinimizedElement() {
        return this.mGenericStack;
    }

    private MUIElement findElement() {
        MUIElement result;
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (ps.size() == 0) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            result = this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            String perspId = toolControlId.substring(index + 1, toolControlId.length() - 1);
            MPerspective persp = null;
            List perspectives = this.modelService.findElements((MUIElement)ps.get(0), perspId, MPerspective.class, null);
            if (perspectives != null && !perspectives.isEmpty()) {
                persp = (MPerspective)perspectives.get(0);
            }
            result = persp != null ? this.modelService.find(stackId, persp) : this.modelService.find(stackId, (MUIElement)this.window);
        }
        return result;
    }

    private String getLabelText(MUILabel label) {
        String text;
        if (label instanceof MUIElement && (text = this.getOverrideTitleToolTip((MUIElement)label)) != null && text.length() > 0) {
            return text;
        }
        String string = label.getLocalizedLabel();
        return string == null ? "" : string;
    }

    private Image getImage(MUILabel element) {
        Image image;
        if (element instanceof MUIElement && (image = this.getOverrideImage((MUIElement)element)) != null) {
            return image;
        }
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            Image image2 = this.imageMap.get(iconURI);
            if (image2 == null) {
                image2 = this.imageDescriptorFromURI(iconURI).createImage();
                this.imageMap.put(iconURI, image2);
            }
            return image2;
        }
        return null;
    }

    public ImageDescriptor imageDescriptorFromURI(String iconPath) {
        try {
            URI uri = new URI(iconPath);
            return ImageDescriptor.createFromURL((URL)new URL(uri.toString()));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private MUILabel getLabelElement(MUIElement element) {
        if (element instanceof MPlaceholder) {
            element = ((MPlaceholder)element).getRef();
        }
        return (MUILabel)(element instanceof MUILabel ? element : null);
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        if (this.trimStackTB != null && !this.trimStackTB.isDisposed()) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl4:
            // 2 sources

            ** while (this.trimStackTB.getItemCount() > 0)
        }
lbl5:
        // 1 sources

        if (this.mGenericStack instanceof MPlaceholder) {
            ph = (MPlaceholder)this.mGenericStack;
            if (ph.getRef() instanceof MPart) {
                part = (MPart)ph.getRef();
                ti = new ToolItem(this.trimStackTB, 32);
                ti.setData((Object)part);
                ti.setImage(this.getImage((MUILabel)part));
                ti.setToolTipText(this.getLabelText((MUILabel)part));
                ti.addSelectionListener(this.toolItemSelectionListener);
            }
        } else if (this.mGenericStack instanceof MGenericStack) {
            theStack = (MGenericStack)this.mGenericStack;
            for (MUIElement stackElement : theStack.getChildren()) {
                trimStackExists = stackElement.getTags().contains("TrimStackExist");
                if (stackElement instanceof MPlaceholder) {
                    part = ((MPlaceholder)stackElement).getRef();
                    trimStackExists = part.getTags().contains("TrimStackExist");
                }
                if (!trimStackExists) continue;
                labelElement = this.getLabelElement(stackElement);
                newItem = new ToolItem(this.trimStackTB, 32);
                newItem.setData((Object)labelElement);
                newItem.setImage(this.getImage(labelElement));
                newItem.setToolTipText(this.getLabelText(labelElement));
                newItem.addSelectionListener(this.toolItemSelectionListener);
            }
        }
        this.trimStackTB.pack();
        this.trimStackTB.getShell().layout(new Control[]{this.trimStackTB}, 4);
        this.fixToolItemSelection();
    }

    public void setStateForShowStack(boolean show) {
        Control ctrl = (Control)this.mGenericStack.getWidget();
        Composite clientAreaComposite = this.getCAComposite();
        if (clientAreaComposite == null || clientAreaComposite.isDisposed()) {
            return;
        }
        if (show) {
            this.mGenericStack.getTags().remove("StackHidden");
            this.mGenericStack.getTags().remove("StackVisible");
            this.mGenericStack.getTags().add("StackVisible");
            ctrl.removeListener(31, this.escapeListener);
            ctrl.addListener(31, this.escapeListener);
        } else {
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.removeListener(31, this.escapeListener);
            }
            this.mGenericStack.getTags().remove("StackHidden");
            this.mGenericStack.getTags().remove("StackVisible");
            this.mGenericStack.getTags().add("StackHidden");
        }
    }

    private void fixToolItemSelection() {
        block10: {
            boolean toShow;
            block9: {
                if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
                    return;
                }
                boolean toHide = this.mGenericStack.getTags().contains("StackHidden");
                toShow = this.mGenericStack.getTags().contains("StackVisible");
                if (!toHide) break block9;
                ToolItem[] toolItemArray = this.trimStackTB.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    item.setSelection(false);
                    ++n2;
                }
                break block10;
            }
            if (!toShow) break block10;
            if (this.mGenericStack instanceof MPlaceholder) {
                this.trimStackTB.getItem(1).setSelection(true);
            } else if (this.isPerspectiveStack()) {
                MPerspectiveStack pStack = (MPerspectiveStack)this.mGenericStack;
                MUIElement selElement = pStack.getSelectedElement();
                ToolItem[] toolItemArray = this.trimStackTB.getItems();
                int n = toolItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ToolItem item;
                    item.setSelection((item = toolItemArray[n3]).getData() == selElement);
                    ++n3;
                }
            } else {
                MPartStack partStack = (MPartStack)this.mGenericStack;
                MUIElement selElement = partStack.getSelectedElement();
                if (selElement instanceof MPlaceholder) {
                    selElement = ((MPlaceholder)selElement).getRef();
                }
                ToolItem[] toolItemArray = this.trimStackTB.getItems();
                int n = toolItemArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ToolItem item = toolItemArray[n4];
                    boolean isSel = item.getData() == selElement;
                    item.setSelection(isSel);
                    ++n4;
                }
            }
        }
    }

    private boolean isPerspectiveStack() {
        return this.mGenericStack instanceof MPerspectiveStack;
    }

    private MPart getLeafPart(MUIElement element) {
        if (element instanceof MPlaceholder) {
            return this.getLeafPart(((MPlaceholder)element).getRef());
        }
        if (element instanceof MElementContainer) {
            return this.getLeafPart(((MElementContainer)element).getSelectedElement());
        }
        if (element instanceof MPart) {
            return (MPart)element;
        }
        return null;
    }

    private Composite getCAComposite() {
        if (this.trimStackTB == null) {
            return null;
        }
        Shell theShell = this.trimStackTB.getShell();
        if (theShell.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)theShell.getLayout();
            if (!tpl.clientArea.isDisposed()) {
                return tpl.clientArea;
            }
        }
        return null;
    }

    private Image getOverrideImage(MUIElement element) {
        Image result = null;
        Object imageObject = element.getTransientData().get("e4_override_icon_image_key");
        if (imageObject != null && imageObject instanceof Image && !((Image)imageObject).isDisposed()) {
            result = (Image)imageObject;
        }
        return result;
    }

    private String getOverrideTitleToolTip(MUIElement element) {
        String label;
        String result = null;
        Object stringObject = element.getTransientData().get("e4_override_title_tool_tip_key");
        if (stringObject != null && stringObject instanceof String) {
            result = (String)stringObject;
        }
        if (result == null || result.length() == 0) {
            return null;
        }
        if (element instanceof MUILabel && (label = ((MUILabel)element).getLocalizedLabel()) != null && label.length() > 0) {
            result = String.valueOf(label) + ' ' + '(' + result + ')';
        }
        return result;
    }
}

