/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.tweaklets.TitlePathUpdater;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CathyWorkbenchActionBuilder;
import org.xmind.cathy.internal.CheckOpenFilesProcess;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.licensing.ILicenseAgent;
import org.xmind.core.licensing.ILicenseChangedListener;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.workbench.Util;

public class CathyWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements IPartListener2,
IPropertyListener,
ILicenseChangedListener {
    private String licenseName = null;
    private IWorkbenchPartReference activePartRef = null;
    private TitlePathUpdater titlePathUpdater = (TitlePathUpdater)Tweaklets.get((Tweaklets.TweakKey)TitlePathUpdater.KEY);
    private boolean homeShowing = false;

    public CathyWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new CathyWorkbenchActionBuilder(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(Util.getInitialWindowSize());
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(WorkbenchMessages.AppWindowTitle);
        CathyPlugin.getDefault().getLicenseAgent().addLicenseChangedListener((ILicenseChangedListener)this);
    }

    public void postWindowOpen() {
        final IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        if (window != null) {
            window.getPartService().addPartListener((IPartListener2)this);
            Shell shell = window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellActivated(ShellEvent e) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                    public void run() throws Exception {
                                        new CheckOpenFilesProcess(window.getWorkbench()).doCheckAndOpenFiles();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
        this.addE4PartListener();
    }

    private void addE4PartListener() {
        IWorkbench workbench = this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
        EModelService modelService = (EModelService)workbench.getService(EModelService.class);
        MApplication application = ((Workbench)workbench).getApplication();
        if (modelService == null || application == null) {
            return;
        }
        List windows = modelService.findElements((MUIElement)application, "org.xmind.cathy.window.main", MWindow.class, null);
        if (windows.isEmpty()) {
            return;
        }
        for (MWindow window : windows) {
            Shell shell = (Shell)window.getContext().get("localActiveShell");
            if (shell == null) continue;
            shell.setMinimumSize(1000, 700);
        }
        EPartService partService = (EPartService)((MWindow)windows.get(0)).getContext().get(EPartService.class);
        if (partService == null) {
            return;
        }
        partService.addPartListener(new IPartListener(){

            public void partVisible(MPart part) {
            }

            public void partHidden(MPart part) {
            }

            public void partDeactivated(MPart part) {
                if ("org.xmind.cathy.part.dashboard".equals(part.getElementId())) {
                    CathyWorkbenchWindowAdvisor.this.homeShowing = false;
                    CathyWorkbenchWindowAdvisor.this.updateWindowTitle();
                }
            }

            public void partBroughtToTop(MPart part) {
            }

            public void partActivated(MPart part) {
                if ("org.xmind.cathy.part.dashboard".equals(part.getElementId())) {
                    CathyWorkbenchWindowAdvisor.this.homeShowing = true;
                    CathyWorkbenchWindowAdvisor.this.updateWindowTitle();
                }
            }
        });
    }

    public void postWindowClose() {
        CathyPlugin.getDefault().getLicenseAgent().removeLicenseChangedListener((ILicenseChangedListener)this);
    }

    public void licenseChanged(ILicenseAgent agent) {
        int licenseType = agent.getLicenseType();
        this.licenseName = (licenseType & 4) != 0 ? "Pro" : ((licenseType & 8) != 0 ? "Plus" : ((licenseType & 2) != 0 ? "Pro" : null));
        this.updateWindowTitle();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            if (this.activePartRef != null) {
                this.activePartRef.removePropertyListener((IPropertyListener)this);
            }
            this.activePartRef = partRef;
            this.activePartRef.addPropertyListener((IPropertyListener)this);
        }
        this.updateWindowTitle();
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef == this.activePartRef) {
            this.activePartRef = null;
            partRef.removePropertyListener((IPropertyListener)this);
        }
        this.updateWindowTitle();
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        this.updateWindowTitle();
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        this.updateWindowTitle();
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.updateWindowTitle();
    }

    private void updateWindowTitle() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CathyWorkbenchWindowAdvisor.this.doUpdateWindowTitle();
            }
        });
    }

    private void doUpdateWindowTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        StringBuffer sb = new StringBuffer(20);
        if (this.homeShowing) {
            sb.append(WorkbenchMessages.CathyWorkbenchWindowAdvisor_windowTitle_home_prefix);
        }
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = null;
        if (page != null) {
            editor = page.getActiveEditor();
        }
        if (editor == null) {
            sb.append(WorkbenchMessages.AppWindowTitle);
            if (this.licenseName != null) {
                sb.append(' ');
                sb.append(this.licenseName);
            }
        } else {
            String text = editor.getClass().toString().contains("org.xmind.ui.internal.browser") ? null : editor.getTitleToolTip();
            text = text == null ? editor.getTitle() : FileUtils.getFileName((String)text);
            sb.append(text);
        }
        configurer.setTitle(sb.toString());
        if (this.titlePathUpdater != null) {
            this.titlePathUpdater.updateTitlePath(shell, this.computeTitlePath(page));
        }
    }

    private String computeTitlePath(IWorkbenchPage page) {
        File file;
        IEditorInput editorInput;
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && (editorInput = activeEditor.getEditorInput()) != null && (file = MME.getFile((Object)editorInput)) != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public void propertyChanged(Object source, int propId) {
        this.updateWindowTitle();
    }
}

