/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.viewers.IGraphicalToolTipProvider;
import org.xmind.ui.viewers.IToolTipProvider;

public class FrameDecorator
extends Decorator {
    public static final FrameDecorator DEFAULT = new FrameDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        IGraphicalToolTipProvider toolTipProvider;
        boolean useCustomDecorator;
        super.decorate(part, figure);
        FrameFigure frame = (FrameFigure)part.getFigure();
        Object model = part.getModel();
        IViewer viewer = part.getSite().getViewer();
        Properties properties = viewer.getProperties();
        IBaseLabelProvider labelProvider = (IBaseLabelProvider)viewer.getAdapter(IBaseLabelProvider.class);
        boolean hideTitle = properties.getBoolean("org.xmind.ui.gallery.hideTitle", false);
        frame.setHideTitle(hideTitle);
        boolean flat = properties.getBoolean("org.xmind.ui.gallery.flatFrames", false);
        frame.setFlat(flat);
        frame.setContentSize((Dimension)properties.get("org.xmind.ui.gallery.frameContentSize"));
        int titlePlacement = properties.getInteger("org.xmind.ui.gallery.titlePlacement", GalleryViewer.TITLE_TOP.intValue());
        frame.setTitlePlacement(titlePlacement);
        if (!hideTitle) {
            this.decorateTitle(frame.getTitle(), model, labelProvider);
        }
        if ((useCustomDecorator = properties.getBoolean("org.xmind.ui.gallery.customDecorateContentPane", false)) && labelProvider instanceof ILabelDecorator) {
            IDecorationContext context = viewer instanceof IDecorationContext ? (IDecorationContext)viewer : null;
            ((ILabelDecorator)labelProvider).decorateFigure((IFigure)frame.getContentPane(), model, context);
        }
        if (labelProvider instanceof IGraphicalToolTipProvider) {
            toolTipProvider = (IGraphicalToolTipProvider)labelProvider;
            IFigure toolTipFigure = toolTipProvider.getToolTipFigure(model);
            frame.setToolTip(toolTipFigure);
        }
        if (labelProvider instanceof IToolTipProvider) {
            toolTipProvider = (IToolTipProvider)labelProvider;
            String toolTip = toolTipProvider.getToolTip(model);
            if (toolTip == null || "".equals(toolTip)) {
                frame.setToolTip(null);
            } else {
                Label toolTipFigure = new Label();
                toolTipFigure.setText(toolTip);
                frame.setToolTip((IFigure)toolTipFigure);
            }
        }
        ShadowedLayer layer = frame.getContentPane();
        layer.setBorderWidth(properties.getInteger("org.xmind.ui.gallery.contentPaneBorderWidth", 1));
        Object color = properties.get("org.xmind.ui.gallery.contentPaneBorderColor");
        if (color != null && color instanceof Color) {
            layer.setBorderAlpha(255);
            layer.setBorderColor((Color)color);
        }
    }

    private String getText(Object element, IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText(element);
        }
        return null;
    }

    protected void decorateTitle(ITextFigure titleFigure, Object model, IBaseLabelProvider labelProvider) {
        String text = this.getText(model, labelProvider);
        if (text == null) {
            text = "";
        }
        titleFigure.setText(text);
        if (labelProvider instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            titleFigure.setFont(fontProvider.getFont(model));
        }
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            titleFigure.setForegroundColor(colorProvider.getForeground(model));
            titleFigure.setBackgroundColor(colorProvider.getBackground(model));
        }
    }
}

