/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.INotes;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.EditDomain;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyNotesCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.FindReplaceAction;
import org.xmind.ui.internal.actions.ShowAllNotesAction;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;
import org.xmind.ui.internal.notes.INotesContentViewer;
import org.xmind.ui.internal.notes.NotesFindReplaceOperationProvider;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.internal.notes.SheetNotesViewer;
import org.xmind.ui.internal.notes.TopicNotesViewer;
import org.xmind.ui.internal.spelling.SpellingPlugin;
import org.xmind.ui.internal.spellsupport.SpellingSupport;
import org.xmind.ui.internal.views.NotesHyperlinkDialog;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.richtext.FullRichTextActionBarContributor;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichTextEditViewer;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.texteditor.IMenuContributor;
import org.xmind.ui.texteditor.ISpellingActivation;
import org.xmind.ui.util.Logger;

public class NotesView
extends ViewPart
implements IPartListener,
ICoreEventListener,
IDocumentListener,
IRichDocumentListener,
IContributedContentsView,
ISelectionChangedListener,
IPropertyChangeListener {
    private static final String NOTES_EDIT_CONTEXT_ID = "org.xmind.ui.context.notes.edit";
    private static boolean DEBUG = false;
    private IGraphicalEditor contributingEditor;
    private ISelection currentSelection;
    private ITopicPart currentTopicPart;
    private INotesContentViewer viewer;
    private RichDocumentNotesAdapter adapter;
    private NotesViewRichTextActionBarContributor topicViewerContributor;
    private ICoreEventRegister eventRegister;
    private IHandlerService handlerService;
    private List<IHandlerActivation> handlerActivations;
    private ISpellingActivation spellingActivation;
    private boolean savingNotes;
    private NotesFindReplaceOperationProvider notesOperationProvider = null;
    private ICoreEventRegistration saveNotesReg = null;
    private Map<String, ActionFactory.IWorkbenchAction> workbenchActions = new HashMap<String, ActionFactory.IWorkbenchAction>(7);
    private List<TextAction> textActions = new ArrayList<TextAction>(7);
    private ActionFactory.IWorkbenchAction findReplaceAction;
    private IHandlerActivation commitHandlerActivation;
    private IPreferenceStore spellingPreferences;
    private boolean updating;
    private Composite contentArea;
    private ISelectionChangedListener listener;

    public IWorkbenchPart getContributingPart() {
        return this.contributingEditor;
    }

    public void createPartControl(Composite parent) {
        this.contentArea = this.createComposite(parent);
        this.topicViewerContributor = new NotesViewRichTextActionBarContributor();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.createActions(actionBars);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.showBootstrapContent();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setEnabled(false);
        return composite;
    }

    private void activateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (handlerService != null) {
            this.commitHandlerActivation = handlerService.activateHandler("org.xmind.ui.command.commitNotes", (IHandler)new CommitNotesHandler());
        }
    }

    private void addSpellChecker() {
        this.spellingActivation = SpellingSupport.getInstance().activateSpelling((ITextViewer)((TopicNotesViewer)this.viewer).getImplementation().getTextViewer());
        this.spellingPreferences = SpellingPlugin.getDefault().getPreferenceStore();
        if (this.spellingPreferences != null) {
            this.spellingPreferences.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void createActions(IActionBars actionBars) {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        this.addGlobalTextAction(actionBars, window, ActionFactory.UNDO, 1);
        this.addGlobalTextAction(actionBars, window, ActionFactory.REDO, 2);
        this.addGlobalTextAction(actionBars, window, ActionFactory.CUT, 3);
        this.addGlobalTextAction(actionBars, window, ActionFactory.COPY, 4);
        this.addGlobalTextAction(actionBars, window, ActionFactory.PASTE, 5);
        this.addGlobalTextAction(actionBars, window, ActionFactory.SELECT_ALL, 7);
        ActionFactory.IWorkbenchAction action = ActionFactory.FIND.create(window);
        this.workbenchActions.put(action.getId(), action);
        this.findReplaceAction = new FindReplaceAction(window);
        actionBars.setGlobalActionHandler(action.getId(), (IAction)this.findReplaceAction);
        this.registerTextActionHandlers();
    }

    private void addGlobalTextAction(IActionBars actionBars, IWorkbenchWindow window, ActionFactory actionFactory, int textOp) {
        ActionFactory.IWorkbenchAction action = actionFactory.create(window);
        this.workbenchActions.put(action.getId(), action);
        TextAction textAction = new TextAction(textOp);
        this.textActions.add(textAction);
        actionBars.setGlobalActionHandler(action.getId(), (IAction)textAction);
    }

    private ActionFactory.IWorkbenchAction getGlobalAction(String actionId) {
        return this.workbenchActions == null ? null : this.workbenchActions.get(actionId);
    }

    private void registerTextActionHandlers() {
        this.handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.handlerService != null) {
            this.activateHandler("font", "org.xmind.ui.command.text.font");
            this.activateHandler("bold", "org.xmind.ui.command.text.bold");
            this.activateHandler("italic", "org.xmind.ui.command.text.italic");
            this.activateHandler("underline", "org.xmind.ui.command.text.underline");
            this.activateHandler("leftAlign", "org.xmind.ui.command.text.leftAlign");
            this.activateHandler("centerAlign", "org.xmind.ui.command.text.centerAlign");
            this.activateHandler("rightAlign", "org.xmind.ui.command.text.rightAlign");
        }
    }

    private void activateHandler(String actionId, String commandId) {
        IRichTextAction action = this.topicViewerContributor.getRichTextAction(actionId);
        if (action != null) {
            action.setActionDefinitionId(commandId);
            IHandlerActivation activation = this.handlerService.activateHandler(commandId, (IHandler)new ActionHandler((IAction)action));
            if (this.handlerActivations == null) {
                this.handlerActivations = new ArrayList<IHandlerActivation>(10);
            }
            this.handlerActivations.add(activation);
        }
    }

    private void unRegisterTextActionHandlers() {
        if (this.handlerService != null && this.handlerActivations != null) {
            for (IHandlerActivation activation : this.handlerActivations) {
                this.handlerService.deactivateHandler(activation);
            }
        }
    }

    private void showBootstrapContent() {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)activeEditor);
        } else {
            this.editorSelectionChanged((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void dispose() {
        this.deactivateHandlers();
        this.removeSpellChecker();
        this.setCurrentTopicPart(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.setContributingEditor(null);
        if (this.handlerService != null && this.handlerActivations != null) {
            for (IHandlerActivation activation : this.handlerActivations) {
                this.handlerService.deactivateHandler(activation);
            }
        }
        this.handlerService = null;
        this.handlerActivations = null;
        super.dispose();
        if (this.findReplaceAction != null) {
            this.findReplaceAction.dispose();
            this.findReplaceAction = null;
        }
        if (this.workbenchActions != null) {
            for (ActionFactory.IWorkbenchAction action : this.workbenchActions.values()) {
                action.dispose();
            }
            this.workbenchActions = null;
        }
        this.textActions = null;
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
    }

    private void removeSpellChecker() {
        if (this.spellingPreferences != null) {
            this.spellingPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
            this.spellingPreferences = null;
        }
        if (this.spellingActivation != null) {
            this.spellingActivation.getSpellingSupport().deactivateSpelling(this.spellingActivation);
            this.spellingActivation = null;
        }
    }

    private void deactivateHandlers() {
        if (this.commitHandlerActivation != null) {
            this.commitHandlerActivation.getHandlerService().deactivateHandler(this.commitHandlerActivation);
            this.commitHandlerActivation = null;
        }
    }

    public void setFocus() {
        if (this.viewer instanceof TopicNotesViewer) {
            ((TopicNotesViewer)this.viewer).getImplementation().getFocusControl().setFocus();
        } else if (this.viewer instanceof SheetNotesViewer) {
            this.viewer.getControl().setFocus();
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part activated: " + part);
        }
        if (part == this || !(part instanceof IEditorPart)) {
            return;
        }
        if (part instanceof IGraphicalEditor) {
            this.setContributingEditor((IGraphicalEditor)part);
        }
    }

    private void setContributingEditor(IGraphicalEditor editor) {
        ISelectionProvider selectionProvider;
        ISelectionProvider selectionProvider2;
        if (editor == this.contributingEditor) {
            return;
        }
        if (this.contributingEditor != null && (selectionProvider2 = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider2.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        this.contributingEditor = editor;
        StructuredSelection newSelection = null;
        if (this.contributingEditor != null && (selectionProvider = this.contributingEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
            newSelection = selectionProvider.getSelection();
        }
        if (newSelection == null) {
            newSelection = StructuredSelection.EMPTY;
        }
        if (this.contentArea.isDisposed()) {
            return;
        }
        this.editorSelectionChanged((ISelection)newSelection);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part closed: " + part);
        }
        if (part == this.contributingEditor) {
            this.setContributingEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (DEBUG) {
            System.out.println("Part deactivated: " + part);
        }
        if (part == this) {
            this.saveNotes();
        }
    }

    private void saveNotes() {
        if (this.adapter == null || this.currentTopicPart == null || !(this.viewer instanceof TopicNotesViewer) || this.viewer.getControl().isDisposed() || !((TopicNotesViewer)this.viewer).hasModified()) {
            this.deactivateJob();
            return;
        }
        if (DEBUG) {
            System.out.println("Start saving notes");
        }
        this.savingNotes = true;
        ITopic topic = this.currentTopicPart.getTopic();
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            this.doSaveNotes(topic, cs);
        } else {
            this.forceSaveNotes(topic);
        }
        ((TopicNotesViewer)this.viewer).resetModified();
        this.savingNotes = false;
        this.deactivateJob();
        if (DEBUG) {
            System.out.println("End saving notes");
        }
    }

    private void forceSaveNotes(ITopic topic) {
        INotes notes = topic.getNotes();
        notes.setContent("html", this.adapter.makeNewHtmlContent());
        notes.setContent("plain", this.adapter.makeNewPlainContent());
    }

    private void doSaveNotes(ITopic topic, ICommandStack cs) {
        ModifyNotesCommand modifyHtml = new ModifyNotesCommand(topic, this.adapter.makeNewHtmlContent(), "html");
        ModifyNotesCommand modifyPlain = new ModifyNotesCommand(topic, this.adapter.makeNewPlainContent(), "plain");
        CompoundCommand cmd = new CompoundCommand(new Command[]{modifyHtml, modifyPlain});
        cmd.setLabel(CommandMessages.Command_ModifyNotes);
        cs.execute((Command)cmd);
    }

    private ICommandStack getCommandStack() {
        EditDomain domain = this.currentTopicPart.getSite().getViewer().getEditDomain();
        if (domain != null) {
            return domain.getCommandStack();
        }
        return null;
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        if (adapter == IFindReplaceOperationProvider.class) {
            if (this.notesOperationProvider == null) {
                this.notesOperationProvider = new NotesFindReplaceOperationProvider((IAdaptable)this);
            }
            return this.notesOperationProvider;
        }
        if (adapter == IFindReplaceTarget.class) {
            TextViewer textViewer;
            IRichTextEditViewer rtViewer;
            if (this.viewer instanceof TopicNotesViewer && (rtViewer = ((TopicNotesViewer)this.viewer).getImplementation()) != null && (textViewer = rtViewer.getTextViewer()) != null) {
                return textViewer.getFindReplaceTarget();
            }
        } else if (adapter == ITextViewer.class) {
            IRichTextEditViewer rtViewer;
            if (this.viewer instanceof TopicNotesViewer && (rtViewer = ((TopicNotesViewer)this.viewer).getImplementation()) != null) {
                return rtViewer.getTextViewer();
            }
        } else if (adapter == IRichTextEditViewer.class) {
            if (this.viewer instanceof TopicNotesViewer) {
                return ((TopicNotesViewer)this.viewer).getImplementation();
            }
        } else {
            if (adapter == ITopicPart.class) {
                return this.currentTopicPart;
            }
            if (adapter == ITopic.class) {
                return this.currentTopicPart == null ? null : this.currentTopicPart.getTopic();
            }
        }
        return super.getAdapter(adapter);
    }

    private void editorSelectionChanged(ISelection selection) {
        if (selection == this.currentSelection || selection != null && selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.setCurrentTopicPart(this.findSelectedTopicPart());
        if (this.currentSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)this.currentSelection).getFirstElement();
            this.updateViewer(obj);
        } else {
            this.updateViewer(null);
        }
    }

    private void setCurrentTopicPart(ITopicPart topicPart) {
        if (topicPart == this.currentTopicPart) {
            return;
        }
        this.unhookTopic();
        this.saveNotes();
        this.currentTopicPart = topicPart;
        this.hookTopic();
    }

    private void forceRefreshViewer() {
        RichDocumentNotesAdapter oldAdapter = this.adapter;
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.adapter = this.createNotesAdapter();
            if (DEBUG && this.adapter != null) {
                System.out.println("New adapter created");
            }
            this.unhookDocument();
            this.viewer.setInput(this.adapter);
            if (this.adapter != null) {
                this.hookDocument();
            }
        } else {
            this.adapter = null;
        }
        if (oldAdapter != null) {
            oldAdapter.dispose();
            if (DEBUG) {
                System.out.println("Old adapter disposed");
            }
        }
        this.update();
    }

    private void hookDocument() {
        IRichDocument document = ((TopicNotesViewer)this.viewer).getImplementation().getDocument();
        if (document != null) {
            document.addDocumentListener((IDocumentListener)this);
            document.addRichDocumentListener((IRichDocumentListener)this);
            if (DEBUG) {
                System.out.println("Document hooked");
            }
        }
    }

    private void unhookDocument() {
        IRichDocument document = ((TopicNotesViewer)this.viewer).getImplementation().getDocument();
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
            document.removeRichDocumentListener((IRichDocumentListener)this);
            if (DEBUG) {
                System.out.println("Document unhooked");
            }
        }
    }

    private void unhookTopic() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            if (DEBUG) {
                System.out.println("Model listeners uninstalled");
            }
            this.eventRegister = null;
        }
    }

    private void hookTopic() {
        if (this.currentTopicPart != null) {
            ITopic topic = this.currentTopicPart.getTopic();
            if (this.eventRegister == null) {
                this.eventRegister = new CoreEventRegister((Object)topic, (ICoreEventListener)this);
            }
            this.eventRegister.register("topicNotes");
            if (DEBUG) {
                System.out.println("Model listeners installed");
            }
        }
    }

    private RichDocumentNotesAdapter createNotesAdapter() {
        if (this.currentTopicPart == null) {
            return null;
        }
        ITopic topic = this.currentTopicPart.getTopic();
        return new RichDocumentNotesAdapter(topic);
    }

    private ITopicPart findSelectedTopicPart() {
        if (this.contributingEditor == null) {
            return null;
        }
        if (this.currentSelection == null || this.currentSelection.isEmpty() || !(this.currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)this.currentSelection).getFirstElement();
        IGraphicalEditorPage page = this.contributingEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        IPart part = page.getViewer().findPart(o);
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    public void handleCoreEvent(final CoreEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String eventType = event.getType();
                if ("topicNotes".equals(eventType)) {
                    NotesView.this.handleNotesChanged();
                }
            }
        });
    }

    private void handleNotesChanged() {
        if (this.savingNotes) {
            return;
        }
        this.forceRefreshViewer();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.update();
    }

    private void updateJob() {
        if (!(this.viewer instanceof TopicNotesViewer) || this.viewer.getControl().isDisposed()) {
            return;
        }
        if (((TopicNotesViewer)this.viewer).hasModified()) {
            this.activateJob();
        } else {
            this.deactivateJob();
        }
    }

    private void activateJob() {
        if (this.saveNotesReg != null && this.saveNotesReg.isValid()) {
            return;
        }
        this.saveNotesReg = null;
        IWorkbook workbook = (IWorkbook)this.contributingEditor.getAdapter(IWorkbook.class);
        if (workbook instanceof ICoreEventSource2) {
            this.saveNotesReg = ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", (ICoreEventListener)new SaveNotesJob());
            if (DEBUG) {
                System.out.println("Job acitvated");
            }
        }
    }

    private void deactivateJob() {
        if (this.saveNotesReg != null) {
            this.saveNotesReg.unregister();
            this.saveNotesReg = null;
        }
    }

    private void updateTextActions() {
        if (!(this.viewer instanceof TopicNotesViewer) || this.viewer.getControl().isDisposed() || this.textActions == null || this.textActions.isEmpty()) {
            return;
        }
        TextViewer textViewer = ((TopicNotesViewer)this.viewer).getImplementation().getTextViewer();
        if (textViewer != null) {
            for (TextAction action : this.textActions) {
                action.update(textViewer);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages) {
        this.update();
    }

    public void lineStyleChanged(IRichDocument document, LineStyle[] oldLineStyles, LineStyle[] newLineStyles) {
        this.update();
    }

    public void textStyleChanged(IRichDocument document, StyleRange[] oldTextStyles, StyleRange[] newTextStyles) {
        this.update();
    }

    public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
        this.update();
    }

    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                NotesView.this.updateJob();
                NotesView.this.updateTextActions();
                NotesView.this.updating = false;
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("SPELLING_CHECK_ENABLED".equals(event.getProperty())) {
            if (this.spellingActivation != null) {
                this.spellingActivation.getSpellingSupport().deactivateSpelling(this.spellingActivation);
                this.spellingActivation = null;
            }
            if (this.spellingPreferences.getBoolean("SPELLING_CHECK_ENABLED")) {
                this.spellingActivation = SpellingSupport.getInstance().activateSpelling((ITextViewer)((TopicNotesViewer)this.viewer).getImplementation().getTextViewer());
            }
        }
    }

    private void updateViewer(Object input) {
        if (this.contentArea == null || this.contentArea.isDisposed()) {
            return;
        }
        this.contentArea.setRedraw(false);
        this.contentArea.setEnabled(true);
        RichDocumentNotesAdapter oldAdapter = this.adapter;
        if (this.viewer instanceof TopicNotesViewer && input instanceof ITopic) {
            this.unhookDocument();
            this.adapter = this.createNotesAdapter();
            this.viewer.setInput(this.adapter);
            this.hookDocument();
        } else if (this.viewer instanceof SheetNotesViewer && input instanceof ISheet) {
            this.viewer.setInput((ISheet)input);
            ((SheetNotesViewer)this.viewer).setEditor(this.contributingEditor);
        } else {
            if (this.viewer instanceof TopicNotesViewer) {
                this.removeSpellChecker();
                this.deactivateHandlers();
                if (((TopicNotesViewer)this.viewer).getImplementation() != null) {
                    ((TopicNotesViewer)this.viewer).getImplementation().removePostSelectionChangedListener((ISelectionChangedListener)this);
                }
                this.unhookDocument();
            }
            if (this.viewer instanceof SheetNotesViewer) {
                ((SheetNotesViewer)this.viewer).setEditor(null);
            }
            if (this.viewer != null) {
                this.viewer.dispose();
                this.viewer = null;
            }
            if (input instanceof ITopic) {
                this.viewer = new TopicNotesViewer((IRichTextActionBarContributor)this.topicViewerContributor);
                this.viewer.createControl(this.contentArea);
                this.adapter = this.createNotesAdapter();
                this.viewer.setInput(this.adapter);
                this.addSpellChecker();
                this.activateHandlers();
                ((TopicNotesViewer)this.viewer).getImplementation().addPostSelectionChangedListener((ISelectionChangedListener)this);
                this.hookDocument();
                IActionBars actionBars = this.getViewSite().getActionBars();
                this.topicViewerContributor.fillMenu(actionBars.getMenuManager());
                new ContextActivator(((TopicNotesViewer)this.viewer).getImplementation().getFocusControl());
            } else if (input instanceof ISheet) {
                this.viewer = new SheetNotesViewer(this.contributingEditor);
                this.viewer.createControl(this.contentArea);
                this.viewer.setInput((ISheet)input);
            } else {
                this.contentArea.setEnabled(false);
            }
        }
        this.contentArea.setRedraw(true);
        this.contentArea.layout(true, true);
        if (oldAdapter != null) {
            oldAdapter.dispose();
        }
        this.update();
        this.unRegisterTextActionHandlers();
        this.registerTextActionHandlers();
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.listener == null) {
            this.listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    NotesView.this.editorSelectionChanged(event.getSelection());
                }
            };
        }
        return this.listener;
    }

    private class CommitNotesHandler
    extends AbstractHandler {
        private CommitNotesHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            NotesView.this.saveNotes();
            IWorkbenchPage page = NotesView.this.getSite().getPage();
            if (page != null && NotesView.this.contributingEditor != null && page == NotesView.this.contributingEditor.getSite().getPage()) {
                page.activate((IWorkbenchPart)NotesView.this.contributingEditor);
            }
            return null;
        }
    }

    private class ContextActivator
    implements FocusListener,
    DisposeListener {
        IContextActivation context;
        IContextService service;

        public ContextActivator(Control control) {
            control.addFocusListener((FocusListener)this);
            control.addDisposeListener((DisposeListener)this);
        }

        public void focusLost(FocusEvent e) {
            this.deactivateContext();
        }

        private void deactivateContext() {
            if (this.service != null && this.context != null) {
                this.service.deactivateContext(this.context);
            }
            this.context = null;
        }

        public void focusGained(FocusEvent e) {
            this.activateContext();
        }

        private void activateContext() {
            if (this.service == null) {
                this.service = (IContextService)NotesView.this.getSite().getService(IContextService.class);
            }
            if (this.service != null) {
                this.context = this.service.activateContext(NotesView.NOTES_EDIT_CONTEXT_ID);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.deactivateContext();
        }
    }

    private class InsertHyperlinkAction
    extends Action
    implements IRichTextAction {
        private IRichTextEditViewer viewer;

        public InsertHyperlinkAction(IRichTextEditViewer viewer) {
            super(MindMapMessages.InsertHyperlinkAction_text, MindMapUI.getImages().get("hyperlink.png", true));
            this.setToolTipText(MindMapMessages.InserthyperlinkAction_toolTip);
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("hyperlink.png", false));
            this.viewer = viewer;
        }

        public void run() {
            NotesHyperlinkDialog dialog;
            int ret;
            IRichTextRenderer renderer = this.viewer.getRenderer();
            ITextSelection selection = (ITextSelection)this.viewer.getSelection();
            String oldText = selection.getText();
            int start = selection.getOffset();
            int end = start + selection.getLength();
            Hyperlink[] oldHyperlinks = renderer.getSelectionHyperlinks();
            String oldHref = null;
            Hyperlink oldHyperlink = null;
            if (oldHyperlinks.length == 1) {
                Hyperlink link = oldHyperlinks[0];
                if (link.start <= selection.getOffset() && link.end() >= selection.getOffset() + selection.getLength()) {
                    oldHyperlink = link;
                    oldHref = link.href;
                    try {
                        oldText = this.viewer.getDocument().get(link.start, link.length);
                        start = link.start;
                        end = start + link.length;
                    }
                    catch (BadLocationException e) {
                        String message = String.format("Unexpected hyperlink range: start=%d, length=%d", link.start, link.length);
                        Logger.log(e, message);
                    }
                }
            }
            ImagePlaceHolder[] images = this.viewer.getDocument().getImages();
            int temp = -1;
            int i = 0;
            while (i < images.length) {
                ImagePlaceHolder image = images[i];
                if (image.offset >= end) break;
                if (image.offset >= start && image.offset <= end) {
                    int offset = image.offset - start;
                    oldText = String.valueOf(oldText.substring(0, offset - ++temp)) + oldText.substring(offset + 1 - temp);
                }
                ++i;
            }
            if ((ret = (dialog = new NotesHyperlinkDialog(NotesView.this.getSite().getShell(), oldHref, oldText)).open()) == 0) {
                String newText = dialog.getDisplayText();
                String newHref = dialog.getHref();
                if (oldHyperlink != null && newText.equals(oldText)) {
                    if (!oldHyperlink.href.equals(newHref)) {
                        RichTextUtils.replaceHyperlinkHref((IRichDocument)this.viewer.getDocument(), (Hyperlink)oldHyperlink, (String)newHref);
                    }
                } else {
                    if ("".equals(newText)) {
                        newText = newHref;
                    }
                    renderer.insertHyperlink(newHref, newText);
                }
            }
        }

        public void dispose() {
            this.viewer = null;
        }

        public void selectionChanged(IRichTextEditViewer viewer, ISelection selection) {
        }
    }

    private class InsertImageAction
    extends Action
    implements IRichTextAction {
        private IRichTextEditViewer viewer;

        public InsertImageAction(IRichTextEditViewer viewer) {
            super(MindMapMessages.InsertImage_text, MindMapUI.getImages().get("insertimage.png", true));
            this.viewer = viewer;
            this.setToolTipText(MindMapMessages.NotesView_InsertImage_toolTip);
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("insertimage.png", false));
        }

        public void run() {
            if (!(this.viewer instanceof RichTextEditViewer) || this.viewer.getControl().isDisposed() || NotesView.this.adapter == null) {
                return;
            }
            String path = this.getPath();
            if (path == null) {
                return;
            }
            Image image = NotesView.this.adapter.createImageFromFile(path);
            if (image == null) {
                return;
            }
            this.viewer.getRenderer().insertImage(image);
        }

        private String getPath() {
            FileDialog fd = new FileDialog(NotesView.this.getSite().getShell(), 4096);
            DialogUtils.makeDefaultImageSelectorDialog(fd, true);
            return fd.open();
        }

        public void dispose() {
            this.viewer = null;
        }

        public void selectionChanged(IRichTextEditViewer viewer, ISelection selection) {
        }
    }

    private class NotesViewRichTextActionBarContributor
    extends FullRichTextActionBarContributor {
        private IRichTextAction insertImageAction;
        private IRichTextAction insertHyperlinkAction;
        private IAction showAllNotesAction;

        private NotesViewRichTextActionBarContributor() {
        }

        protected void makeActions(IRichTextEditViewer viewer) {
            super.makeActions(viewer);
            this.insertImageAction = new InsertImageAction(viewer);
            this.addRichTextAction(this.insertImageAction);
            this.insertHyperlinkAction = new InsertHyperlinkAction(viewer);
            this.addRichTextAction(this.insertHyperlinkAction);
            this.showAllNotesAction = new ShowAllNotesAction(null);
        }

        public void fillMenu(IMenuManager menu) {
        }

        public void fillToolBar(IToolBarManager toolbar) {
            super.fillToolBar(toolbar);
            toolbar.add((IContributionItem)new Separator());
            toolbar.add((IAction)this.insertImageAction);
            toolbar.add((IAction)this.insertHyperlinkAction);
            toolbar.add(this.showAllNotesAction);
        }

        public void fillContextMenu(IMenuManager menu) {
            IMenuContributor contributor;
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.UNDO.getId()));
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.REDO.getId()));
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.CUT.getId()));
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.COPY.getId()));
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.PASTE.getId()));
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)NotesView.this.getGlobalAction(ActionFactory.SELECT_ALL.getId()));
            menu.add((IContributionItem)new Separator());
            super.fillContextMenu(menu);
            if (NotesView.this.spellingActivation != null && (contributor = (IMenuContributor)NotesView.this.spellingActivation.getAdapter(IMenuContributor.class)) != null) {
                menu.add((IContributionItem)new Separator());
                contributor.fillMenu(menu);
            }
        }
    }

    private class SaveNotesJob
    implements ICoreEventListener {
        private SaveNotesJob() {
        }

        public void handleCoreEvent(CoreEvent event) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    NotesView.this.saveNotes();
                }
            });
        }
    }

    private class TextAction
    extends Action {
        private int op;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (!(NotesView.this.viewer instanceof TopicNotesViewer) || NotesView.this.viewer.getControl().isDisposed()) {
                return;
            }
            TextViewer textViewer = ((TopicNotesViewer)NotesView.this.viewer).getImplementation().getTextViewer();
            if (textViewer.canDoOperation(this.op)) {
                textViewer.doOperation(this.op);
            }
        }

        public void update(TextViewer textViewer) {
            this.setEnabled(textViewer.canDoOperation(this.op));
        }
    }
}

