/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.xmind.gef.service.IRectangleProvider;
import org.xmind.gef.service.RectangleFeedback;
import org.xmind.ui.resources.ColorUtils;

public class MindMapFeedbackFactory {
    public static final String LINE_COLOR_AREA_SELECT = "#00007f";
    public static final String FILL_COLOR_AREA_SELECT = "#aaaac8";
    public static final String LINE_COLOR_SIMPLE_SELECTION = "#0000f0";
    public static final String LINE_COLOR_SIMPLE_PRESELECTION = "#0000ff";
    public static final String FILL_COLOR_SIMPLE_PRESELECTION = "#0000ff";

    private MindMapFeedbackFactory() {
    }

    public static RectangleFeedback createAreaSelectFeedback(IRectangleProvider boundsProvider) {
        RectangleFeedback feedback = new RectangleFeedback();
        feedback.setBorderColor(ColorUtils.getColor((String)LINE_COLOR_AREA_SELECT));
        feedback.setFillColor(ColorUtils.getColor((String)FILL_COLOR_AREA_SELECT));
        feedback.setBorderAlpha(160);
        feedback.setFillAlpha(96);
        feedback.setBoundsProvider(boundsProvider);
        return feedback;
    }

    public static RectangleFeedback createSimpleSelectionFeedback(IRectangleProvider boundsProvider) {
        RectangleFeedback feedback = new RectangleFeedback();
        feedback.setBorderColor(ColorUtils.getColor((String)LINE_COLOR_SIMPLE_SELECTION));
        feedback.setBorderAlpha(255);
        feedback.setBoundsProvider(boundsProvider);
        return feedback;
    }

    public static RectangleFeedback createSimplePreselectionFeedback(IRectangleProvider boundsProvider) {
        RectangleFeedback feedback = new RectangleFeedback();
        feedback.setBorderColor(ColorUtils.getColor((String)"#0000ff"));
        feedback.setFillColor(ColorUtils.getColor((String)"#0000ff"));
        feedback.setBorderAlpha(255);
        feedback.setFillAlpha(32);
        feedback.setBoundsProvider(boundsProvider);
        return feedback;
    }
}

