/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.AbstractEditPolicy;
import org.xmind.gef.service.IAnimationService;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapPolicyBase
extends AbstractEditPolicy {
    protected static final String EMPTY = "";

    protected IAnimationService getAnimationService(IViewer viewer) {
        return (IAnimationService)viewer.getService(IAnimationService.class);
    }

    protected void select(Object element, IViewer viewer) {
        StructuredSelection selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection(element);
        viewer.setSelection((ISelection)selection, true);
    }

    protected void select(List<?> elements, IViewer viewer) {
        viewer.setSelection((ISelection)new StructuredSelection(elements), true);
    }

    protected void selectPart(IPart part, IViewer viewer) {
        this.select(MindMapUtils.getRealModel(part), viewer);
    }

    protected void selectParts(List<? extends IPart> parts, IViewer viewer) {
        this.select(MindMapUtils.getRealModels(parts), viewer);
    }

    protected boolean isAnimationRequired(Request req) {
        return req.isParameter("withAnimation");
    }

    protected boolean isAnimationEnalbed(IViewer viewer) {
        return MindMapUI.isAnimationEnabled() && viewer.hasService(IAnimationService.class);
    }

    protected boolean animateCommand(Command cmd, IViewer viewer) {
        if (!this.isAnimationEnalbed(viewer)) {
            return false;
        }
        IAnimationService anim = this.getAnimationService(viewer);
        if (anim == null) {
            return false;
        }
        anim.stop();
        this.doAnimateCommand(cmd, anim, viewer);
        return true;
    }

    protected void doAnimateCommand(final Command cmd, IAnimationService anim, final IViewer viewer) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                MindMapPolicyBase.this.createAnimation(cmd, viewer);
            }
        };
        anim.start(job, this.createBeforeEffect(cmd, viewer), this.createAfterEffect(cmd, viewer));
    }

    protected Runnable createBeforeEffect(Command cmd, IViewer viewer) {
        return null;
    }

    protected Runnable createAfterEffect(Command cmd, IViewer viewer) {
        return null;
    }

    protected void createAnimation(Command cmd, IViewer viewer) {
        this.saveAndRun(cmd, viewer.getEditDomain());
    }
}

