/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.NavigablePolicy;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapNavigablePolicyBase
extends NavigablePolicy {
    public static final String CACHE_NAV_OUTGOING = "org.xmind.ui.cache.navigation.outgoing.";
    public static final String CACHE_NAV_INCOMING = "org.xmind.ui.cache.navigation.incoming.";

    protected void findNavParts(Request request, String navType, List<IPart> sources, List<IPart> result) {
        IPart navPart = this.findCachedNavigation(sources, this.invertNavType(navType));
        if (navPart != null) {
            result.add(navPart);
            this.setNavCaches(sources, navPart, navType);
            return;
        }
        navPart = this.findNewNavParts(request, navType, sources);
        this.setNavCaches(sources, navPart, navType);
        if (navPart != null) {
            result.add(navPart);
            return;
        }
        super.findNavParts(request, navType, sources, result);
    }

    protected abstract IPart findNewNavParts(Request var1, String var2, List<IPart> var3);

    protected String invertNavType(String navType) {
        if ("navigate_up".equals(navType)) {
            return "navigate_down";
        }
        if ("navigate_down".equals(navType)) {
            return "navigate_up";
        }
        if ("navigate_left".equals(navType)) {
            return "navigate_right";
        }
        if ("navigate_right".equals(navType)) {
            return "navigate_left";
        }
        return navType;
    }

    private String getCacheKey(String navType, boolean inOrOut) {
        String prefix = inOrOut ? CACHE_NAV_INCOMING : CACHE_NAV_OUTGOING;
        return String.valueOf(prefix) + navType.replaceAll("\\s", "_");
    }

    protected IPart findCachedNavigation(List<IPart> sources, String navType) {
        for (IPart source : sources) {
            IPart navPart = this.getCachedNavigation(source, navType);
            if (navPart == null) continue;
            return navPart;
        }
        return null;
    }

    protected IPart getCachedNavigation(IPart source, String navType) {
        String inKey = this.getCacheKey(navType, true);
        IPart target = (IPart)MindMapUtils.getCache(source, inKey);
        if (target != null) {
            if (target.getStatus().isActive() && target.hasRole("selectable role") && source == MindMapUtils.getCache(target, this.getCacheKey(navType, false))) {
                return target;
            }
            MindMapUtils.flushCache(source, inKey);
        }
        return null;
    }

    protected void setNavCaches(List<IPart> sources, IPart target, String navType) {
        if (!sources.isEmpty()) {
            this.setNavCache(sources.get(0), target, navType);
        }
        int i = 1;
        while (i < sources.size()) {
            this.setNavCache(sources.get(i), null, navType);
            ++i;
        }
    }

    protected void setNavCache(final IPart source, final IPart target, String navType) {
        final String outKey = this.getCacheKey(navType, false);
        if (target == null || target == source) {
            IPart oldTarget = (IPart)MindMapUtils.getCache(source, outKey);
            if (oldTarget != null) {
                MindMapUtils.flushCache(oldTarget, this.getCacheKey(navType, true));
            }
            MindMapUtils.flushCache(source, outKey);
        } else {
            MindMapUtils.setCache(source, outKey, target);
            if (source instanceof IGraphicalPart) {
                ((IGraphicalPart)source).getFigure().addFigureListener(new FigureListener(){

                    public void figureMoved(IFigure fig) {
                        fig.removeFigureListener((FigureListener)this);
                        MindMapUtils.flushCache(source, outKey);
                    }
                });
            }
        }
        if (target != null) {
            final String inKey = this.getCacheKey(navType, true);
            MindMapUtils.setCache(target, inKey, source);
            if (target instanceof IGraphicalPart) {
                ((IGraphicalPart)target).getFigure().addFigureListener(new FigureListener(){

                    public void figureMoved(IFigure fig) {
                        fig.removeFigureListener((FigureListener)this);
                        MindMapUtils.flushCache(target, inKey);
                    }
                });
            }
        }
    }
}

