/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.IArrowDecoration;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.internal.figures.RelationshipFigure;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipDecorator
extends Decorator {
    private static final RelationshipDecorator instance = new RelationshipDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof RelationshipFigure) {
            this.decorateRelationship(part, (RelationshipFigure)figure);
        }
    }

    public void deactivate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof RelationshipFigure) {
            RelationshipFigure rf = (RelationshipFigure)figure;
            rf.setSourceAnchor(null);
            rf.setTargetAnchor(null);
        }
        super.deactivate(part, figure);
    }

    private void decorateRelationship(IGraphicalPart part, RelationshipFigure figure) {
        this.decorateRelationship(part, StyleUtils.getStyleSelector(part), figure);
    }

    private void decorateRelationship(IGraphicalPart part, IStyleSelector ss, RelationshipFigure figure) {
        String newId;
        IRelationshipDecoration decoration = figure.getDecoration();
        if (!StyleUtils.isSameDecoration((IDecoration)decoration, newId = StyleUtils.getString(part, ss, "shape-class", "org.xmind.relationshipShape.straight"))) {
            decoration = StyleUtils.createRelationshipDecoration(part, newId);
            figure.setDecoration(decoration);
        }
        if (decoration != null) {
            String decorationId = decoration.getId();
            decoration.setAlpha((IFigure)figure, 255);
            decoration.setLineColor((IFigure)figure, StyleUtils.getColor(part, ss, "line-color", decorationId, "#3050f0"));
            decoration.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(part, ss, decorationId, 2));
            decoration.setLineWidth((IFigure)figure, StyleUtils.getInteger(part, ss, "line-width", decorationId, 3));
            this.decorateAnchors(part, figure, decoration);
            Object m = MindMapUtils.getRealModel((IPart)part);
            if (m instanceof IRelationship) {
                IRelationship r = (IRelationship)m;
                this.decorateControlPoints(r, figure, decoration);
            }
            this.decorateArrows(part, ss, figure, decoration);
            decoration.setVisible((IFigure)figure, decoration.getSourceAnchor() != null && decoration.getTargetAnchor() != null && figure.isVisible());
            decoration.reroute((IFigure)figure);
            figure.setBounds(decoration.getPreferredBounds((IFigure)figure));
        }
    }

    private void decorateAnchors(IGraphicalPart part, RelationshipFigure figure, IRelationshipDecoration decoration) {
        if (part instanceof IRelationshipPart) {
            IRelationshipPart rel = (IRelationshipPart)part;
            INodePart sourceNode = rel.getSourceNode();
            IAnchor anchor = sourceNode == null ? null : sourceNode.getSourceAnchor(rel);
            figure.setSourceAnchor(anchor);
            INodePart targetNode = rel.getTargetNode();
            anchor = targetNode == null ? null : targetNode.getTargetAnchor(rel);
            figure.setTargetAnchor(anchor);
            figure.setVisible(sourceNode != null && sourceNode.getFigure().isShowing() && targetNode != null && targetNode.getFigure().isShowing());
        }
    }

    private void decorateArrows(IGraphicalPart part, IStyleSelector ss, RelationshipFigure figure, IRelationshipDecoration decoration) {
        String newArrow2Id;
        IArrowDecoration arrow2;
        String newArrow1Id;
        IArrowDecoration arrow1 = decoration.getArrow1();
        if (!StyleUtils.isSameDecoration(arrow1, newArrow1Id = StyleUtils.getString(part, ss, "arrow-begin-class", "org.xmind.arrowShape.dot"))) {
            arrow1 = StyleUtils.createArrowDecoration(part, newArrow1Id);
            decoration.setArrow1((IFigure)figure, arrow1);
        }
        if (arrow1 != null) {
            this.decorateArrow(part, figure, decoration, arrow1);
        }
        if (!StyleUtils.isSameDecoration(arrow2 = decoration.getArrow2(), newArrow2Id = StyleUtils.getString(part, ss, "arrow-end-class", "org.xmind.arrowShape.normal"))) {
            arrow2 = StyleUtils.createArrowDecoration(part, newArrow2Id);
            decoration.setArrow2((IFigure)figure, arrow2);
        }
        if (arrow2 != null) {
            this.decorateArrow(part, figure, decoration, arrow2);
        }
    }

    private void decorateArrow(IGraphicalPart part, RelationshipFigure figure, IRelationshipDecoration decoration, IArrowDecoration arrow) {
        arrow.setColor((IFigure)figure, decoration.getLineColor());
        arrow.setWidth((IFigure)figure, decoration.getLineWidth());
    }

    private void decorateControlPoints(IRelationship r, RelationshipFigure figure, IRelationshipDecoration decoration) {
        if (r != null) {
            IControlPoint cp0 = r.getControlPoint(0);
            decoration.setRelativeSourceControlPoint((IFigure)figure, MindMapUtils.toGraphicalPosition(cp0.getPosition()));
            Double angle = cp0 == null ? null : Double.valueOf(cp0.getPolarAngle());
            Double amount = cp0 == null ? null : Double.valueOf(cp0.getPolarAmount());
            decoration.setSourceControlPointHint((IFigure)figure, angle, amount);
            IControlPoint cp1 = r.getControlPoint(1);
            decoration.setRelativeTargetControlPoint((IFigure)figure, MindMapUtils.toGraphicalPosition(cp1.getPosition()));
            angle = cp1 == null ? null : Double.valueOf(cp1.getPolarAngle());
            amount = cp1 == null ? null : Double.valueOf(cp1.getPolarAmount());
            decoration.setTargetControlPointHint((IFigure)figure, angle, amount);
        }
    }

    public static RelationshipDecorator getInstance() {
        return instance;
    }
}

