/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.xmind.gef.draw2d.IRotatable;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.RotatableLineBorder;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class LabelDecorator
extends Decorator {
    private static final LabelDecorator instance = new LabelDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setOpaque(true);
        RotatableLineBorder border = new RotatableLineBorder(1);
        figure.setBorder((Border)border);
        figure.setFont(JFaceResources.getDefaultFont());
        if (figure instanceof RotatableWrapLabel) {
            ((RotatableWrapLabel)figure).setSingleLine(true);
        }
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        figure.setVisible(this.isLabelVisible(part, figure));
        IStyleSelector ss = StyleUtils.getStyleSelector(part);
        figure.setBackgroundColor(StyleUtils.getColor(part, ss, "svg:fill", null, "#ffff80"));
        figure.setForegroundColor(StyleUtils.getColor(part, ss, "fo:color", null, "#000000"));
        Border border = figure.getBorder();
        if (border instanceof RotatableLineBorder) {
            ((RotatableLineBorder)border).setColor(StyleUtils.getColor(part, ss, "line-color", null, "#a0a0a0"));
        }
        if (part instanceof ILabelPart) {
            IBranchPart branch;
            ILabelPart label = (ILabelPart)part;
            ITextFigure textFigure = this.getTextFigure(figure);
            if (textFigure != null) {
                textFigure.setText(label.getLabelText());
            }
            if (figure instanceof IRotatable && (branch = label.getOwnedBranch()) != null) {
                IStyleSelector bss = branch.getBranchPolicy().getStyleSelector(branch);
                double angle = StyleUtils.getDouble(branch, bss, "rotate-angle", 0.0);
                ((IRotatable)figure).setRotationDegrees(angle);
            }
        }
    }

    private boolean isLabelVisible(IGraphicalPart part, IFigure figure) {
        IBranchPart parent;
        IBranchPart branch = MindMapUtils.findBranch((IPart)part);
        if (branch != null && (parent = branch.getParentBranch()) != null) {
            IStyleSelector ss = StyleUtils.getStyleSelector(parent);
            String value = ss.getStyleValue((IGraphicalPart)parent, "hide-children-labels");
            if (Boolean.TRUE.toString().equals(value)) {
                return false;
            }
        }
        return true;
    }

    private ITextFigure getTextFigure(IFigure figure) {
        if (figure instanceof ITextFigure) {
            return (ITextFigure)figure;
        }
        if (figure instanceof ITitledFigure) {
            return ((ITitledFigure)figure).getTitle();
        }
        return null;
    }

    public static LabelDecorator getInstance() {
        return instance;
    }
}

