/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.xmind.core.ISheet;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.util.CloneHandler;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.actions.ViewerAction;
import org.xmind.ui.util.MarkerImageDescriptor;

public class ReplaceMarkerAction
extends ViewerAction {
    private final IMarkerRef sourceMarkerRef;
    private final IMarker targetMarker;

    public ReplaceMarkerAction(IGraphicalViewer viewer, IMarkerRef sourceMarkerRef, IMarker targetMarker) {
        super(viewer);
        Assert.isNotNull((Object)sourceMarkerRef);
        Assert.isNotNull((Object)targetMarker);
        this.sourceMarkerRef = sourceMarkerRef;
        this.targetMarker = targetMarker;
        ISheet sheet = sourceMarkerRef.getOwnedSheet();
        String text = sheet == null || !sheet.getLegend().getMarkerIds().contains(targetMarker.getId()) ? null : sheet.getLegend().getMarkerDescription(targetMarker.getId());
        text = text == null ? targetMarker.getName() : text;
        this.setText(text == null ? "" : text);
        this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(targetMarker, 16, 16));
        boolean sameMarker = targetMarker.getId().equals(sourceMarkerRef.getMarkerId());
        this.setChecked(sameMarker);
        this.setEnabled(!sameMarker);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                ReplaceMarkerAction.this.runSafely();
            }
        });
    }

    private void runSafely() throws IOException {
        IMarker actualTargetMarker = this.sourceMarkerRef.getOwnedWorkbook().getMarkerSheet().findMarker(this.targetMarker.getId());
        if (actualTargetMarker == null && (actualTargetMarker = (IMarker)new CloneHandler().withMarkerSheets(this.targetMarker.getOwnedSheet(), this.sourceMarkerRef.getOwnedWorkbook().getMarkerSheet()).cloneObject((Object)this.targetMarker)) == null) {
            return;
        }
        CompoundCommand command = new CompoundCommand(CommandMessages.Command_ReplaceMarker, new Command[]{new DeleteMarkerCommand(this.sourceMarkerRef), new AddMarkerCommand(this.sourceMarkerRef.getParent(), actualTargetMarker.getId())});
        this.executeCommand((Command)command);
    }
}

