/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.ILineStyleModifier;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.IStyleRangeModifier;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.LineStyleModifier;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.richtext.RichTextViewerUndoManager;
import org.xmind.ui.richtext.StyleRangeModifier;
import org.xmind.ui.viewers.SWTUtils;

public class RichTextRenderer
implements IRichTextRenderer {
    private TextViewer viewer;
    private IRichDocument document;
    private IDocumentListener documentChangeHandler;
    private IRichDocumentListener richDocumentChangeHandler;
    private StyleRange selectionTextStyle;
    private LineStyle selectionLineStyle;
    private boolean ignoreDocumentChange = false;
    private Point lineRangeBeforeChange = null;
    private boolean asyncRefreshing = false;
    private static StyleRangeModifier boldModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setBold(style, (Boolean)value);
        }
    };
    private static StyleRangeModifier italicModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setItalic(style, (Boolean)value);
        }
    };
    private static StyleRangeModifier underlineModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            boolean v = (Boolean)value;
            if (style.underline == v) {
                return false;
            }
            style.underline = v;
            return true;
        }
    };
    private static StyleRangeModifier strikeoutModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            boolean v = (Boolean)value;
            if (style.strikeout == v) {
                return false;
            }
            style.strikeout = v;
            return true;
        }
    };
    private static StyleRangeModifier faceModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setFontFace(style, (String)value);
        }
    };
    private static StyleRangeModifier sizeModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setFontSize(style, (Integer)value);
        }
    };
    private static StyleRangeModifier fontModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setFont(style, (Font)value);
        }
    };
    private static StyleRangeModifier foregroundModifier = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setForeground(style, (Color)value);
        }
    };
    private static StyleRangeModifier backgroundModifer = new StyleRangeModifier(){

        @Override
        protected boolean modify(StyleRange style, Object value) {
            return RichTextUtils.setBackground(style, (Color)value);
        }
    };
    private static LineStyleModifier alignmentModifier = new LineStyleModifier(){

        @Override
        protected boolean modify(LineStyle style, Object value) {
            int alignment = (Integer)value;
            if (style.alignment == alignment) {
                return false;
            }
            style.alignment = alignment;
            return true;
        }

        @Override
        protected void updateViewer(TextViewer viewer, int startLine, int lineCount, Object value) {
            int alignment = (Integer)value;
            int endLine = startLine + lineCount;
            StyledText textWidget = viewer.getTextWidget();
            int line = startLine;
            while (line < endLine) {
                int wLine = viewer.modelLine2WidgetLine(line);
                textWidget.setLineAlignment(wLine, 1, alignment);
                ++line;
            }
        }
    };
    private static LineStyleModifier indentReplacer = new LineStyleModifier(){

        @Override
        protected boolean modify(LineStyle style, Object value) {
            int indent = (Integer)value;
            if (indent == style.indent) {
                return false;
            }
            style.indent = indent;
            return true;
        }

        @Override
        protected void updateViewer(TextViewer viewer, int startLine, int lineCount, Object value) {
            IDocument document = viewer.getDocument();
            if (document == null) {
                return;
            }
            int indent = (Integer)value;
            int endLine = startLine + lineCount;
            Point range = viewer.getSelectedRange();
            range = new Point(range.x, range.y);
            try {
                int line = startLine;
                while (line < endLine) {
                    int realDeltaIndent = RichTextUtils.replaceDocumentIndent(document, line, indent);
                    if (line == startLine) {
                        range.x += realDeltaIndent;
                    } else {
                        range.y += realDeltaIndent;
                    }
                    ++line;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            viewer.setSelectedRange(range.x, range.y);
        }
    };
    private static LineStyleModifier indentModifier = new LineStyleModifier(){

        @Override
        protected boolean modify(LineStyle style, Object value) {
            int deltaIndent = (Integer)value;
            if (deltaIndent == 0 || deltaIndent < 0 && style.indent == 0) {
                return false;
            }
            style.indent += deltaIndent;
            return true;
        }

        @Override
        protected void updateViewer(TextViewer viewer, int startLine, int lineCount, Object value) {
            IDocument document = viewer.getDocument();
            if (document == null) {
                return;
            }
            int deltaIndent = (Integer)value;
            int endLine = startLine + lineCount;
            Point range = viewer.getSelectedRange();
            range = new Point(range.x, range.y);
            try {
                int line = startLine;
                while (line < endLine) {
                    int realDeltaIndent = RichTextUtils.modifyDocumentIndent(viewer, document, line, deltaIndent);
                    if (line == startLine) {
                        range.x += realDeltaIndent;
                    } else {
                        range.y += realDeltaIndent;
                    }
                    ++line;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            viewer.setSelectedRange(range.x, range.y);
        }
    };
    private static LineStyleModifier bulletModifier = new LineStyleModifier(){

        @Override
        protected boolean modify(LineStyle style, Object value) {
            String v = (String)value;
            if (style.bulletStyle.equals(v)) {
                return false;
            }
            style.bulletStyle = v;
            return true;
        }

        @Override
        protected void updateViewer(TextViewer viewer, int startLine, int lineCount, Object value) {
            String v = (String)value;
            StyledText styledText = viewer.getTextWidget();
            StyleRange style = new StyleRange();
            style.metrics = new GlyphMetrics(0, 0, 50);
            styledText.setLineBullet(startLine, lineCount, null);
            if (v.equals("bullet")) {
                Bullet bullet = new Bullet(style);
                styledText.setLineBullet(startLine, lineCount, bullet);
            } else if (v.equals("number")) {
                Bullet bullet = new Bullet(32, style);
                styledText.setLineBullet(startLine, lineCount, bullet);
            } else {
                styledText.setLineBullet(startLine, lineCount, null);
            }
        }
    };

    public RichTextRenderer(TextViewer viewer) {
        this.viewer = viewer;
        this.initialize(viewer);
    }

    private void initialize(TextViewer viewer) {
        this.documentChangeHandler = new DocumentListener();
        this.richDocumentChangeHandler = new RichDocumentListener();
        IDocument doc = viewer.getDocument();
        if (doc instanceof IRichDocument) {
            this.document = (IRichDocument)doc;
            this.document.addDocumentListener(this.documentChangeHandler);
            this.document.addRichDocumentListener(this.richDocumentChangeHandler);
        }
        viewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                if (oldInput != newInput) {
                    if (RichTextRenderer.this.document != null) {
                        RichTextRenderer.this.document.removeDocumentListener(RichTextRenderer.this.documentChangeHandler);
                        RichTextRenderer.this.document.removeRichDocumentListener(RichTextRenderer.this.richDocumentChangeHandler);
                    }
                    if (newInput != null && newInput instanceof IRichDocument) {
                        RichTextRenderer.this.document = (IRichDocument)newInput;
                        RichTextRenderer.this.document.addDocumentListener(RichTextRenderer.this.documentChangeHandler);
                        RichTextRenderer.this.document.addRichDocumentListener(RichTextRenderer.this.richDocumentChangeHandler);
                    } else {
                        RichTextRenderer.this.document = null;
                    }
                    RichTextRenderer.this.initialize();
                }
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)sel;
                    int offset = ts.getOffset();
                    int length = ts.getLength();
                    RichTextRenderer.this.updateSelectionTextStyle(offset, length);
                    if (RichTextRenderer.this.document != null) {
                        try {
                            int line = RichTextRenderer.this.document.getLineOfOffset(offset);
                            RichTextRenderer.this.updateSelectionLineStyle(line);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            }
        });
        viewer.getTextWidget().addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                StyleRange style = event.style;
                int start = style.start;
                Image image = RichTextRenderer.this.document.findImage(start);
                if (image != null && !image.isDisposed()) {
                    GC gc = event.gc;
                    int x = event.x;
                    GlyphMetrics metrics = style.metrics;
                    if (metrics != null) {
                        int y = event.y + event.ascent - metrics.ascent;
                        gc.drawImage(image, x, y);
                    }
                }
            }
        });
        viewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey(e.stateMask, e.keyCode, 0, 13)) {
                    if (RichTextRenderer.this.document == null) {
                        return;
                    }
                    RichTextRenderer.this.handEntryKey();
                } else if (SWTUtils.matchKey(e.stateMask, e.keyCode, 0, 8)) {
                    if (RichTextRenderer.this.document == null) {
                        return;
                    }
                    RichTextRenderer.this.handleBackspaceKey();
                }
            }
        });
    }

    private void handEntryKey() {
        if ("none".equals(this.selectionLineStyle.bulletStyle)) {
            return;
        }
        List<LineStyle> lineStyles = this.getModifiableLineStyles();
        if (lineStyles == null || lineStyles.isEmpty()) {
            return;
        }
        Point point = this.getSelectedLineRange();
        int startLine = point.x;
        if (this.find(startLine)) {
            LineStyle lineStyle = this.findLineStyleAt(startLine);
            lineStyles.remove(lineStyle);
            lineStyles.remove(this.findLineStyleAt(startLine - 1));
            this.document.setLineStyles(lineStyles.toArray(IRichDocument.EMPTY_LINE_STYLES));
        }
    }

    private boolean find(int startLine) {
        block7: {
            block6: {
                block5: {
                    try {
                        IRegion r1 = this.document.getLineInformation(startLine - 1);
                        String content1 = this.document.get(r1.getOffset(), r1.getLength());
                        if ("".equals(content1)) break block5;
                        return false;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                String style1 = this.findLineStyleAt((int)(startLine - 1)).bulletStyle;
                if (!"none".equals(style1)) break block6;
                return false;
            }
            IRegion r = this.document.getLineInformation(startLine);
            String content2 = this.document.get(r.getOffset(), r.getLength());
            if ("".equals(content2)) break block7;
            return false;
        }
        String style2 = this.findLineStyleAt((int)startLine).bulletStyle;
        return !"none".equals(style2);
    }

    private void handleBackspaceKey() {
        try {
            IRegion lineInfo = this.document.getLineInformation(0);
            if (lineInfo.getLength() == 0 && lineInfo.getOffset() == 0) {
                RichTextRenderer.getBulletModifier("none").updateViewer(this.viewer, 0, 1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void initialize() {
        this.selectionTextStyle = (StyleRange)RichTextUtils.DEFAULT_STYLE.clone();
        this.ignoreDocumentChange = false;
        this.refreshViewer();
    }

    private void asyncRefreshViewer() {
        if (this.asyncRefreshing) {
            return;
        }
        this.asyncRefreshing = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                RichTextRenderer.this.refreshViewer();
                RichTextRenderer.this.asyncRefreshing = false;
            }
        });
    }

    private void refreshViewer() {
        if (this.document != null && this.viewer != null) {
            this.refreshViewer(this.document.getTextStyles());
            this.viewer.invalidateTextPresentation();
            LineStyle[] lineStyles = this.document.getLineStyles();
            int lineStyleIndex = lineStyles.length == 0 ? -1 : 0;
            LineStyle lineStyle = lineStyleIndex < 0 ? null : lineStyles[lineStyleIndex];
            int lines = this.document.getNumberOfLines();
            int i = 0;
            while (i < lines) {
                if (lineStyle != null && i == lineStyle.lineIndex) {
                    RichTextRenderer.getAlignmentModifier(lineStyle.alignment).updateViewer(this.viewer, lineStyle.lineIndex, 1);
                    RichTextRenderer.getBulletModifier(lineStyle.bulletStyle).updateViewer(this.viewer, lineStyle.lineIndex, 1);
                    lineStyle = ++lineStyleIndex >= lineStyles.length ? null : lineStyles[lineStyleIndex];
                } else {
                    RichTextRenderer.getAlignmentModifier(16384).updateViewer(this.viewer, i, 1);
                    RichTextRenderer.getBulletModifier("none").updateViewer(this.viewer, i, 1);
                }
                ++i;
            }
        }
    }

    public StyleRange getSelectionTextStyle() {
        this.updateSelectionTextStyle();
        return this.selectionTextStyle;
    }

    private void updateSelectionTextStyle() {
        Point range = this.viewer.getSelectedRange();
        this.updateSelectionTextStyle(range.x, range.y);
    }

    private void updateSelectionTextStyle(int offset, int length) {
        if (this.selectionTextStyle == null || offset != this.selectionTextStyle.start || length != this.selectionTextStyle.length) {
            StyleRange style = this.findTextStyleAt(offset, length);
            if (style == null) {
                style = RichTextUtils.DEFAULT_STYLE;
            }
            this.selectionTextStyle = (StyleRange)style.clone();
            this.selectionTextStyle.metrics = null;
        }
        this.selectionTextStyle.start = offset;
        this.selectionTextStyle.length = length;
    }

    protected StyleRange findTextStyleAt(int offset, int length) {
        return this.document == null ? null : this.document.findTextStyle(offset, length);
    }

    protected LineStyle getSelectionLineStyle() {
        this.updateSelectionLineStyle();
        return this.selectionLineStyle;
    }

    private void updateSelectionLineStyle() {
        Point range = this.getSelectedLineRange();
        this.updateSelectionLineStyle(range.x);
    }

    private void updateSelectionLineStyle(int startLine) {
        if (this.selectionLineStyle == null || this.selectionLineStyle.lineIndex != startLine) {
            LineStyle lineStyle = this.findLineStyleAt(startLine);
            if (lineStyle == null) {
                lineStyle = RichTextUtils.DEFAULT_LINE_STYLE;
            }
            this.selectionLineStyle = (LineStyle)lineStyle.clone();
        }
        this.selectionLineStyle.lineIndex = startLine;
        LineStyle style = this.findLineStyleAt(startLine);
        if (style != null) {
            this.selectionLineStyle.bulletStyle = style.bulletStyle;
        }
    }

    private LineStyle findLineStyleAt(int startLine) {
        return this.document == null ? null : this.document.findLineStyle(startLine);
    }

    @Override
    public Color getSelectionBackground() {
        return RichTextUtils.getBackground(this.getSelectionTextStyle());
    }

    @Override
    public Font getSelectionFont() {
        return RichTextUtils.getFont(this.getSelectionTextStyle());
    }

    @Override
    public boolean getSelectionFontBold() {
        return RichTextUtils.isBold(this.getSelectionTextStyle());
    }

    @Override
    public String getSelectionFontFace() {
        return RichTextUtils.getFontFace(this.getSelectionTextStyle());
    }

    @Override
    public boolean getSelectionFontItalic() {
        return RichTextUtils.isItalic(this.getSelectionTextStyle());
    }

    @Override
    public int getSelectionFontSize() {
        return RichTextUtils.getFontSize(this.getSelectionTextStyle());
    }

    @Override
    public boolean getSelectionFontStrikeout() {
        return this.getSelectionTextStyle().strikeout;
    }

    @Override
    public boolean getSelectionFontUnderline() {
        return this.getSelectionTextStyle().underline;
    }

    @Override
    public Color getSelectionForeground() {
        return RichTextUtils.getForeground(this.getSelectionTextStyle());
    }

    @Override
    public int getSelectionParagraphAlignment() {
        return this.getSelectionLineStyle().alignment;
    }

    @Override
    public int getSelectionParagraphIndent() {
        return this.getSelectionLineStyle().indent;
    }

    @Override
    public boolean getBulletSelectionParagraph() {
        LineStyle lineStyle = this.getSelectionLineStyle();
        return "bullet".equals(lineStyle.bulletStyle);
    }

    @Override
    public boolean getNumberSelectionParagraph() {
        LineStyle lineStyle = this.getSelectionLineStyle();
        return "number".equals(lineStyle.bulletStyle);
    }

    @Override
    public void indentSelectionParagraph() {
        this.modifySelectionLineStyles(RichTextRenderer.getIndentModifier(1));
    }

    @Override
    public void bulletSelectionParagraph(boolean bullet) {
        String bulletStyle = bullet ? "bullet" : "none";
        this.modifySelectionLineStyles(RichTextRenderer.getBulletModifier(bulletStyle));
    }

    @Override
    public void numberSelectionParagraph(boolean number) {
        String bulletStyle = number ? "number" : "none";
        this.modifySelectionLineStyles(RichTextRenderer.getBulletModifier(bulletStyle));
    }

    @Override
    public void insertHyperlink(String href) {
        this.insertHyperlink(href, null);
    }

    @Override
    public void insertHyperlink(String href, String displayText) {
        int oldLength;
        Point range = this.viewer.getSelectedRange();
        this.updateSelectionTextStyle();
        this.commitLastChange();
        this.beginCompoundChange();
        range = this.modifyHyperlinksPosition(range);
        int start = range.x;
        int newLength = oldLength = range.y;
        if (displayText != null) {
            newLength = displayText.length();
            try {
                this.document.replace(start, oldLength, displayText);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return;
            }
        }
        this.addHyperlinkToDocument(start, newLength, href);
        this.setSelectedRange(start + newLength, 0);
        this.endCompoundChange();
        this.commitLastChange();
    }

    private Point modifyHyperlinksPosition(Point range) {
        int start = range.x;
        int oldLength = range.y;
        int oldEnd = start + oldLength;
        int length = this.document.getLength();
        if (start == length) {
            return range;
        }
        List<Hyperlink> hyperlinks = this.getModifiableHyperlinks();
        int i = 0;
        while (i < hyperlinks.size()) {
            Hyperlink hyper = hyperlinks.get(i);
            int hyperStart = hyper.start;
            int hyperEnd = hyper.end();
            if (oldEnd <= hyperStart) break;
            if (start >= hyperStart && oldEnd <= hyperEnd) {
                start = hyperStart;
                oldLength = hyperEnd - hyperStart;
                break;
            }
            ++i;
        }
        return new Point(start, oldLength);
    }

    private void addHyperlinkToDocument(int start, int newLength, String hyperlink) {
        int end = start + newLength;
        List<Hyperlink> oldHyperlinks = this.getModifiableHyperlinks();
        int i = 0;
        while (i < oldHyperlinks.size()) {
            Hyperlink indexHyper = oldHyperlinks.get(i);
            if (end <= indexHyper.start) break;
            int hyperStart = indexHyper.start;
            int hyperEnd = indexHyper.end();
            if (hyperStart < end && start < hyperEnd) {
                if (end <= hyperEnd && start < hyperStart) {
                    indexHyper.length = hyperEnd - end;
                    indexHyper.start = end;
                }
                if (start > hyperStart && end > hyperEnd) {
                    indexHyper.length = end - hyperStart;
                }
                if (end <= hyperEnd && start >= hyperStart) {
                    oldHyperlinks.remove(i);
                    break;
                }
            }
            ++i;
        }
        int index = this.getInsertHyperlinkIndex(start, oldHyperlinks);
        Hyperlink hyper = new Hyperlink(start, newLength, hyperlink);
        oldHyperlinks.add(index, hyper);
        this.document.setHyperlinks(oldHyperlinks.toArray(IRichDocument.EMPTY_HYPERLINK));
    }

    private List<Hyperlink> getModifiableHyperlinks() {
        Hyperlink[] oldHyperlinks = this.document.getHyperlinks();
        ArrayList<Hyperlink> newHyperlinks = new ArrayList<Hyperlink>(oldHyperlinks.length);
        Hyperlink[] hyperlinkArray = oldHyperlinks;
        int n = oldHyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            Hyperlink hyper = hyperlinkArray[n2];
            newHyperlinks.add((Hyperlink)hyper.clone());
            ++n2;
        }
        return newHyperlinks;
    }

    private int getInsertHyperlinkIndex(int offset, List<Hyperlink> hyperlinks) {
        int i = 0;
        while (i < hyperlinks.size()) {
            Hyperlink hyperlink = hyperlinks.get(i);
            if (hyperlink.start >= offset) {
                return i;
            }
            ++i;
        }
        return i;
    }

    @Override
    public Hyperlink[] getSelectionHyperlinks() {
        Point range = this.viewer.getSelectedRange();
        Hyperlink[] hyperlinks = this.document.getHyperlinks();
        List<Hyperlink> list = RichTextUtils.getHyperlinksInRange(hyperlinks, range.x, range.x + range.y);
        return list.toArray(new Hyperlink[list.size()]);
    }

    @Override
    public void outdentSelectionParagraph() {
        this.modifySelectionLineStyles(RichTextRenderer.getIndentModifier(-1));
    }

    @Override
    public void insertImage(Image image) {
        Point range = this.viewer.getSelectedRange();
        int start = range.x;
        int oldLength = range.y;
        String placeHolder = "\ufffc";
        int newLength = placeHolder.length();
        this.updateSelectionTextStyle();
        this.commitLastChange();
        this.beginCompoundChange();
        try {
            this.document.replace(start, oldLength, placeHolder);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        this.addImageToDocument(image, start);
        this.addImageStyleRangeToDocument(image, start, newLength);
        this.setSelectedRange(start + newLength, 0);
        this.endCompoundChange();
        this.commitLastChange();
    }

    @Override
    public void setSelectionBackground(Color color) {
        this.modifySelectionTextStyles(RichTextRenderer.getBackgroundModifier(color));
    }

    @Override
    public void setSelectionFont(Font font) {
        this.modifySelectionTextStyles(RichTextRenderer.getFontModifier(font));
    }

    @Override
    public void setSelectionFontBold(boolean bold) {
        this.modifySelectionTextStyles(RichTextRenderer.getBoldModifier(bold));
    }

    @Override
    public void setSelectionFontFace(String fontFace) {
        this.modifySelectionTextStyles(RichTextRenderer.getFontFaceModifier(fontFace));
    }

    @Override
    public void setSelectionFontItalic(boolean italic) {
        this.modifySelectionTextStyles(RichTextRenderer.getItalicModifier(italic));
    }

    @Override
    public void setSelectionFontSize(int size) {
        this.modifySelectionTextStyles(RichTextRenderer.getFontSizeModifier(size));
    }

    @Override
    public void setSelectionFontStrikeout(boolean strikeout) {
        this.modifySelectionTextStyles(RichTextRenderer.getStrikeoutModifier(strikeout));
    }

    @Override
    public void setSelectionFontUnderline(boolean underline) {
        this.modifySelectionTextStyles(RichTextRenderer.getUnderlineModifier(underline));
    }

    @Override
    public void setSelectionForeground(Color color) {
        this.modifySelectionTextStyles(RichTextRenderer.getForegroundModifier(color));
    }

    @Override
    public void setSelectionParagraphAlignment(int alignment) {
        this.modifySelectionLineStyles(RichTextRenderer.getAlignmentModifier(alignment));
    }

    @Override
    public void setSelectionParagraphIndent(int insertIndent) {
        this.modifySelectionLineStyles(RichTextRenderer.getIndentReplacer(insertIndent));
    }

    protected void updateDocumentPositions(DocumentEvent event) {
        if (this.document == null) {
            return;
        }
        int start = event.getOffset();
        int oldLength = event.getLength();
        int newLength = event.getText().length();
        this.updateTextStylesInDocument(start, oldLength, newLength);
        this.updateLineStylesInDocument(start, oldLength, newLength, event.getText());
        this.updateImagesInDocument(start, oldLength, newLength);
        this.updateHyperlinksInDocument(start, oldLength, newLength);
    }

    private void updateHyperlinksInDocument(int start, int oldLength, int newLength) {
        List<Hyperlink> hyperlinks = this.getModifiableHyperlinks();
        RichTextUtils.updateHyperlinksPositions(start, oldLength, newLength, hyperlinks);
        Hyperlink[] modifiedHyperlinks = hyperlinks.toArray(IRichDocument.EMPTY_HYPERLINK);
        this.document.setHyperlinks(modifiedHyperlinks);
    }

    private void updateTextStylesInDocument(int start, int oldLength, int newLength) {
        List<StyleRange> styles = this.getModifiableTextStyles();
        this.updateSelectionTextStyle(start, oldLength);
        RichTextUtils.replaceStyleRanges(start, oldLength, newLength, styles, this.selectionTextStyle);
        StyleRange[] modifiedStyleRanges = styles.toArray(IRichDocument.EMPTY_TEXT_STYLES);
        this.document.setTextStyles(modifiedStyleRanges);
        this.selectionTextStyle.start = start + newLength;
        this.selectionTextStyle.length = 0;
    }

    private void updateLineStylesInDocument(int start, int oldLength, int newLength, String text) {
        if (this.lineRangeBeforeChange == null || this.lineRangeBeforeChange.x < 0 || this.lineRangeBeforeChange.y < 0) {
            return;
        }
        Point currentLineRange = this.getLineRange(start, newLength);
        int startLine = currentLineRange.x;
        int lineCount = currentLineRange.y;
        if (startLine < 0 || lineCount < 0) {
            return;
        }
        List<LineStyle> lineStyles = this.getModifiableLineStyles();
        RichTextUtils.updateLineStylePositions(startLine, this.lineRangeBeforeChange.y, currentLineRange.y, lineStyles, this.document);
        LineStyle[] modifiedLineStyles = lineStyles.toArray(IRichDocument.EMPTY_LINE_STYLES);
        this.document.setLineStyles(modifiedLineStyles);
        this.lineRangeBeforeChange = null;
    }

    private void updateImagesInDocument(int start, int oldLength, int newLength) {
        List<ImagePlaceHolder> images = this.getModifiableImages();
        RichTextUtils.updateImagePositions(start, oldLength, newLength, images);
        ImagePlaceHolder[] modifiedImages = images.toArray(IRichDocument.EMPTY_IMAGES);
        this.document.setImages(modifiedImages);
    }

    private List<StyleRange> getModifiableTextStyles() {
        StyleRange[] oldTextStyles = this.document.getTextStyles();
        ArrayList<StyleRange> newStyles = new ArrayList<StyleRange>(oldTextStyles.length);
        StyleRange[] styleRangeArray = oldTextStyles;
        int n = oldTextStyles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange textStyle = styleRangeArray[n2];
            newStyles.add((StyleRange)textStyle.clone());
            ++n2;
        }
        return newStyles;
    }

    private void addImageStyleRangeToDocument(Image image, int start, int length) {
        List<StyleRange> styles = this.getModifiableTextStyles();
        StyleRange imageStyle = this.createImageStyle(start, length, image);
        RichTextUtils.replaceStyleRanges(start, length, length, styles, imageStyle);
        StyleRange[] modifiedStyleRanges = styles.toArray(IRichDocument.EMPTY_TEXT_STYLES);
        this.document.setTextStyles(modifiedStyleRanges);
    }

    private void refreshViewer(StyleRange[] modifiedStyleRanges) {
        TextPresentation presentation = RichTextRenderer.createPresentation(0, this.document.getLength(), modifiedStyleRanges);
        this.viewer.changeTextPresentation(presentation, true);
    }

    private void addImageToDocument(Image image, int start) {
        List<ImagePlaceHolder> oldImages = this.getModifiableImages();
        int index = this.getInsertImageIndex(start, oldImages);
        ImagePlaceHolder imagePlaceHolder = new ImagePlaceHolder(start, image);
        oldImages.add(index, imagePlaceHolder);
        this.document.setImages(oldImages.toArray(IRichDocument.EMPTY_IMAGES));
    }

    private List<ImagePlaceHolder> getModifiableImages() {
        ImagePlaceHolder[] oldImages = this.document.getImages();
        ArrayList<ImagePlaceHolder> newImages = new ArrayList<ImagePlaceHolder>(oldImages.length);
        ImagePlaceHolder[] imagePlaceHolderArray = oldImages;
        int n = oldImages.length;
        int n2 = 0;
        while (n2 < n) {
            ImagePlaceHolder img = imagePlaceHolderArray[n2];
            newImages.add((ImagePlaceHolder)img.clone());
            ++n2;
        }
        return newImages;
    }

    private List<LineStyle> getModifiableLineStyles() {
        LineStyle[] oldLineStyles = this.document.getLineStyles();
        ArrayList<LineStyle> newLineStyles = new ArrayList<LineStyle>(oldLineStyles.length);
        LineStyle[] lineStyleArray = oldLineStyles;
        int n = oldLineStyles.length;
        int n2 = 0;
        while (n2 < n) {
            LineStyle line = lineStyleArray[n2];
            newLineStyles.add((LineStyle)line.clone());
            ++n2;
        }
        return newLineStyles;
    }

    private int getInsertImageIndex(int offset, List<ImagePlaceHolder> images) {
        int i = 0;
        while (i < images.size()) {
            ImagePlaceHolder image = images.get(i);
            if (image.offset >= offset) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void setSelectedRange(int start, int length) {
        this.viewer.setSelectedRange(start, length);
        this.selectionTextStyle.start = start;
        this.selectionTextStyle.length = length;
    }

    private StyleRange createImageStyle(int start, int length, Image image) {
        StyleRange style = (StyleRange)this.selectionTextStyle.clone();
        style.start = start;
        style.length = length;
        Rectangle rect = image.getBounds();
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        return style;
    }

    private void modifySelectionTextStyles(IStyleRangeModifier modifier) {
        if (this.document == null || modifier == null) {
            return;
        }
        this.commitLastChange();
        this.beginCompoundChange();
        modifier.modify(this.getSelectionTextStyle());
        Point range = this.viewer.getSelectedRange();
        int start = range.x;
        int length = range.y;
        this.modifyTextStyles(start, length, modifier);
        this.endCompoundChange();
        this.commitLastChange();
    }

    protected void beginCompoundChange() {
        IUndoManager undoManager;
        if (this.viewer != null && (undoManager = this.viewer.getUndoManager()) != null) {
            undoManager.beginCompoundChange();
        }
    }

    protected void endCompoundChange() {
        IUndoManager undoManager;
        if (this.viewer != null && (undoManager = this.viewer.getUndoManager()) != null) {
            undoManager.endCompoundChange();
        }
    }

    protected void commitLastChange() {
        IUndoManager undoManager;
        if (this.viewer != null && (undoManager = this.viewer.getUndoManager()) != null && undoManager instanceof RichTextViewerUndoManager) {
            ((RichTextViewerUndoManager)undoManager).commit();
        }
    }

    private void modifyTextStyles(int start, int length, IStyleRangeModifier modifier) {
        if (this.document == null || modifier == null || length <= 0) {
            return;
        }
        List<StyleRange> styles = this.getModifiableTextStyles();
        boolean changed = RichTextUtils.modifyTextStyles(start, length, styles, modifier);
        if (changed) {
            StyleRange[] modifiedStyleRanges = styles.toArray(IRichDocument.EMPTY_TEXT_STYLES);
            this.document.setTextStyles(modifiedStyleRanges);
        }
    }

    private static TextPresentation createPresentation(int start, int length, StyleRange[] styleRanges) {
        TextPresentation presentation = new TextPresentation();
        StyleRange defaultStyle = RichTextRenderer.createDefaultStyle(start, length);
        presentation.setDefaultStyleRange(defaultStyle);
        presentation.replaceStyleRanges(styleRanges);
        return presentation;
    }

    private static StyleRange createDefaultStyle(int start, int length) {
        StyleRange defaultStyle = (StyleRange)RichTextUtils.DEFAULT_STYLE.clone();
        defaultStyle.start = start;
        defaultStyle.length = length;
        return defaultStyle;
    }

    private void modifySelectionLineStyles(ILineStyleModifier modifier) {
        if (this.document == null || modifier == null) {
            return;
        }
        Point p = this.getSelectedLineRange();
        if (p.x < 0 || p.y < 0) {
            return;
        }
        this.commitLastChange();
        this.beginCompoundChange();
        int startLine = p.x;
        int lineCount = p.y;
        this.modifyLineStyles(startLine, lineCount, modifier);
        this.endCompoundChange();
        this.commitLastChange();
    }

    private Point getSelectedLineRange() {
        Point p = this.viewer.getSelectedRange();
        int offset = p.x;
        int length = p.y;
        return this.getLineRange(offset, length);
    }

    private Point getLineRange(int offset, int length) {
        if (this.document != null) {
            try {
                int startLine = this.document.getLineOfOffset(offset);
                int lineCount = this.document.getNumberOfLines(offset, length);
                return new Point(startLine, lineCount);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return new Point(-1, -1);
    }

    private void modifyLineStyles(int startLine, int lineCount, ILineStyleModifier modifier) {
        if (this.document == null || modifier == null || lineCount <= 0) {
            return;
        }
        List<LineStyle> lineStyles = this.getModifiableLineStyles();
        boolean changed = RichTextUtils.modifyLineStyles(startLine, lineCount, lineStyles, modifier);
        if (changed) {
            LineStyle[] modifiedLineStyles = lineStyles.toArray(IRichDocument.EMPTY_LINE_STYLES);
            modifier.updateViewer(this.viewer, startLine, lineCount);
            this.document.setLineStyles(modifiedLineStyles);
        }
    }

    private static IStyleRangeModifier getBoldModifier(boolean bold) {
        boldModifier.setValue(bold);
        return boldModifier;
    }

    private static IStyleRangeModifier getItalicModifier(boolean italic) {
        italicModifier.setValue(italic);
        return italicModifier;
    }

    private static IStyleRangeModifier getUnderlineModifier(boolean italic) {
        underlineModifier.setValue(italic);
        return underlineModifier;
    }

    private static IStyleRangeModifier getStrikeoutModifier(boolean italic) {
        strikeoutModifier.setValue(italic);
        return strikeoutModifier;
    }

    private static IStyleRangeModifier getFontFaceModifier(String face) {
        faceModifier.setValue(face);
        return faceModifier;
    }

    private static IStyleRangeModifier getFontSizeModifier(int size) {
        sizeModifier.setValue(size);
        return sizeModifier;
    }

    private static IStyleRangeModifier getFontModifier(Font value) {
        fontModifier.setValue(value);
        return fontModifier;
    }

    private static IStyleRangeModifier getForegroundModifier(Color color) {
        foregroundModifier.setValue(color);
        return foregroundModifier;
    }

    private static IStyleRangeModifier getBackgroundModifier(Color color) {
        backgroundModifer.setValue(color);
        return backgroundModifer;
    }

    private static ILineStyleModifier getAlignmentModifier(int alignment) {
        alignmentModifier.setValue(alignment);
        return alignmentModifier;
    }

    private static ILineStyleModifier getIndentReplacer(int indent) {
        indentReplacer.setValue(indent);
        return indentReplacer;
    }

    private static ILineStyleModifier getIndentModifier(int deltaIndent) {
        indentModifier.setValue(deltaIndent);
        return indentModifier;
    }

    private static ILineStyleModifier getBulletModifier(String bullet) {
        bulletModifier.setValue(bullet);
        return bulletModifier;
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            RichTextRenderer.this.lineRangeBeforeChange = RichTextRenderer.this.getLineRange(event.getOffset(), event.getLength());
        }

        public void documentChanged(DocumentEvent event) {
            if (RichTextRenderer.this.ignoreDocumentChange) {
                return;
            }
            RichTextRenderer.this.updateDocumentPositions(event);
        }
    }

    private class RichDocumentListener
    implements IRichDocumentListener {
        private RichDocumentListener() {
        }

        @Override
        public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldStyles, ImagePlaceHolder[] newStyles) {
            RichTextRenderer.this.asyncRefreshViewer();
        }

        @Override
        public void lineStyleChanged(IRichDocument document, LineStyle[] oldStyles, LineStyle[] newStyles) {
            RichTextRenderer.this.asyncRefreshViewer();
        }

        @Override
        public void textStyleChanged(IRichDocument document, StyleRange[] oldStyles, StyleRange[] newStyles) {
            RichTextRenderer.this.asyncRefreshViewer();
        }

        @Override
        public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
            RichTextRenderer.this.asyncRefreshViewer();
        }
    }
}

