# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FolderInfo(Model):
    """Information about a image store folder. It includes how many files this
    folder contains and its image store relative path.

    :param store_relative_path: The remote location within image store. This
     path is relative to the image store root.
    :type store_relative_path: str
    :param file_count: The number of files from within the image store folder.
    :type file_count: str
    """

    _attribute_map = {
        'store_relative_path': {'key': 'StoreRelativePath', 'type': 'str'},
        'file_count': {'key': 'FileCount', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FolderInfo, self).__init__(**kwargs)
        self.store_relative_path = kwargs.get('store_relative_path', None)
        self.file_count = kwargs.get('file_count', None)
