/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Arrays;
import java.util.function.IntPredicate;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Slice16;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Twine16
extends UnicodeString {
    protected char[] chars;
    protected int cachedHash = 0;

    protected Twine16(char[] chars) {
        this.chars = chars;
    }

    public Twine16(char[] chars, int start, int len) {
        if (start == 0) {
            this.chars = Arrays.copyOf(chars, len);
        } else {
            this.chars = new char[len];
            System.arraycopy(chars, start, this.chars, 0, len);
        }
    }

    public char[] getCharArray() {
        return this.chars;
    }

    @Override
    public long length() {
        return this.chars.length;
    }

    @Override
    public int length32() {
        return this.chars.length;
    }

    @Override
    public UnicodeString substring(long start, long end) {
        int start32 = StringTool.requireInt(start);
        int end32 = StringTool.requireInt(end);
        int len = this.length32();
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        if (start == 0L && end == (long)len) {
            return this;
        }
        return new Slice16(this.chars, start32, end32);
    }

    @Override
    public int codePointAt(long index) throws IndexOutOfBoundsException {
        int index32 = StringTool.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[index32];
    }

    @Override
    public long indexOf(int codePoint, long from) {
        if (codePoint < 0 || codePoint > 65535) {
            return -1L;
        }
        int from32 = Math.max(Twine16.requireInt(from), 0);
        int last = this.chars.length;
        for (int i = from32; i < last; ++i) {
            if (this.chars[i] != codePoint) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long indexOf(UnicodeString other, long from) {
        int from32 = StringTool.requireInt(from);
        if (from32 < 0) {
            from32 = 0;
        } else if (from32 >= this.length32()) {
            return -1L;
        }
        if (other.isEmpty()) {
            return from;
        }
        int initial = other.codePointAt(0L);
        int len = StringTool.requireInt(other.length());
        int lastPossible = this.length32() - len;
        while (from32 <= lastPossible) {
            int i = StringTool.requireInt(this.indexOf(initial, (long)from32));
            if (i < 0) {
                return -1L;
            }
            if (this.hasSubstring(other, i)) {
                return i;
            }
            from32 = i + 1;
        }
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.chars.length == 0;
    }

    @Override
    void copy16bit(char[] target, int offset) {
        System.arraycopy(this.chars, 0, target, offset, this.chars.length);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        int i = 0;
        int j = offset;
        while (i < this.chars.length) {
            char c = this.chars[i++];
            target[j++] = 0;
            target[j++] = (byte)(c >> 8);
            target[j++] = (byte)(c & 0xFF);
        }
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Twine16.this.chars.length;
            }

            @Override
            public int next() {
                return Twine16.this.chars[this.i++];
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h2 = 0;
        for (char cp : this.chars) {
            h2 = 31 * h2 + cp;
        }
        this.cachedHash = h2;
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Twine16) {
            return Arrays.equals(this.chars, ((Twine16)o).chars);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (other instanceof Twine16) {
            Twine16 o = (Twine16)other;
            char[] a = this.chars;
            char[] b = o.chars;
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                int diff = a[i] - b[i];
                if (diff == 0) continue;
                return diff;
            }
            return Long.compare(this.length(), o.length());
        }
        return super.compareTo(other);
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        int i = Twine16.requireInt(from);
        while ((long)i < this.length()) {
            if (predicate.test(this.chars[i])) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public String details() {
        return "Twine16 length = " + this.chars.length;
    }
}

