// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(add)                       \
  M(addw)                      \
  M(sub)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{al, r11, pc, 2982}, false, al, "al r11 pc 2982", "al_r11_pc_2982"},
     {{al, r7, pc, 893}, false, al, "al r7 pc 893", "al_r7_pc_893"},
     {{al, r12, pc, 3583}, false, al, "al r12 pc 3583", "al_r12_pc_3583"},
     {{al, r8, pc, 1348}, false, al, "al r8 pc 1348", "al_r8_pc_1348"},
     {{al, r13, pc, 1892}, false, al, "al r13 pc 1892", "al_r13_pc_1892"},
     {{al, r9, pc, 2052}, false, al, "al r9 pc 2052", "al_r9_pc_2052"},
     {{al, r2, pc, 2345}, false, al, "al r2 pc 2345", "al_r2_pc_2345"},
     {{al, r6, pc, 1009}, false, al, "al r6 pc 1009", "al_r6_pc_1009"},
     {{al, r12, pc, 2689}, false, al, "al r12 pc 2689", "al_r12_pc_2689"},
     {{al, r5, pc, 2999}, false, al, "al r5 pc 2999", "al_r5_pc_2999"},
     {{al, r13, pc, 429}, false, al, "al r13 pc 429", "al_r13_pc_429"},
     {{al, r9, pc, 3978}, false, al, "al r9 pc 3978", "al_r9_pc_3978"},
     {{al, r11, pc, 955}, false, al, "al r11 pc 955", "al_r11_pc_955"},
     {{al, r12, pc, 2810}, false, al, "al r12 pc 2810", "al_r12_pc_2810"},
     {{al, r6, pc, 2651}, false, al, "al r6 pc 2651", "al_r6_pc_2651"},
     {{al, r2, pc, 496}, false, al, "al r2 pc 496", "al_r2_pc_496"},
     {{al, r3, pc, 3079}, false, al, "al r3 pc 3079", "al_r3_pc_3079"},
     {{al, r1, pc, 783}, false, al, "al r1 pc 783", "al_r1_pc_783"},
     {{al, r2, pc, 2559}, false, al, "al r2 pc 2559", "al_r2_pc_2559"},
     {{al, r5, pc, 1835}, false, al, "al r5 pc 1835", "al_r5_pc_1835"},
     {{al, r0, pc, 48}, false, al, "al r0 pc 48", "al_r0_pc_48"},
     {{al, r0, pc, 3170}, false, al, "al r0 pc 3170", "al_r0_pc_3170"},
     {{al, r14, pc, 3343}, false, al, "al r14 pc 3343", "al_r14_pc_3343"},
     {{al, r9, pc, 2651}, false, al, "al r9 pc 2651", "al_r9_pc_2651"},
     {{al, r12, pc, 523}, false, al, "al r12 pc 523", "al_r12_pc_523"},
     {{al, r12, pc, 2069}, false, al, "al r12 pc 2069", "al_r12_pc_2069"},
     {{al, r14, pc, 513}, false, al, "al r14 pc 513", "al_r14_pc_513"},
     {{al, r7, pc, 3607}, false, al, "al r7 pc 3607", "al_r7_pc_3607"},
     {{al, r4, pc, 2701}, false, al, "al r4 pc 2701", "al_r4_pc_2701"},
     {{al, r9, pc, 2358}, false, al, "al r9 pc 2358", "al_r9_pc_2358"},
     {{al, r9, pc, 1295}, false, al, "al r9 pc 1295", "al_r9_pc_1295"},
     {{al, r4, pc, 106}, false, al, "al r4 pc 106", "al_r4_pc_106"},
     {{al, r12, pc, 618}, false, al, "al r12 pc 618", "al_r12_pc_618"},
     {{al, r4, pc, 1266}, false, al, "al r4 pc 1266", "al_r4_pc_1266"},
     {{al, r9, pc, 2454}, false, al, "al r9 pc 2454", "al_r9_pc_2454"},
     {{al, r7, pc, 1394}, false, al, "al r7 pc 1394", "al_r7_pc_1394"},
     {{al, r4, pc, 3117}, false, al, "al r4 pc 3117", "al_r4_pc_3117"},
     {{al, r12, pc, 2662}, false, al, "al r12 pc 2662", "al_r12_pc_2662"},
     {{al, r10, pc, 1759}, false, al, "al r10 pc 1759", "al_r10_pc_1759"},
     {{al, r13, pc, 0}, false, al, "al r13 pc 0", "al_r13_pc_0"},
     {{al, r12, pc, 542}, false, al, "al r12 pc 542", "al_r12_pc_542"},
     {{al, r10, pc, 1585}, false, al, "al r10 pc 1585", "al_r10_pc_1585"},
     {{al, r2, pc, 479}, false, al, "al r2 pc 479", "al_r2_pc_479"},
     {{al, r14, pc, 22}, false, al, "al r14 pc 22", "al_r14_pc_22"},
     {{al, r11, pc, 3963}, false, al, "al r11 pc 3963", "al_r11_pc_3963"},
     {{al, r6, pc, 4079}, false, al, "al r6 pc 4079", "al_r6_pc_4079"},
     {{al, r13, pc, 2395}, false, al, "al r13 pc 2395", "al_r13_pc_2395"},
     {{al, r11, pc, 484}, false, al, "al r11 pc 484", "al_r11_pc_484"},
     {{al, r13, pc, 3638}, false, al, "al r13 pc 3638", "al_r13_pc_3638"},
     {{al, r9, pc, 525}, false, al, "al r9 pc 525", "al_r9_pc_525"},
     {{al, r10, pc, 53}, false, al, "al r10 pc 53", "al_r10_pc_53"},
     {{al, r13, pc, 1585}, false, al, "al r13 pc 1585", "al_r13_pc_1585"},
     {{al, r7, pc, 2217}, false, al, "al r7 pc 2217", "al_r7_pc_2217"},
     {{al, r7, pc, 2462}, false, al, "al r7 pc 2462", "al_r7_pc_2462"},
     {{al, r1, pc, 2703}, false, al, "al r1 pc 2703", "al_r1_pc_2703"},
     {{al, r5, pc, 270}, false, al, "al r5 pc 270", "al_r5_pc_270"},
     {{al, r11, pc, 624}, false, al, "al r11 pc 624", "al_r11_pc_624"},
     {{al, r3, pc, 216}, false, al, "al r3 pc 216", "al_r3_pc_216"},
     {{al, r1, pc, 3585}, false, al, "al r1 pc 3585", "al_r1_pc_3585"},
     {{al, r1, pc, 216}, false, al, "al r1 pc 216", "al_r1_pc_216"},
     {{al, r14, pc, 1666}, false, al, "al r14 pc 1666", "al_r14_pc_1666"},
     {{al, r1, pc, 1079}, false, al, "al r1 pc 1079", "al_r1_pc_1079"},
     {{al, r10, pc, 2086}, false, al, "al r10 pc 2086", "al_r10_pc_2086"},
     {{al, r12, pc, 2047}, false, al, "al r12 pc 2047", "al_r12_pc_2047"},
     {{al, r1, pc, 55}, false, al, "al r1 pc 55", "al_r1_pc_55"},
     {{al, r9, pc, 1699}, false, al, "al r9 pc 1699", "al_r9_pc_1699"},
     {{al, r14, pc, 547}, false, al, "al r14 pc 547", "al_r14_pc_547"},
     {{al, r2, pc, 3585}, false, al, "al r2 pc 3585", "al_r2_pc_3585"},
     {{al, r12, pc, 3603}, false, al, "al r12 pc 3603", "al_r12_pc_3603"},
     {{al, r13, pc, 2665}, false, al, "al r13 pc 2665", "al_r13_pc_2665"},
     {{al, r3, pc, 2864}, false, al, "al r3 pc 2864", "al_r3_pc_2864"},
     {{al, r3, pc, 4079}, false, al, "al r3 pc 4079", "al_r3_pc_4079"},
     {{al, r12, pc, 1655}, false, al, "al r12 pc 1655", "al_r12_pc_1655"},
     {{al, r3, pc, 524}, false, al, "al r3 pc 524", "al_r3_pc_524"},
     {{al, r1, pc, 732}, false, al, "al r1 pc 732", "al_r1_pc_732"},
     {{al, r11, pc, 3282}, false, al, "al r11 pc 3282", "al_r11_pc_3282"},
     {{al, r4, pc, 2462}, false, al, "al r4 pc 2462", "al_r4_pc_2462"},
     {{al, r11, pc, 2948}, false, al, "al r11 pc 2948", "al_r11_pc_2948"},
     {{al, r13, pc, 2821}, false, al, "al r13 pc 2821", "al_r13_pc_2821"},
     {{al, r7, pc, 1542}, false, al, "al r7 pc 1542", "al_r7_pc_1542"},
     {{al, r7, pc, 2546}, false, al, "al r7 pc 2546", "al_r7_pc_2546"},
     {{al, r12, pc, 3865}, false, al, "al r12 pc 3865", "al_r12_pc_3865"},
     {{al, r1, pc, 3856}, false, al, "al r1 pc 3856", "al_r1_pc_3856"},
     {{al, r4, pc, 2651}, false, al, "al r4 pc 2651", "al_r4_pc_2651"},
     {{al, r6, pc, 3717}, false, al, "al r6 pc 3717", "al_r6_pc_3717"},
     {{al, r0, pc, 525}, false, al, "al r0 pc 525", "al_r0_pc_525"},
     {{al, r14, pc, 3626}, false, al, "al r14 pc 3626", "al_r14_pc_3626"},
     {{al, r0, pc, 510}, false, al, "al r0 pc 510", "al_r0_pc_510"},
     {{al, r10, pc, 542}, false, al, "al r10 pc 542", "al_r10_pc_542"},
     {{al, r10, pc, 3811}, false, al, "al r10 pc 3811", "al_r10_pc_3811"},
     {{al, r4, pc, 1116}, false, al, "al r4 pc 1116", "al_r4_pc_1116"},
     {{al, r1, pc, 831}, false, al, "al r1 pc 831", "al_r1_pc_831"},
     {{al, r1, pc, 2403}, false, al, "al r1 pc 2403", "al_r1_pc_2403"},
     {{al, r3, pc, 200}, false, al, "al r3 pc 200", "al_r3_pc_200"},
     {{al, r3, pc, 685}, false, al, "al r3 pc 685", "al_r3_pc_685"},
     {{al, r7, pc, 2721}, false, al, "al r7 pc 2721", "al_r7_pc_2721"},
     {{al, r10, pc, 2119}, false, al, "al r10 pc 2119", "al_r10_pc_2119"},
     {{al, r10, pc, 233}, false, al, "al r10 pc 233", "al_r10_pc_233"},
     {{al, r0, pc, 3739}, false, al, "al r0 pc 3739", "al_r0_pc_3739"},
     {{al, r6, pc, 1712}, false, al, "al r6 pc 1712", "al_r6_pc_1712"},
     {{al, r11, pc, 2978}, false, al, "al r11 pc 2978", "al_r11_pc_2978"},
     {{al, r1, pc, 2721}, false, al, "al r1 pc 2721", "al_r1_pc_2721"},
     {{al, r7, pc, 198}, false, al, "al r7 pc 198", "al_r7_pc_198"},
     {{al, r1, pc, 970}, false, al, "al r1 pc 970", "al_r1_pc_970"},
     {{al, r2, pc, 2982}, false, al, "al r2 pc 2982", "al_r2_pc_2982"},
     {{al, r1, pc, 2982}, false, al, "al r1 pc 2982", "al_r1_pc_2982"},
     {{al, r11, pc, 1377}, false, al, "al r11 pc 1377", "al_r11_pc_1377"},
     {{al, r13, pc, 1479}, false, al, "al r13 pc 1479", "al_r13_pc_1479"},
     {{al, r13, pc, 3787}, false, al, "al r13 pc 3787", "al_r13_pc_3787"},
     {{al, r7, pc, 47}, false, al, "al r7 pc 47", "al_r7_pc_47"},
     {{al, r13, pc, 1485}, false, al, "al r13 pc 1485", "al_r13_pc_1485"},
     {{al, r12, pc, 2137}, false, al, "al r12 pc 2137", "al_r12_pc_2137"},
     {{al, r5, pc, 3041}, false, al, "al r5 pc 3041", "al_r5_pc_3041"},
     {{al, r9, pc, 3399}, false, al, "al r9 pc 3399", "al_r9_pc_3399"},
     {{al, r4, pc, 2453}, false, al, "al r4 pc 2453", "al_r4_pc_2453"},
     {{al, r6, pc, 2016}, false, al, "al r6 pc 2016", "al_r6_pc_2016"},
     {{al, r11, pc, 3034}, false, al, "al r11 pc 3034", "al_r11_pc_3034"},
     {{al, r10, pc, 3063}, false, al, "al r10 pc 3063", "al_r10_pc_3063"},
     {{al, r7, pc, 2792}, false, al, "al r7 pc 2792", "al_r7_pc_2792"},
     {{al, r6, pc, 517}, false, al, "al r6 pc 517", "al_r6_pc_517"},
     {{al, r14, pc, 3076}, false, al, "al r14 pc 3076", "al_r14_pc_3076"},
     {{al, r1, pc, 2490}, false, al, "al r1 pc 2490", "al_r1_pc_2490"},
     {{al, r8, pc, 1892}, false, al, "al r8 pc 1892", "al_r8_pc_1892"},
     {{al, r14, pc, 3570}, false, al, "al r14 pc 3570", "al_r14_pc_3570"},
     {{al, r5, pc, 57}, false, al, "al r5 pc 57", "al_r5_pc_57"},
     {{al, r0, pc, 4058}, false, al, "al r0 pc 4058", "al_r0_pc_4058"},
     {{al, r14, pc, 199}, false, al, "al r14 pc 199", "al_r14_pc_199"},
     {{al, r2, pc, 1186}, false, al, "al r2 pc 1186", "al_r2_pc_1186"},
     {{al, r1, pc, 523}, false, al, "al r1 pc 523", "al_r1_pc_523"},
     {{al, r0, pc, 3978}, false, al, "al r0 pc 3978", "al_r0_pc_3978"},
     {{al, r13, pc, 2796}, false, al, "al r13 pc 2796", "al_r13_pc_2796"},
     {{al, r8, pc, 2}, false, al, "al r8 pc 2", "al_r8_pc_2"},
     {{al, r13, pc, 3308}, false, al, "al r13 pc 3308", "al_r13_pc_3308"},
     {{al, r5, pc, 783}, false, al, "al r5 pc 783", "al_r5_pc_783"},
     {{al, r11, pc, 3221}, false, al, "al r11 pc 3221", "al_r11_pc_3221"},
     {{al, r9, pc, 3417}, false, al, "al r9 pc 3417", "al_r9_pc_3417"},
     {{al, r11, pc, 3487}, false, al, "al r11 pc 3487", "al_r11_pc_3487"},
     {{al, r12, pc, 2490}, false, al, "al r12 pc 2490", "al_r12_pc_2490"},
     {{al, r5, pc, 180}, false, al, "al r5 pc 180", "al_r5_pc_180"},
     {{al, r14, pc, 2098}, false, al, "al r14 pc 2098", "al_r14_pc_2098"},
     {{al, r11, pc, 263}, false, al, "al r11 pc 263", "al_r11_pc_263"},
     {{al, r1, pc, 595}, false, al, "al r1 pc 595", "al_r1_pc_595"},
     {{al, r0, pc, 3117}, false, al, "al r0 pc 3117", "al_r0_pc_3117"},
     {{al, r9, pc, 348}, false, al, "al r9 pc 348", "al_r9_pc_348"},
     {{al, r5, pc, 3142}, false, al, "al r5 pc 3142", "al_r5_pc_3142"},
     {{al, r10, pc, 766}, false, al, "al r10 pc 766", "al_r10_pc_766"},
     {{al, r4, pc, 2944}, false, al, "al r4 pc 2944", "al_r4_pc_2944"},
     {{al, r9, pc, 3663}, false, al, "al r9 pc 3663", "al_r9_pc_3663"},
     {{al, r8, pc, 3063}, false, al, "al r8 pc 3063", "al_r8_pc_3063"},
     {{al, r8, pc, 3472}, false, al, "al r8 pc 3472", "al_r8_pc_3472"},
     {{al, r6, pc, 3504}, false, al, "al r6 pc 3504", "al_r6_pc_3504"},
     {{al, r6, pc, 3491}, false, al, "al r6 pc 3491", "al_r6_pc_3491"},
     {{al, r0, pc, 4093}, false, al, "al r0 pc 4093", "al_r0_pc_4093"},
     {{al, r2, pc, 188}, false, al, "al r2 pc 188", "al_r2_pc_188"},
     {{al, r2, pc, 3109}, false, al, "al r2 pc 3109", "al_r2_pc_3109"},
     {{al, r3, pc, 4091}, false, al, "al r3 pc 4091", "al_r3_pc_4091"},
     {{al, r13, pc, 1967}, false, al, "al r13 pc 1967", "al_r13_pc_1967"},
     {{al, r9, pc, 811}, false, al, "al r9 pc 811", "al_r9_pc_811"},
     {{al, r5, pc, 3417}, false, al, "al r5 pc 3417", "al_r5_pc_3417"},
     {{al, r9, pc, 1750}, false, al, "al r9 pc 1750", "al_r9_pc_1750"},
     {{al, r12, pc, 481}, false, al, "al r12 pc 481", "al_r12_pc_481"},
     {{al, r5, pc, 811}, false, al, "al r5 pc 811", "al_r5_pc_811"},
     {{al, r11, pc, 1635}, false, al, "al r11 pc 1635", "al_r11_pc_1635"},
     {{al, r12, pc, 2}, false, al, "al r12 pc 2", "al_r12_pc_2"},
     {{al, r2, pc, 3325}, false, al, "al r2 pc 3325", "al_r2_pc_3325"},
     {{al, r4, pc, 2326}, false, al, "al r4 pc 2326", "al_r4_pc_2326"},
     {{al, r8, pc, 2047}, false, al, "al r8 pc 2047", "al_r8_pc_2047"},
     {{al, r6, pc, 3028}, false, al, "al r6 pc 3028", "al_r6_pc_3028"},
     {{al, r8, pc, 2021}, false, al, "al r8 pc 2021", "al_r8_pc_2021"},
     {{al, r11, pc, 1892}, false, al, "al r11 pc 1892", "al_r11_pc_1892"},
     {{al, r14, pc, 1198}, false, al, "al r14 pc 1198", "al_r14_pc_1198"},
     {{al, r9, pc, 1374}, false, al, "al r9 pc 1374", "al_r9_pc_1374"},
     {{al, r4, pc, 3136}, false, al, "al r4 pc 3136", "al_r4_pc_3136"},
     {{al, r14, pc, 4046}, false, al, "al r14 pc 4046", "al_r14_pc_4046"},
     {{al, r2, pc, 2233}, false, al, "al r2 pc 2233", "al_r2_pc_2233"},
     {{al, r8, pc, 1870}, false, al, "al r8 pc 1870", "al_r8_pc_1870"},
     {{al, r9, pc, 2202}, false, al, "al r9 pc 2202", "al_r9_pc_2202"},
     {{al, r11, pc, 704}, false, al, "al r11 pc 704", "al_r11_pc_704"},
     {{al, r13, pc, 2813}, false, al, "al r13 pc 2813", "al_r13_pc_2813"},
     {{al, r5, pc, 624}, false, al, "al r5 pc 624", "al_r5_pc_624"},
     {{al, r14, pc, 1695}, false, al, "al r14 pc 1695", "al_r14_pc_1695"},
     {{al, r11, pc, 2701}, false, al, "al r11 pc 2701", "al_r11_pc_2701"},
     {{al, r14, pc, 3487}, false, al, "al r14 pc 3487", "al_r14_pc_3487"},
     {{al, r5, pc, 19}, false, al, "al r5 pc 19", "al_r5_pc_19"},
     {{al, r7, pc, 2137}, false, al, "al r7 pc 2137", "al_r7_pc_2137"},
     {{al, r4, pc, 2012}, false, al, "al r4 pc 2012", "al_r4_pc_2012"},
     {{al, r0, pc, 2124}, false, al, "al r0 pc 2124", "al_r0_pc_2124"},
     {{al, r2, pc, 1666}, false, al, "al r2 pc 1666", "al_r2_pc_1666"},
     {{al, r14, pc, 1066}, false, al, "al r14 pc 1066", "al_r14_pc_1066"},
     {{al, r11, pc, 2901}, false, al, "al r11 pc 2901", "al_r11_pc_2901"},
     {{al, r0, pc, 3002}, false, al, "al r0 pc 3002", "al_r0_pc_3002"},
     {{al, r0, pc, 3633}, false, al, "al r0 pc 3633", "al_r0_pc_3633"},
     {{al, r11, pc, 794}, false, al, "al r11 pc 794", "al_r11_pc_794"},
     {{al, r6, pc, 484}, false, al, "al r6 pc 484", "al_r6_pc_484"},
     {{al, r5, pc, 1198}, false, al, "al r5 pc 1198", "al_r5_pc_1198"},
     {{al, r3, pc, 2642}, false, al, "al r3 pc 2642", "al_r3_pc_2642"},
     {{al, r11, pc, 1934}, false, al, "al r11 pc 1934", "al_r11_pc_1934"},
     {{al, r10, pc, 3491}, false, al, "al r10 pc 3491", "al_r10_pc_3491"},
     {{al, r4, pc, 2796}, false, al, "al r4 pc 2796", "al_r4_pc_2796"},
     {{al, r10, pc, 1485}, false, al, "al r10 pc 1485", "al_r10_pc_1485"},
     {{al, r7, pc, 844}, false, al, "al r7 pc 844", "al_r7_pc_844"},
     {{al, r2, pc, 3625}, false, al, "al r2 pc 3625", "al_r2_pc_3625"},
     {{al, r0, pc, 4037}, false, al, "al r0 pc 4037", "al_r0_pc_4037"},
     {{al, r5, pc, 4093}, false, al, "al r5 pc 4093", "al_r5_pc_4093"},
     {{al, r14, pc, 712}, false, al, "al r14 pc 712", "al_r14_pc_712"},
     {{al, r2, pc, 4095}, false, al, "al r2 pc 4095", "al_r2_pc_4095"},
     {{al, r8, pc, 3069}, false, al, "al r8 pc 3069", "al_r8_pc_3069"},
     {{al, r10, pc, 791}, false, al, "al r10 pc 791", "al_r10_pc_791"},
     {{al, r4, pc, 188}, false, al, "al r4 pc 188", "al_r4_pc_188"},
     {{al, r9, pc, 3529}, false, al, "al r9 pc 3529", "al_r9_pc_3529"},
     {{al, r13, pc, 2650}, false, al, "al r13 pc 2650", "al_r13_pc_2650"},
     {{al, r12, pc, 3282}, false, al, "al r12 pc 3282", "al_r12_pc_3282"},
     {{al, r7, pc, 1231}, false, al, "al r7 pc 1231", "al_r7_pc_1231"},
     {{al, r9, pc, 1651}, false, al, "al r9 pc 1651", "al_r9_pc_1651"},
     {{al, r6, pc, 3728}, false, al, "al r6 pc 3728", "al_r6_pc_3728"},
     {{al, r8, pc, 3787}, false, al, "al r8 pc 3787", "al_r8_pc_3787"},
     {{al, r9, pc, 3544}, false, al, "al r9 pc 3544", "al_r9_pc_3544"},
     {{al, r8, pc, 2994}, false, al, "al r8 pc 2994", "al_r8_pc_2994"},
     {{al, r4, pc, 601}, false, al, "al r4 pc 601", "al_r4_pc_601"},
     {{al, r4, pc, 2365}, false, al, "al r4 pc 2365", "al_r4_pc_2365"},
     {{al, r0, pc, 4018}, false, al, "al r0 pc 4018", "al_r0_pc_4018"},
     {{al, r10, pc, 1687}, false, al, "al r10 pc 1687", "al_r10_pc_1687"},
     {{al, r7, pc, 3963}, false, al, "al r7 pc 3963", "al_r7_pc_3963"},
     {{al, r7, pc, 1537}, false, al, "al r7 pc 1537", "al_r7_pc_1537"},
     {{al, r11, pc, 872}, false, al, "al r11 pc 872", "al_r11_pc_872"},
     {{al, r5, pc, 3696}, false, al, "al r5 pc 3696", "al_r5_pc_3696"},
     {{al, r0, pc, 3439}, false, al, "al r0 pc 3439", "al_r0_pc_3439"},
     {{al, r3, pc, 3541}, false, al, "al r3 pc 3541", "al_r3_pc_3541"},
     {{al, r5, pc, 3918}, false, al, "al r5 pc 3918", "al_r5_pc_3918"},
     {{al, r2, pc, 3597}, false, al, "al r2 pc 3597", "al_r2_pc_3597"},
     {{al, r3, pc, 970}, false, al, "al r3 pc 970", "al_r3_pc_970"},
     {{al, r8, pc, 1899}, false, al, "al r8 pc 1899", "al_r8_pc_1899"},
     {{al, r6, pc, 322}, false, al, "al r6 pc 322", "al_r6_pc_322"},
     {{al, r4, pc, 3914}, false, al, "al r4 pc 3914", "al_r4_pc_3914"},
     {{al, r11, pc, 2651}, false, al, "al r11 pc 2651", "al_r11_pc_2651"},
     {{al, r2, pc, 2796}, false, al, "al r2 pc 2796", "al_r2_pc_2796"},
     {{al, r8, pc, 3195}, false, al, "al r8 pc 3195", "al_r8_pc_3195"},
     {{al, r13, pc, 844}, false, al, "al r13 pc 844", "al_r13_pc_844"},
     {{al, r5, pc, 2929}, false, al, "al r5 pc 2929", "al_r5_pc_2929"},
     {{al, r1, pc, 3417}, false, al, "al r1 pc 3417", "al_r1_pc_3417"},
     {{al, r12, pc, 2906}, false, al, "al r12 pc 2906", "al_r12_pc_2906"},
     {{al, r1, pc, 3583}, false, al, "al r1 pc 3583", "al_r1_pc_3583"},
     {{al, r14, pc, 3963}, false, al, "al r14 pc 3963", "al_r14_pc_3963"},
     {{al, r12, pc, 2665}, false, al, "al r12 pc 2665", "al_r12_pc_2665"},
     {{al, r8, pc, 1437}, false, al, "al r8 pc 1437", "al_r8_pc_1437"},
     {{al, r9, pc, 3413}, false, al, "al r9 pc 3413", "al_r9_pc_3413"},
     {{al, r13, pc, 1186}, false, al, "al r13 pc 1186", "al_r13_pc_1186"},
     {{al, r10, pc, 1860}, false, al, "al r10 pc 1860", "al_r10_pc_1860"},
     {{al, r13, pc, 1498}, false, al, "al r13 pc 1498", "al_r13_pc_1498"},
     {{al, r14, pc, 2026}, false, al, "al r14 pc 2026", "al_r14_pc_2026"},
     {{al, r10, pc, 1246}, false, al, "al r10 pc 1246", "al_r10_pc_1246"},
     {{al, r9, pc, 831}, false, al, "al r9 pc 831", "al_r9_pc_831"},
     {{al, r5, pc, 893}, false, al, "al r5 pc 893", "al_r5_pc_893"},
     {{al, r14, pc, 1712}, false, al, "al r14 pc 1712", "al_r14_pc_1712"},
     {{al, r4, pc, 2023}, false, al, "al r4 pc 2023", "al_r4_pc_2023"},
     {{al, r9, pc, 3583}, false, al, "al r9 pc 3583", "al_r9_pc_3583"},
     {{al, r9, pc, 3405}, false, al, "al r9 pc 3405", "al_r9_pc_3405"},
     {{al, r2, pc, 3076}, false, al, "al r2 pc 3076", "al_r2_pc_3076"},
     {{al, r11, pc, 2038}, false, al, "al r11 pc 2038", "al_r11_pc_2038"},
     {{al, r3, pc, 3282}, false, al, "al r3 pc 3282", "al_r3_pc_3282"},
     {{al, r2, pc, 72}, false, al, "al r2 pc 72", "al_r2_pc_72"},
     {{al, r13, pc, 791}, false, al, "al r13 pc 791", "al_r13_pc_791"},
     {{al, r4, pc, 2240}, false, al, "al r4 pc 2240", "al_r4_pc_2240"},
     {{al, r8, pc, 1859}, false, al, "al r8 pc 1859", "al_r8_pc_1859"},
     {{al, r3, pc, 732}, false, al, "al r3 pc 732", "al_r3_pc_732"},
     {{al, r2, pc, 3728}, false, al, "al r2 pc 3728", "al_r2_pc_3728"},
     {{al, r14, pc, 1835}, false, al, "al r14 pc 1835", "al_r14_pc_1835"},
     {{al, r10, pc, 662}, false, al, "al r10 pc 662", "al_r10_pc_662"},
     {{al, r7, pc, 791}, false, al, "al r7 pc 791", "al_r7_pc_791"},
     {{al, r12, pc, 3633}, false, al, "al r12 pc 3633", "al_r12_pc_3633"},
     {{al, r9, pc, 2046}, false, al, "al r9 pc 2046", "al_r9_pc_2046"},
     {{al, r0, pc, 2726}, false, al, "al r0 pc 2726", "al_r0_pc_2726"},
     {{al, r0, pc, 3194}, false, al, "al r0 pc 3194", "al_r0_pc_3194"},
     {{al, r13, pc, 2290}, false, al, "al r13 pc 2290", "al_r13_pc_2290"},
     {{al, r9, pc, 624}, false, al, "al r9 pc 624", "al_r9_pc_624"},
     {{al, r3, pc, 3572}, false, al, "al r3 pc 3572", "al_r3_pc_3572"},
     {{al, r0, pc, 1823}, false, al, "al r0 pc 1823", "al_r0_pc_1823"},
     {{al, r12, pc, 2535}, false, al, "al r12 pc 2535", "al_r12_pc_2535"},
     {{al, r7, pc, 719}, false, al, "al r7 pc 719", "al_r7_pc_719"},
     {{al, r12, pc, 678}, false, al, "al r12 pc 678", "al_r12_pc_678"},
     {{al, r5, pc, 1455}, false, al, "al r5 pc 1455", "al_r5_pc_1455"},
     {{al, r6, pc, 2994}, false, al, "al r6 pc 2994", "al_r6_pc_2994"},
     {{al, r9, pc, 3082}, false, al, "al r9 pc 3082", "al_r9_pc_3082"},
     {{al, r11, pc, 2703}, false, al, "al r11 pc 2703", "al_r11_pc_2703"},
     {{al, r9, pc, 2541}, false, al, "al r9 pc 2541", "al_r9_pc_2541"},
     {{al, r8, pc, 3688}, false, al, "al r8 pc 3688", "al_r8_pc_3688"},
     {{al, r6, pc, 1374}, false, al, "al r6 pc 1374", "al_r6_pc_1374"},
     {{al, r5, pc, 2976}, false, al, "al r5 pc 2976", "al_r5_pc_2976"},
     {{al, r0, pc, 2799}, false, al, "al r0 pc 2799", "al_r0_pc_2799"},
     {{al, r0, pc, 1394}, false, al, "al r0 pc 1394", "al_r0_pc_1394"},
     {{al, r7, pc, 1666}, false, al, "al r7 pc 1666", "al_r7_pc_1666"},
     {{al, r11, pc, 1309}, false, al, "al r11 pc 1309", "al_r11_pc_1309"},
     {{al, r9, pc, 3439}, false, al, "al r9 pc 3439", "al_r9_pc_3439"},
     {{al, r0, pc, 1526}, false, al, "al r0 pc 1526", "al_r0_pc_1526"},
     {{al, r14, pc, 1348}, false, al, "al r14 pc 1348", "al_r14_pc_1348"},
     {{al, r12, pc, 3105}, false, al, "al r12 pc 3105", "al_r12_pc_3105"},
     {{al, r6, pc, 510}, false, al, "al r6 pc 510", "al_r6_pc_510"},
     {{al, r11, pc, 2590}, false, al, "al r11 pc 2590", "al_r11_pc_2590"},
     {{al, r11, pc, 1479}, false, al, "al r11 pc 1479", "al_r11_pc_1479"},
     {{al, r3, pc, 57}, false, al, "al r3 pc 57", "al_r3_pc_57"},
     {{al, r5, pc, 2233}, false, al, "al r5 pc 2233", "al_r5_pc_2233"},
     {{al, r6, pc, 831}, false, al, "al r6 pc 831", "al_r6_pc_831"},
     {{al, r10, pc, 3918}, false, al, "al r10 pc 3918", "al_r10_pc_3918"},
     {{al, r7, pc, 227}, false, al, "al r7 pc 227", "al_r7_pc_227"},
     {{al, r6, pc, 2703}, false, al, "al r6 pc 2703", "al_r6_pc_2703"},
     {{al, r10, pc, 1556}, false, al, "al r10 pc 1556", "al_r10_pc_1556"},
     {{al, r1, pc, 1922}, false, al, "al r1 pc 1922", "al_r1_pc_1922"},
     {{al, r3, pc, 2944}, false, al, "al r3 pc 2944", "al_r3_pc_2944"},
     {{al, r6, pc, 2490}, false, al, "al r6 pc 2490", "al_r6_pc_2490"},
     {{al, r13, pc, 774}, false, al, "al r13 pc 774", "al_r13_pc_774"},
     {{al, r10, pc, 2794}, false, al, "al r10 pc 2794", "al_r10_pc_2794"},
     {{al, r11, pc, 1359}, false, al, "al r11 pc 1359", "al_r11_pc_1359"},
     {{al, r1, pc, 2677}, false, al, "al r1 pc 2677", "al_r1_pc_2677"},
     {{al, r3, pc, 618}, false, al, "al r3 pc 618", "al_r3_pc_618"},
     {{al, r9, pc, 3076}, false, al, "al r9 pc 3076", "al_r9_pc_3076"},
     {{al, r7, pc, 524}, false, al, "al r7 pc 524", "al_r7_pc_524"},
     {{al, r8, pc, 732}, false, al, "al r8 pc 732", "al_r8_pc_732"},
     {{al, r6, pc, 778}, false, al, "al r6 pc 778", "al_r6_pc_778"},
     {{al, r13, pc, 3138}, false, al, "al r13 pc 3138", "al_r13_pc_3138"},
     {{al, r5, pc, 4018}, false, al, "al r5 pc 4018", "al_r5_pc_4018"},
     {{al, r4, pc, 1079}, false, al, "al r4 pc 1079", "al_r4_pc_1079"},
     {{al, r9, pc, 2507}, false, al, "al r9 pc 2507", "al_r9_pc_2507"},
     {{al, r4, pc, 2582}, false, al, "al r4 pc 2582", "al_r4_pc_2582"},
     {{al, r8, pc, 1759}, false, al, "al r8 pc 1759", "al_r8_pc_1759"},
     {{al, r3, pc, 3899}, false, al, "al r3 pc 3899", "al_r3_pc_3899"},
     {{al, r13, pc, 2519}, false, al, "al r13 pc 2519", "al_r13_pc_2519"},
     {{al, r7, pc, 2507}, false, al, "al r7 pc 2507", "al_r7_pc_2507"},
     {{al, r0, pc, 3663}, false, al, "al r0 pc 3663", "al_r0_pc_3663"},
     {{al, r0, pc, 831}, false, al, "al r0 pc 831", "al_r0_pc_831"},
     {{al, r8, pc, 3157}, false, al, "al r8 pc 3157", "al_r8_pc_3157"},
     {{al, r1, pc, 2984}, false, al, "al r1 pc 2984", "al_r1_pc_2984"},
     {{al, r2, pc, 1372}, false, al, "al r2 pc 1372", "al_r2_pc_1372"},
     {{al, r4, pc, 2523}, false, al, "al r4 pc 2523", "al_r4_pc_2523"},
     {{al, r9, pc, 4091}, false, al, "al r9 pc 4091", "al_r9_pc_4091"},
     {{al, r10, pc, 2240}, false, al, "al r10 pc 2240", "al_r10_pc_2240"},
     {{al, r7, pc, 3256}, false, al, "al r7 pc 3256", "al_r7_pc_3256"},
     {{al, r9, pc, 3994}, false, al, "al r9 pc 3994", "al_r9_pc_3994"},
     {{al, r8, pc, 2281}, false, al, "al r8 pc 2281", "al_r8_pc_2281"},
     {{al, r6, pc, 180}, false, al, "al r6 pc 180", "al_r6_pc_180"},
     {{al, r5, pc, 1009}, false, al, "al r5 pc 1009", "al_r5_pc_1009"},
     {{al, r11, pc, 1372}, false, al, "al r11 pc 1372", "al_r11_pc_1372"},
     {{al, r9, pc, 22}, false, al, "al r9 pc 22", "al_r9_pc_22"},
     {{al, r6, pc, 3548}, false, al, "al r6 pc 3548", "al_r6_pc_3548"},
     {{al, r5, pc, 1357}, false, al, "al r5 pc 1357", "al_r5_pc_1357"},
     {{al, r9, pc, 1736}, false, al, "al r9 pc 1736", "al_r9_pc_1736"},
     {{al, r9, pc, 2016}, false, al, "al r9 pc 2016", "al_r9_pc_2016"},
     {{al, r10, pc, 719}, false, al, "al r10 pc 719", "al_r10_pc_719"},
     {{al, r0, pc, 3564}, false, al, "al r0 pc 3564", "al_r0_pc_3564"},
     {{al, r5, pc, 2794}, false, al, "al r5 pc 2794", "al_r5_pc_2794"},
     {{al, r14, pc, 2710}, false, al, "al r14 pc 2710", "al_r14_pc_2710"},
     {{al, r5, pc, 2588}, false, al, "al r5 pc 2588", "al_r5_pc_2588"},
     {{al, r6, pc, 2541}, false, al, "al r6 pc 2541", "al_r6_pc_2541"},
     {{al, r6, pc, 83}, false, al, "al r6 pc 83", "al_r6_pc_83"},
     {{al, r2, pc, 547}, false, al, "al r2 pc 547", "al_r2_pc_547"},
     {{al, r12, pc, 3659}, false, al, "al r12 pc 3659", "al_r12_pc_3659"},
     {{al, r8, pc, 1687}, false, al, "al r8 pc 1687", "al_r8_pc_1687"},
     {{al, r7, pc, 3325}, false, al, "al r7 pc 3325", "al_r7_pc_3325"},
     {{al, r4, pc, 421}, false, al, "al r4 pc 421", "al_r4_pc_421"},
     {{al, r5, pc, 2689}, false, al, "al r5 pc 2689", "al_r5_pc_2689"},
     {{al, r0, pc, 2040}, false, al, "al r0 pc 2040", "al_r0_pc_2040"},
     {{al, r14, pc, 3384}, false, al, "al r14 pc 3384", "al_r14_pc_3384"},
     {{al, r9, pc, 2948}, false, al, "al r9 pc 2948", "al_r9_pc_2948"},
     {{al, r11, pc, 2945}, false, al, "al r11 pc 2945", "al_r11_pc_2945"},
     {{al, r12, pc, 2546}, false, al, "al r12 pc 2546", "al_r12_pc_2546"},
     {{al, r9, pc, 2086}, false, al, "al r9 pc 2086", "al_r9_pc_2086"},
     {{al, r6, pc, 783}, false, al, "al r6 pc 783", "al_r6_pc_783"},
     {{al, r9, pc, 1485}, false, al, "al r9 pc 1485", "al_r9_pc_1485"},
     {{al, r0, pc, 2978}, false, al, "al r0 pc 2978", "al_r0_pc_2978"},
     {{al, r3, pc, 1642}, false, al, "al r3 pc 1642", "al_r3_pc_1642"},
     {{al, r6, pc, 3105}, false, al, "al r6 pc 3105", "al_r6_pc_3105"},
     {{al, r3, pc, 2040}, false, al, "al r3 pc 2040", "al_r3_pc_2040"},
     {{al, r9, pc, 1556}, false, al, "al r9 pc 1556", "al_r9_pc_1556"},
     {{al, r10, pc, 3907}, false, al, "al r10 pc 3907", "al_r10_pc_3907"},
     {{al, r0, pc, 796}, false, al, "al r0 pc 796", "al_r0_pc_796"},
     {{al, r6, pc, 1961}, false, al, "al r6 pc 1961", "al_r6_pc_1961"},
     {{al, r0, pc, 1455}, false, al, "al r0 pc 1455", "al_r0_pc_1455"},
     {{al, r6, pc, 3256}, false, al, "al r6 pc 3256", "al_r6_pc_3256"},
     {{al, r3, pc, 1527}, false, al, "al r3 pc 1527", "al_r3_pc_1527"},
     {{al, r0, pc, 1097}, false, al, "al r0 pc 1097", "al_r0_pc_1097"},
     {{al, r6, pc, 2650}, false, al, "al r6 pc 2650", "al_r6_pc_2650"},
     {{al, r8, pc, 2507}, false, al, "al r8 pc 2507", "al_r8_pc_2507"},
     {{al, r9, pc, 459}, false, al, "al r9 pc 459", "al_r9_pc_459"},
     {{al, r6, pc, 70}, false, al, "al r6 pc 70", "al_r6_pc_70"},
     {{al, r5, pc, 4092}, false, al, "al r5 pc 4092", "al_r5_pc_4092"},
     {{al, r9, pc, 1660}, false, al, "al r9 pc 1660", "al_r9_pc_1660"},
     {{al, r7, pc, 1687}, false, al, "al r7 pc 1687", "al_r7_pc_1687"},
     {{al, r3, pc, 2839}, false, al, "al r3 pc 2839", "al_r3_pc_2839"},
     {{al, r3, pc, 1867}, false, al, "al r3 pc 1867", "al_r3_pc_1867"},
     {{al, r2, pc, 3544}, false, al, "al r2 pc 3544", "al_r2_pc_3544"},
     {{al, r14, pc, 674}, false, al, "al r14 pc 674", "al_r14_pc_674"},
     {{al, r7, pc, 1372}, false, al, "al r7 pc 1372", "al_r7_pc_1372"},
     {{al, r12, pc, 2021}, false, al, "al r12 pc 2021", "al_r12_pc_2021"},
     {{al, r9, pc, 766}, false, al, "al r9 pc 766", "al_r9_pc_766"},
     {{al, r12, pc, 421}, false, al, "al r12 pc 421", "al_r12_pc_421"},
     {{al, r14, pc, 2559}, false, al, "al r14 pc 2559", "al_r14_pc_2559"},
     {{al, r14, pc, 362}, false, al, "al r14 pc 362", "al_r14_pc_362"},
     {{al, r9, pc, 3607}, false, al, "al r9 pc 3607", "al_r9_pc_3607"},
     {{al, r4, pc, 3002}, false, al, "al r4 pc 3002", "al_r4_pc_3002"},
     {{al, r9, pc, 1899}, false, al, "al r9 pc 1899", "al_r9_pc_1899"},
     {{al, r11, pc, 1043}, false, al, "al r11 pc 1043", "al_r11_pc_1043"},
     {{al, r6, pc, 3564}, false, al, "al r6 pc 3564", "al_r6_pc_3564"},
     {{al, r9, pc, 1171}, false, al, "al r9 pc 1171", "al_r9_pc_1171"},
     {{al, r12, pc, 662}, false, al, "al r12 pc 662", "al_r12_pc_662"},
     {{al, r10, pc, 871}, false, al, "al r10 pc 871", "al_r10_pc_871"},
     {{al, r2, pc, 3636}, false, al, "al r2 pc 3636", "al_r2_pc_3636"},
     {{al, r0, pc, 1266}, false, al, "al r0 pc 1266", "al_r0_pc_1266"},
     {{al, r14, pc, 1824}, false, al, "al r14 pc 1824", "al_r14_pc_1824"},
     {{al, r5, pc, 2427}, false, al, "al r5 pc 2427", "al_r5_pc_2427"},
     {{al, r3, pc, 3139}, false, al, "al r3 pc 3139", "al_r3_pc_3139"},
     {{al, r4, pc, 3952}, false, al, "al r4 pc 3952", "al_r4_pc_3952"},
     {{al, r8, pc, 1472}, false, al, "al r8 pc 1472", "al_r8_pc_1472"},
     {{al, r2, pc, 1732}, false, al, "al r2 pc 1732", "al_r2_pc_1732"},
     {{al, r10, pc, 3099}, false, al, "al r10 pc 3099", "al_r10_pc_3099"},
     {{al, r7, pc, 3652}, false, al, "al r7 pc 3652", "al_r7_pc_3652"},
     {{al, r2, pc, 1740}, false, al, "al r2 pc 1740", "al_r2_pc_1740"},
     {{al, r5, pc, 1309}, false, al, "al r5 pc 1309", "al_r5_pc_1309"},
     {{al, r2, pc, 1485}, false, al, "al r2 pc 1485", "al_r2_pc_1485"},
     {{al, r1, pc, 766}, false, al, "al r1 pc 766", "al_r1_pc_766"},
     {{al, r0, pc, 791}, false, al, "al r0 pc 791", "al_r0_pc_791"},
     {{al, r11, pc, 1652}, false, al, "al r11 pc 1652", "al_r11_pc_1652"},
     {{al, r11, pc, 3417}, false, al, "al r11 pc 3417", "al_r11_pc_3417"},
     {{al, r1, pc, 3771}, false, al, "al r1 pc 3771", "al_r1_pc_3771"},
     {{al, r2, pc, 3088}, false, al, "al r2 pc 3088", "al_r2_pc_3088"},
     {{al, r10, pc, 3787}, false, al, "al r10 pc 3787", "al_r10_pc_3787"},
     {{al, r4, pc, 837}, false, al, "al r4 pc 837", "al_r4_pc_837"},
     {{al, r8, pc, 969}, false, al, "al r8 pc 969", "al_r8_pc_969"},
     {{al, r10, pc, 2651}, false, al, "al r10 pc 2651", "al_r10_pc_2651"},
     {{al, r11, pc, 2464}, false, al, "al r11 pc 2464", "al_r11_pc_2464"},
     {{al, r4, pc, 679}, false, al, "al r4 pc 679", "al_r4_pc_679"},
     {{al, r5, pc, 2036}, false, al, "al r5 pc 2036", "al_r5_pc_2036"},
     {{al, r12, pc, 2052}, false, al, "al r12 pc 2052", "al_r12_pc_2052"},
     {{al, r13, pc, 999}, false, al, "al r13 pc 999", "al_r13_pc_999"},
     {{al, r8, pc, 2929}, false, al, "al r8 pc 2929", "al_r8_pc_2929"},
     {{al, r6, pc, 1485}, false, al, "al r6 pc 1485", "al_r6_pc_1485"},
     {{al, r9, pc, 3688}, false, al, "al r9 pc 3688", "al_r9_pc_3688"},
     {{al, r1, pc, 4}, false, al, "al r1 pc 4", "al_r1_pc_4"},
     {{al, r1, pc, 180}, false, al, "al r1 pc 180", "al_r1_pc_180"},
     {{al, r2, pc, 1665}, false, al, "al r2 pc 1665", "al_r2_pc_1665"},
     {{al, r10, pc, 955}, false, al, "al r10 pc 955", "al_r10_pc_955"},
     {{al, r6, pc, 3994}, false, al, "al r6 pc 3994", "al_r6_pc_3994"},
     {{al, r2, pc, 3603}, false, al, "al r2 pc 3603", "al_r2_pc_3603"},
     {{al, r4, pc, 964}, false, al, "al r4 pc 964", "al_r4_pc_964"},
     {{al, r14, pc, 955}, false, al, "al r14 pc 955", "al_r14_pc_955"},
     {{al, r11, pc, 3880}, false, al, "al r11 pc 3880", "al_r11_pc_3880"},
     {{al, r10, pc, 524}, false, al, "al r10 pc 524", "al_r10_pc_524"},
     {{al, r14, pc, 2792}, false, al, "al r14 pc 2792", "al_r14_pc_2792"},
     {{al, r11, pc, 3952}, false, al, "al r11 pc 3952", "al_r11_pc_3952"},
     {{al, r5, pc, 4091}, false, al, "al r5 pc 4091", "al_r5_pc_4091"},
     {{al, r13, pc, 1359}, false, al, "al r13 pc 1359", "al_r13_pc_1359"},
     {{al, r9, pc, 490}, false, al, "al r9 pc 490", "al_r9_pc_490"},
     {{al, r0, pc, 3221}, false, al, "al r0 pc 3221", "al_r0_pc_3221"},
     {{al, r11, pc, 3313}, false, al, "al r11 pc 3313", "al_r11_pc_3313"},
     {{al, r1, pc, 1961}, false, al, "al r1 pc 1961", "al_r1_pc_1961"},
     {{al, r9, pc, 478}, false, al, "al r9 pc 478", "al_r9_pc_478"},
     {{al, r12, pc, 1687}, false, al, "al r12 pc 1687", "al_r12_pc_1687"},
     {{al, r1, pc, 2038}, false, al, "al r1 pc 2038", "al_r1_pc_2038"},
     {{al, r0, pc, 3517}, false, al, "al r0 pc 3517", "al_r0_pc_3517"},
     {{al, r0, pc, 3041}, false, al, "al r0 pc 3041", "al_r0_pc_3041"},
     {{al, r12, pc, 3522}, false, al, "al r12 pc 3522", "al_r12_pc_3522"},
     {{al, r11, pc, 3728}, false, al, "al r11 pc 3728", "al_r11_pc_3728"},
     {{al, r1, pc, 960}, false, al, "al r1 pc 960", "al_r1_pc_960"},
     {{al, r10, pc, 3308}, false, al, "al r10 pc 3308", "al_r10_pc_3308"},
     {{al, r1, pc, 3871}, false, al, "al r1 pc 3871", "al_r1_pc_3871"},
     {{al, r2, pc, 138}, false, al, "al r2 pc 138", "al_r2_pc_138"},
     {{al, r4, pc, 2946}, false, al, "al r4 pc 2946", "al_r4_pc_2946"},
     {{al, r14, pc, 1445}, false, al, "al r14 pc 1445", "al_r14_pc_1445"},
     {{al, r8, pc, 263}, false, al, "al r8 pc 263", "al_r8_pc_263"},
     {{al, r7, pc, 348}, false, al, "al r7 pc 348", "al_r7_pc_348"},
     {{al, r1, pc, 606}, false, al, "al r1 pc 606", "al_r1_pc_606"},
     {{al, r10, pc, 2402}, false, al, "al r10 pc 2402", "al_r10_pc_2402"},
     {{al, r3, pc, 70}, false, al, "al r3 pc 70", "al_r3_pc_70"},
     {{al, r7, pc, 2994}, false, al, "al r7 pc 2994", "al_r7_pc_2994"},
     {{al, r13, pc, 3880}, false, al, "al r13 pc 3880", "al_r13_pc_3880"},
     {{al, r10, pc, 2224}, false, al, "al r10 pc 2224", "al_r10_pc_2224"},
     {{al, r11, pc, 2710}, false, al, "al r11 pc 2710", "al_r11_pc_2710"},
     {{al, r7, pc, 3491}, false, al, "al r7 pc 3491", "al_r7_pc_3491"},
     {{al, r5, pc, 3384}, false, al, "al r5 pc 3384", "al_r5_pc_3384"},
     {{al, r4, pc, 2628}, false, al, "al r4 pc 2628", "al_r4_pc_2628"},
     {{al, r0, pc, 3907}, false, al, "al r0 pc 3907", "al_r0_pc_3907"},
     {{al, r5, pc, 523}, false, al, "al r5 pc 523", "al_r5_pc_523"},
     {{al, r0, pc, 1261}, false, al, "al r0 pc 1261", "al_r0_pc_1261"},
     {{al, r2, pc, 1428}, false, al, "al r2 pc 1428", "al_r2_pc_1428"},
     {{al, r12, pc, 606}, false, al, "al r12 pc 606", "al_r12_pc_606"},
     {{al, r4, pc, 2710}, false, al, "al r4 pc 2710", "al_r4_pc_2710"},
     {{al, r0, pc, 3007}, false, al, "al r0 pc 3007", "al_r0_pc_3007"},
     {{al, r8, pc, 2464}, false, al, "al r8 pc 2464", "al_r8_pc_2464"},
     {{al, r6, pc, 674}, false, al, "al r6 pc 674", "al_r6_pc_674"},
     {{al, r5, pc, 136}, false, al, "al r5 pc 136", "al_r5_pc_136"},
     {{al, r1, pc, 2374}, false, al, "al r1 pc 2374", "al_r1_pc_2374"},
     {{al, r7, pc, 3989}, false, al, "al r7 pc 3989", "al_r7_pc_3989"},
     {{al, r6, pc, 3702}, false, al, "al r6 pc 3702", "al_r6_pc_3702"},
     {{al, r9, pc, 1527}, false, al, "al r9 pc 1527", "al_r9_pc_1527"},
     {{al, r1, pc, 3564}, false, al, "al r1 pc 3564", "al_r1_pc_3564"},
     {{al, r2, pc, 3072}, false, al, "al r2 pc 3072", "al_r2_pc_3072"},
     {{al, r4, pc, 4076}, false, al, "al r4 pc 4076", "al_r4_pc_4076"},
     {{al, r8, pc, 4091}, false, al, "al r8 pc 4091", "al_r8_pc_4091"},
     {{al, r11, pc, 3099}, false, al, "al r11 pc 3099", "al_r11_pc_3099"},
     {{al, r0, pc, 358}, false, al, "al r0 pc 358", "al_r0_pc_358"},
     {{al, r2, pc, 704}, false, al, "al r2 pc 704", "al_r2_pc_704"},
     {{al, r5, pc, 386}, false, al, "al r5 pc 386", "al_r5_pc_386"},
     {{al, r11, pc, 4056}, false, al, "al r11 pc 4056", "al_r11_pc_4056"},
     {{al, r4, pc, 3450}, false, al, "al r4 pc 3450", "al_r4_pc_3450"},
     {{al, r8, pc, 2628}, false, al, "al r8 pc 2628", "al_r8_pc_2628"},
     {{al, r14, pc, 3752}, false, al, "al r14 pc 3752", "al_r14_pc_3752"},
     {{al, r0, pc, 2326}, false, al, "al r0 pc 2326", "al_r0_pc_2326"},
     {{al, r13, pc, 3978}, false, al, "al r13 pc 3978", "al_r13_pc_3978"},
     {{al, r5, pc, 2982}, false, al, "al r5 pc 2982", "al_r5_pc_2982"},
     {{al, r5, pc, 1274}, false, al, "al r5 pc 1274", "al_r5_pc_1274"},
     {{al, r5, pc, 2718}, false, al, "al r5 pc 2718", "al_r5_pc_2718"},
     {{al, r9, pc, 872}, false, al, "al r9 pc 872", "al_r9_pc_872"},
     {{al, r8, pc, 3626}, false, al, "al r8 pc 3626", "al_r8_pc_3626"},
     {{al, r0, pc, 2254}, false, al, "al r0 pc 2254", "al_r0_pc_2254"},
     {{al, r0, pc, 3660}, false, al, "al r0 pc 3660", "al_r0_pc_3660"},
     {{al, r13, pc, 270}, false, al, "al r13 pc 270", "al_r13_pc_270"},
     {{al, r6, pc, 2358}, false, al, "al r6 pc 2358", "al_r6_pc_2358"},
     {{al, r6, pc, 342}, false, al, "al r6 pc 342", "al_r6_pc_342"},
     {{al, r3, pc, 828}, false, al, "al r3 pc 828", "al_r3_pc_828"},
     {{al, r6, pc, 3239}, false, al, "al r6 pc 3239", "al_r6_pc_3239"},
     {{al, r9, pc, 3313}, false, al, "al r9 pc 3313", "al_r9_pc_3313"},
     {{al, r9, pc, 2669}, false, al, "al r9 pc 2669", "al_r9_pc_2669"},
     {{al, r9, pc, 2314}, false, al, "al r9 pc 2314", "al_r9_pc_2314"},
     {{al, r3, pc, 1475}, false, al, "al r3 pc 1475", "al_r3_pc_1475"},
     {{al, r6, pc, 1759}, false, al, "al r6 pc 1759", "al_r6_pc_1759"},
     {{al, r1, pc, 3572}, false, al, "al r1 pc 3572", "al_r1_pc_3572"},
     {{al, r5, pc, 1655}, false, al, "al r5 pc 1655", "al_r5_pc_1655"},
     {{al, r6, pc, 1498}, false, al, "al r6 pc 1498", "al_r6_pc_1498"},
     {{al, r9, pc, 1542}, false, al, "al r9 pc 1542", "al_r9_pc_1542"},
     {{al, r4, pc, 3079}, false, al, "al r4 pc 3079", "al_r4_pc_3079"},
     {{al, r14, pc, 3438}, false, al, "al r14 pc 3438", "al_r14_pc_3438"},
     {{al, r0, pc, 2721}, false, al, "al r0 pc 2721", "al_r0_pc_2721"},
     {{al, r0, pc, 2627}, false, al, "al r0 pc 2627", "al_r0_pc_2627"},
     {{al, r12, pc, 136}, false, al, "al r12 pc 136", "al_r12_pc_136"},
     {{al, r14, pc, 2462}, false, al, "al r14 pc 2462", "al_r14_pc_2462"},
     {{al, r11, pc, 47}, false, al, "al r11 pc 47", "al_r11_pc_47"},
     {{al, r4, pc, 2535}, false, al, "al r4 pc 2535", "al_r4_pc_2535"},
     {{al, r13, pc, 2281}, false, al, "al r13 pc 2281", "al_r13_pc_2281"},
     {{al, r7, pc, 22}, false, al, "al r7 pc 22", "al_r7_pc_22"},
     {{al, r0, pc, 1991}, false, al, "al r0 pc 1991", "al_r0_pc_1991"},
     {{al, r6, pc, 3313}, false, al, "al r6 pc 3313", "al_r6_pc_3313"},
     {{al, r1, pc, 3728}, false, al, "al r1 pc 3728", "al_r1_pc_3728"},
     {{al, r12, pc, 1759}, false, al, "al r12 pc 1759", "al_r12_pc_1759"},
     {{al, r6, pc, 3282}, false, al, "al r6 pc 3282", "al_r6_pc_3282"},
     {{al, r6, pc, 988}, false, al, "al r6 pc 988", "al_r6_pc_988"},
     {{al, r13, pc, 3952}, false, al, "al r13 pc 3952", "al_r13_pc_3952"},
     {{al, r10, pc, 1390}, false, al, "al r10 pc 1390", "al_r10_pc_1390"},
     {{al, r5, pc, 2810}, false, al, "al r5 pc 2810", "al_r5_pc_2810"},
     {{al, r3, pc, 1198}, false, al, "al r3 pc 1198", "al_r3_pc_1198"},
     {{al, r11, pc, 796}, false, al, "al r11 pc 796", "al_r11_pc_796"},
     {{al, r7, pc, 3856}, false, al, "al r7 pc 3856", "al_r7_pc_3856"},
     {{al, r5, pc, 3504}, false, al, "al r5 pc 3504", "al_r5_pc_3504"},
     {{al, r9, pc, 2402}, false, al, "al r9 pc 2402", "al_r9_pc_2402"},
     {{al, r5, pc, 251}, false, al, "al r5 pc 251", "al_r5_pc_251"},
     {{al, r4, pc, 2119}, false, al, "al r4 pc 2119", "al_r4_pc_2119"},
     {{al, r6, pc, 2069}, false, al, "al r6 pc 2069", "al_r6_pc_2069"},
     {{al, r3, pc, 1485}, false, al, "al r3 pc 1485", "al_r3_pc_1485"},
     {{al, r1, pc, 3994}, false, al, "al r1 pc 3994", "al_r1_pc_3994"},
     {{al, r13, pc, 342}, false, al, "al r13 pc 342", "al_r13_pc_342"},
     {{al, r12, pc, 964}, false, al, "al r12 pc 964", "al_r12_pc_964"},
     {{al, r10, pc, 3662}, false, al, "al r10 pc 3662", "al_r10_pc_3662"},
     {{al, r5, pc, 398}, false, al, "al r5 pc 398", "al_r5_pc_398"},
     {{al, r9, pc, 2523}, false, al, "al r9 pc 2523", "al_r9_pc_2523"},
     {{al, r3, pc, 1372}, false, al, "al r3 pc 1372", "al_r3_pc_1372"},
     {{al, r7, pc, 3449}, false, al, "al r7 pc 3449", "al_r7_pc_3449"},
     {{al, r8, pc, 2240}, false, al, "al r8 pc 2240", "al_r8_pc_2240"},
     {{al, r9, pc, 670}, false, al, "al r9 pc 670", "al_r9_pc_670"},
     {{al, r6, pc, 999}, false, al, "al r6 pc 999", "al_r6_pc_999"},
     {{al, r7, pc, 2799}, false, al, "al r7 pc 2799", "al_r7_pc_2799"},
     {{al, r1, pc, 1168}, false, al, "al r1 pc 1168", "al_r1_pc_1168"},
     {{al, r6, pc, 4}, false, al, "al r6 pc 4", "al_r6_pc_4"},
     {{al, r13, pc, 2546}, false, al, "al r13 pc 2546", "al_r13_pc_2546"},
     {{al, r10, pc, 3585}, false, al, "al r10 pc 3585", "al_r10_pc_3585"},
     {{al, r5, pc, 1175}, false, al, "al r5 pc 1175", "al_r5_pc_1175"},
     {{al, r14, pc, 669}, false, al, "al r14 pc 669", "al_r14_pc_669"},
     {{al, r7, pc, 2052}, false, al, "al r7 pc 2052", "al_r7_pc_2052"},
     {{al, r7, pc, 1097}, false, al, "al r7 pc 1097", "al_r7_pc_1097"},
     {{al, r0, pc, 2866}, false, al, "al r0 pc 2866", "al_r0_pc_2866"},
     {{al, r3, pc, 484}, false, al, "al r3 pc 484", "al_r3_pc_484"},
     {{al, r2, pc, 1527}, false, al, "al r2 pc 1527", "al_r2_pc_1527"},
     {{al, r11, pc, 362}, false, al, "al r11 pc 362", "al_r11_pc_362"},
     {{al, r1, pc, 770}, false, al, "al r1 pc 770", "al_r1_pc_770"},
     {{al, r0, pc, 1475}, false, al, "al r0 pc 1475", "al_r0_pc_1475"},
     {{al, r4, pc, 1642}, false, al, "al r4 pc 1642", "al_r4_pc_1642"},
     {{al, r11, pc, 3583}, false, al, "al r11 pc 3583", "al_r11_pc_3583"},
     {{al, r13, pc, 2591}, false, al, "al r13 pc 2591", "al_r13_pc_2591"},
     {{al, r12, pc, 3366}, false, al, "al r12 pc 3366", "al_r12_pc_3366"},
     {{al, r12, pc, 524}, false, al, "al r12 pc 524", "al_r12_pc_524"},
     {{al, r14, pc, 2929}, false, al, "al r14 pc 2929", "al_r14_pc_2929"},
     {{al, r14, pc, 915}, false, al, "al r14 pc 915", "al_r14_pc_915"},
     {{al, r8, pc, 2545}, false, al, "al r8 pc 2545", "al_r8_pc_2545"},
     {{al, r4, pc, 523}, false, al, "al r4 pc 523", "al_r4_pc_523"},
     {{al, r4, pc, 3702}, false, al, "al r4 pc 3702", "al_r4_pc_3702"},
     {{al, r2, pc, 3986}, false, al, "al r2 pc 3986", "al_r2_pc_3986"},
     {{al, r3, pc, 1246}, false, al, "al r3 pc 1246", "al_r3_pc_1246"},
     {{al, r9, pc, 2326}, false, al, "al r9 pc 2326", "al_r9_pc_2326"},
     {{al, r12, pc, 3079}, false, al, "al r12 pc 3079", "al_r12_pc_3079"},
     {{al, r13, pc, 2728}, false, al, "al r13 pc 2728", "al_r13_pc_2728"},
     {{al, r9, pc, 732}, false, al, "al r9 pc 732", "al_r9_pc_732"},
     {{al, r1, pc, 3652}, false, al, "al r1 pc 3652", "al_r1_pc_3652"},
     {{al, r4, pc, 542}, false, al, "al r4 pc 542", "al_r4_pc_542"},
     {{al, r3, pc, 2365}, false, al, "al r3 pc 2365", "al_r3_pc_2365"},
     {{al, r12, pc, 2023}, false, al, "al r12 pc 2023", "al_r12_pc_2023"},
     {{al, r11, pc, 2721}, false, al, "al r11 pc 2721", "al_r11_pc_2721"},
     {{al, r4, pc, 1635}, false, al, "al r4 pc 1635", "al_r4_pc_1635"},
     {{al, r6, pc, 2792}, false, al, "al r6 pc 2792", "al_r6_pc_2792"},
     {{al, r4, pc, 3821}, false, al, "al r4 pc 3821", "al_r4_pc_3821"},
     {{al, r3, pc, 2072}, false, al, "al r3 pc 2072", "al_r3_pc_2072"},
     {{al, r11, pc, 689}, false, al, "al r11 pc 689", "al_r11_pc_689"},
     {{al, r7, pc, 1872}, false, al, "al r7 pc 1872", "al_r7_pc_1872"},
     {{al, r14, pc, 524}, false, al, "al r14 pc 524", "al_r14_pc_524"},
     {{al, r2, pc, 1198}, false, al, "al r2 pc 1198", "al_r2_pc_1198"},
     {{al, r10, pc, 306}, false, al, "al r10 pc 306", "al_r10_pc_306"},
     {{al, r1, pc, 481}, false, al, "al r1 pc 481", "al_r1_pc_481"},
     {{al, r2, pc, 2183}, false, al, "al r2 pc 2183", "al_r2_pc_2183"},
     {{al, r9, pc, 1835}, false, al, "al r9 pc 1835", "al_r9_pc_1835"},
     {{al, r1, pc, 1824}, false, al, "al r1 pc 1824", "al_r1_pc_1824"},
     {{al, r4, pc, 3105}, false, al, "al r4 pc 3105", "al_r4_pc_3105"},
     {{al, r3, pc, 1309}, false, al, "al r3 pc 1309", "al_r3_pc_1309"},
     {{al, r0, pc, 1804}, false, al, "al r0 pc 1804", "al_r0_pc_1804"},
     {{al, r12, pc, 478}, false, al, "al r12 pc 478", "al_r12_pc_478"},
     {{al, r2, pc, 3008}, false, al, "al r2 pc 3008", "al_r2_pc_3008"},
     {{al, r10, pc, 3625}, false, al, "al r10 pc 3625", "al_r10_pc_3625"},
     {{al, r10, pc, 98}, false, al, "al r10 pc 98", "al_r10_pc_98"},
     {{al, r0, pc, 233}, false, al, "al r0 pc 233", "al_r0_pc_233"},
     {{al, r2, pc, 2281}, false, al, "al r2 pc 2281", "al_r2_pc_2281"},
     {{al, r0, pc, 674}, false, al, "al r0 pc 674", "al_r0_pc_674"},
     {{al, r1, pc, 3209}, false, al, "al r1 pc 3209", "al_r1_pc_3209"},
     {{al, r1, pc, 2072}, false, al, "al r1 pc 2072", "al_r1_pc_2072"},
     {{al, r5, pc, 3170}, false, al, "al r5 pc 3170", "al_r5_pc_3170"},
     {{al, r8, pc, 2091}, false, al, "al r8 pc 2091", "al_r8_pc_2091"},
     {{al, r6, pc, 1359}, false, al, "al r6 pc 1359", "al_r6_pc_1359"},
     {{al, r7, pc, 510}, false, al, "al r7 pc 510", "al_r7_pc_510"},
     {{al, r11, pc, 1666}, false, al, "al r11 pc 1666", "al_r11_pc_1666"},
     {{al, r0, pc, 3397}, false, al, "al r0 pc 3397", "al_r0_pc_3397"},
     {{al, r11, pc, 2535}, false, al, "al r11 pc 2535", "al_r11_pc_2535"},
     {{al, r6, pc, 3638}, false, al, "al r6 pc 3638", "al_r6_pc_3638"},
     {{al, r3, pc, 2929}, false, al, "al r3 pc 2929", "al_r3_pc_2929"},
     {{al, r7, pc, 970}, false, al, "al r7 pc 970", "al_r7_pc_970"},
     {{al, r0, pc, 484}, false, al, "al r0 pc 484", "al_r0_pc_484"},
     {{al, r13, pc, 1699}, false, al, "al r13 pc 1699", "al_r13_pc_1699"},
     {{al, r14, pc, 2532}, false, al, "al r14 pc 2532", "al_r14_pc_2532"},
     {{al, r11, pc, 342}, false, al, "al r11 pc 342", "al_r11_pc_342"},
     {{al, r13, pc, 2933}, false, al, "al r13 pc 2933", "al_r13_pc_2933"},
     {{al, r2, pc, 1899}, false, al, "al r2 pc 1899", "al_r2_pc_1899"},
     {{al, r10, pc, 2945}, false, al, "al r10 pc 2945", "al_r10_pc_2945"},
     {{al, r4, pc, 2233}, false, al, "al r4 pc 2233", "al_r4_pc_2233"},
     {{al, r4, pc, 2451}, false, al, "al r4 pc 2451", "al_r4_pc_2451"},
     {{al, r13, pc, 1168}, false, al, "al r13 pc 1168", "al_r13_pc_1168"},
     {{al, r3, pc, 999}, false, al, "al r3 pc 999", "al_r3_pc_999"},
     {{al, r6, pc, 3771}, false, al, "al r6 pc 3771", "al_r6_pc_3771"},
     {{al, r13, pc, 1556}, false, al, "al r13 pc 1556", "al_r13_pc_1556"},
     {{al, r7, pc, 662}, false, al, "al r7 pc 662", "al_r7_pc_662"},
     {{al, r9, pc, 4095}, false, al, "al r9 pc 4095", "al_r9_pc_4095"},
     {{al, r14, pc, 2233}, false, al, "al r14 pc 2233", "al_r14_pc_2233"},
     {{al, r7, pc, 783}, false, al, "al r7 pc 783", "al_r7_pc_783"},
     {{al, r3, pc, 3449}, false, al, "al r3 pc 3449", "al_r3_pc_3449"},
     {{al, r7, pc, 672}, false, al, "al r7 pc 672", "al_r7_pc_672"},
     {{al, r11, pc, 2944}, false, al, "al r11 pc 2944", "al_r11_pc_2944"},
     {{al, r1, pc, 2797}, false, al, "al r1 pc 2797", "al_r1_pc_2797"},
     {{al, r4, pc, 811}, false, al, "al r4 pc 811", "al_r4_pc_811"},
     {{al, r0, pc, 2464}, false, al, "al r0 pc 2464", "al_r0_pc_2464"},
     {{al, r8, pc, 806}, false, al, "al r8 pc 806", "al_r8_pc_806"},
     {{al, r7, pc, 2800}, false, al, "al r7 pc 2800", "al_r7_pc_2800"},
     {{al, r10, pc, 525}, false, al, "al r10 pc 525", "al_r10_pc_525"},
     {{al, r13, pc, 1234}, false, al, "al r13 pc 1234", "al_r13_pc_1234"},
     {{al, r7, pc, 999}, false, al, "al r7 pc 999", "al_r7_pc_999"},
     {{al, r3, pc, 2233}, false, al, "al r3 pc 2233", "al_r3_pc_2233"},
     {{al, r6, pc, 2617}, false, al, "al r6 pc 2617", "al_r6_pc_2617"},
     {{al, r14, pc, 3078}, false, al, "al r14 pc 3078", "al_r14_pc_3078"},
     {{al, r2, pc, 1357}, false, al, "al r2 pc 1357", "al_r2_pc_1357"},
     {{al, r6, pc, 1975}, false, al, "al r6 pc 1975", "al_r6_pc_1975"},
     {{al, r6, pc, 2944}, false, al, "al r6 pc 2944", "al_r6_pc_2944"},
     {{al, r1, pc, 915}, false, al, "al r1 pc 915", "al_r1_pc_915"},
     {{al, r13, pc, 3572}, false, al, "al r13 pc 3572", "al_r13_pc_3572"},
     {{al, r11, pc, 106}, false, al, "al r11 pc 106", "al_r11_pc_106"},
     {{al, r3, pc, 542}, false, al, "al r3 pc 542", "al_r3_pc_542"},
     {{al, r10, pc, 1867}, false, al, "al r10 pc 1867", "al_r10_pc_1867"},
     {{al, r3, pc, 2323}, false, al, "al r3 pc 2323", "al_r3_pc_2323"},
     {{al, r11, pc, 1407}, false, al, "al r11 pc 1407", "al_r11_pc_1407"},
     {{al, r2, pc, 1652}, false, al, "al r2 pc 1652", "al_r2_pc_1652"},
     {{al, r9, pc, 1428}, false, al, "al r9 pc 1428", "al_r9_pc_1428"},
     {{al, r12, pc, 47}, false, al, "al r12 pc 47", "al_r12_pc_47"},
     {{al, r12, pc, 3663}, false, al, "al r12 pc 3663", "al_r12_pc_3663"},
     {{al, r6, pc, 3008}, false, al, "al r6 pc 3008", "al_r6_pc_3008"},
     {{al, r3, pc, 3254}, false, al, "al r3 pc 3254", "al_r3_pc_3254"},
     {{al, r14, pc, 2}, false, al, "al r14 pc 2", "al_r14_pc_2"},
     {{al, r9, pc, 958}, false, al, "al r9 pc 958", "al_r9_pc_958"},
     {{al, r3, pc, 1922}, false, al, "al r3 pc 1922", "al_r3_pc_1922"},
     {{al, r10, pc, 3239}, false, al, "al r10 pc 3239", "al_r10_pc_3239"},
     {{al, r6, pc, 1948}, false, al, "al r6 pc 1948", "al_r6_pc_1948"},
     {{al, r11, pc, 2523}, false, al, "al r11 pc 2523", "al_r11_pc_2523"},
     {{al, r8, pc, 2038}, false, al, "al r8 pc 2038", "al_r8_pc_2038"},
     {{al, r0, pc, 2999}, false, al, "al r0 pc 2999", "al_r0_pc_2999"},
     {{al, r9, pc, 672}, false, al, "al r9 pc 672", "al_r9_pc_672"},
     {{al, r0, pc, 4090}, false, al, "al r0 pc 4090", "al_r0_pc_4090"},
     {{al, r3, pc, 22}, false, al, "al r3 pc 22", "al_r3_pc_22"},
     {{al, r13, pc, 1231}, false, al, "al r13 pc 1231", "al_r13_pc_1231"},
     {{al, r9, pc, 2559}, false, al, "al r9 pc 2559", "al_r9_pc_2559"},
     {{al, r12, pc, 1505}, false, al, "al r12 pc 1505", "al_r12_pc_1505"},
     {{al, r13, pc, 670}, false, al, "al r13 pc 670", "al_r13_pc_670"},
     {{al, r0, pc, 2338}, false, al, "al r0 pc 2338", "al_r0_pc_2338"},
     {{al, r9, pc, 2475}, false, al, "al r9 pc 2475", "al_r9_pc_2475"},
     {{al, r11, pc, 1009}, false, al, "al r11 pc 1009", "al_r11_pc_1009"},
     {{al, r9, pc, 3425}, false, al, "al r9 pc 3425", "al_r9_pc_3425"},
     {{al, r10, pc, 1896}, false, al, "al r10 pc 1896", "al_r10_pc_1896"},
     {{al, r4, pc, 3007}, false, al, "al r4 pc 3007", "al_r4_pc_3007"},
     {{al, r4, pc, 3094}, false, al, "al r4 pc 3094", "al_r4_pc_3094"},
     {{al, r14, pc, 3739}, false, al, "al r14 pc 3739", "al_r14_pc_3739"},
     {{al, r1, pc, 2036}, false, al, "al r1 pc 2036", "al_r1_pc_2036"},
     {{al, r14, pc, 3194}, false, al, "al r14 pc 3194", "al_r14_pc_3194"},
     {{al, r13, pc, 2247}, false, al, "al r13 pc 2247", "al_r13_pc_2247"},
     {{al, r7, pc, 2464}, false, al, "al r7 pc 2464", "al_r7_pc_2464"},
     {{al, r5, pc, 200}, false, al, "al r5 pc 200", "al_r5_pc_200"},
     {{al, r3, pc, 3069}, false, al, "al r3 pc 3069", "al_r3_pc_3069"},
     {{al, r3, pc, 1666}, false, al, "al r3 pc 1666", "al_r3_pc_1666"},
     {{al, r3, pc, 1116}, false, al, "al r3 pc 1116", "al_r3_pc_1116"},
     {{al, r3, pc, 1097}, false, al, "al r3 pc 1097", "al_r3_pc_1097"},
     {{al, r14, pc, 3449}, false, al, "al r14 pc 3449", "al_r14_pc_3449"},
     {{al, r12, pc, 1635}, false, al, "al r12 pc 1635", "al_r12_pc_1635"},
     {{al, r9, pc, 213}, false, al, "al r9 pc 213", "al_r9_pc_213"},
     {{al, r9, pc, 1961}, false, al, "al r9 pc 1961", "al_r9_pc_1961"},
     {{al, r8, pc, 3610}, false, al, "al r8 pc 3610", "al_r8_pc_3610"},
     {{al, r0, pc, 3008}, false, al, "al r0 pc 3008", "al_r0_pc_3008"},
     {{al, r0, pc, 811}, false, al, "al r0 pc 811", "al_r0_pc_811"},
     {{al, r3, pc, 831}, false, al, "al r3 pc 831", "al_r3_pc_831"},
     {{al, r5, pc, 4082}, false, al, "al r5 pc 4082", "al_r5_pc_4082"},
     {{al, r3, pc, 3413}, false, al, "al r3 pc 3413", "al_r3_pc_3413"},
     {{al, r12, pc, 4092}, false, al, "al r12 pc 4092", "al_r12_pc_4092"},
     {{al, r8, pc, 3652}, false, al, "al r8 pc 3652", "al_r8_pc_3652"},
     {{al, r6, pc, 1459}, false, al, "al r6 pc 1459", "al_r6_pc_1459"},
     {{al, r8, pc, 1459}, false, al, "al r8 pc 1459", "al_r8_pc_1459"},
     {{al, r10, pc, 2994}, false, al, "al r10 pc 2994", "al_r10_pc_2994"},
     {{al, r6, pc, 523}, false, al, "al r6 pc 523", "al_r6_pc_523"},
     {{al, r11, pc, 3802}, false, al, "al r11 pc 3802", "al_r11_pc_3802"},
     {{al, r1, pc, 3008}, false, al, "al r1 pc 3008", "al_r1_pc_3008"},
     {{al, r9, pc, 1804}, false, al, "al r9 pc 1804", "al_r9_pc_1804"},
     {{al, r13, pc, 2642}, false, al, "al r13 pc 2642", "al_r13_pc_2642"},
     {{al, r4, pc, 4090}, false, al, "al r4 pc 4090", "al_r4_pc_4090"},
     {{al, r14, pc, 1687}, false, al, "al r14 pc 1687", "al_r14_pc_1687"},
     {{al, r2, pc, 2046}, false, al, "al r2 pc 2046", "al_r2_pc_2046"},
     {{al, r3, pc, 1168}, false, al, "al r3 pc 1168", "al_r3_pc_1168"},
     {{al, r3, pc, 1389}, false, al, "al r3 pc 1389", "al_r3_pc_1389"},
     {{al, r8, pc, 1479}, false, al, "al r8 pc 1479", "al_r8_pc_1479"},
     {{al, r3, pc, 2175}, false, al, "al r3 pc 2175", "al_r3_pc_2175"},
     {{al, r13, pc, 3772}, false, al, "al r13 pc 3772", "al_r13_pc_3772"},
     {{al, r4, pc, 3076}, false, al, "al r4 pc 3076", "al_r4_pc_3076"},
     {{al, r13, pc, 210}, false, al, "al r13 pc 210", "al_r13_pc_210"},
     {{al, r5, pc, 282}, false, al, "al r5 pc 282", "al_r5_pc_282"},
     {{al, r12, pc, 1859}, false, al, "al r12 pc 1859", "al_r12_pc_1859"},
     {{al, r5, pc, 796}, false, al, "al r5 pc 796", "al_r5_pc_796"},
     {{al, r8, pc, 2338}, false, al, "al r8 pc 2338", "al_r8_pc_2338"},
     {{al, r2, pc, 685}, false, al, "al r2 pc 685", "al_r2_pc_685"},
     {{al, r5, pc, 3405}, false, al, "al r5 pc 3405", "al_r5_pc_3405"},
     {{al, r0, pc, 915}, false, al, "al r0 pc 915", "al_r0_pc_915"},
     {{al, r13, pc, 1916}, false, al, "al r13 pc 1916", "al_r13_pc_1916"},
     {{al, r14, pc, 2695}, false, al, "al r14 pc 2695", "al_r14_pc_2695"},
     {{al, r13, pc, 2139}, false, al, "al r13 pc 2139", "al_r13_pc_2139"},
     {{al, r2, pc, 2866}, false, al, "al r2 pc 2866", "al_r2_pc_2866"},
     {{al, r5, pc, 1804}, false, al, "al r5 pc 1804", "al_r5_pc_1804"},
     {{al, r4, pc, 2541}, false, al, "al r4 pc 2541", "al_r4_pc_2541"},
     {{al, r11, pc, 1922}, false, al, "al r11 pc 1922", "al_r11_pc_1922"},
     {{al, r2, pc, 462}, false, al, "al r2 pc 462", "al_r2_pc_462"},
     {{al, r2, pc, 3384}, false, al, "al r2 pc 3384", "al_r2_pc_3384"},
     {{al, r6, pc, 2427}, false, al, "al r6 pc 2427", "al_r6_pc_2427"},
     {{al, r11, pc, 3384}, false, al, "al r11 pc 3384", "al_r11_pc_3384"},
     {{al, r5, pc, 2180}, false, al, "al r5 pc 2180", "al_r5_pc_2180"},
     {{al, r11, pc, 1860}, false, al, "al r11 pc 1860", "al_r11_pc_1860"},
     {{al, r8, pc, 1652}, false, al, "al r8 pc 1652", "al_r8_pc_1652"},
     {{al, r8, pc, 1099}, false, al, "al r8 pc 1099", "al_r8_pc_1099"},
     {{al, r11, pc, 1399}, false, al, "al r11 pc 1399", "al_r11_pc_1399"},
     {{al, r11, pc, 2628}, false, al, "al r11 pc 2628", "al_r11_pc_2628"},
     {{al, r14, pc, 2797}, false, al, "al r14 pc 2797", "al_r14_pc_2797"},
     {{al, r4, pc, 2994}, false, al, "al r4 pc 2994", "al_r4_pc_2994"},
     {{al, r6, pc, 3221}, false, al, "al r6 pc 3221", "al_r6_pc_3221"},
     {{al, r0, pc, 618}, false, al, "al r0 pc 618", "al_r0_pc_618"},
     {{al, r3, pc, 1357}, false, al, "al r3 pc 1357", "al_r3_pc_1357"},
     {{al, r11, pc, 2358}, false, al, "al r11 pc 2358", "al_r11_pc_2358"},
     {{al, r11, pc, 2627}, false, al, "al r11 pc 2627", "al_r11_pc_2627"},
     {{al, r10, pc, 3039}, false, al, "al r10 pc 3039", "al_r10_pc_3039"},
     {{al, r4, pc, 2590}, false, al, "al r4 pc 2590", "al_r4_pc_2590"},
     {{al, r14, pc, 282}, false, al, "al r14 pc 282", "al_r14_pc_282"},
     {{al, r1, pc, 251}, false, al, "al r1 pc 251", "al_r1_pc_251"},
     {{al, r10, pc, 3566}, false, al, "al r10 pc 3566", "al_r10_pc_3566"},
     {{al, r13, pc, 689}, false, al, "al r13 pc 689", "al_r13_pc_689"},
     {{al, r13, pc, 3918}, false, al, "al r13 pc 3918", "al_r13_pc_3918"},
     {{al, r0, pc, 3254}, false, al, "al r0 pc 3254", "al_r0_pc_3254"},
     {{al, r11, pc, 2866}, false, al, "al r11 pc 2866", "al_r11_pc_2866"},
     {{al, r14, pc, 1027}, false, al, "al r14 pc 1027", "al_r14_pc_1027"},
     {{al, r11, pc, 3007}, false, al, "al r11 pc 3007", "al_r11_pc_3007"},
     {{al, r4, pc, 1479}, false, al, "al r4 pc 1479", "al_r4_pc_1479"},
     {{al, r6, pc, 3449}, false, al, "al r6 pc 3449", "al_r6_pc_3449"},
     {{al, r3, pc, 2849}, false, al, "al r3 pc 2849", "al_r3_pc_2849"},
     {{al, r4, pc, 3608}, false, al, "al r4 pc 3608", "al_r4_pc_3608"},
     {{al, r2, pc, 2945}, false, al, "al r2 pc 2945", "al_r2_pc_2945"},
     {{al, r5, pc, 3105}, false, al, "al r5 pc 3105", "al_r5_pc_3105"},
     {{al, r4, pc, 1390}, false, al, "al r4 pc 1390", "al_r4_pc_1390"},
     {{al, r6, pc, 672}, false, al, "al r6 pc 672", "al_r6_pc_672"},
     {{al, r0, pc, 3921}, false, al, "al r0 pc 3921", "al_r0_pc_3921"},
     {{al, r13, pc, 3079}, false, al, "al r13 pc 3079", "al_r13_pc_3079"},
     {{al, r3, pc, 2359}, false, al, "al r3 pc 2359", "al_r3_pc_2359"},
     {{al, r12, pc, 1357}, false, al, "al r12 pc 1357", "al_r12_pc_1357"},
     {{al, r10, pc, 264}, false, al, "al r10 pc 264", "al_r10_pc_264"},
     {{al, r14, pc, 264}, false, al, "al r14 pc 264", "al_r14_pc_264"},
     {{al, r4, pc, 3688}, false, al, "al r4 pc 3688", "al_r4_pc_3688"},
     {{al, r13, pc, 198}, false, al, "al r13 pc 198", "al_r13_pc_198"},
     {{al, r0, pc, 2451}, false, al, "al r0 pc 2451", "al_r0_pc_2451"},
     {{al, r2, pc, 3633}, false, al, "al r2 pc 3633", "al_r2_pc_3633"},
     {{al, r1, pc, 3633}, false, al, "al r1 pc 3633", "al_r1_pc_3633"},
     {{al, r8, pc, 1567}, false, al, "al r8 pc 1567", "al_r8_pc_1567"},
     {{al, r11, pc, 2582}, false, al, "al r11 pc 2582", "al_r11_pc_2582"},
     {{al, r10, pc, 2650}, false, al, "al r10 pc 2650", "al_r10_pc_2650"},
     {{al, r3, pc, 398}, false, al, "al r3 pc 398", "al_r3_pc_398"},
     {{al, r5, pc, 3266}, false, al, "al r5 pc 3266", "al_r5_pc_3266"},
     {{al, r14, pc, 83}, false, al, "al r14 pc 83", "al_r14_pc_83"},
     {{al, r0, pc, 893}, false, al, "al r0 pc 893", "al_r0_pc_893"},
     {{al, r12, pc, 233}, false, al, "al r12 pc 233", "al_r12_pc_233"},
     {{al, r7, pc, 3771}, false, al, "al r7 pc 3771", "al_r7_pc_3771"},
     {{al, r12, pc, 3504}, false, al, "al r12 pc 3504", "al_r12_pc_3504"},
     {{al, r2, pc, 1390}, false, al, "al r2 pc 1390", "al_r2_pc_1390"},
     {{al, r13, pc, 547}, false, al, "al r13 pc 547", "al_r13_pc_547"},
     {{al, r13, pc, 3728}, false, al, "al r13 pc 3728", "al_r13_pc_3728"},
     {{al, r14, pc, 478}, false, al, "al r14 pc 478", "al_r14_pc_478"},
     {{al, r0, pc, 3139}, false, al, "al r0 pc 3139", "al_r0_pc_3139"},
     {{al, r12, pc, 3239}, false, al, "al r12 pc 3239", "al_r12_pc_3239"},
     {{al, r14, pc, 2359}, false, al, "al r14 pc 2359", "al_r14_pc_2359"},
     {{al, r10, pc, 510}, false, al, "al r10 pc 510", "al_r10_pc_510"},
     {{al, r3, pc, 679}, false, al, "al r3 pc 679", "al_r3_pc_679"},
     {{al, r11, pc, 662}, false, al, "al r11 pc 662", "al_r11_pc_662"},
     {{al, r7, pc, 3481}, false, al, "al r7 pc 3481", "al_r7_pc_3481"},
     {{al, r11, pc, 2254}, false, al, "al r11 pc 2254", "al_r11_pc_2254"},
     {{al, r13, pc, 2627}, false, al, "al r13 pc 2627", "al_r13_pc_2627"},
     {{al, r10, pc, 1872}, false, al, "al r10 pc 1872", "al_r10_pc_1872"},
     {{al, r3, pc, 2091}, false, al, "al r3 pc 2091", "al_r3_pc_2091"},
     {{al, r5, pc, 3986}, false, al, "al r5 pc 3986", "al_r5_pc_3986"},
     {{al, r5, pc, 1168}, false, al, "al r5 pc 1168", "al_r5_pc_1168"},
     {{al, r1, pc, 624}, false, al, "al r1 pc 624", "al_r1_pc_624"},
     {{al, r5, pc, 3397}, false, al, "al r5 pc 3397", "al_r5_pc_3397"},
     {{al, r12, pc, 2345}, false, al, "al r12 pc 2345", "al_r12_pc_2345"},
     {{al, r13, pc, 3566}, false, al, "al r13 pc 3566", "al_r13_pc_3566"},
     {{al, r8, pc, 612}, false, al, "al r8 pc 612", "al_r8_pc_612"},
     {{al, r10, pc, 960}, false, al, "al r10 pc 960", "al_r10_pc_960"},
     {{al, r4, pc, 479}, false, al, "al r4 pc 479", "al_r4_pc_479"},
     {{al, r7, pc, 2290}, false, al, "al r7 pc 2290", "al_r7_pc_2290"},
     {{al, r1, pc, 1835}, false, al, "al r1 pc 1835", "al_r1_pc_1835"},
     {{al, r0, pc, 3625}, false, al, "al r0 pc 3625", "al_r0_pc_3625"},
     {{al, r12, pc, 3397}, false, al, "al r12 pc 3397", "al_r12_pc_3397"},
     {{al, r2, pc, 3638}, false, al, "al r2 pc 3638", "al_r2_pc_3638"},
     {{al, r7, pc, 955}, false, al, "al r7 pc 955", "al_r7_pc_955"},
     {{al, r0, pc, 365}, false, al, "al r0 pc 365", "al_r0_pc_365"},
     {{al, r13, pc, 3028}, false, al, "al r13 pc 3028", "al_r13_pc_3028"},
     {{al, r5, pc, 3608}, false, al, "al r5 pc 3608", "al_r5_pc_3608"},
     {{al, r6, pc, 2864}, false, al, "al r6 pc 2864", "al_r6_pc_2864"},
     {{al, r8, pc, 3139}, false, al, "al r8 pc 3139", "al_r8_pc_3139"},
     {{al, r13, pc, 484}, false, al, "al r13 pc 484", "al_r13_pc_484"},
     {{al, r14, pc, 371}, false, al, "al r14 pc 371", "al_r14_pc_371"},
     {{al, r10, pc, 2535}, false, al, "al r10 pc 2535", "al_r10_pc_2535"},
     {{al, r11, pc, 582}, false, al, "al r11 pc 582", "al_r11_pc_582"},
     {{al, r14, pc, 811}, false, al, "al r14 pc 811", "al_r14_pc_811"},
     {{al, r14, pc, 53}, false, al, "al r14 pc 53", "al_r14_pc_53"},
     {{al, r14, pc, 3572}, false, al, "al r14 pc 3572", "al_r14_pc_3572"},
     {{al, r4, pc, 3771}, false, al, "al r4 pc 3771", "al_r4_pc_3771"},
     {{al, r9, pc, 1066}, false, al, "al r9 pc 1066", "al_r9_pc_1066"},
     {{al, r14, pc, 871}, false, al, "al r14 pc 871", "al_r14_pc_871"},
     {{al, r8, pc, 844}, false, al, "al r8 pc 844", "al_r8_pc_844"},
     {{al, r8, pc, 1377}, false, al, "al r8 pc 1377", "al_r8_pc_1377"},
     {{al, r4, pc, 525}, false, al, "al r4 pc 525", "al_r4_pc_525"},
     {{al, r13, pc, 1017}, false, al, "al r13 pc 1017", "al_r13_pc_1017"},
     {{al, r11, pc, 958}, false, al, "al r11 pc 958", "al_r11_pc_958"},
     {{al, r14, pc, 3491}, false, al, "al r14 pc 3491", "al_r14_pc_3491"},
     {{al, r7, pc, 1261}, false, al, "al r7 pc 1261", "al_r7_pc_1261"},
     {{al, r3, pc, 2710}, false, al, "al r3 pc 2710", "al_r3_pc_2710"},
     {{al, r7, pc, 850}, false, al, "al r7 pc 850", "al_r7_pc_850"},
     {{al, r12, pc, 1274}, false, al, "al r12 pc 1274", "al_r12_pc_1274"},
     {{al, r13, pc, 3397}, false, al, "al r13 pc 3397", "al_r13_pc_3397"},
     {{al, r8, pc, 1981}, false, al, "al r8 pc 1981", "al_r8_pc_1981"},
     {{al, r0, pc, 2374}, false, al, "al r0 pc 2374", "al_r0_pc_2374"},
     {{al, r5, pc, 2490}, false, al, "al r5 pc 2490", "al_r5_pc_2490"},
     {{al, r10, pc, 1934}, false, al, "al r10 pc 1934", "al_r10_pc_1934"},
     {{al, r2, pc, 2507}, false, al, "al r2 pc 2507", "al_r2_pc_2507"},
     {{al, r6, pc, 618}, false, al, "al r6 pc 618", "al_r6_pc_618"},
     {{al, r5, pc, 3109}, false, al, "al r5 pc 3109", "al_r5_pc_3109"},
     {{al, r8, pc, 199}, false, al, "al r8 pc 199", "al_r8_pc_199"},
     {{al, r9, pc, 1687}, false, al, "al r9 pc 1687", "al_r9_pc_1687"},
     {{al, r2, pc, 1759}, false, al, "al r2 pc 1759", "al_r2_pc_1759"},
     {{al, r5, pc, 601}, false, al, "al r5 pc 601", "al_r5_pc_601"},
     {{al, r6, pc, 198}, false, al, "al r6 pc 198", "al_r6_pc_198"},
     {{al, r0, pc, 688}, false, al, "al r0 pc 688", "al_r0_pc_688"},
     {{al, r6, pc, 624}, false, al, "al r6 pc 624", "al_r6_pc_624"},
     {{al, r8, pc, 2963}, false, al, "al r8 pc 2963", "al_r8_pc_2963"},
     {{al, r2, pc, 806}, false, al, "al r2 pc 806", "al_r2_pc_806"},
     {{al, r2, pc, 1999}, false, al, "al r2 pc 1999", "al_r2_pc_1999"},
     {{al, r0, pc, 1485}, false, al, "al r0 pc 1485", "al_r0_pc_1485"},
     {{al, r7, pc, 270}, false, al, "al r7 pc 270", "al_r7_pc_270"},
     {{al, r11, pc, 2427}, false, al, "al r11 pc 2427", "al_r11_pc_2427"},
     {{al, r1, pc, 2011}, false, al, "al r1 pc 2011", "al_r1_pc_2011"},
     {{al, r3, pc, 2797}, false, al, "al r3 pc 2797", "al_r3_pc_2797"},
     {{al, r4, pc, 1234}, false, al, "al r4 pc 1234", "al_r4_pc_1234"},
     {{al, r1, pc, 2617}, false, al, "al r1 pc 2617", "al_r1_pc_2617"},
     {{al, r8, pc, 770}, false, al, "al r8 pc 770", "al_r8_pc_770"},
     {{al, r3, pc, 662}, false, al, "al r3 pc 662", "al_r3_pc_662"},
     {{al, r9, pc, 542}, false, al, "al r9 pc 542", "al_r9_pc_542"},
     {{al, r0, pc, 2395}, false, al, "al r0 pc 2395", "al_r0_pc_2395"},
     {{al, r0, pc, 3384}, false, al, "al r0 pc 3384", "al_r0_pc_3384"},
     {{al, r10, pc, 2345}, false, al, "al r10 pc 2345", "al_r10_pc_2345"},
     {{al, r9, pc, 3986}, false, al, "al r9 pc 3986", "al_r9_pc_3986"},
     {{al, r2, pc, 199}, false, al, "al r2 pc 199", "al_r2_pc_199"},
     {{al, r10, pc, 732}, false, al, "al r10 pc 732", "al_r10_pc_732"},
     {{al, r7, pc, 3633}, false, al, "al r7 pc 3633", "al_r7_pc_3633"},
     {{al, r14, pc, 2976}, false, al, "al r14 pc 2976", "al_r14_pc_2976"},
     {{al, r8, pc, 1390}, false, al, "al r8 pc 1390", "al_r8_pc_1390"},
     {{al, r4, pc, 872}, false, al, "al r4 pc 872", "al_r4_pc_872"},
     {{al, r4, pc, 2813}, false, al, "al r4 pc 2813", "al_r4_pc_2813"},
     {{al, r7, pc, 4}, false, al, "al r7 pc 4", "al_r7_pc_4"},
     {{al, r10, pc, 806}, false, al, "al r10 pc 806", "al_r10_pc_806"},
     {{al, r8, pc, 3714}, false, al, "al r8 pc 3714", "al_r8_pc_3714"},
     {{al, r11, pc, 2546}, false, al, "al r11 pc 2546", "al_r11_pc_2546"},
     {{al, r5, pc, 794}, false, al, "al r5 pc 794", "al_r5_pc_794"},
     {{al, r12, pc, 1359}, false, al, "al r12 pc 1359", "al_r12_pc_1359"},
     {{al, r7, pc, 3728}, false, al, "al r7 pc 3728", "al_r7_pc_3728"},
     {{al, r6, pc, 216}, false, al, "al r6 pc 216", "al_r6_pc_216"},
     {{al, r8, pc, 1732}, false, al, "al r8 pc 1732", "al_r8_pc_1732"},
     {{al, r5, pc, 2796}, false, al, "al r5 pc 2796", "al_r5_pc_2796"},
     {{al, r11, pc, 3548}, false, al, "al r11 pc 3548", "al_r11_pc_3548"},
     {{al, r1, pc, 478}, false, al, "al r1 pc 478", "al_r1_pc_478"},
     {{al, r9, pc, 1896}, false, al, "al r9 pc 1896", "al_r9_pc_1896"},
     {{al, r2, pc, 270}, false, al, "al r2 pc 270", "al_r2_pc_270"},
     {{al, r0, pc, 2619}, false, al, "al r0 pc 2619", "al_r0_pc_2619"},
     {{al, r13, pc, 3802}, false, al, "al r13 pc 3802", "al_r13_pc_3802"},
     {{al, r2, pc, 3254}, false, al, "al r2 pc 3254", "al_r2_pc_3254"},
     {{al, r12, pc, 1066}, false, al, "al r12 pc 1066", "al_r12_pc_1066"},
     {{al, r11, pc, 2323}, false, al, "al r11 pc 2323", "al_r11_pc_2323"},
     {{al, r13, pc, 1274}, false, al, "al r13 pc 1274", "al_r13_pc_1274"},
     {{al, r13, pc, 1948}, false, al, "al r13 pc 1948", "al_r13_pc_1948"},
     {{al, r14, pc, 1472}, false, al, "al r14 pc 1472", "al_r14_pc_1472"},
     {{al, r14, pc, 2703}, false, al, "al r14 pc 2703", "al_r14_pc_2703"},
     {{al, r9, pc, 136}, false, al, "al r9 pc 136", "al_r9_pc_136"},
     {{al, r12, pc, 2475}, false, al, "al r12 pc 2475", "al_r12_pc_2475"},
     {{al, r6, pc, 1295}, false, al, "al r6 pc 1295", "al_r6_pc_1295"},
     {{al, r6, pc, 48}, false, al, "al r6 pc 48", "al_r6_pc_48"},
     {{al, r12, pc, 1348}, false, al, "al r12 pc 1348", "al_r12_pc_1348"},
     {{al, r10, pc, 3856}, false, al, "al r10 pc 3856", "al_r10_pc_3856"},
     {{al, r6, pc, 2281}, false, al, "al r6 pc 2281", "al_r6_pc_2281"},
     {{al, r13, pc, 1377}, false, al, "al r13 pc 1377", "al_r13_pc_1377"},
     {{al, r0, pc, 3774}, false, al, "al r0 pc 3774", "al_r0_pc_3774"},
     {{al, r5, pc, 828}, false, al, "al r5 pc 828", "al_r5_pc_828"},
     {{al, r14, pc, 3907}, false, al, "al r14 pc 3907", "al_r14_pc_3907"},
     {{al, r2, pc, 960}, false, al, "al r2 pc 960", "al_r2_pc_960"},
     {{al, r7, pc, 2728}, false, al, "al r7 pc 2728", "al_r7_pc_2728"},
     {{al, r8, pc, 2359}, false, al, "al r8 pc 2359", "al_r8_pc_2359"},
     {{al, r5, pc, 3544}, false, al, "al r5 pc 3544", "al_r5_pc_3544"},
     {{al, r14, pc, 3663}, false, al, "al r14 pc 3663", "al_r14_pc_3663"},
     {{al, r3, pc, 678}, false, al, "al r3 pc 678", "al_r3_pc_678"},
     {{al, r6, pc, 2395}, false, al, "al r6 pc 2395", "al_r6_pc_2395"},
     {{al, r2, pc, 1845}, false, al, "al r2 pc 1845", "al_r2_pc_1845"},
     {{al, r14, pc, 1635}, false, al, "al r14 pc 1635", "al_r14_pc_1635"},
     {{al, r6, pc, 3652}, false, al, "al r6 pc 3652", "al_r6_pc_3652"},
     {{al, r14, pc, 213}, false, al, "al r14 pc 213", "al_r14_pc_213"},
     {{al, r0, pc, 2281}, false, al, "al r0 pc 2281", "al_r0_pc_2281"},
     {{al, r11, pc, 19}, false, al, "al r11 pc 19", "al_r11_pc_19"},
     {{al, r0, pc, 2119}, false, al, "al r0 pc 2119", "al_r0_pc_2119"},
     {{al, r1, pc, 53}, false, al, "al r1 pc 53", "al_r1_pc_53"},
     {{al, r10, pc, 2490}, false, al, "al r10 pc 2490", "al_r10_pc_2490"},
     {{al, r12, pc, 2591}, false, al, "al r12 pc 2591", "al_r12_pc_2591"},
     {{al, r1, pc, 2358}, false, al, "al r1 pc 2358", "al_r1_pc_2358"},
     {{al, r10, pc, 342}, false, al, "al r10 pc 342", "al_r10_pc_342"},
     {{al, r14, pc, 601}, false, al, "al r14 pc 601", "al_r14_pc_601"},
     {{al, r9, pc, 55}, false, al, "al r9 pc 55", "al_r9_pc_55"},
     {{al, r6, pc, 2139}, false, al, "al r6 pc 2139", "al_r6_pc_2139"},
     {{al, r1, pc, 517}, false, al, "al r1 pc 517", "al_r1_pc_517"},
     {{al, r1, pc, 3986}, false, al, "al r1 pc 3986", "al_r1_pc_3986"},
     {{al, r3, pc, 4076}, false, al, "al r3 pc 4076", "al_r3_pc_4076"},
     {{al, r0, pc, 2662}, false, al, "al r0 pc 2662", "al_r0_pc_2662"},
     {{al, r14, pc, 1652}, false, al, "al r14 pc 1652", "al_r14_pc_1652"},
     {{al, r3, pc, 964}, false, al, "al r3 pc 964", "al_r3_pc_964"},
     {{al, r3, pc, 1961}, false, al, "al r3 pc 1961", "al_r3_pc_1961"},
     {{al, r9, pc, 3871}, false, al, "al r9 pc 3871", "al_r9_pc_3871"},
     {{al, r6, pc, 496}, false, al, "al r6 pc 496", "al_r6_pc_496"},
     {{al, r11, pc, 3821}, false, al, "al r11 pc 3821", "al_r11_pc_3821"},
     {{al, r9, pc, 2483}, false, al, "al r9 pc 2483", "al_r9_pc_2483"},
     {{al, r4, pc, 3209}, false, al, "al r4 pc 3209", "al_r4_pc_3209"},
     {{al, r13, pc, 2}, false, al, "al r13 pc 2", "al_r13_pc_2"},
     {{al, r14, pc, 2796}, false, al, "al r14 pc 2796", "al_r14_pc_2796"},
     {{al, r13, pc, 1652}, false, al, "al r13 pc 1652", "al_r13_pc_1652"},
     {{al, r2, pc, 4091}, false, al, "al r2 pc 4091", "al_r2_pc_4091"},
     {{al, r14, pc, 132}, false, al, "al r14 pc 132", "al_r14_pc_132"},
     {{al, r3, pc, 1872}, false, al, "al r3 pc 1872", "al_r3_pc_1872"},
     {{al, r14, pc, 4058}, false, al, "al r14 pc 4058", "al_r14_pc_4058"},
     {{al, r3, pc, 1099}, false, al, "al r3 pc 1099", "al_r3_pc_1099"},
     {{al, r1, pc, 3195}, false, al, "al r1 pc 3195", "al_r1_pc_3195"},
     {{al, r0, pc, 19}, false, al, "al r0 pc 19", "al_r0_pc_19"},
     {{al, r14, pc, 1981}, false, al, "al r14 pc 1981", "al_r14_pc_1981"},
     {{al, r3, pc, 3162}, false, al, "al r3 pc 3162", "al_r3_pc_3162"},
     {{al, r4, pc, 678}, false, al, "al r4 pc 678", "al_r4_pc_678"},
     {{al, r8, pc, 1967}, false, al, "al r8 pc 1967", "al_r8_pc_1967"},
     {{al, r0, pc, 1274}, false, al, "al r0 pc 1274", "al_r0_pc_1274"},
     {{al, r10, pc, 1407}, false, al, "al r10 pc 1407", "al_r10_pc_1407"},
     {{al, r6, pc, 2946}, false, al, "al r6 pc 2946", "al_r6_pc_2946"},
     {{al, r13, pc, 47}, false, al, "al r13 pc 47", "al_r13_pc_47"},
     {{al, r4, pc, 612}, false, al, "al r4 pc 612", "al_r4_pc_612"},
     {{al, r0, pc, 2247}, false, al, "al r0 pc 2247", "al_r0_pc_2247"},
     {{al, r4, pc, 365}, false, al, "al r4 pc 365", "al_r4_pc_365"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-pc-operand-imm12-add-t32.h"
#include "aarch32/traces/assembler-cond-rd-pc-operand-imm12-addw-t32.h"
#include "aarch32/traces/assembler-cond-rd-pc-operand-imm12-sub-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                         \
  void Test_##mnemonic() {                                                     \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);    \
  }                                                                            \
  Test test_##mnemonic("AARCH32_ASSEMBLER_COND_RD_PC_OPERAND_IMM12_" #mnemonic \
                       "_T32",                                                 \
                       &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
