% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_line_endings.R
\name{file_line_endings}
\alias{file_line_endings}
\title{Retrieve the type of line endings used by a file}
\usage{
file_line_endings(path)
}
\arguments{
\item{path}{A character string of the path to the file to read.}
}
\value{
The line endings used, one of
\itemize{
\item '\\n' - if the file uses Unix line endings
\item '\\r\\n' - if the file uses Windows line endings
\item NA - if it cannot be determined
}
}
\description{
Retrieve the type of line endings used by a file
}
\examples{
tf1 <- tempfile()
tf2 <- tempfile()
write_lines("foo", tf1, eol = "\n")
write_lines("bar", tf2, eol = "\r\n")

file_line_endings(tf1)
file_line_endings(tf2)

unlink(c(tf1, tf2))
}
