.TH MH-MAIL %manext5% 2014-01-08 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
mh-mail \- message format for nmh message system
.SH DESCRIPTION
.B nmh
processes messages in a particular format.  It should be noted
that although neither Bell nor Berkeley mailers produce message files
in the format that
.B nmh
prefers,
.B nmh
can read message files in that format.
.PP
Each user possesses a mail drop which initially receives all messages
processed by
.BR post .
.B inc
will read from that mail drop and incorporate new messages found there
into the user's own mail folders (typically
.RI \*(lq +inbox \*(rq).
The mail drop consists of one or more messages.
.PP
Messages are expected to consist of lines of text.  Graphics and binary
data are not handled.  No data compression is accepted.  All text is
clear ASCII 7-bit data.
.PP
The general \*(lqmemo\*(rq framework of RFC 822 is used.  A message
consists of a block of information in a rigid format, followed by
general text with no specified format.  The rigidly formatted first
part of a message is called the header, and the free-format portion is
called the body.  The header must always exist, but the body is optional.
These parts are separated by an empty line, i.e., two consecutive newline
characters.  Within
.BR nmh ,
the header and body may be separated by a line consisting of dashes:
.PP
.RS 5
.nf
From: Local Mailbox <user@example.com>
To:
cc:
Fcc: +outbox
Subject:
.fi
.RE
.PP
The header is composed of one or more header items.  Each header item can
be viewed as a single logical line of ASCII characters.  If the text of
a header item extends across several real lines, the continuation lines
are indicated by leading spaces or tabs.
.PP
Each header item is called a component and is composed of a keyword or
name, along with associated text.  The keyword begins at the left margin,
may
.I not
contain spaces or tabs, may not exceed 63 characters (as specified
by RFC 822), and is terminated by a colon (`:').  Certain components
(as identified by their keywords) must follow rigidly defined formats
in their text portions.
.PP
The text for most formatted components (e.g., \*(lqDate:\*(rq and
\*(lqMessage\-Id:\*(rq) is produced automatically.  The only ones entered
by the user are address fields such as \*(lqTo:\*(rq, \*(lqcc:\*(rq,
etc.  Internet addresses are assigned mailbox names and host computer
specifications.  The rough format is \*(lqlocal@domain\*(rq, such as
\*(lqMH@UCI\*(rq, or \*(lqMH@UCI\-ICSA.ARPA\*(rq.  Multiple addresses
are separated by commas.  A missing host/domain is assumed to be the
local host/domain.
.PP
As mentioned above, a blank line (or a line of dashes) signals that all
following text up to the end of the file is the body.  No formatting is
expected or enforced within the body.
.PP
Following is a list of header components that are considered
meaningful to various
.B nmh
programs.
.PP
.BR Date :
.RS 5
Added by
.BR post ,
contains date and time of the message's entry into the mail transport system.
.RE
.PP
.BR From :
.RS 5
This header is filled in by default with the system's idea of the user's local
mailbox.  This can be changed with the
.B Local\-Mailbox
profile entry.
It contains the address of the author or authors (may be more than one if a
\*(lqSender:\*(rq field is present).  For a standard reply (using
.BR repl ),
the reply address is constructed by checking the following headers (in this
order): \*(lqMail-Reply\-To:\*(rq, \*(lqReply\-To:\*(rq, \*(lqFrom:\*(rq,
\*(lqSender:\*(rq.  A \*(lqFrom:\*(rq header MUST exist when the message is
sent to
.BR post ,
otherwise the message will be rejected.
.RE
.PP
.BR Envelope\-From :
.RS 5
Used by
.B post
to specify a value for the sender's envelope address to the mail transport
system.  If omitted,
.B post
will use the value of the \*(lqSender:\*(rq or the \*(lqFrom:\*(rq header.
See
.IR send (1)
for more details.
.RE
.PP
.BR Mail\-Reply\-To :
.RS 5
For a standard reply (using
.BR repl ),
the reply address is constructed by checking the following headers
(in this order): \*(lqMail-Reply\-To:\*(rq, \*(lqReply\-To:\*(rq,
\*(lqFrom:\*(rq, \*(lqSender:\*(rq.
.RE
.PP
.BR Mail\-Followup\-To :
.RS 5
When making a \*(lqgroup\*(rq reply (using
.B repl
.BR \-group ),
any addresses in this field will take precedence, and no other reply address
will be added to the draft.  If this header is not available, then the
return addresses will be constructed from the \*(lqMail-Reply\-To:\*(rq,
or \*(lqReply\-To:\*(rq, or \*(lqFrom:\*(rq, along with adding the
addresses from the headers \*(lqTo:\*(rq, \*(lqcc:\*(rq, as well as
adding your personal address.
.RE
.PP
.BR Reply\-To :
.RS 5
For a standard reply (using
.BR repl ),
the reply address is
constructed by checking the following headers (in this order):
\*(lqMail-Reply\-To:\*(rq, \*(lqReply\-To:\*(rq, \*(lqFrom:\*(rq,
\*(lqSender:\*(rq.
.RE
.PP
.BR Sender :
.RS 5
Required by
.B post
in the event that the message has multiple addresses on the
\*(lqFrom:\*(rq line.  It is otherwise optional.  This line should
contain the address of the actual sender.
.RE
.PP
.BR To :
.RS 5
Contains addresses of primary recipients.
.RE
.PP
.BR cc :
.RS 5
Contains addresses of secondary recipients.
.RE
.PP
.BR Bcc :
.RS 5
Still more recipients.  However, the \*(lqBcc:\*(rq line is not
copied onto the message as delivered, so these recipients are not
listed.
.B nmh
uses an encapsulation method for blind copies, see
.IR send (1).
.RE
.PP
.BR Dcc :
.RS 5
Still more recipients.  However, the \*(lqDcc:\*(rq line is not
copied onto the messages as delivered.  Recipients on the \*(lqDcc:\*(rq
line receive the same message as recipients on the \*(lqTo:\*(rq and
\*(lqcc:\*(rq lines.  See
.IR send (1)
for more details.
.B Dcc
is not supported with the
.B sendmail/pipe
mail transport method.
.RE
.PP
.BR Fcc :
.RS 5
Causes
.B post
to copy the message into the specified folder for the sender,
if the message was successfully given to the transport system.
.RE
.PP
.BR Message\-ID :
.RS 5
A unique message identifier added by
.B post
if the
.B \-msgid
flag is set.
.RE
.PP
.BR Subject :
.RS 5
Sender's commentary.  It is displayed by
.BR scan .
.RE
.PP
.BR In\-Reply\-To :
.RS 5
A commentary line added by
.B repl
when replying to a message.
.RE
.PP
.BR Resent\-Date :
.RS 5
Added when redistributing a message by
.BR post .
.RE
.PP
.BR Resent\-From :
.RS 5
Used instead of the \*(lqFrom:\*(rq header when
.B post
redistributes a message.  See \*(lqFrom:\*(rq.
.RE
.PP
.BR Resent\-To :
.RS 5
New recipients for a message resent by
.BR dist .
.RE
.PP
.BR Resent\-cc :
.RS 5
Still more recipients.  See \*(lqcc:\*(rq and \*(lqResent\-To:\*(rq.
.RE
.PP
.BR Resent\-Bcc :
.RS 5
Even more recipients.  See \*(lqBcc:\*(rq and \*(lqResent\-To:\*(rq.
.RE
.PP
.BR Resent\-Fcc :
.RS 5
Copy resent message into a folder.
See \*(lqFcc:\*(rq and \*(lqResent\-To:\*(rq.
.RE
.PP
.BR Resent\-Message\-Id :
.RS 5
A unique identifier glued on by
.B post
if the
.B \-msgid
flag is set.
See \*(lqMessage\-Id:\*(rq and \*(lqResent\-To:\*(rq.
.RE
.PP
.BR Resent :
.RS 5
Annotation for
.B dist
under the
.B \-annotate
option.
.RE
.PP
.BR Forwarded :
.RS 5
Annotation for
.B forw
under the
.B \-annotate
option.
.RE
.PP
.BR Replied :
.RS 5
Annotation for
.B repl
under the
.B \-annotate
option.
.RE
.PP
.BR Attach :
.RS 5
Used by
.B mhbuild
to specify a filename to attach to this message.  See
.IR mhbuild (1)
for more information.
.RE
.SH FILES
.TP 20
%mailspool%/$USER
Location of mail drop.
.SH "SEE ALSO"
.I
Standard for the Format of ARPA Internet Text Messages
(RFC 822)
.SH CONTEXT
None
