
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsGridLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsGridLayout>
#include <QEvent>
#include <QGraphicsItem>
#include <QGraphicsLayoutItem>
#include <QRectF>
#include <QSizeF>
#include <QSizePolicy>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsGridLayout

// void QGraphicsGridLayout::addItem(QGraphicsLayoutItem *item, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_addItem_7835 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rowSpan");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("columnSpan");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alignment", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_addItem_7835 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg6 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->addItem (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QGraphicsGridLayout::addItem(QGraphicsLayoutItem *item, int row, int column, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_addItem_6517 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("alignment", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addItem_6517 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->addItem (arg1, arg2, arg3, arg4);
}


// QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::alignment(QGraphicsLayoutItem *item)


static void _init_f_alignment_c2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QGraphicsGridLayout *)cls)->alignment (arg1));
}


// QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::columnAlignment(int column)


static void _init_f_columnAlignment_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_columnAlignment_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QGraphicsGridLayout *)cls)->columnAlignment (arg1));
}


// int QGraphicsGridLayout::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsGridLayout *)cls)->columnCount ());
}


// double QGraphicsGridLayout::columnMaximumWidth(int column)


static void _init_f_columnMaximumWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_columnMaximumWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->columnMaximumWidth (arg1));
}


// double QGraphicsGridLayout::columnMinimumWidth(int column)


static void _init_f_columnMinimumWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_columnMinimumWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->columnMinimumWidth (arg1));
}


// double QGraphicsGridLayout::columnPreferredWidth(int column)


static void _init_f_columnPreferredWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_columnPreferredWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->columnPreferredWidth (arg1));
}


// double QGraphicsGridLayout::columnSpacing(int column)


static void _init_f_columnSpacing_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_columnSpacing_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->columnSpacing (arg1));
}


// int QGraphicsGridLayout::columnStretchFactor(int column)


static void _init_f_columnStretchFactor_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnStretchFactor_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGraphicsGridLayout *)cls)->columnStretchFactor (arg1));
}


// int QGraphicsGridLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsGridLayout *)cls)->count ());
}


// double QGraphicsGridLayout::horizontalSpacing()


static void _init_f_horizontalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_horizontalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->horizontalSpacing ());
}


// void QGraphicsGridLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->invalidate ();
}


// QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int row, int column)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsGridLayout *)cls)->itemAt (arg1, arg2));
}


// QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int index)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsGridLayout *)cls)->itemAt (arg1));
}


// void QGraphicsGridLayout::removeAt(int index)


static void _init_f_removeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAt_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->removeAt (arg1);
}


// void QGraphicsGridLayout::removeItem(QGraphicsLayoutItem *item)


static void _init_f_removeItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->removeItem (arg1);
}


// QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::rowAlignment(int row)


static void _init_f_rowAlignment_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_rowAlignment_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QGraphicsGridLayout *)cls)->rowAlignment (arg1));
}


// int QGraphicsGridLayout::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsGridLayout *)cls)->rowCount ());
}


// double QGraphicsGridLayout::rowMaximumHeight(int row)


static void _init_f_rowMaximumHeight_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rowMaximumHeight_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->rowMaximumHeight (arg1));
}


// double QGraphicsGridLayout::rowMinimumHeight(int row)


static void _init_f_rowMinimumHeight_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rowMinimumHeight_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->rowMinimumHeight (arg1));
}


// double QGraphicsGridLayout::rowPreferredHeight(int row)


static void _init_f_rowPreferredHeight_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rowPreferredHeight_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->rowPreferredHeight (arg1));
}


// double QGraphicsGridLayout::rowSpacing(int row)


static void _init_f_rowSpacing_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rowSpacing_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->rowSpacing (arg1));
}


// int QGraphicsGridLayout::rowStretchFactor(int row)


static void _init_f_rowStretchFactor_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowStretchFactor_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGraphicsGridLayout *)cls)->rowStretchFactor (arg1));
}


// void QGraphicsGridLayout::setAlignment(QGraphicsLayoutItem *item, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_5199 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_5199 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setAlignment (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnAlignment(int column, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setColumnAlignment_3409 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnAlignment_3409 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnAlignment (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnFixedWidth(int column, double width)


static void _init_f_setColumnFixedWidth_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnFixedWidth_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnFixedWidth (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnMaximumWidth(int column, double width)


static void _init_f_setColumnMaximumWidth_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnMaximumWidth_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnMaximumWidth (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnMinimumWidth(int column, double width)


static void _init_f_setColumnMinimumWidth_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnMinimumWidth_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnMinimumWidth (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnPreferredWidth(int column, double width)


static void _init_f_setColumnPreferredWidth_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnPreferredWidth_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnPreferredWidth (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnSpacing(int column, double spacing)


static void _init_f_setColumnSpacing_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacing");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnSpacing_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnSpacing (arg1, arg2);
}


// void QGraphicsGridLayout::setColumnStretchFactor(int column, int stretch)


static void _init_f_setColumnStretchFactor_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnStretchFactor_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setColumnStretchFactor (arg1, arg2);
}


// void QGraphicsGridLayout::setGeometry(const QRectF &rect)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setGeometry (arg1);
}


// void QGraphicsGridLayout::setHorizontalSpacing(double spacing)


static void _init_f_setHorizontalSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setHorizontalSpacing (arg1);
}


// void QGraphicsGridLayout::setRowAlignment(int row, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setRowAlignment_3409 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowAlignment_3409 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowAlignment (arg1, arg2);
}


// void QGraphicsGridLayout::setRowFixedHeight(int row, double height)


static void _init_f_setRowFixedHeight_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowFixedHeight_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowFixedHeight (arg1, arg2);
}


// void QGraphicsGridLayout::setRowMaximumHeight(int row, double height)


static void _init_f_setRowMaximumHeight_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowMaximumHeight_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowMaximumHeight (arg1, arg2);
}


// void QGraphicsGridLayout::setRowMinimumHeight(int row, double height)


static void _init_f_setRowMinimumHeight_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowMinimumHeight_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowMinimumHeight (arg1, arg2);
}


// void QGraphicsGridLayout::setRowPreferredHeight(int row, double height)


static void _init_f_setRowPreferredHeight_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowPreferredHeight_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowPreferredHeight (arg1, arg2);
}


// void QGraphicsGridLayout::setRowSpacing(int row, double spacing)


static void _init_f_setRowSpacing_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacing");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowSpacing_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowSpacing (arg1, arg2);
}


// void QGraphicsGridLayout::setRowStretchFactor(int row, int stretch)


static void _init_f_setRowStretchFactor_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowStretchFactor_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setRowStretchFactor (arg1, arg2);
}


// void QGraphicsGridLayout::setSpacing(double spacing)


static void _init_f_setSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setSpacing (arg1);
}


// void QGraphicsGridLayout::setVerticalSpacing(double spacing)


static void _init_f_setVerticalSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout *)cls)->setVerticalSpacing (arg1);
}


// QSizeF QGraphicsGridLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)


static void _init_f_sizeHint_c3330 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint", true, "QSizeF()");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_f_sizeHint_c3330 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::SizeHint>::target_type & >() (args, heap);
  const QSizeF &arg2 = args ? gsi::arg_reader<const QSizeF & >() (args, heap) : gsi::arg_maker<const QSizeF & >() (QSizeF(), heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsGridLayout *)cls)->sizeHint (qt_gsi::QtToCppAdaptor<Qt::SizeHint>(arg1).cref(), arg2));
}


// double QGraphicsGridLayout::verticalSpacing()


static void _init_f_verticalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_verticalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsGridLayout *)cls)->verticalSpacing ());
}


namespace gsi
{

static gsi::Methods methods_QGraphicsGridLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QGraphicsGridLayout::addItem(QGraphicsLayoutItem *item, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_addItem_7835, &_call_f_addItem_7835);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QGraphicsGridLayout::addItem(QGraphicsLayoutItem *item, int row, int column, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_addItem_6517, &_call_f_addItem_6517);
  methods += new qt_gsi::GenericMethod ("alignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::alignment(QGraphicsLayoutItem *item)\n", true, &_init_f_alignment_c2557, &_call_f_alignment_c2557);
  methods += new qt_gsi::GenericMethod ("columnAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::columnAlignment(int column)\n", true, &_init_f_columnAlignment_c767, &_call_f_columnAlignment_c767);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QGraphicsGridLayout::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
  methods += new qt_gsi::GenericMethod ("columnMaximumWidth", "@brief Method double QGraphicsGridLayout::columnMaximumWidth(int column)\n", true, &_init_f_columnMaximumWidth_c767, &_call_f_columnMaximumWidth_c767);
  methods += new qt_gsi::GenericMethod ("columnMinimumWidth", "@brief Method double QGraphicsGridLayout::columnMinimumWidth(int column)\n", true, &_init_f_columnMinimumWidth_c767, &_call_f_columnMinimumWidth_c767);
  methods += new qt_gsi::GenericMethod ("columnPreferredWidth", "@brief Method double QGraphicsGridLayout::columnPreferredWidth(int column)\n", true, &_init_f_columnPreferredWidth_c767, &_call_f_columnPreferredWidth_c767);
  methods += new qt_gsi::GenericMethod ("columnSpacing", "@brief Method double QGraphicsGridLayout::columnSpacing(int column)\n", true, &_init_f_columnSpacing_c767, &_call_f_columnSpacing_c767);
  methods += new qt_gsi::GenericMethod ("columnStretchFactor", "@brief Method int QGraphicsGridLayout::columnStretchFactor(int column)\n", true, &_init_f_columnStretchFactor_c767, &_call_f_columnStretchFactor_c767);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method int QGraphicsGridLayout::count()\nThis is a reimplementation of QGraphicsLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod (":horizontalSpacing", "@brief Method double QGraphicsGridLayout::horizontalSpacing()\n", true, &_init_f_horizontalSpacing_c0, &_call_f_horizontalSpacing_c0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGraphicsGridLayout::invalidate()\nThis is a reimplementation of QGraphicsLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int row, int column)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int index)\nThis is a reimplementation of QGraphicsLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
  methods += new qt_gsi::GenericMethod ("removeAt", "@brief Method void QGraphicsGridLayout::removeAt(int index)\nThis is a reimplementation of QGraphicsLayout::removeAt", false, &_init_f_removeAt_767, &_call_f_removeAt_767);
  methods += new qt_gsi::GenericMethod ("removeItem", "@brief Method void QGraphicsGridLayout::removeItem(QGraphicsLayoutItem *item)\n", false, &_init_f_removeItem_2557, &_call_f_removeItem_2557);
  methods += new qt_gsi::GenericMethod ("rowAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsGridLayout::rowAlignment(int row)\n", true, &_init_f_rowAlignment_c767, &_call_f_rowAlignment_c767);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QGraphicsGridLayout::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod ("rowMaximumHeight", "@brief Method double QGraphicsGridLayout::rowMaximumHeight(int row)\n", true, &_init_f_rowMaximumHeight_c767, &_call_f_rowMaximumHeight_c767);
  methods += new qt_gsi::GenericMethod ("rowMinimumHeight", "@brief Method double QGraphicsGridLayout::rowMinimumHeight(int row)\n", true, &_init_f_rowMinimumHeight_c767, &_call_f_rowMinimumHeight_c767);
  methods += new qt_gsi::GenericMethod ("rowPreferredHeight", "@brief Method double QGraphicsGridLayout::rowPreferredHeight(int row)\n", true, &_init_f_rowPreferredHeight_c767, &_call_f_rowPreferredHeight_c767);
  methods += new qt_gsi::GenericMethod ("rowSpacing", "@brief Method double QGraphicsGridLayout::rowSpacing(int row)\n", true, &_init_f_rowSpacing_c767, &_call_f_rowSpacing_c767);
  methods += new qt_gsi::GenericMethod ("rowStretchFactor", "@brief Method int QGraphicsGridLayout::rowStretchFactor(int row)\n", true, &_init_f_rowStretchFactor_c767, &_call_f_rowStretchFactor_c767);
  methods += new qt_gsi::GenericMethod ("setAlignment", "@brief Method void QGraphicsGridLayout::setAlignment(QGraphicsLayoutItem *item, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_5199, &_call_f_setAlignment_5199);
  methods += new qt_gsi::GenericMethod ("setColumnAlignment", "@brief Method void QGraphicsGridLayout::setColumnAlignment(int column, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setColumnAlignment_3409, &_call_f_setColumnAlignment_3409);
  methods += new qt_gsi::GenericMethod ("setColumnFixedWidth", "@brief Method void QGraphicsGridLayout::setColumnFixedWidth(int column, double width)\n", false, &_init_f_setColumnFixedWidth_1730, &_call_f_setColumnFixedWidth_1730);
  methods += new qt_gsi::GenericMethod ("setColumnMaximumWidth", "@brief Method void QGraphicsGridLayout::setColumnMaximumWidth(int column, double width)\n", false, &_init_f_setColumnMaximumWidth_1730, &_call_f_setColumnMaximumWidth_1730);
  methods += new qt_gsi::GenericMethod ("setColumnMinimumWidth", "@brief Method void QGraphicsGridLayout::setColumnMinimumWidth(int column, double width)\n", false, &_init_f_setColumnMinimumWidth_1730, &_call_f_setColumnMinimumWidth_1730);
  methods += new qt_gsi::GenericMethod ("setColumnPreferredWidth", "@brief Method void QGraphicsGridLayout::setColumnPreferredWidth(int column, double width)\n", false, &_init_f_setColumnPreferredWidth_1730, &_call_f_setColumnPreferredWidth_1730);
  methods += new qt_gsi::GenericMethod ("setColumnSpacing", "@brief Method void QGraphicsGridLayout::setColumnSpacing(int column, double spacing)\n", false, &_init_f_setColumnSpacing_1730, &_call_f_setColumnSpacing_1730);
  methods += new qt_gsi::GenericMethod ("setColumnStretchFactor", "@brief Method void QGraphicsGridLayout::setColumnStretchFactor(int column, int stretch)\n", false, &_init_f_setColumnStretchFactor_1426, &_call_f_setColumnStretchFactor_1426);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QGraphicsGridLayout::setGeometry(const QRectF &rect)\nThis is a reimplementation of QGraphicsLayoutItem::setGeometry", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
  methods += new qt_gsi::GenericMethod ("setHorizontalSpacing|horizontalSpacing=", "@brief Method void QGraphicsGridLayout::setHorizontalSpacing(double spacing)\n", false, &_init_f_setHorizontalSpacing_1071, &_call_f_setHorizontalSpacing_1071);
  methods += new qt_gsi::GenericMethod ("setRowAlignment", "@brief Method void QGraphicsGridLayout::setRowAlignment(int row, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setRowAlignment_3409, &_call_f_setRowAlignment_3409);
  methods += new qt_gsi::GenericMethod ("setRowFixedHeight", "@brief Method void QGraphicsGridLayout::setRowFixedHeight(int row, double height)\n", false, &_init_f_setRowFixedHeight_1730, &_call_f_setRowFixedHeight_1730);
  methods += new qt_gsi::GenericMethod ("setRowMaximumHeight", "@brief Method void QGraphicsGridLayout::setRowMaximumHeight(int row, double height)\n", false, &_init_f_setRowMaximumHeight_1730, &_call_f_setRowMaximumHeight_1730);
  methods += new qt_gsi::GenericMethod ("setRowMinimumHeight", "@brief Method void QGraphicsGridLayout::setRowMinimumHeight(int row, double height)\n", false, &_init_f_setRowMinimumHeight_1730, &_call_f_setRowMinimumHeight_1730);
  methods += new qt_gsi::GenericMethod ("setRowPreferredHeight", "@brief Method void QGraphicsGridLayout::setRowPreferredHeight(int row, double height)\n", false, &_init_f_setRowPreferredHeight_1730, &_call_f_setRowPreferredHeight_1730);
  methods += new qt_gsi::GenericMethod ("setRowSpacing", "@brief Method void QGraphicsGridLayout::setRowSpacing(int row, double spacing)\n", false, &_init_f_setRowSpacing_1730, &_call_f_setRowSpacing_1730);
  methods += new qt_gsi::GenericMethod ("setRowStretchFactor", "@brief Method void QGraphicsGridLayout::setRowStretchFactor(int row, int stretch)\n", false, &_init_f_setRowStretchFactor_1426, &_call_f_setRowStretchFactor_1426);
  methods += new qt_gsi::GenericMethod ("setSpacing", "@brief Method void QGraphicsGridLayout::setSpacing(double spacing)\n", false, &_init_f_setSpacing_1071, &_call_f_setSpacing_1071);
  methods += new qt_gsi::GenericMethod ("setVerticalSpacing|verticalSpacing=", "@brief Method void QGraphicsGridLayout::setVerticalSpacing(double spacing)\n", false, &_init_f_setVerticalSpacing_1071, &_call_f_setVerticalSpacing_1071);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSizeF QGraphicsGridLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis is a reimplementation of QGraphicsLayoutItem::sizeHint", true, &_init_f_sizeHint_c3330, &_call_f_sizeHint_c3330);
  methods += new qt_gsi::GenericMethod (":verticalSpacing", "@brief Method double QGraphicsGridLayout::verticalSpacing()\n", true, &_init_f_verticalSpacing_c0, &_call_f_verticalSpacing_c0);
  return methods;
}

gsi::Class<QGraphicsLayout> &qtdecl_QGraphicsLayout ();

gsi::Class<QGraphicsGridLayout> decl_QGraphicsGridLayout (qtdecl_QGraphicsLayout (), "QtWidgets", "QGraphicsGridLayout_Native",
  methods_QGraphicsGridLayout (),
  "@hide\n@alias QGraphicsGridLayout");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsGridLayout> &qtdecl_QGraphicsGridLayout () { return decl_QGraphicsGridLayout; }

}


class QGraphicsGridLayout_Adaptor : public QGraphicsGridLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsGridLayout_Adaptor();

  //  [adaptor ctor] QGraphicsGridLayout::QGraphicsGridLayout(QGraphicsLayoutItem *parent)
  QGraphicsGridLayout_Adaptor() : QGraphicsGridLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsGridLayout::QGraphicsGridLayout(QGraphicsLayoutItem *parent)
  QGraphicsGridLayout_Adaptor(QGraphicsLayoutItem *parent) : QGraphicsGridLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsGridLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)
  void fp_QGraphicsGridLayout_addChildLayoutItem_2557 (QGraphicsLayoutItem *layoutItem) {
    QGraphicsGridLayout::addChildLayoutItem(layoutItem);
  }

  //  [expose] void QGraphicsGridLayout::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsGridLayout_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsGridLayout::setGraphicsItem(item);
  }

  //  [expose] void QGraphicsGridLayout::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsGridLayout_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsGridLayout::setOwnedByLayout(ownedByLayout);
  }

  //  [adaptor impl] int QGraphicsGridLayout::count()
  int cbs_count_c0_0() const
  {
    return QGraphicsGridLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QGraphicsGridLayout_Adaptor, int>(&QGraphicsGridLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QGraphicsGridLayout::count();
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsGridLayout::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsGridLayout_Adaptor, double *, double *, double *, double *>(&QGraphicsGridLayout_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsGridLayout::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QGraphicsGridLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QGraphicsGridLayout_Adaptor>(&QGraphicsGridLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QGraphicsGridLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QGraphicsGridLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QGraphicsGridLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QGraphicsGridLayout_Adaptor, bool>(&QGraphicsGridLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QGraphicsGridLayout::isEmpty();
    }
  }

  //  [adaptor impl] QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int index)
  QGraphicsLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    return QGraphicsGridLayout::itemAt(index);
  }

  virtual QGraphicsLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QGraphicsGridLayout_Adaptor, QGraphicsLayoutItem *, int>(&QGraphicsGridLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      return QGraphicsGridLayout::itemAt(index);
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::removeAt(int index)
  void cbs_removeAt_767_0(int index)
  {
    QGraphicsGridLayout::removeAt(index);
  }

  virtual void removeAt(int index)
  {
    if (cb_removeAt_767_0.can_issue()) {
      cb_removeAt_767_0.issue<QGraphicsGridLayout_Adaptor, int>(&QGraphicsGridLayout_Adaptor::cbs_removeAt_767_0, index);
    } else {
      QGraphicsGridLayout::removeAt(index);
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsGridLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsGridLayout_Adaptor, const QRectF &>(&QGraphicsGridLayout_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsGridLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] QSizeF QGraphicsGridLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    return QGraphicsGridLayout::sizeHint(qt_gsi::QtToCppAdaptor<Qt::SizeHint>(which).cref(), constraint);
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsGridLayout_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsGridLayout_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      return QGraphicsGridLayout::sizeHint(which, constraint);
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsGridLayout::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsGridLayout_Adaptor>(&QGraphicsGridLayout_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsGridLayout::updateGeometry();
    }
  }

  //  [adaptor impl] void QGraphicsGridLayout::widgetEvent(QEvent *e)
  void cbs_widgetEvent_1217_0(QEvent *e)
  {
    QGraphicsGridLayout::widgetEvent(e);
  }

  virtual void widgetEvent(QEvent *e)
  {
    if (cb_widgetEvent_1217_0.can_issue()) {
      cb_widgetEvent_1217_0.issue<QGraphicsGridLayout_Adaptor, QEvent *>(&QGraphicsGridLayout_Adaptor::cbs_widgetEvent_1217_0, e);
    } else {
      QGraphicsGridLayout::widgetEvent(e);
    }
  }

  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_removeAt_767_0;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_sizeHint_c3330_1;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_widgetEvent_1217_0;
};

QGraphicsGridLayout_Adaptor::~QGraphicsGridLayout_Adaptor() { }

//  Constructor QGraphicsGridLayout::QGraphicsGridLayout(QGraphicsLayoutItem *parent) (adaptor class)

static void _init_ctor_QGraphicsGridLayout_Adaptor_2557 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return_new<QGraphicsGridLayout_Adaptor> ();
}

static void _call_ctor_QGraphicsGridLayout_Adaptor_2557 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args ? gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap) : gsi::arg_maker<QGraphicsLayoutItem * >() (nullptr, heap);
  ret.write<QGraphicsGridLayout_Adaptor *> (new QGraphicsGridLayout_Adaptor (arg1));
}


// exposed void QGraphicsGridLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)

static void _init_fp_addChildLayoutItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layoutItem");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayoutItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->fp_QGraphicsGridLayout_addChildLayoutItem_2557 (arg1);
}


// int QGraphicsGridLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsGridLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// void QGraphicsGridLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = args.read<double * > (heap);
  double *arg2 = args.read<double * > (heap);
  double *arg3 = args.read<double * > (heap);
  double *arg4 = args.read<double * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}


// void QGraphicsGridLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// bool QGraphicsGridLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsGridLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}


// QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsGridLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// void QGraphicsGridLayout::removeAt(int index)

static void _init_cbs_removeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_removeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_removeAt_767_0 (arg1);
}

static void _set_callback_cbs_removeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_removeAt_767_0 = cb;
}


// void QGraphicsGridLayout::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}


// exposed void QGraphicsGridLayout::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->fp_QGraphicsGridLayout_setGraphicsItem_1919 (arg1);
}


// exposed void QGraphicsGridLayout::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->fp_QGraphicsGridLayout_setOwnedByLayout_864 (arg1);
}


// QSizeF QGraphicsGridLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args.read<const QSizeF & > (heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsGridLayout_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}


// void QGraphicsGridLayout::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}


// void QGraphicsGridLayout::widgetEvent(QEvent *e)

static void _init_cbs_widgetEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_widgetEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsGridLayout_Adaptor *)cls)->cbs_widgetEvent_1217_0 (arg1);
}

static void _set_callback_cbs_widgetEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsGridLayout_Adaptor *)cls)->cb_widgetEvent_1217_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsGridLayout> &qtdecl_QGraphicsGridLayout ();

static gsi::Methods methods_QGraphicsGridLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsGridLayout::QGraphicsGridLayout(QGraphicsLayoutItem *parent)\nThis method creates an object of class QGraphicsGridLayout.", &_init_ctor_QGraphicsGridLayout_Adaptor_2557, &_call_ctor_QGraphicsGridLayout_Adaptor_2557);
  methods += new qt_gsi::GenericMethod ("*addChildLayoutItem", "@brief Method void QGraphicsGridLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayoutItem_2557, &_call_fp_addChildLayoutItem_2557);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QGraphicsGridLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsGridLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QGraphicsGridLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QGraphicsGridLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QGraphicsLayoutItem *QGraphicsGridLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("removeAt", "@brief Virtual method void QGraphicsGridLayout::removeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeAt_767_0, &_call_cbs_removeAt_767_0);
  methods += new qt_gsi::GenericMethod ("removeAt", "@hide", false, &_init_cbs_removeAt_767_0, &_call_cbs_removeAt_767_0, &_set_callback_cbs_removeAt_767_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsGridLayout::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("*setGraphicsItem", "@brief Method void QGraphicsGridLayout::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
  methods += new qt_gsi::GenericMethod ("*setOwnedByLayout", "@brief Method void QGraphicsGridLayout::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSizeF QGraphicsGridLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@brief Virtual method void QGraphicsGridLayout::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("widgetEvent", "@brief Virtual method void QGraphicsGridLayout::widgetEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widgetEvent_1217_0, &_call_cbs_widgetEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("widgetEvent", "@hide", false, &_init_cbs_widgetEvent_1217_0, &_call_cbs_widgetEvent_1217_0, &_set_callback_cbs_widgetEvent_1217_0);
  return methods;
}

gsi::Class<QGraphicsGridLayout_Adaptor> decl_QGraphicsGridLayout_Adaptor (qtdecl_QGraphicsGridLayout (), "QtWidgets", "QGraphicsGridLayout",
  methods_QGraphicsGridLayout_Adaptor (),
  "@qt\n@brief Binding of QGraphicsGridLayout");

}

