
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsView>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QBrush>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsItem>
#include <QGraphicsProxyWidget>
#include <QGraphicsScene>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPainterPath>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QPolygon>
#include <QPolygonF>
#include <QRect>
#include <QRectF>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QTransform>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsView::staticMetaObject);
}


// QFlags<Qt::AlignmentFlag> QGraphicsView::alignment()


static void _init_f_alignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QGraphicsView *)cls)->alignment ());
}


// QBrush QGraphicsView::backgroundBrush()


static void _init_f_backgroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_backgroundBrush_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QGraphicsView *)cls)->backgroundBrush ());
}


// QFlags<QGraphicsView::CacheModeFlag> QGraphicsView::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QGraphicsView::CacheModeFlag> > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QGraphicsView::CacheModeFlag> > ((QFlags<QGraphicsView::CacheModeFlag>)((QGraphicsView *)cls)->cacheMode ());
}


// void QGraphicsView::centerOn(const QPointF &pos)


static void _init_f_centerOn_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_centerOn_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->centerOn (arg1);
}


// void QGraphicsView::centerOn(double x, double y)


static void _init_f_centerOn_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_centerOn_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->centerOn (arg1, arg2);
}


// void QGraphicsView::centerOn(const QGraphicsItem *item)


static void _init_f_centerOn_2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_centerOn_2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->centerOn (arg1);
}


// QGraphicsView::DragMode QGraphicsView::dragMode()


static void _init_f_dragMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::DragMode>::target_type > ();
}

static void _call_f_dragMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsView::DragMode>::target_type > ((qt_gsi::Converter<QGraphicsView::DragMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::DragMode>(((QGraphicsView *)cls)->dragMode ()));
}


// void QGraphicsView::ensureVisible(const QRectF &rect, int xmargin, int ymargin)


static void _init_f_ensureVisible_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3);
}


// void QGraphicsView::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)


static void _init_f_ensureVisible_5278 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_5278 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QGraphicsView::ensureVisible(const QGraphicsItem *item, int xmargin, int ymargin)


static void _init_f_ensureVisible_3932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3932 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3);
}


// void QGraphicsView::fitInView(const QRectF &rect, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_4011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fitInView_4011 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->fitInView (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}


// void QGraphicsView::fitInView(double x, double y, double w, double h, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_6109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fitInView_6109 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->fitInView (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg5).cref());
}


// void QGraphicsView::fitInView(const QGraphicsItem *item, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_4763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fitInView_4763 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->fitInView (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}


// QBrush QGraphicsView::foregroundBrush()


static void _init_f_foregroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foregroundBrush_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QGraphicsView *)cls)->foregroundBrush ());
}


// QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QGraphicsView *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// void QGraphicsView::invalidateScene(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidateScene_5397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<QFlags<QGraphicsScene::SceneLayer> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_invalidateScene_5397 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  QFlags<QGraphicsScene::SceneLayer> arg2 = args ? gsi::arg_reader<QFlags<QGraphicsScene::SceneLayer> >() (args, heap) : gsi::arg_maker<QFlags<QGraphicsScene::SceneLayer> >() (QGraphicsScene::AllLayers, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->invalidateScene (arg1, arg2);
}


// bool QGraphicsView::isInteractive()


static void _init_f_isInteractive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isInteractive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsView *)cls)->isInteractive ());
}


// bool QGraphicsView::isTransformed()


static void _init_f_isTransformed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTransformed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsView *)cls)->isTransformed ());
}


// QGraphicsItem *QGraphicsView::itemAt(const QPoint &pos)


static void _init_f_itemAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsView *)cls)->itemAt (arg1));
}


// QGraphicsItem *QGraphicsView::itemAt(int x, int y)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsView *)cls)->itemAt (arg1, arg2));
}


// QList<QGraphicsItem *> QGraphicsView::items()


static void _init_f_items_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items ());
}


// QList<QGraphicsItem *> QGraphicsView::items(const QPoint &pos)


static void _init_f_items_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1));
}


// QList<QGraphicsItem *> QGraphicsView::items(int x, int y)


static void _init_f_items_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1, arg2));
}


// QList<QGraphicsItem *> QGraphicsView::items(const QRect &rect, Qt::ItemSelectionMode mode)


static void _init_f_items_c4155 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c4155 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// QList<QGraphicsItem *> QGraphicsView::items(int x, int y, int w, int h, Qt::ItemSelectionMode mode)


static void _init_f_items_c5107 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_4);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c5107 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg5).cref()));
}


// QList<QGraphicsItem *> QGraphicsView::items(const QPolygon &polygon, Qt::ItemSelectionMode mode)


static void _init_f_items_c4501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c4501 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// QList<QGraphicsItem *> QGraphicsView::items(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_items_c4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c4877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// QPoint QGraphicsView::mapFromScene(const QPointF &point)


static void _init_f_mapFromScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromScene_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QGraphicsView *)cls)->mapFromScene (arg1));
}


// QPolygon QGraphicsView::mapFromScene(const QRectF &rect)


static void _init_f_mapFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1));
}


// QPolygon QGraphicsView::mapFromScene(const QPolygonF &polygon)


static void _init_f_mapFromScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1));
}


// QPainterPath QGraphicsView::mapFromScene(const QPainterPath &path)


static void _init_f_mapFromScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromScene_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsView *)cls)->mapFromScene (arg1));
}


// QPoint QGraphicsView::mapFromScene(double x, double y)


static void _init_f_mapFromScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromScene_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPoint > ((QPoint)((QGraphicsView *)cls)->mapFromScene (arg1, arg2));
}


// QPolygon QGraphicsView::mapFromScene(double x, double y, double w, double h)


static void _init_f_mapFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1, arg2, arg3, arg4));
}


// QPointF QGraphicsView::mapToScene(const QPoint &point)


static void _init_f_mapToScene_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsView *)cls)->mapToScene (arg1));
}


// QPolygonF QGraphicsView::mapToScene(const QRect &rect)


static void _init_f_mapToScene_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1));
}


// QPolygonF QGraphicsView::mapToScene(const QPolygon &polygon)


static void _init_f_mapToScene_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1));
}


// QPainterPath QGraphicsView::mapToScene(const QPainterPath &path)


static void _init_f_mapToScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToScene_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsView *)cls)->mapToScene (arg1));
}


// QPointF QGraphicsView::mapToScene(int x, int y)


static void _init_f_mapToScene_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsView *)cls)->mapToScene (arg1, arg2));
}


// QPolygonF QGraphicsView::mapToScene(int x, int y, int w, int h)


static void _init_f_mapToScene_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1, arg2, arg3, arg4));
}


// QFlags<QGraphicsView::OptimizationFlag> QGraphicsView::optimizationFlags()


static void _init_f_optimizationFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QGraphicsView::OptimizationFlag> > ();
}

static void _call_f_optimizationFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QGraphicsView::OptimizationFlag> > ((QFlags<QGraphicsView::OptimizationFlag>)((QGraphicsView *)cls)->optimizationFlags ());
}


// void QGraphicsView::render(QPainter *painter, const QRectF &target, const QRect &source, Qt::AspectRatioMode aspectRatioMode)


static void _init_f_render_7013 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("target", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("source", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("aspectRatioMode", true, "Qt::KeepAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7013 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRectF &arg2 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  const QRect &arg3 = args ? gsi::arg_reader<const QRect & >() (args, heap) : gsi::arg_maker<const QRect & >() (QRect(), heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::KeepAspectRatio), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg4).cref());
}


// QFlags<QPainter::RenderHint> QGraphicsView::renderHints()


static void _init_f_renderHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QPainter::RenderHint> > ();
}

static void _call_f_renderHints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QPainter::RenderHint> > ((QFlags<QPainter::RenderHint>)((QGraphicsView *)cls)->renderHints ());
}


// void QGraphicsView::resetCachedContent()


static void _init_f_resetCachedContent_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetCachedContent_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->resetCachedContent ();
}


// void QGraphicsView::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->resetTransform ();
}


// QGraphicsView::ViewportAnchor QGraphicsView::resizeAnchor()


static void _init_f_resizeAnchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ();
}

static void _call_f_resizeAnchor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportAnchor>(((QGraphicsView *)cls)->resizeAnchor ()));
}


// void QGraphicsView::rotate(double angle)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->rotate (arg1);
}


// QRect QGraphicsView::rubberBandRect()


static void _init_f_rubberBandRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rubberBandRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QGraphicsView *)cls)->rubberBandRect ());
}


// Qt::ItemSelectionMode QGraphicsView::rubberBandSelectionMode()


static void _init_f_rubberBandSelectionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ItemSelectionMode>::target_type > ();
}

static void _call_f_rubberBandSelectionMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ItemSelectionMode>::target_type > ((qt_gsi::Converter<Qt::ItemSelectionMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(((QGraphicsView *)cls)->rubberBandSelectionMode ()));
}


// void QGraphicsView::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->scale (arg1, arg2);
}


// QGraphicsScene *QGraphicsView::scene()


static void _init_f_scene_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsScene * > ();
}

static void _call_f_scene_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsScene * > ((QGraphicsScene *)((QGraphicsView *)cls)->scene ());
}


// QRectF QGraphicsView::sceneRect()


static void _init_f_sceneRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsView *)cls)->sceneRect ());
}


// void QGraphicsView::setAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setAlignment (arg1);
}


// void QGraphicsView::setBackgroundBrush(const QBrush &brush)


static void _init_f_setBackgroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundBrush_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setBackgroundBrush (arg1);
}


// void QGraphicsView::setCacheMode(QFlags<QGraphicsView::CacheModeFlag> mode)


static void _init_f_setCacheMode_3792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QGraphicsView::CacheModeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_3792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsView::CacheModeFlag> arg1 = gsi::arg_reader<QFlags<QGraphicsView::CacheModeFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setCacheMode (arg1);
}


// void QGraphicsView::setDragMode(QGraphicsView::DragMode mode)


static void _init_f_setDragMode_2632 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragMode_2632 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setDragMode (qt_gsi::QtToCppAdaptor<QGraphicsView::DragMode>(arg1).cref());
}


// void QGraphicsView::setForegroundBrush(const QBrush &brush)


static void _init_f_setForegroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundBrush_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setForegroundBrush (arg1);
}


// void QGraphicsView::setInteractive(bool allowed)


static void _init_f_setInteractive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("allowed");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInteractive_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setInteractive (arg1);
}


// void QGraphicsView::setOptimizationFlag(QGraphicsView::OptimizationFlag flag, bool enabled)


static void _init_f_setOptimizationFlag_4282 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flag");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOptimizationFlag_4282 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setOptimizationFlag (qt_gsi::QtToCppAdaptor<QGraphicsView::OptimizationFlag>(arg1).cref(), arg2);
}


// void QGraphicsView::setOptimizationFlags(QFlags<QGraphicsView::OptimizationFlag> flags)


static void _init_f_setOptimizationFlags_4222 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsView::OptimizationFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptimizationFlags_4222 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsView::OptimizationFlag> arg1 = gsi::arg_reader<QFlags<QGraphicsView::OptimizationFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setOptimizationFlags (arg1);
}


// void QGraphicsView::setRenderHint(QPainter::RenderHint hint, bool enabled)


static void _init_f_setRenderHint_3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHint_3123 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPainter::RenderHint>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref(), arg2);
}


// void QGraphicsView::setRenderHints(QFlags<QPainter::RenderHint> hints)


static void _init_f_setRenderHints_3063 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<QPainter::RenderHint> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRenderHints_3063 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPainter::RenderHint> arg1 = gsi::arg_reader<QFlags<QPainter::RenderHint> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setRenderHints (arg1);
}


// void QGraphicsView::setResizeAnchor(QGraphicsView::ViewportAnchor anchor)


static void _init_f_setResizeAnchor_3328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("anchor");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResizeAnchor_3328 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setResizeAnchor (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportAnchor>(arg1).cref());
}


// void QGraphicsView::setRubberBandSelectionMode(Qt::ItemSelectionMode mode)


static void _init_f_setRubberBandSelectionMode_2471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRubberBandSelectionMode_2471 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setRubberBandSelectionMode (qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg1).cref());
}


// void QGraphicsView::setScene(QGraphicsScene *scene)


static void _init_f_setScene_2014 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scene");
  decl->add_arg<QGraphicsScene * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScene_2014 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsScene *arg1 = gsi::arg_reader<QGraphicsScene * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setScene (arg1);
}


// void QGraphicsView::setSceneRect(const QRectF &rect)


static void _init_f_setSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setSceneRect (arg1);
}


// void QGraphicsView::setSceneRect(double x, double y, double w, double h)


static void _init_f_setSceneRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setSceneRect (arg1, arg2, arg3, arg4);
}


// void QGraphicsView::setTransform(const QTransform &matrix, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setTransform (arg1, arg2);
}


// void QGraphicsView::setTransformationAnchor(QGraphicsView::ViewportAnchor anchor)


static void _init_f_setTransformationAnchor_3328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("anchor");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformationAnchor_3328 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setTransformationAnchor (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportAnchor>(arg1).cref());
}


// void QGraphicsView::setViewportUpdateMode(QGraphicsView::ViewportUpdateMode mode)


static void _init_f_setViewportUpdateMode_3725 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewportUpdateMode_3725 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->setViewportUpdateMode (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportUpdateMode>(arg1).cref());
}


// void QGraphicsView::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->shear (arg1, arg2);
}


// QSize QGraphicsView::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGraphicsView *)cls)->sizeHint ());
}


// QTransform QGraphicsView::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QGraphicsView *)cls)->transform ());
}


// QGraphicsView::ViewportAnchor QGraphicsView::transformationAnchor()


static void _init_f_transformationAnchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ();
}

static void _call_f_transformationAnchor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportAnchor>(((QGraphicsView *)cls)->transformationAnchor ()));
}


// void QGraphicsView::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->translate (arg1, arg2);
}


// void QGraphicsView::updateScene(const QList<QRectF> &rects)


static void _init_f_updateScene_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rects");
  decl->add_arg<const QList<QRectF> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateScene_2477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QRectF> &arg1 = gsi::arg_reader<const QList<QRectF> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->updateScene (arg1);
}


// void QGraphicsView::updateSceneRect(const QRectF &rect)


static void _init_f_updateSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateSceneRect_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView *)cls)->updateSceneRect (arg1);
}


// QTransform QGraphicsView::viewportTransform()


static void _init_f_viewportTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_viewportTransform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QGraphicsView *)cls)->viewportTransform ());
}


// QGraphicsView::ViewportUpdateMode QGraphicsView::viewportUpdateMode()


static void _init_f_viewportUpdateMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type > ();
}

static void _call_f_viewportUpdateMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportUpdateMode>(((QGraphicsView *)cls)->viewportUpdateMode ()));
}


// static QString QGraphicsView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsView::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsView () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":alignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsView::alignment()\n", true, &_init_f_alignment_c0, &_call_f_alignment_c0);
  methods += new qt_gsi::GenericMethod (":backgroundBrush", "@brief Method QBrush QGraphicsView::backgroundBrush()\n", true, &_init_f_backgroundBrush_c0, &_call_f_backgroundBrush_c0);
  methods += new qt_gsi::GenericMethod (":cacheMode", "@brief Method QFlags<QGraphicsView::CacheModeFlag> QGraphicsView::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
  methods += new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(const QPointF &pos)\n", false, &_init_f_centerOn_1986, &_call_f_centerOn_1986);
  methods += new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(double x, double y)\n", false, &_init_f_centerOn_2034, &_call_f_centerOn_2034);
  methods += new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(const QGraphicsItem *item)\n", false, &_init_f_centerOn_2614, &_call_f_centerOn_2614);
  methods += new qt_gsi::GenericMethod (":dragMode", "@brief Method QGraphicsView::DragMode QGraphicsView::dragMode()\n", true, &_init_f_dragMode_c0, &_call_f_dragMode_c0);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(const QRectF &rect, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3180, &_call_f_ensureVisible_3180);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_5278, &_call_f_ensureVisible_5278);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(const QGraphicsItem *item, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3932, &_call_f_ensureVisible_3932);
  methods += new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(const QRectF &rect, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_4011, &_call_f_fitInView_4011);
  methods += new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(double x, double y, double w, double h, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_6109, &_call_f_fitInView_6109);
  methods += new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(const QGraphicsItem *item, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_4763, &_call_f_fitInView_4763);
  methods += new qt_gsi::GenericMethod (":foregroundBrush", "@brief Method QBrush QGraphicsView::foregroundBrush()\n", true, &_init_f_foregroundBrush_c0, &_call_f_foregroundBrush_c0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("invalidateScene", "@brief Method void QGraphicsView::invalidateScene(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidateScene_5397, &_call_f_invalidateScene_5397);
  methods += new qt_gsi::GenericMethod ("isInteractive?|:interactive", "@brief Method bool QGraphicsView::isInteractive()\n", true, &_init_f_isInteractive_c0, &_call_f_isInteractive_c0);
  methods += new qt_gsi::GenericMethod ("isTransformed?", "@brief Method bool QGraphicsView::isTransformed()\n", true, &_init_f_isTransformed_c0, &_call_f_isTransformed_c0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsView::itemAt(const QPoint &pos)\n", true, &_init_f_itemAt_c1916, &_call_f_itemAt_c1916);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsView::itemAt(int x, int y)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items()\n", true, &_init_f_items_c0, &_call_f_items_c0);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPoint &pos)\n", true, &_init_f_items_c1916, &_call_f_items_c1916);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(int x, int y)\n", true, &_init_f_items_c1426, &_call_f_items_c1426);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QRect &rect, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4155, &_call_f_items_c4155);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(int x, int y, int w, int h, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c5107, &_call_f_items_c5107);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPolygon &polygon, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4501, &_call_f_items_c4501);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4877, &_call_f_items_c4877);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPoint QGraphicsView::mapFromScene(const QPointF &point)\n", true, &_init_f_mapFromScene_c1986, &_call_f_mapFromScene_c1986);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(const QRectF &rect)\n", true, &_init_f_mapFromScene_c1862, &_call_f_mapFromScene_c1862);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(const QPolygonF &polygon)\n", true, &_init_f_mapFromScene_c2208, &_call_f_mapFromScene_c2208);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPainterPath QGraphicsView::mapFromScene(const QPainterPath &path)\n", true, &_init_f_mapFromScene_c2514, &_call_f_mapFromScene_c2514);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPoint QGraphicsView::mapFromScene(double x, double y)\n", true, &_init_f_mapFromScene_c2034, &_call_f_mapFromScene_c2034);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapFromScene_c3960, &_call_f_mapFromScene_c3960);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsView::mapToScene(const QPoint &point)\n", true, &_init_f_mapToScene_c1916, &_call_f_mapToScene_c1916);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(const QRect &rect)\n", true, &_init_f_mapToScene_c1792, &_call_f_mapToScene_c1792);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(const QPolygon &polygon)\n", true, &_init_f_mapToScene_c2138, &_call_f_mapToScene_c2138);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPainterPath QGraphicsView::mapToScene(const QPainterPath &path)\n", true, &_init_f_mapToScene_c2514, &_call_f_mapToScene_c2514);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsView::mapToScene(int x, int y)\n", true, &_init_f_mapToScene_c1426, &_call_f_mapToScene_c1426);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(int x, int y, int w, int h)\n", true, &_init_f_mapToScene_c2744, &_call_f_mapToScene_c2744);
  methods += new qt_gsi::GenericMethod (":optimizationFlags", "@brief Method QFlags<QGraphicsView::OptimizationFlag> QGraphicsView::optimizationFlags()\n", true, &_init_f_optimizationFlags_c0, &_call_f_optimizationFlags_c0);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QGraphicsView::render(QPainter *painter, const QRectF &target, const QRect &source, Qt::AspectRatioMode aspectRatioMode)\n", false, &_init_f_render_7013, &_call_f_render_7013);
  methods += new qt_gsi::GenericMethod (":renderHints", "@brief Method QFlags<QPainter::RenderHint> QGraphicsView::renderHints()\n", true, &_init_f_renderHints_c0, &_call_f_renderHints_c0);
  methods += new qt_gsi::GenericMethod ("resetCachedContent", "@brief Method void QGraphicsView::resetCachedContent()\n", false, &_init_f_resetCachedContent_0, &_call_f_resetCachedContent_0);
  methods += new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QGraphicsView::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
  methods += new qt_gsi::GenericMethod (":resizeAnchor", "@brief Method QGraphicsView::ViewportAnchor QGraphicsView::resizeAnchor()\n", true, &_init_f_resizeAnchor_c0, &_call_f_resizeAnchor_c0);
  methods += new qt_gsi::GenericMethod ("rotate", "@brief Method void QGraphicsView::rotate(double angle)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
  methods += new qt_gsi::GenericMethod ("rubberBandRect", "@brief Method QRect QGraphicsView::rubberBandRect()\n", true, &_init_f_rubberBandRect_c0, &_call_f_rubberBandRect_c0);
  methods += new qt_gsi::GenericMethod (":rubberBandSelectionMode", "@brief Method Qt::ItemSelectionMode QGraphicsView::rubberBandSelectionMode()\n", true, &_init_f_rubberBandSelectionMode_c0, &_call_f_rubberBandSelectionMode_c0);
  methods += new qt_gsi::GenericMethod ("scale", "@brief Method void QGraphicsView::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
  methods += new qt_gsi::GenericMethod (":scene", "@brief Method QGraphicsScene *QGraphicsView::scene()\n", true, &_init_f_scene_c0, &_call_f_scene_c0);
  methods += new qt_gsi::GenericMethod (":sceneRect", "@brief Method QRectF QGraphicsView::sceneRect()\n", true, &_init_f_sceneRect_c0, &_call_f_sceneRect_c0);
  methods += new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QGraphicsView::setAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setBackgroundBrush|backgroundBrush=", "@brief Method void QGraphicsView::setBackgroundBrush(const QBrush &brush)\n", false, &_init_f_setBackgroundBrush_1910, &_call_f_setBackgroundBrush_1910);
  methods += new qt_gsi::GenericMethod ("setCacheMode|cacheMode=", "@brief Method void QGraphicsView::setCacheMode(QFlags<QGraphicsView::CacheModeFlag> mode)\n", false, &_init_f_setCacheMode_3792, &_call_f_setCacheMode_3792);
  methods += new qt_gsi::GenericMethod ("setDragMode|dragMode=", "@brief Method void QGraphicsView::setDragMode(QGraphicsView::DragMode mode)\n", false, &_init_f_setDragMode_2632, &_call_f_setDragMode_2632);
  methods += new qt_gsi::GenericMethod ("setForegroundBrush|foregroundBrush=", "@brief Method void QGraphicsView::setForegroundBrush(const QBrush &brush)\n", false, &_init_f_setForegroundBrush_1910, &_call_f_setForegroundBrush_1910);
  methods += new qt_gsi::GenericMethod ("setInteractive|interactive=", "@brief Method void QGraphicsView::setInteractive(bool allowed)\n", false, &_init_f_setInteractive_864, &_call_f_setInteractive_864);
  methods += new qt_gsi::GenericMethod ("setOptimizationFlag", "@brief Method void QGraphicsView::setOptimizationFlag(QGraphicsView::OptimizationFlag flag, bool enabled)\n", false, &_init_f_setOptimizationFlag_4282, &_call_f_setOptimizationFlag_4282);
  methods += new qt_gsi::GenericMethod ("setOptimizationFlags|optimizationFlags=", "@brief Method void QGraphicsView::setOptimizationFlags(QFlags<QGraphicsView::OptimizationFlag> flags)\n", false, &_init_f_setOptimizationFlags_4222, &_call_f_setOptimizationFlags_4222);
  methods += new qt_gsi::GenericMethod ("setRenderHint", "@brief Method void QGraphicsView::setRenderHint(QPainter::RenderHint hint, bool enabled)\n", false, &_init_f_setRenderHint_3123, &_call_f_setRenderHint_3123);
  methods += new qt_gsi::GenericMethod ("setRenderHints|renderHints=", "@brief Method void QGraphicsView::setRenderHints(QFlags<QPainter::RenderHint> hints)\n", false, &_init_f_setRenderHints_3063, &_call_f_setRenderHints_3063);
  methods += new qt_gsi::GenericMethod ("setResizeAnchor|resizeAnchor=", "@brief Method void QGraphicsView::setResizeAnchor(QGraphicsView::ViewportAnchor anchor)\n", false, &_init_f_setResizeAnchor_3328, &_call_f_setResizeAnchor_3328);
  methods += new qt_gsi::GenericMethod ("setRubberBandSelectionMode|rubberBandSelectionMode=", "@brief Method void QGraphicsView::setRubberBandSelectionMode(Qt::ItemSelectionMode mode)\n", false, &_init_f_setRubberBandSelectionMode_2471, &_call_f_setRubberBandSelectionMode_2471);
  methods += new qt_gsi::GenericMethod ("setScene|scene=", "@brief Method void QGraphicsView::setScene(QGraphicsScene *scene)\n", false, &_init_f_setScene_2014, &_call_f_setScene_2014);
  methods += new qt_gsi::GenericMethod ("setSceneRect|sceneRect=", "@brief Method void QGraphicsView::setSceneRect(const QRectF &rect)\n", false, &_init_f_setSceneRect_1862, &_call_f_setSceneRect_1862);
  methods += new qt_gsi::GenericMethod ("setSceneRect", "@brief Method void QGraphicsView::setSceneRect(double x, double y, double w, double h)\n", false, &_init_f_setSceneRect_3960, &_call_f_setSceneRect_3960);
  methods += new qt_gsi::GenericMethod ("setTransform", "@brief Method void QGraphicsView::setTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
  methods += new qt_gsi::GenericMethod ("setTransformationAnchor|transformationAnchor=", "@brief Method void QGraphicsView::setTransformationAnchor(QGraphicsView::ViewportAnchor anchor)\n", false, &_init_f_setTransformationAnchor_3328, &_call_f_setTransformationAnchor_3328);
  methods += new qt_gsi::GenericMethod ("setViewportUpdateMode|viewportUpdateMode=", "@brief Method void QGraphicsView::setViewportUpdateMode(QGraphicsView::ViewportUpdateMode mode)\n", false, &_init_f_setViewportUpdateMode_3725, &_call_f_setViewportUpdateMode_3725);
  methods += new qt_gsi::GenericMethod ("shear", "@brief Method void QGraphicsView::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QGraphicsView::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":transform", "@brief Method QTransform QGraphicsView::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
  methods += new qt_gsi::GenericMethod (":transformationAnchor", "@brief Method QGraphicsView::ViewportAnchor QGraphicsView::transformationAnchor()\n", true, &_init_f_transformationAnchor_c0, &_call_f_transformationAnchor_c0);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QGraphicsView::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
  methods += new qt_gsi::GenericMethod ("updateScene", "@brief Method void QGraphicsView::updateScene(const QList<QRectF> &rects)\n", false, &_init_f_updateScene_2477, &_call_f_updateScene_2477);
  methods += new qt_gsi::GenericMethod ("updateSceneRect", "@brief Method void QGraphicsView::updateSceneRect(const QRectF &rect)\n", false, &_init_f_updateSceneRect_1862, &_call_f_updateSceneRect_1862);
  methods += new qt_gsi::GenericMethod ("viewportTransform", "@brief Method QTransform QGraphicsView::viewportTransform()\n", true, &_init_f_viewportTransform_c0, &_call_f_viewportTransform_c0);
  methods += new qt_gsi::GenericMethod (":viewportUpdateMode", "@brief Method QGraphicsView::ViewportUpdateMode QGraphicsView::viewportUpdateMode()\n", true, &_init_f_viewportUpdateMode_c0, &_call_f_viewportUpdateMode_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QGraphicsView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsView::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsView::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QRect, QPointF, QPointF > ("rubberBandChanged(QRect, QPointF, QPointF)", "rubberBandChanged", gsi::arg("viewportRect"), gsi::arg("fromScenePoint"), gsi::arg("toScenePoint"), "@brief Signal declaration for QGraphicsView::rubberBandChanged(QRect viewportRect, QPointF fromScenePoint, QPointF toScenePoint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QGraphicsView::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QGraphicsView::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QGraphicsView::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

qt_gsi::QtNativeClass<QGraphicsView> decl_QGraphicsView (qtdecl_QAbstractScrollArea (), "QtWidgets", "QGraphicsView_Native",
  methods_QGraphicsView (),
  "@hide\n@alias QGraphicsView");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsView> &qtdecl_QGraphicsView () { return decl_QGraphicsView; }

}


class QGraphicsView_Adaptor : public QGraphicsView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsView_Adaptor();

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QWidget *parent)
  QGraphicsView_Adaptor() : QGraphicsView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QWidget *parent)
  QGraphicsView_Adaptor(QWidget *parent) : QGraphicsView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)
  QGraphicsView_Adaptor(QGraphicsScene *scene) : QGraphicsView(scene)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)
  QGraphicsView_Adaptor(QGraphicsScene *scene, QWidget *parent) : QGraphicsView(scene, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QGraphicsView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QGraphicsView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QGraphicsView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QGraphicsView::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QGraphicsView::drawFrame(QPainter *)
  void fp_QGraphicsView_drawFrame_1426 (QPainter *arg1) {
    QGraphicsView::drawFrame(arg1);
  }

  //  [expose] bool QGraphicsView::focusNextChild()
  bool fp_QGraphicsView_focusNextChild_0 () {
    return QGraphicsView::focusNextChild();
  }

  //  [expose] bool QGraphicsView::focusPreviousChild()
  bool fp_QGraphicsView_focusPreviousChild_0 () {
    return QGraphicsView::focusPreviousChild();
  }

  //  [expose] bool QGraphicsView::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsView_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsView::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsView::receivers(const char *signal)
  int fp_QGraphicsView_receivers_c1731 (const char *signal) const {
    return QGraphicsView::receivers(signal);
  }

  //  [expose] QObject *QGraphicsView::sender()
  QObject * fp_QGraphicsView_sender_c0 () const {
    return QGraphicsView::sender();
  }

  //  [expose] int QGraphicsView::senderSignalIndex()
  int fp_QGraphicsView_senderSignalIndex_c0 () const {
    return QGraphicsView::senderSignalIndex();
  }

  //  [expose] void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QGraphicsView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QGraphicsView::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QGraphicsView::setViewportMargins(const QMargins &margins)
  void fp_QGraphicsView_setViewportMargins_2115 (const QMargins &margins) {
    QGraphicsView::setViewportMargins(margins);
  }

  //  [expose] void QGraphicsView::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QGraphicsView_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QGraphicsView::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [expose] QMargins QGraphicsView::viewportMargins()
  QMargins fp_QGraphicsView_viewportMargins_c0 () const {
    return QGraphicsView::viewportMargins();
  }

  //  [emitter impl] void QGraphicsView::customContextMenuRequested(const QPoint &pos)
  void emitter_QGraphicsView_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QGraphicsView::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QGraphicsView::destroyed(QObject *)
  void emitter_QGraphicsView_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsView::destroyed(arg1);
  }

  //  [adaptor impl] bool QGraphicsView::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QGraphicsView::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QGraphicsView_Adaptor, bool>(&QGraphicsView_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QGraphicsView::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QGraphicsView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QGraphicsView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QGraphicsView_Adaptor, int, int>(&QGraphicsView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QGraphicsView::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QSize QGraphicsView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QGraphicsView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QGraphicsView_Adaptor, QSize>(&QGraphicsView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QGraphicsView::minimumSizeHint();
    }
  }

  //  [emitter impl] void QGraphicsView::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsView_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsView::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QGraphicsView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QGraphicsView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QGraphicsView_Adaptor, QPaintEngine *>(&QGraphicsView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QGraphicsView::paintEngine();
    }
  }

  //  [emitter impl] void QGraphicsView::rubberBandChanged(QRect viewportRect, QPointF fromScenePoint, QPointF toScenePoint)
  void emitter_QGraphicsView_rubberBandChanged_2917(QRect viewportRect, QPointF fromScenePoint, QPointF toScenePoint)
  {
    emit QGraphicsView::rubberBandChanged(viewportRect, fromScenePoint, toScenePoint);
  }

  //  [adaptor impl] void QGraphicsView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QGraphicsView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QGraphicsView_Adaptor, bool>(&QGraphicsView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QGraphicsView::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QGraphicsView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QGraphicsView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QGraphicsView_Adaptor, QSize>(&QGraphicsView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QGraphicsView::sizeHint();
    }
  }

  //  [emitter impl] void QGraphicsView::windowIconChanged(const QIcon &icon)
  void emitter_QGraphicsView_windowIconChanged_1787(const QIcon &icon)
  {
    emit QGraphicsView::windowIconChanged(icon);
  }

  //  [emitter impl] void QGraphicsView::windowIconTextChanged(const QString &iconText)
  void emitter_QGraphicsView_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QGraphicsView::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QGraphicsView::windowTitleChanged(const QString &title)
  void emitter_QGraphicsView_windowTitleChanged_2025(const QString &title)
  {
    emit QGraphicsView::windowTitleChanged(title);
  }

  //  [adaptor impl] void QGraphicsView::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QGraphicsView::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QGraphicsView_Adaptor, QActionEvent *>(&QGraphicsView_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QGraphicsView::actionEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QGraphicsView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QGraphicsView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsView::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsView_Adaptor, QChildEvent *>(&QGraphicsView_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsView::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QGraphicsView::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QGraphicsView_Adaptor, QCloseEvent *>(&QGraphicsView_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QGraphicsView::closeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QGraphicsView::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QGraphicsView_Adaptor, QContextMenuEvent *>(&QGraphicsView_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QGraphicsView::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsView::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsView::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsView_Adaptor, const QMetaMethod &>(&QGraphicsView_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QGraphicsView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QGraphicsView_Adaptor, QDragEnterEvent *>(&QGraphicsView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QGraphicsView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QGraphicsView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QGraphicsView_Adaptor, QDragLeaveEvent *>(&QGraphicsView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QGraphicsView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QGraphicsView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QGraphicsView_Adaptor, QDragMoveEvent *>(&QGraphicsView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QGraphicsView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)
  void cbs_drawBackground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsView::drawBackground(painter, rect);
  }

  virtual void drawBackground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawBackground_3180_0.can_issue()) {
      cb_drawBackground_3180_0.issue<QGraphicsView_Adaptor, QPainter *, const QRectF &>(&QGraphicsView_Adaptor::cbs_drawBackground_3180_0, painter, rect);
    } else {
      QGraphicsView::drawBackground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)
  void cbs_drawForeground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsView::drawForeground(painter, rect);
  }

  virtual void drawForeground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawForeground_3180_0.can_issue()) {
      cb_drawForeground_3180_0.issue<QGraphicsView_Adaptor, QPainter *, const QRectF &>(&QGraphicsView_Adaptor::cbs_drawForeground_3180_0, painter, rect);
    } else {
      QGraphicsView::drawForeground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QGraphicsView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QGraphicsView_Adaptor, QDropEvent *>(&QGraphicsView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QGraphicsView::dropEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QGraphicsView::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QGraphicsView_Adaptor, QEnterEvent *>(&QGraphicsView_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QGraphicsView::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsView::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsView_Adaptor, bool, QEvent *>(&QGraphicsView_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsView::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsView_Adaptor, bool, QObject *, QEvent *>(&QGraphicsView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsView_Adaptor, QFocusEvent *>(&QGraphicsView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsView_Adaptor, bool, bool>(&QGraphicsView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsView_Adaptor, QFocusEvent *>(&QGraphicsView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QGraphicsView::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QGraphicsView_Adaptor, QHideEvent *>(&QGraphicsView_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QGraphicsView::hideEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QGraphicsView::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QGraphicsView_Adaptor, QPainter *>(&QGraphicsView_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QGraphicsView::initPainter(painter);
    }
  }

  //  [adaptor impl] void QGraphicsView::initStyleOption(QStyleOptionFrame *option)
  void cbs_initStyleOption_c2356_0(QStyleOptionFrame *option) const
  {
    QGraphicsView::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionFrame *option) const
  {
    if (cb_initStyleOption_c2356_0.can_issue()) {
      cb_initStyleOption_c2356_0.issue<QGraphicsView_Adaptor, QStyleOptionFrame *>(&QGraphicsView_Adaptor::cbs_initStyleOption_c2356_0, option);
    } else {
      QGraphicsView::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsView_Adaptor, QInputMethodEvent *>(&QGraphicsView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsView_Adaptor, QKeyEvent *>(&QGraphicsView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsView::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsView_Adaptor, QKeyEvent *>(&QGraphicsView_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsView::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QGraphicsView::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QGraphicsView::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QGraphicsView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QGraphicsView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QGraphicsView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QGraphicsView::metric(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QGraphicsView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QGraphicsView::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QGraphicsView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QGraphicsView::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QGraphicsView::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QGraphicsView_Adaptor, QMoveEvent *>(&QGraphicsView_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QGraphicsView::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QGraphicsView::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QGraphicsView_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QGraphicsView_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QGraphicsView::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QGraphicsView::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QGraphicsView::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QGraphicsView_Adaptor, QPaintEvent *>(&QGraphicsView_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QGraphicsView::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QGraphicsView::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QGraphicsView::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QGraphicsView_Adaptor, QPaintDevice *, QPoint *>(&QGraphicsView_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QGraphicsView::redirected(offset);
    }
  }

  //  [adaptor impl] void QGraphicsView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QGraphicsView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QGraphicsView_Adaptor, QResizeEvent *>(&QGraphicsView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QGraphicsView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QGraphicsView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QGraphicsView_Adaptor, int, int>(&QGraphicsView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QGraphicsView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QGraphicsView::setupViewport(QWidget *widget)
  void cbs_setupViewport_1315_0(QWidget *widget)
  {
    QGraphicsView::setupViewport(widget);
  }

  virtual void setupViewport(QWidget *widget)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QGraphicsView_Adaptor, QWidget *>(&QGraphicsView_Adaptor::cbs_setupViewport_1315_0, widget);
    } else {
      QGraphicsView::setupViewport(widget);
    }
  }

  //  [adaptor impl] QPainter *QGraphicsView::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QGraphicsView::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QGraphicsView_Adaptor, QPainter *>(&QGraphicsView_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QGraphicsView::sharedPainter();
    }
  }

  //  [adaptor impl] void QGraphicsView::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QGraphicsView::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QGraphicsView_Adaptor, QShowEvent *>(&QGraphicsView_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QGraphicsView::showEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QGraphicsView::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QGraphicsView_Adaptor, QTabletEvent *>(&QGraphicsView_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QGraphicsView::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsView::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsView_Adaptor, QTimerEvent *>(&QGraphicsView_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsView::timerEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QGraphicsView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QGraphicsView_Adaptor, bool, QEvent *>(&QGraphicsView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QGraphicsView::viewportEvent(event);
    }
  }

  //  [adaptor impl] QSize QGraphicsView::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QGraphicsView::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QGraphicsView_Adaptor, QSize>(&QGraphicsView_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QGraphicsView::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QGraphicsView::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QGraphicsView::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QGraphicsView_Adaptor, QWheelEvent *>(&QGraphicsView_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QGraphicsView::wheelEvent(event);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_drawBackground_3180_0;
  gsi::Callback cb_drawForeground_3180_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2356_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QGraphicsView_Adaptor::~QGraphicsView_Adaptor() { }

//  Constructor QGraphicsView::QGraphicsView(QWidget *parent) (adaptor class)

static void _init_ctor_QGraphicsView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QGraphicsView_Adaptor> ();
}

static void _call_ctor_QGraphicsView_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QGraphicsView_Adaptor *> (new QGraphicsView_Adaptor (arg1));
}


//  Constructor QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent) (adaptor class)

static void _init_ctor_QGraphicsView_Adaptor_3221 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scene");
  decl->add_arg<QGraphicsScene * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QGraphicsView_Adaptor> ();
}

static void _call_ctor_QGraphicsView_Adaptor_3221 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsScene *arg1 = gsi::arg_reader<QGraphicsScene * >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QGraphicsView_Adaptor *> (new QGraphicsView_Adaptor (arg1, arg2));
}


// void QGraphicsView::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QGraphicsView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QGraphicsView::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsView::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_create_2208 (arg1, arg2, arg3);
}


// emitter void QGraphicsView::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_customContextMenuRequested_1916 (arg1);
}


// void QGraphicsView::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_destroy_1620 (arg1, arg2);
}


// emitter void QGraphicsView::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_destroyed_1302 (arg1);
}


// void QGraphicsView::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawBackground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawBackground_3180_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_drawBackground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawBackground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_drawBackground_3180_0 = cb;
}


// void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawForeground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawForeground_3180_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_drawForeground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawForeground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_drawForeground_3180_0 = cb;
}


// exposed void QGraphicsView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_drawFrame_1426 (arg1);
}


// void QGraphicsView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QGraphicsView::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QGraphicsView::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QGraphicsView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QGraphicsView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_focusNextChild_0 ());
}


// bool QGraphicsView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QGraphicsView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QGraphicsView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_focusPreviousChild_0 ());
}


// bool QGraphicsView::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QGraphicsView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QGraphicsView::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QGraphicsView::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QGraphicsView::initStyleOption(QStyleOptionFrame *option)

static void _init_cbs_initStyleOption_c2356_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2356_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = args.read<QStyleOptionFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_initStyleOption_c2356_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2356_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_initStyleOption_c2356_0 = cb;
}


// void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QGraphicsView::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_isSignalConnected_c2394 (arg1));
}


// void QGraphicsView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsView::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QGraphicsView::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QGraphicsView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGraphicsView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QGraphicsView::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QGraphicsView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QGraphicsView::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QGraphicsView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QGraphicsView::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QGraphicsView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QGraphicsView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QGraphicsView::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QGraphicsView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_receivers_c1731 (arg1));
}


// QPaintDevice *QGraphicsView::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QGraphicsView_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QGraphicsView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// emitter void QGraphicsView::rubberBandChanged(QRect viewportRect, QPointF fromScenePoint, QPointF toScenePoint)

static void _init_emitter_rubberBandChanged_2917 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewportRect");
  decl->add_arg<QRect > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fromScenePoint");
  decl->add_arg<QPointF > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("toScenePoint");
  decl->add_arg<QPointF > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rubberBandChanged_2917 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRect arg1 = gsi::arg_reader<QRect >() (args, heap);
  QPointF arg2 = gsi::arg_reader<QPointF >() (args, heap);
  QPointF arg3 = gsi::arg_reader<QPointF >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_rubberBandChanged_2917 (arg1, arg2, arg3);
}


// void QGraphicsView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed QObject *QGraphicsView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_sender_c0 ());
}


// exposed int QGraphicsView::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_senderSignalIndex_c0 ());
}


// exposed void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QGraphicsView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_setViewportMargins_2115 (arg1);
}


// void QGraphicsView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QGraphicsView::setupViewport(QWidget *widget)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QGraphicsView::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QGraphicsView_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QGraphicsView::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QGraphicsView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGraphicsView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QGraphicsView::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QGraphicsView::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QGraphicsView::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_updateMicroFocus_2420 (arg1);
}


// bool QGraphicsView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QGraphicsView::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_viewportMargins_c0 ());
}


// QSize QGraphicsView::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGraphicsView_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QGraphicsView::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QGraphicsView::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_windowIconChanged_1787 (arg1);
}


// emitter void QGraphicsView::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_windowIconTextChanged_2025 (arg1);
}


// emitter void QGraphicsView::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsView_Adaptor *)cls)->emitter_QGraphicsView_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QGraphicsView> &qtdecl_QGraphicsView ();

static gsi::Methods methods_QGraphicsView_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsView::QGraphicsView(QWidget *parent)\nThis method creates an object of class QGraphicsView.", &_init_ctor_QGraphicsView_Adaptor_1315, &_call_ctor_QGraphicsView_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)\nThis method creates an object of class QGraphicsView.", &_init_ctor_QGraphicsView_Adaptor_3221, &_call_ctor_QGraphicsView_Adaptor_3221);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QGraphicsView::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QGraphicsView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsView::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QGraphicsView::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QGraphicsView::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsView::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsView::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsView::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawBackground", "@brief Virtual method void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawBackground", "@hide", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0, &_set_callback_cbs_drawBackground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawForeground", "@brief Virtual method void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawForeground", "@hide", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0, &_set_callback_cbs_drawForeground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QGraphicsView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QGraphicsView::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsView::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QGraphicsView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QGraphicsView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QGraphicsView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QGraphicsView::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QGraphicsView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QGraphicsView::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QGraphicsView::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QGraphicsView::initStyleOption(QStyleOptionFrame *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0, &_set_callback_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsView::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsView::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QGraphicsView::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QGraphicsView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsView::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QGraphicsView::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QGraphicsView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsView::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QGraphicsView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QGraphicsView::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QGraphicsView::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QGraphicsView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("emit_rubberBandChanged", "@brief Emitter for signal void QGraphicsView::rubberBandChanged(QRect viewportRect, QPointF fromScenePoint, QPointF toScenePoint)\nCall this method to emit this signal.", false, &_init_emitter_rubberBandChanged_2917, &_call_emitter_rubberBandChanged_2917);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QGraphicsView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsView::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QGraphicsView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QGraphicsView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@brief Virtual method void QGraphicsView::setupViewport(QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QGraphicsView::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QGraphicsView::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QGraphicsView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QGraphicsView::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsView::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QGraphicsView::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QGraphicsView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QGraphicsView::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QGraphicsView::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsView::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QGraphicsView::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QGraphicsView::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QGraphicsView::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QGraphicsView_Adaptor> decl_QGraphicsView_Adaptor (qtdecl_QGraphicsView (), "QtWidgets", "QGraphicsView",
  methods_QGraphicsView_Adaptor (),
  "@qt\n@brief Binding of QGraphicsView");

}


//  Implementation of the enum wrapper class for QGraphicsView::CacheModeFlag
namespace qt_gsi
{

static gsi::Enum<QGraphicsView::CacheModeFlag> decl_QGraphicsView_CacheModeFlag_Enum ("QtWidgets", "QGraphicsView_CacheModeFlag",
    gsi::enum_const ("CacheNone", QGraphicsView::CacheNone, "@brief Enum constant QGraphicsView::CacheNone") +
    gsi::enum_const ("CacheBackground", QGraphicsView::CacheBackground, "@brief Enum constant QGraphicsView::CacheBackground"),
  "@qt\n@brief This class represents the QGraphicsView::CacheModeFlag enum");

static gsi::QFlagsClass<QGraphicsView::CacheModeFlag > decl_QGraphicsView_CacheModeFlag_Enums ("QtWidgets", "QGraphicsView_QFlags_CacheModeFlag",
  "@qt\n@brief This class represents the QFlags<QGraphicsView::CacheModeFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_CacheModeFlag_Enum_in_parent (decl_QGraphicsView_CacheModeFlag_Enum.defs ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_CacheModeFlag_Enum_as_child (decl_QGraphicsView_CacheModeFlag_Enum, "CacheModeFlag");
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_CacheModeFlag_Enums_as_child (decl_QGraphicsView_CacheModeFlag_Enums, "QFlags_CacheModeFlag");

}


//  Implementation of the enum wrapper class for QGraphicsView::DragMode
namespace qt_gsi
{

static gsi::Enum<QGraphicsView::DragMode> decl_QGraphicsView_DragMode_Enum ("QtWidgets", "QGraphicsView_DragMode",
    gsi::enum_const ("NoDrag", QGraphicsView::NoDrag, "@brief Enum constant QGraphicsView::NoDrag") +
    gsi::enum_const ("ScrollHandDrag", QGraphicsView::ScrollHandDrag, "@brief Enum constant QGraphicsView::ScrollHandDrag") +
    gsi::enum_const ("RubberBandDrag", QGraphicsView::RubberBandDrag, "@brief Enum constant QGraphicsView::RubberBandDrag"),
  "@qt\n@brief This class represents the QGraphicsView::DragMode enum");

static gsi::QFlagsClass<QGraphicsView::DragMode > decl_QGraphicsView_DragMode_Enums ("QtWidgets", "QGraphicsView_QFlags_DragMode",
  "@qt\n@brief This class represents the QFlags<QGraphicsView::DragMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_DragMode_Enum_in_parent (decl_QGraphicsView_DragMode_Enum.defs ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_DragMode_Enum_as_child (decl_QGraphicsView_DragMode_Enum, "DragMode");
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_DragMode_Enums_as_child (decl_QGraphicsView_DragMode_Enums, "QFlags_DragMode");

}


//  Implementation of the enum wrapper class for QGraphicsView::OptimizationFlag
namespace qt_gsi
{

static gsi::Enum<QGraphicsView::OptimizationFlag> decl_QGraphicsView_OptimizationFlag_Enum ("QtWidgets", "QGraphicsView_OptimizationFlag",
    gsi::enum_const ("DontSavePainterState", QGraphicsView::DontSavePainterState, "@brief Enum constant QGraphicsView::DontSavePainterState") +
    gsi::enum_const ("DontAdjustForAntialiasing", QGraphicsView::DontAdjustForAntialiasing, "@brief Enum constant QGraphicsView::DontAdjustForAntialiasing") +
    gsi::enum_const ("IndirectPainting", QGraphicsView::IndirectPainting, "@brief Enum constant QGraphicsView::IndirectPainting"),
  "@qt\n@brief This class represents the QGraphicsView::OptimizationFlag enum");

static gsi::QFlagsClass<QGraphicsView::OptimizationFlag > decl_QGraphicsView_OptimizationFlag_Enums ("QtWidgets", "QGraphicsView_QFlags_OptimizationFlag",
  "@qt\n@brief This class represents the QFlags<QGraphicsView::OptimizationFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_OptimizationFlag_Enum_in_parent (decl_QGraphicsView_OptimizationFlag_Enum.defs ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_OptimizationFlag_Enum_as_child (decl_QGraphicsView_OptimizationFlag_Enum, "OptimizationFlag");
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_OptimizationFlag_Enums_as_child (decl_QGraphicsView_OptimizationFlag_Enums, "QFlags_OptimizationFlag");

}


//  Implementation of the enum wrapper class for QGraphicsView::ViewportAnchor
namespace qt_gsi
{

static gsi::Enum<QGraphicsView::ViewportAnchor> decl_QGraphicsView_ViewportAnchor_Enum ("QtWidgets", "QGraphicsView_ViewportAnchor",
    gsi::enum_const ("NoAnchor", QGraphicsView::NoAnchor, "@brief Enum constant QGraphicsView::NoAnchor") +
    gsi::enum_const ("AnchorViewCenter", QGraphicsView::AnchorViewCenter, "@brief Enum constant QGraphicsView::AnchorViewCenter") +
    gsi::enum_const ("AnchorUnderMouse", QGraphicsView::AnchorUnderMouse, "@brief Enum constant QGraphicsView::AnchorUnderMouse"),
  "@qt\n@brief This class represents the QGraphicsView::ViewportAnchor enum");

static gsi::QFlagsClass<QGraphicsView::ViewportAnchor > decl_QGraphicsView_ViewportAnchor_Enums ("QtWidgets", "QGraphicsView_QFlags_ViewportAnchor",
  "@qt\n@brief This class represents the QFlags<QGraphicsView::ViewportAnchor> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_ViewportAnchor_Enum_in_parent (decl_QGraphicsView_ViewportAnchor_Enum.defs ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportAnchor_Enum_as_child (decl_QGraphicsView_ViewportAnchor_Enum, "ViewportAnchor");
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportAnchor_Enums_as_child (decl_QGraphicsView_ViewportAnchor_Enums, "QFlags_ViewportAnchor");

}


//  Implementation of the enum wrapper class for QGraphicsView::ViewportUpdateMode
namespace qt_gsi
{

static gsi::Enum<QGraphicsView::ViewportUpdateMode> decl_QGraphicsView_ViewportUpdateMode_Enum ("QtWidgets", "QGraphicsView_ViewportUpdateMode",
    gsi::enum_const ("FullViewportUpdate", QGraphicsView::FullViewportUpdate, "@brief Enum constant QGraphicsView::FullViewportUpdate") +
    gsi::enum_const ("MinimalViewportUpdate", QGraphicsView::MinimalViewportUpdate, "@brief Enum constant QGraphicsView::MinimalViewportUpdate") +
    gsi::enum_const ("SmartViewportUpdate", QGraphicsView::SmartViewportUpdate, "@brief Enum constant QGraphicsView::SmartViewportUpdate") +
    gsi::enum_const ("NoViewportUpdate", QGraphicsView::NoViewportUpdate, "@brief Enum constant QGraphicsView::NoViewportUpdate") +
    gsi::enum_const ("BoundingRectViewportUpdate", QGraphicsView::BoundingRectViewportUpdate, "@brief Enum constant QGraphicsView::BoundingRectViewportUpdate"),
  "@qt\n@brief This class represents the QGraphicsView::ViewportUpdateMode enum");

static gsi::QFlagsClass<QGraphicsView::ViewportUpdateMode > decl_QGraphicsView_ViewportUpdateMode_Enums ("QtWidgets", "QGraphicsView_QFlags_ViewportUpdateMode",
  "@qt\n@brief This class represents the QFlags<QGraphicsView::ViewportUpdateMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_ViewportUpdateMode_Enum_in_parent (decl_QGraphicsView_ViewportUpdateMode_Enum.defs ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportUpdateMode_Enum_as_child (decl_QGraphicsView_ViewportUpdateMode_Enum, "ViewportUpdateMode");
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportUpdateMode_Enums_as_child (decl_QGraphicsView_ViewportUpdateMode_Enums, "QFlags_ViewportUpdateMode");

}

