
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextLength.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextLength>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextLength

//  Constructor QTextLength::QTextLength()


static void _init_ctor_QTextLength_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextLength> ();
}

static void _call_ctor_QTextLength_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextLength *> (new QTextLength ());
}


//  Constructor QTextLength::QTextLength(QTextLength::Type type, double value)


static void _init_ctor_QTextLength_3045 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QTextLength::Type>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<double > (argspec_1);
  decl->set_return_new<QTextLength> ();
}

static void _call_ctor_QTextLength_3045 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextLength::Type>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextLength::Type>::target_type & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTextLength *> (new QTextLength (qt_gsi::QtToCppAdaptor<QTextLength::Type>(arg1).cref(), arg2));
}


// bool QTextLength::operator!=(const QTextLength &other)


static void _init_f_operator_excl__eq__c2425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextLength & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextLength &arg1 = gsi::arg_reader<const QTextLength & >() (args, heap);
  ret.write<bool > ((bool)((QTextLength *)cls)->operator!= (arg1));
}


// bool QTextLength::operator==(const QTextLength &other)


static void _init_f_operator_eq__eq__c2425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextLength & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextLength &arg1 = gsi::arg_reader<const QTextLength & >() (args, heap);
  ret.write<bool > ((bool)((QTextLength *)cls)->operator== (arg1));
}


// double QTextLength::rawValue()


static void _init_f_rawValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_rawValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextLength *)cls)->rawValue ());
}


// QTextLength::Type QTextLength::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextLength::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextLength::Type>::target_type > ((qt_gsi::Converter<QTextLength::Type>::target_type)qt_gsi::CppToQtAdaptor<QTextLength::Type>(((QTextLength *)cls)->type ()));
}


// double QTextLength::value(double maximumLength)


static void _init_f_value_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maximumLength");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_value_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QTextLength *)cls)->value (arg1));
}



namespace gsi
{

static gsi::Methods methods_QTextLength () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLength::QTextLength()\nThis method creates an object of class QTextLength.", &_init_ctor_QTextLength_0, &_call_ctor_QTextLength_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLength::QTextLength(QTextLength::Type type, double value)\nThis method creates an object of class QTextLength.", &_init_ctor_QTextLength_3045, &_call_ctor_QTextLength_3045);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QTextLength::operator!=(const QTextLength &other)\n", true, &_init_f_operator_excl__eq__c2425, &_call_f_operator_excl__eq__c2425);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QTextLength::operator==(const QTextLength &other)\n", true, &_init_f_operator_eq__eq__c2425, &_call_f_operator_eq__eq__c2425);
  methods += new qt_gsi::GenericMethod ("rawValue", "@brief Method double QTextLength::rawValue()\n", true, &_init_f_rawValue_c0, &_call_f_rawValue_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method QTextLength::Type QTextLength::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("value", "@brief Method double QTextLength::value(double maximumLength)\n", true, &_init_f_value_c1071, &_call_f_value_c1071);
  return methods;
}

gsi::Class<QTextLength> decl_QTextLength ("QtGui", "QTextLength",
  methods_QTextLength (),
  "@qt\n@brief Binding of QTextLength");


GSI_QTGUI_PUBLIC gsi::Class<QTextLength> &qtdecl_QTextLength () { return decl_QTextLength; }

}


//  Implementation of the enum wrapper class for QTextLength::Type
namespace qt_gsi
{

static gsi::Enum<QTextLength::Type> decl_QTextLength_Type_Enum ("QtGui", "QTextLength_Type",
    gsi::enum_const ("VariableLength", QTextLength::VariableLength, "@brief Enum constant QTextLength::VariableLength") +
    gsi::enum_const ("FixedLength", QTextLength::FixedLength, "@brief Enum constant QTextLength::FixedLength") +
    gsi::enum_const ("PercentageLength", QTextLength::PercentageLength, "@brief Enum constant QTextLength::PercentageLength"),
  "@qt\n@brief This class represents the QTextLength::Type enum");

static gsi::QFlagsClass<QTextLength::Type > decl_QTextLength_Type_Enums ("QtGui", "QTextLength_QFlags_Type",
  "@qt\n@brief This class represents the QFlags<QTextLength::Type> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextLength> inject_QTextLength_Type_Enum_in_parent (decl_QTextLength_Type_Enum.defs ());
static gsi::ClassExt<QTextLength> decl_QTextLength_Type_Enum_as_child (decl_QTextLength_Type_Enum, "Type");
static gsi::ClassExt<QTextLength> decl_QTextLength_Type_Enums_as_child (decl_QTextLength_Type_Enums, "QFlags_Type");

}

