/* r1_sub.c
 *
 * By Byron C. Darrah
 * 10-May-1994, Tuesday
 *
 * This is a short program for testing the system-dependent
 * display_list routines.  It substitues itself for render1 (hence the
 * name, r1_sub) by calling the display routines directly.
 *
 * If the test is successfull, r1_sub will display a blue rectangle on
 * top of a red diamond.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>

#include "display_list.h"

polygon_t diamond;
polygon_t rectangle;
int_point_t diamond_points[] =
{
   {100, 25},
   {150, 100},
   {100, 175},
   { 50, 100}
};
int_point_t rectangle_points[] =
{
   {50, 50},
   {100, 50},
   {100, 100},
   {50, 100}
};

int main(int argc, char *argv[])
{
   polygon_node_t polys[2];
   polys[0].next = polys+1;
   polys[1].next = NULL;
   polys[0].k = 6.0;
   polys[1].k = 1.0;
   
   polys[0].polygon = &diamond;
   polys[1].polygon = &rectangle;

   diamond.color   = RED;
   diamond.npoints = 4;
   diamond.int_points = diamond_points;

   rectangle.color   = BLUE;
   rectangle.npoints = 4;
   rectangle.int_points = rectangle_points;

   disp_init(&argc, argv);

   disp_polygons(polys);
 
   disp_freeze();

   disp_end();

   return(0);
}
