import string
from types import IntType
def CheckBuilder(context, text=None, language=None):
    lang, suffix, msg=_lang2suffix(language)
    if msg:
        context.Display("%s\n" % msg)
        return msg
    if not text:
        text="""
                int main() {
                        return 0;
                    }\n\n"""
    context.Display("Checking if building a %s file works... " % lang)
    ret=context.BuildProg(text, suffix)
    _YesNoResult(context, ret, None, text)
    return ret
def CheckFunc(context, function_name, header=None, language=None):
    if context.headerfilename:
        includetext='#include "%s"' % context.headerfilename
    else:
        includetext=''
    if not header:
        header="""
                extern "C"
                char %s();""" % function_name
    lang, suffix, msg=_lang2suffix(language)
    if msg:
        context.Display("Cannot check for %s(): %s\n" % (function_name, msg))
        return msg
    text="""
            %(include)s
            %(hdr)s
            int main() {
                    fail fail fail
                    %(name)s();
                    return 0;
                }\n\n""" % { 'name': function_name,
                             'include': includetext,
                             'hdr': header }
    context.Display("Checking for %s function %s()... " % (lang, function_name))
    ret=context.BuildProg(text, suffix)
    _YesNoResult(context, ret, "HAVE_" + function_name, text)
    return ret
def CheckHeader(context, header_name, header=None, language=None,
                                                        include_quotes=None):
    if context.headerfilename:
        includetext='#include "%s"\n' % context.headerfilename
    else:
        includetext=''
    if not header:
        header=""
    lang, suffix, msg=_lang2suffix(language)
    if msg:
        context.Display("Cannot check for header file %s: %s\n"
                                                          % (header_name, msg))
        return msg
    if not include_quotes:
        include_quotes="<>"
    text="%s%s\n#include %s%s%s\n\n" % (includetext, header,
                             include_quotes[0], header_name, include_quotes[1])
    context.Display("Checking for %s header file %s... " % (lang, header_name))
    ret=context.CompileProg(text, suffix)
    _YesNoResult(context, ret, "HAVE_" + header_name, text)
    return ret
def CheckType(context, type_name, fallback=None,
                                               header=None, language=None):
    if context.headerfilename:
        includetext='#include "%s"' % context.headerfilename
    else:
        includetext=''
    if not header:
        header=""
    lang, suffix, msg=_lang2suffix(language)
    if msg:
        context.Display("Cannot check for %s type: %s\n" % (type_name, msg))
        return msg
    text="""
            %(include)s
            %(header)s
            int main() {
                    if ((%(name)s *) 0)
                            return 0;
                    if (sizeof (%(name)s))
                            return 0;
            }\n\n""" % { 'include': includetext,
                         'header': header,
                         'name': type_name }
    context.Display("Checking for %s type %s... " % (lang, type_name))
    ret=context.BuildProg(text, suffix)
    _YesNoResult(context, ret, "HAVE_" + type_name, text)
    if ret and fallback and context.headerfilename:
        f=open(context.headerfilename, "a")
        f.write("typedef %s %s;\n" % (fallback, type_name))
        f.close()
    return ret
def CheckLib(context, libs, func_name, header=None,
                 extra_libs=None, call=None, language=None, autoadd=1):
    if context.headerfilename:
        includetext='#include "%s"' % context.headerfilename
    else:
        includetext=''
    if not header:
        header=""
    text="""
            %s
            %s """ % (includetext, header)
    if func_name and func_name != "main" and not header:
        text=text + """
                extern "C"
                char %s();""" % func_name
    if not call:
        call="%s();" % func_name
    text=text + """
            int
            main() {
            %s
            return 0;
            }
            \n\n""" % call
    i=string.find(call, "\n")
    if i > 0:
        calltext=call[:i] + ".."
    elif call[-1]==';':
        calltext=call[:-1]
    else:
        calltext=call
    for lib_name in libs:
        lang, suffix, msg=_lang2suffix(language)
        if msg:
            context.Display("Cannot check for library %s: %s\n" % (lib_name, msg))
            return msg
        context.Display("Checking for %s in %s library %s... "
                        % (calltext, lang, lib_name))
        if lib_name:
            l=[ lib_name ]
            if extra_libs:
                l.extend(extra_libs)
            oldLIBS=context.AppendLIBS(l)
            sym="HAVE_LIB" + lib_name
        else:
            oldLIBS=-1
            sym=None
        ret=context.BuildProg(text, suffix)
        _YesNoResult(context, ret, sym, text)
        if oldLIBS != -1 and (ret or not autoadd):
            context.SetLIBS(oldLIBS)
            
        if ret=="":
            return ret
    return ret
def _YesNoResult(context, ret, key, text):
    if key:
        _Have(context, key, not ret)
    if ret:
        context.Display("no\n")
        _LogFailed(context, text, ret)
    else:
        context.Display("yes\n")
def _Have(context, key, have):
    key_up=string.upper(key)
    key_up=string.replace(key_up, ':', '_')
    key_up=string.replace(key_up, '.', '_')
    key_up=string.replace(key_up, '/', '_')
    key_up=string.replace(key_up, ' ', '_')
    context.havedict[key_up]=have
    if context.headerfilename:
        f=open(context.headerfilename, "a")
        if have==1:
            f.write("#define %s\n" % key_up)
        elif have==0:
            f.write("/* #undef %s */\n" % key_up)
        elif type(have)==IntType:
            f.write("#define %s %d\n" % (key_up, have))
        else:
            f.write("#define %s %s\n" % (key_up, str(have)))
        f.close()
def _LogFailed(context, text, msg):
    context.Log("Failed program was:\n")
    lines=string.split(text, '\n')
    if len(lines) and lines[-1]=='':
        lines=lines[:-1]
    n=1
    for line in lines:
        context.Log("%d: %s\n" % (n, line))
        n=n + 1
    context.Log("Error message: %s\n" % msg)
def _lang2suffix(lang):
    if not lang or lang in ["C", "c"]:
        return ("C", ".c", None)
    if lang in ["c++", "C++", "cpp", "CXX", "cxx"]:
        return ("C++", ".cpp", None)
    return None, None, "Unsupported language: %s" % lang
