/*
 * Decompiled with CFR 0.152.
 */
import Ice.Communicator;
import Ice.ObjectPrx;
import Test.Base;
import Test.KnownDerived;
import Test.KnownIntermediate;
import Test.KnownMostDerived;
import Test.TestIntfPrx;
import Test.TestIntfPrxHelper;
import java.io.PrintStream;

public class AllTests {
    private static void test(boolean bl) {
        if (!bl) {
            throw new RuntimeException();
        }
    }

    public static TestIntfPrx allTests(Communicator communicator, boolean bl, PrintStream printStream) {
        printStream.print("testing stringToProxy... ");
        printStream.flush();
        String string = communicator.getProperties().getPropertyWithDefault("Test.Proxy", "Test:default -p 12010 -t 2000");
        ObjectPrx objectPrx = communicator.stringToProxy(string);
        AllTests.test(objectPrx != null);
        printStream.println("ok");
        printStream.print("testing checked cast... ");
        printStream.flush();
        TestIntfPrx testIntfPrx = TestIntfPrxHelper.checkedCast(objectPrx);
        AllTests.test(testIntfPrx != null);
        AllTests.test(testIntfPrx.equals(objectPrx));
        printStream.println("ok");
        printStream.print("base... ");
        printStream.flush();
        try {
            testIntfPrx.baseAsBase();
            AllTests.test(false);
        }
        catch (Base base) {
            AllTests.test(base.b.equals("Base.b"));
            AllTests.test(base.ice_name().equals("Test::Base"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of unknown derived... ");
        printStream.flush();
        try {
            testIntfPrx.unknownDerivedAsBase();
            AllTests.test(false);
        }
        catch (Base base) {
            AllTests.test(base.b.equals("UnknownDerived.b"));
            AllTests.test(base.ice_name().equals("Test::Base"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("non-slicing of known derived as base... ");
        printStream.flush();
        try {
            testIntfPrx.knownDerivedAsBase();
            AllTests.test(false);
        }
        catch (KnownDerived knownDerived) {
            AllTests.test(knownDerived.b.equals("KnownDerived.b"));
            AllTests.test(knownDerived.kd.equals("KnownDerived.kd"));
            AllTests.test(knownDerived.ice_name().equals("Test::KnownDerived"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("non-slicing of known derived as derived... ");
        printStream.flush();
        try {
            testIntfPrx.knownDerivedAsKnownDerived();
            AllTests.test(false);
        }
        catch (KnownDerived knownDerived) {
            AllTests.test(knownDerived.b.equals("KnownDerived.b"));
            AllTests.test(knownDerived.kd.equals("KnownDerived.kd"));
            AllTests.test(knownDerived.ice_name().equals("Test::KnownDerived"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of unknown intermediate as base... ");
        printStream.flush();
        try {
            testIntfPrx.unknownIntermediateAsBase();
            AllTests.test(false);
        }
        catch (Base base) {
            AllTests.test(base.b.equals("UnknownIntermediate.b"));
            AllTests.test(base.ice_name().equals("Test::Base"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of known intermediate as base... ");
        printStream.flush();
        try {
            testIntfPrx.knownIntermediateAsBase();
            AllTests.test(false);
        }
        catch (KnownIntermediate knownIntermediate) {
            AllTests.test(knownIntermediate.b.equals("KnownIntermediate.b"));
            AllTests.test(knownIntermediate.ki.equals("KnownIntermediate.ki"));
            AllTests.test(knownIntermediate.ice_name().equals("Test::KnownIntermediate"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of known most derived as base... ");
        printStream.flush();
        try {
            testIntfPrx.knownMostDerivedAsBase();
            AllTests.test(false);
        }
        catch (KnownMostDerived knownMostDerived) {
            AllTests.test(knownMostDerived.b.equals("KnownMostDerived.b"));
            AllTests.test(knownMostDerived.ki.equals("KnownMostDerived.ki"));
            AllTests.test(knownMostDerived.kmd.equals("KnownMostDerived.kmd"));
            AllTests.test(knownMostDerived.ice_name().equals("Test::KnownMostDerived"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("non-slicing of known intermediate as intermediate... ");
        printStream.flush();
        try {
            testIntfPrx.knownIntermediateAsKnownIntermediate();
            AllTests.test(false);
        }
        catch (KnownIntermediate knownIntermediate) {
            AllTests.test(knownIntermediate.b.equals("KnownIntermediate.b"));
            AllTests.test(knownIntermediate.ki.equals("KnownIntermediate.ki"));
            AllTests.test(knownIntermediate.ice_name().equals("Test::KnownIntermediate"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("non-slicing of known most derived as intermediate... ");
        printStream.flush();
        try {
            testIntfPrx.knownMostDerivedAsKnownIntermediate();
            AllTests.test(false);
        }
        catch (KnownMostDerived knownMostDerived) {
            AllTests.test(knownMostDerived.b.equals("KnownMostDerived.b"));
            AllTests.test(knownMostDerived.ki.equals("KnownMostDerived.ki"));
            AllTests.test(knownMostDerived.kmd.equals("KnownMostDerived.kmd"));
            AllTests.test(knownMostDerived.ice_name().equals("Test::KnownMostDerived"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("non-slicing of known most derived as most derived... ");
        printStream.flush();
        try {
            testIntfPrx.knownMostDerivedAsKnownMostDerived();
            AllTests.test(false);
        }
        catch (KnownMostDerived knownMostDerived) {
            AllTests.test(knownMostDerived.b.equals("KnownMostDerived.b"));
            AllTests.test(knownMostDerived.ki.equals("KnownMostDerived.ki"));
            AllTests.test(knownMostDerived.kmd.equals("KnownMostDerived.kmd"));
            AllTests.test(knownMostDerived.ice_name().equals("Test::KnownMostDerived"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of unknown most derived, known intermediate as base... ");
        printStream.flush();
        try {
            testIntfPrx.unknownMostDerived1AsBase();
            AllTests.test(false);
        }
        catch (KnownIntermediate knownIntermediate) {
            AllTests.test(knownIntermediate.b.equals("UnknownMostDerived1.b"));
            AllTests.test(knownIntermediate.ki.equals("UnknownMostDerived1.ki"));
            AllTests.test(knownIntermediate.ice_name().equals("Test::KnownIntermediate"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of unknown most derived, known intermediate as intermediate... ");
        printStream.flush();
        try {
            testIntfPrx.unknownMostDerived1AsKnownIntermediate();
            AllTests.test(false);
        }
        catch (KnownIntermediate knownIntermediate) {
            AllTests.test(knownIntermediate.b.equals("UnknownMostDerived1.b"));
            AllTests.test(knownIntermediate.ki.equals("UnknownMostDerived1.ki"));
            AllTests.test(knownIntermediate.ice_name().equals("Test::KnownIntermediate"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("slicing of unknown most derived, unknown intermediate thrown as base... ");
        printStream.flush();
        try {
            testIntfPrx.unknownMostDerived2AsBase();
            AllTests.test(false);
        }
        catch (Base base) {
            AllTests.test(base.b.equals("UnknownMostDerived2.b"));
            AllTests.test(base.ice_name().equals("Test::Base"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        return testIntfPrx;
    }
}

