/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.LoggerI;
import Ice.Properties;
import Ice.RouterPrxHelper;
import Ice.StringSeqHolder;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactory;
import IceInternal.LocatorManager;
import IceInternal.ObjectAdapterFactory;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProxyFactory;
import IceInternal.ReferenceFactory;
import IceInternal.RouterManager;
import IceInternal.TraceLevels;
import IceUtil.Debug;
import java.util.Enumeration;
import java.util.Hashtable;

public class Instance {
    private static final int StateActive = 0;
    private static final int StateDestroyInProgress = 1;
    private static final int StateDestroyed = 2;
    private int _state = 0;
    private final Properties _properties;
    private Logger _logger;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ObjectAdapterFactory _objectAdapterFactory;
    private final int _threadPerConnectionStackSize;
    private EndpointFactory _endpointFactory;
    private Hashtable _defaultContext;
    private static Hashtable _emptyContext = new Hashtable();
    private static boolean _oneOffDone = false;

    public Properties properties() {
        return this._properties;
    }

    public synchronized Logger logger() {
        return this._logger;
    }

    public synchronized void logger(Logger logger) {
        this._logger = logger;
    }

    public TraceLevels traceLevels() {
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._referenceFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._outgoingConnectionFactory;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._objectAdapterFactory;
    }

    public int threadPerConnectionStackSize() {
        return this._threadPerConnectionStackSize;
    }

    public synchronized EndpointFactory endpointFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._endpointFactory;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public void setDefaultContext(Hashtable hashtable) {
        if (hashtable == null || hashtable.isEmpty()) {
            this._defaultContext = _emptyContext;
        } else {
            this._defaultContext = new Hashtable(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this._defaultContext.put(k, hashtable.get(k));
            }
        }
    }

    public Hashtable getDefaultContext() {
        if (this._defaultContext.isEmpty()) {
            return new Hashtable();
        }
        Hashtable hashtable = new Hashtable(this._defaultContext.size());
        Enumeration enumeration = this._defaultContext.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this._defaultContext.get(k);
            hashtable.put(k, v);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ObjectAdapterFactory objectAdapterFactory;
        OutgoingConnectionFactory outgoingConnectionFactory;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            outgoingConnectionFactory = this._outgoingConnectionFactory;
            objectAdapterFactory = this._objectAdapterFactory;
        }
        outgoingConnectionFactory.flushBatchRequests();
        objectAdapterFactory.flushBatchRequests();
    }

    public Instance(Communicator communicator, Properties properties) {
        this._properties = properties;
        try {
            this._logger = new LoggerI(this._properties.getProperty("Ice.ProgramName"), this._properties.getPropertyAsInt("Ice.Logger.Timestamp") > 0);
            this.validatePackages();
            this._traceLevels = new TraceLevels(this._properties);
            this._defaultsAndOverrides = new DefaultsAndOverrides(this._properties);
            int n = this._properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
            this._messageSizeMax = n < 1 ? 0x100000 : (n > 0x1FFFFF ? Integer.MAX_VALUE : n * 1024);
            int n2 = this._properties.getPropertyAsInt("Ice.ThreadPerConnection.StackSize");
            if (n2 < 0) {
                n2 = 0;
            }
            this._threadPerConnectionStackSize = n2;
            this._routerManager = new RouterManager();
            this._locatorManager = new LocatorManager();
            this._referenceFactory = new ReferenceFactory(this, communicator);
            this._proxyFactory = new ProxyFactory(this);
            this._endpointFactory = new EndpointFactory(this);
            this._defaultContext = _emptyContext;
            this._outgoingConnectionFactory = new OutgoingConnectionFactory(this);
            this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
        }
        catch (LocalException localException) {
            this.destroy();
            throw localException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Debug.FinalizerAssert(this._state == 2);
        Debug.FinalizerAssert(this._referenceFactory == null);
        Debug.FinalizerAssert(this._proxyFactory == null);
        Debug.FinalizerAssert(this._outgoingConnectionFactory == null);
        Debug.FinalizerAssert(this._objectAdapterFactory == null);
        Debug.FinalizerAssert(this._routerManager == null);
        Debug.FinalizerAssert(this._locatorManager == null);
        Debug.FinalizerAssert(this._endpointFactory == null);
    }

    public void finishSetup(StringSeqHolder stringSeqHolder) {
        if (this._defaultsAndOverrides.defaultRouter.length() > 0) {
            this._referenceFactory.setDefaultRouter(RouterPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultRouter)));
        }
        if (this._defaultsAndOverrides.defaultLocator.length() > 0) {
            this._referenceFactory.setDefaultLocator(LocatorPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultLocator)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Instance instance = this;
        synchronized (instance) {
            if (this._state != 0) {
                return;
            }
            this._state = 1;
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.shutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.destroy();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.waitForShutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.waitUntilFinished();
        }
        instance = this;
        synchronized (instance) {
            this._objectAdapterFactory = null;
            this._outgoingConnectionFactory = null;
            if (this._referenceFactory != null) {
                this._referenceFactory.destroy();
                this._referenceFactory = null;
            }
            this._proxyFactory = null;
            if (this._routerManager != null) {
                this._routerManager.destroy();
                this._routerManager = null;
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
                this._locatorManager = null;
            }
            if (this._endpointFactory != null) {
                this._endpointFactory.destroy();
                this._endpointFactory = null;
            }
            this._state = 2;
        }
    }

    private void validatePackages() {
        Hashtable hashtable = this._properties.getPropertiesForPrefix("Ice.Package.");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string.length() == "Ice.Package.".length()) {
                this._logger.warning("ignoring invalid property: " + string + "=" + string2);
            }
            String string3 = string.substring("Ice.Package.".length());
            String string4 = string2 + "." + string3 + "._Marker";
            try {
                Class.forName(string4);
            }
            catch (Exception exception) {
                this._logger.warning("unable to validate package: " + string + "=" + string2);
            }
        }
    }
}

