/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.BadMagicException;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectTimeoutException;
import Ice.ConnectionLostException;
import Ice.ConnectionNotValidatedException;
import Ice.FeatureNotSupportedException;
import Ice.ForcedCloseConnectionException;
import Ice.IllegalMessageSizeException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MemoryLimitException;
import Ice.NegativeSizeException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.OperationMode;
import Ice.SyscallException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownMessageException;
import Ice.UnknownRequestIdException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.Endpoint;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.IntMap;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Outgoing;
import IceInternal.Protocol;
import IceInternal.Reference;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import IceUtil.AssertionError;
import java.util.Hashtable;

public final class Connection {
    private static final byte[] _requestHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] _requestBatchHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] _replyHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 2, 0, 0, 0, 0, 0};
    private Thread _threadPerConnection;
    private Instance _instance;
    private Transceiver _transceiver;
    private String _desc;
    private String _type;
    private Endpoint _endpoint;
    private BasicStream _stream;
    private Incoming _in;
    private Logger _logger;
    private TraceLevels _traceLevels;
    private boolean _warn;
    private LocalException _exception;
    private BasicStream _batchStream;
    private boolean _batchStreamInUse;
    private int _batchRequestNum;
    private int _dispatchCount;
    private int _state;
    private long _stateTime;
    private boolean _blocking;
    private Object _sendMonitor = new Object();
    private int _nextRequestId;
    private IntMap _requests = new IntMap();
    private Outgoing _outgoingCache;
    private Object _outgoingCacheMutex = new Object();

    public synchronized void waitForValidation() {
        while (this._state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._state >= 3) {
            throw this._exception;
        }
    }

    public synchronized void activate() {
        this.setState(1);
    }

    public synchronized void hold() {
        this.setState(2);
    }

    public synchronized void destroy(int n) {
        switch (n) {
            case 0: {
                this.setState(3, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(3, new CommunicatorDestroyedException());
            }
        }
    }

    public synchronized boolean isDestroyed() {
        return this._state >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Thread thread = null;
        Connection connection = this;
        synchronized (connection) {
            if (this._transceiver != null || this._dispatchCount != 0 || this._threadPerConnection != null && this._threadPerConnection.isAlive()) {
                return false;
            }
            thread = this._threadPerConnection;
            this._threadPerConnection = null;
        }
        if (thread != null) {
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        Thread thread = null;
        Connection connection = this;
        synchronized (connection) {
            while (this._state < 3 || this._dispatchCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this._transceiver != null) {
                try {
                    if (this._state != 4 && this._endpoint.timeout() >= 0) {
                        long l = this._stateTime + (long)this._endpoint.timeout();
                        long l2 = l - System.currentTimeMillis();
                        if (l2 > 0L) {
                            this.wait(l2);
                            if (System.currentTimeMillis() < l) continue;
                            this.setState(4, new CloseTimeoutException());
                            continue;
                        }
                        this.setState(4, new CloseTimeoutException());
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            thread = this._threadPerConnection;
            this._threadPerConnection = null;
        }
        if (thread != null) {
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public byte[] getRequestHeader() {
        return _requestHdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(BasicStream basicStream, Outgoing outgoing) throws LocalExceptionWrapper {
        boolean bl = false;
        try {
            Object object = this._sendMonitor;
            synchronized (object) {
                if (this._transceiver == null) {
                    throw new LocalExceptionWrapper(this._exception, true);
                }
                int n = 0;
                if (outgoing != null) {
                    if ((n = this._nextRequestId++) <= 0) {
                        this._nextRequestId = 1;
                        n = this._nextRequestId++;
                    }
                    basicStream.pos(14);
                    basicStream.writeInt(n);
                    this._requests.put(n, outgoing);
                }
                basicStream.pos(10);
                basicStream.writeInt(basicStream.size());
                TraceUtil.traceRequest("sending request", basicStream, this._logger, this._traceLevels);
                this._transceiver.write(basicStream, this._endpoint.timeout());
                bl = true;
                if (outgoing == null) {
                    return;
                }
                if (this._blocking) {
                    basicStream.reset();
                    MessageInfo messageInfo = new MessageInfo();
                    this.readStreamAndParseMessage(basicStream, messageInfo);
                    if (messageInfo.invokeNum > 0) {
                        throw new UnknownMessageException();
                    }
                    if (messageInfo.requestId != n) {
                        throw new UnknownRequestIdException();
                    }
                    outgoing.finished(basicStream);
                } else {
                    int n2 = this.timeout();
                    long l = 0L;
                    if (n2 > 0) {
                        l = System.currentTimeMillis() + (long)n2;
                    }
                    while (outgoing.state() == 1) {
                        try {
                            if (n2 > 0) {
                                long l2 = System.currentTimeMillis();
                                if (l2 < l) {
                                    this._sendMonitor.wait(l - l2);
                                }
                                if (outgoing.state() != 1 || System.currentTimeMillis() <= l) continue;
                                throw new TimeoutException();
                            }
                            this._sendMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (LocalException localException) {
            Object object = this;
            synchronized (object) {
                this.setState(4, localException);
                if (!bl) {
                    throw this._exception;
                }
            }
            object = this._sendMonitor;
            synchronized (object) {
                if (this._blocking) {
                    outgoing.finished(localException);
                } else {
                    while (outgoing.state() == 1) {
                        try {
                            this._sendMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public synchronized void prepareBatchRequest(BasicStream basicStream) {
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._batchStream.isEmpty()) {
            try {
                this._batchStream.writeBlob(_requestBatchHdr);
            }
            catch (LocalException localException) {
                this.setState(4, localException);
                throw localException;
            }
        }
        this._batchStreamInUse = true;
        this._batchStream.swap(basicStream);
    }

    public synchronized void finishBatchRequest(BasicStream basicStream) {
        this._batchStream.swap(basicStream);
        ++this._batchRequestNum;
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    public synchronized void abortBatchRequest() {
        this._batchStream = new BasicStream(this._instance);
        this._batchRequestNum = 0;
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(BasicStream basicStream) {
        Object object;
        try {
            object = this._sendMonitor;
            synchronized (object) {
                if (this._transceiver == null) {
                    throw this._exception;
                }
                basicStream.pos(9);
                basicStream.writeByte((byte)0);
                basicStream.pos(10);
                basicStream.writeInt(basicStream.size());
                TraceUtil.traceReply("sending reply", basicStream, this._logger, this._traceLevels);
                this._transceiver.write(basicStream, this._endpoint.timeout());
            }
        }
        catch (LocalException localException) {
            Connection connection = this;
            synchronized (connection) {
                this.setState(4, localException);
            }
        }
        object = this;
        synchronized (object) {
            try {
                if (--this._dispatchCount == 0) {
                    this.notifyAll();
                }
                if (this._state == 3 && this._dispatchCount == 0) {
                    this.initiateShutdown();
                }
            }
            catch (LocalException localException) {
                this.setState(4, localException);
            }
        }
    }

    public synchronized void sendNoResponse() {
        try {
            if (--this._dispatchCount == 0) {
                this.notifyAll();
            }
            if (this._state == 3 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
        }
        catch (LocalException localException) {
            this.setState(4, localException);
        }
    }

    public Endpoint endpoint() {
        return this._endpoint;
    }

    public synchronized void setAdapter(ObjectAdapter objectAdapter) {
        if (this._blocking) {
            FeatureNotSupportedException featureNotSupportedException = new FeatureNotSupportedException();
            featureNotSupportedException.unsupportedFeature = "setAdapter with blocking connection";
            throw featureNotSupportedException;
        }
        while (this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        this._in.setAdapter(objectAdapter);
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._in.getAdapter();
    }

    public int timeout() {
        return this._endpoint.timeout();
    }

    public String toString() {
        return this._desc;
    }

    public Connection(Instance instance, Transceiver transceiver, Endpoint endpoint, ObjectAdapter objectAdapter) {
        this._instance = instance;
        this._transceiver = transceiver;
        this._desc = transceiver.toString();
        this._type = transceiver.type();
        this._endpoint = endpoint;
        this._logger = instance.logger();
        this._traceLevels = instance.traceLevels();
        this._warn = this._instance.properties().getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._nextRequestId = 1;
        this._batchStream = new BasicStream(instance);
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._dispatchCount = 0;
        this._state = 0;
        this._stateTime = System.currentTimeMillis();
        this._blocking = this._instance.properties().getPropertyAsInt("Ice.Blocking") > 0 && objectAdapter == null;
        this._stream = new BasicStream(this._instance);
        this._in = new Incoming(this._instance, this, this._stream, objectAdapter);
        if (this._blocking) {
            this.validate();
        } else {
            try {
                this._threadPerConnection = new ThreadPerConnection(this);
                this._threadPerConnection.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = "cannot create thread for connection:\n";
                string = string + exception.toString();
                this._instance.logger().error(string);
                try {
                    this._transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
                SyscallException syscallException = new SyscallException();
                syscallException.initCause(exception);
                throw syscallException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        boolean bl;
        Connection connection = this;
        synchronized (connection) {
            if (this._state == 4) {
                throw this._exception;
            }
            bl = this._in.getAdapter() != null;
        }
        try {
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            int n = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : this._endpoint.timeout();
            if (bl) {
                Object object = this._sendMonitor;
                synchronized (object) {
                    BasicStream basicStream = new BasicStream(this._instance);
                    basicStream.writeBlob(Protocol.magic);
                    basicStream.writeByte((byte)1);
                    basicStream.writeByte((byte)0);
                    basicStream.writeByte((byte)1);
                    basicStream.writeByte((byte)0);
                    basicStream.writeByte((byte)3);
                    basicStream.writeByte((byte)0);
                    basicStream.writeInt(14);
                    TraceUtil.traceHeader("sending validate connection", basicStream, this._logger, this._traceLevels);
                    try {
                        this._transceiver.write(basicStream, n);
                    }
                    catch (TimeoutException timeoutException) {
                        throw new ConnectTimeoutException();
                    }
                }
            }
            BasicStream basicStream = new BasicStream(this._instance);
            basicStream.resize(14, true);
            basicStream.pos(0);
            try {
                this._transceiver.read(basicStream, n);
            }
            catch (TimeoutException timeoutException) {
                throw new ConnectTimeoutException();
            }
            basicStream.pos(0);
            byte[] byArray = basicStream.readBlob(4);
            if (byArray[0] != Protocol.magic[0] || byArray[1] != Protocol.magic[1] || byArray[2] != Protocol.magic[2] || byArray[3] != Protocol.magic[3]) {
                BadMagicException badMagicException = new BadMagicException();
                badMagicException.badMagic = byArray;
                throw badMagicException;
            }
            int n2 = basicStream.readByte();
            int n3 = basicStream.readByte();
            if (n2 != 1) {
                UnsupportedProtocolException unsupportedProtocolException = new UnsupportedProtocolException();
                unsupportedProtocolException.badMajor = n2 < 0 ? n2 + 255 : n2;
                unsupportedProtocolException.badMinor = n3 < 0 ? n3 + 255 : n3;
                unsupportedProtocolException.major = 1;
                unsupportedProtocolException.minor = 0;
                throw unsupportedProtocolException;
            }
            int n4 = basicStream.readByte();
            int n5 = basicStream.readByte();
            if (n4 != 1) {
                UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException();
                unsupportedEncodingException.badMajor = n4 < 0 ? n4 + 255 : n4;
                unsupportedEncodingException.badMinor = n5 < 0 ? n5 + 255 : n5;
                unsupportedEncodingException.major = 1;
                unsupportedEncodingException.minor = 0;
                throw unsupportedEncodingException;
            }
            byte by = basicStream.readByte();
            if (by != 3) {
                throw new ConnectionNotValidatedException();
            }
            byte by2 = basicStream.readByte();
            int n6 = basicStream.readInt();
            if (n6 != 14) {
                throw new IllegalMessageSizeException();
            }
            TraceUtil.traceHeader("received validate connection", basicStream, this._logger, this._traceLevels);
        }
        catch (LocalException localException) {
            Connection connection2 = this;
            synchronized (connection2) {
                this.setState(4, localException);
                throw this._exception;
            }
        }
        Connection connection3 = this;
        synchronized (connection3) {
            this.setState(2);
        }
    }

    private void setState(int n, LocalException localException) {
        if (this._state == n) {
            return;
        }
        if (this._exception == null) {
            this._exception = localException;
            if (!(!this._warn || this._state <= 0 || this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state == 3)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        if (this._state == 0 && n == 3) {
            n = 4;
        }
        if (this._state == n) {
            return;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (this._state == 2 || this._state == 0) break;
                return;
            }
            case 2: {
                if (this._state == 1 || this._state == 0) break;
                return;
            }
            case 3: {
                if (this._state != 4) break;
                return;
            }
            case 4: {
                this._transceiver.shutdownReadWrite();
                if (!this._blocking) break;
                Object object = this._sendMonitor;
                synchronized (object) {
                    try {
                        this._transceiver.close();
                    }
                    catch (LocalException localException) {
                        // empty catch block
                    }
                    this._transceiver = null;
                    break;
                }
            }
        }
        this._state = n;
        this._stateTime = System.currentTimeMillis();
        this.notifyAll();
        if (this._state == 3 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
                if (this._blocking) {
                    this.setState(4);
                }
            }
            catch (LocalException localException) {
                this.setState(4, localException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateShutdown() {
        Object object = this._sendMonitor;
        synchronized (object) {
            BasicStream basicStream = new BasicStream(this._instance);
            basicStream.writeBlob(Protocol.magic);
            basicStream.writeByte((byte)1);
            basicStream.writeByte((byte)0);
            basicStream.writeByte((byte)1);
            basicStream.writeByte((byte)0);
            basicStream.writeByte((byte)4);
            basicStream.writeByte((byte)0);
            basicStream.writeInt(14);
            TraceUtil.traceHeader("sending close connection", basicStream, this._logger, this._traceLevels);
            this._transceiver.write(basicStream, this._endpoint.timeout());
        }
    }

    private void readStreamAndParseMessage(BasicStream basicStream, MessageInfo messageInfo) {
        basicStream.resize(14, true);
        basicStream.pos(0);
        this._transceiver.read(basicStream, this._blocking ? this._endpoint.timeout() : -1);
        int n = basicStream.pos();
        basicStream.pos(0);
        byte[] byArray = basicStream.readBlob(4);
        if (byArray[0] != Protocol.magic[0] || byArray[1] != Protocol.magic[1] || byArray[2] != Protocol.magic[2] || byArray[3] != Protocol.magic[3]) {
            BadMagicException badMagicException = new BadMagicException();
            badMagicException.badMagic = byArray;
            throw badMagicException;
        }
        int n2 = basicStream.readByte();
        int n3 = basicStream.readByte();
        if (n2 != 1) {
            UnsupportedProtocolException unsupportedProtocolException = new UnsupportedProtocolException();
            unsupportedProtocolException.badMajor = n2 < 0 ? n2 + 255 : n2;
            unsupportedProtocolException.badMinor = n3 < 0 ? n3 + 255 : n3;
            unsupportedProtocolException.major = 1;
            unsupportedProtocolException.minor = 0;
            throw unsupportedProtocolException;
        }
        int n4 = basicStream.readByte();
        int n5 = basicStream.readByte();
        if (n4 != 1) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException();
            unsupportedEncodingException.badMajor = n4 < 0 ? n4 + 255 : n4;
            unsupportedEncodingException.badMinor = n5 < 0 ? n5 + 255 : n5;
            unsupportedEncodingException.major = 1;
            unsupportedEncodingException.minor = 0;
            throw unsupportedEncodingException;
        }
        byte by = basicStream.readByte();
        byte by2 = basicStream.readByte();
        if (by2 == 2) {
            FeatureNotSupportedException featureNotSupportedException = new FeatureNotSupportedException();
            featureNotSupportedException.unsupportedFeature = "compression";
            throw featureNotSupportedException;
        }
        int n6 = basicStream.readInt();
        if (n6 < 14) {
            throw new IllegalMessageSizeException();
        }
        if (n6 > this._instance.messageSizeMax()) {
            throw new MemoryLimitException();
        }
        if (n6 > basicStream.size()) {
            basicStream.resize(n6, true);
        }
        basicStream.pos(n);
        if (n != basicStream.size()) {
            this._transceiver.read(basicStream, this._blocking ? this._endpoint.timeout() : -1);
        }
        basicStream.pos(14);
        switch (by) {
            case 4: {
                TraceUtil.traceHeader("received close connection", basicStream, this._logger, this._traceLevels);
                throw new CloseConnectionException();
            }
            case 2: {
                TraceUtil.traceReply("received reply", basicStream, this._logger, this._traceLevels);
                messageInfo.requestId = basicStream.readInt();
                break;
            }
            case 0: {
                TraceUtil.traceRequest("received request", basicStream, this._logger, this._traceLevels);
                messageInfo.requestId = basicStream.readInt();
                messageInfo.invokeNum = 1;
                break;
            }
            case 1: {
                TraceUtil.traceBatchRequest("received batch request", basicStream, this._logger, this._traceLevels);
                messageInfo.invokeNum = basicStream.readInt();
                if (messageInfo.invokeNum >= 0) break;
                messageInfo.invokeNum = 0;
                throw new NegativeSizeException();
            }
            case 3: {
                TraceUtil.traceHeader("received validate connection", basicStream, this._logger, this._traceLevels);
                if (!this._warn) break;
                this._logger.warning("ignoring unexpected validate connection message:\n" + this._desc);
                break;
            }
            default: {
                TraceUtil.traceHeader("received unexpected message\n(invalid, closing connection)", basicStream, this._logger, this._traceLevels);
                throw new UnknownMessageException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.validate();
        }
        catch (LocalException localException) {
            Connection connection = this;
            synchronized (connection) {
                Object object = this._sendMonitor;
                synchronized (object) {
                    try {
                        this._transceiver.close();
                    }
                    catch (LocalException localException2) {
                        // empty catch block
                    }
                    this._transceiver = null;
                    this.notifyAll();
                }
            }
            return;
        }
        this.activate();
        boolean bl = false;
        MessageInfo messageInfo = new MessageInfo();
        while (!bl) {
            Object object;
            Object object2;
            messageInfo.requestId = 0;
            messageInfo.invokeNum = 0;
            this._in.os().reset();
            this._in.is().reset();
            try {
                this.readStreamAndParseMessage(this._stream, messageInfo);
            }
            catch (LocalException localException) {
                object2 = this;
                synchronized (object2) {
                    this.setState(4, localException);
                }
            }
            Connection connection = this;
            synchronized (connection) {
                if (this._state != 4) {
                    if (messageInfo.invokeNum > 0) {
                        if (this._state == 3) {
                            TraceUtil.traceRequest("received " + (messageInfo.invokeNum > 1 ? "batch request" : "request") + " during closing\n" + "(ignored by server, client will retry)", this._stream, this._logger, this._traceLevels);
                            messageInfo.invokeNum = 0;
                        }
                        this._dispatchCount += messageInfo.invokeNum;
                    } else if (messageInfo.requestId > 0) {
                        try {
                            object2 = this._sendMonitor;
                            synchronized (object2) {
                                object = (Outgoing)this._requests.remove(messageInfo.requestId);
                                if (object == null) {
                                    throw new UnknownRequestIdException();
                                }
                                ((Outgoing)object).finished(this._stream);
                                this._sendMonitor.notifyAll();
                            }
                        }
                        catch (LocalException localException) {
                            this.setState(4, localException);
                        }
                    }
                }
                while (this._state == 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._state == 4) {
                    object2 = this._sendMonitor;
                    synchronized (object2) {
                        try {
                            this._transceiver.close();
                        }
                        catch (LocalException localException) {
                            // empty catch block
                        }
                        this._transceiver = null;
                        this.notifyAll();
                    }
                    bl = true;
                }
                if (this._state == 4 || this._state == 3) {
                    object2 = this._sendMonitor;
                    synchronized (object2) {
                        object = this._requests.elements();
                        while (object.hasMoreElements()) {
                            IntMap.Entry entry = (IntMap.Entry)object.nextElement();
                            Outgoing outgoing = (Outgoing)entry.getValue();
                            outgoing.finished(this._exception);
                        }
                        this._requests.clear();
                        this._sendMonitor.notifyAll();
                    }
                }
            }
            try {
                while (messageInfo.invokeNum > 0) {
                    boolean bl2;
                    boolean bl3 = bl2 = messageInfo.requestId != 0;
                    if (bl2) {
                        object2 = this._in.os();
                        ((BasicStream)object2).writeBlob(_replyHdr);
                        ((BasicStream)object2).writeInt(messageInfo.requestId);
                    }
                    this._in.invoke(bl2);
                    --messageInfo.invokeNum;
                }
            }
            catch (LocalException localException) {
                object2 = this;
                synchronized (object2) {
                    this.setState(4, localException);
                }
            }
            catch (AssertionError assertionError) {
                object2 = this;
                synchronized (object2) {
                    object = new UnknownException();
                    ((UnknownException)object).unknown = assertionError.toString();
                    this._logger.error(((UnknownException)object).unknown);
                    this.setState(4, (LocalException)object);
                }
            }
            catch (Exception exception) {
                object2 = this;
                synchronized (object2) {
                    object = new UnknownException();
                    ((UnknownException)object).unknown = exception.toString();
                    this.setState(4, (LocalException)object);
                }
            }
            if (messageInfo.invokeNum <= 0) continue;
            Connection connection2 = this;
            synchronized (connection2) {
                this._dispatchCount -= messageInfo.invokeNum;
                if (this._dispatchCount == 0) {
                    this.notifyAll();
                }
            }
        }
    }

    public void warning(String string, Exception exception) {
        String string2 = string + ":\n" + exception.toString() + "\n" + this._desc;
        this._logger.warning(string2);
    }

    public void error(String string, Exception exception) {
        String string2 = string + ":\n" + exception.toString() + "\n" + this._desc;
        this._logger.error(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outgoing getOutgoing(Reference reference, String string, OperationMode operationMode, Hashtable hashtable) {
        Outgoing outgoing;
        Object object = this._outgoingCacheMutex;
        synchronized (object) {
            if (this._outgoingCache == null) {
                outgoing = new Outgoing(this, reference, string, operationMode, hashtable);
            } else {
                outgoing = this._outgoingCache;
                this._outgoingCache = this._outgoingCache.next;
                outgoing.reset(reference, string, operationMode, hashtable);
                outgoing.next = null;
            }
        }
        return outgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimOutgoing(Outgoing outgoing) {
        Object object = this._outgoingCacheMutex;
        synchronized (object) {
            outgoing.next = this._outgoingCache;
            this._outgoingCache = outgoing;
        }
    }

    private class ThreadPerConnection
    extends Thread {
        Connection _connection;

        ThreadPerConnection(Connection connection2) {
            this._connection = connection2;
        }

        public void run() {
            try {
                this._connection.run();
            }
            catch (Exception exception) {
                this._connection.error("exception in thread per connection", exception);
            }
        }
    }

    private static class MessageInfo {
        int invokeNum;
        int requestId;

        private MessageInfo() {
        }
    }
}

