/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpTransceiver;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

class TcpAcceptor
implements Acceptor {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;
    private Selector _selector;

    public ServerSocketChannel fd() {
        return this._fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Selector selector;
        ServerSocketChannel fd;
        if (this._traceLevels.network >= 1) {
            String s = "stopping to accept tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        TcpAcceptor tcpAcceptor = this;
        synchronized (tcpAcceptor) {
            fd = this._fd;
            selector = this._selector;
            this._fd = null;
            this._selector = null;
        }
        if (fd != null) {
            try {
                fd.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._traceLevels.network >= 1) {
            String s = "accepting tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
    }

    public Transceiver accept(int timeout) {
        SocketChannel fd = null;
        block6: while (fd == null) {
            try {
                fd = this._fd.accept();
                if (fd != null) continue;
                if (this._selector == null) {
                    this._selector = Selector.open();
                }
                while (true) {
                    try {
                        SelectionKey key = this._fd.register(this._selector, 16);
                        if (timeout > 0) {
                            if (this._selector.select(timeout) != 0) continue block6;
                            throw new TimeoutException();
                        }
                        if (timeout == 0) {
                            if (this._selector.selectNow() != 0) continue block6;
                            throw new TimeoutException();
                        }
                        this._selector.select();
                        continue block6;
                    }
                    catch (IOException ex) {
                        if (Network.interrupted(ex)) continue;
                        SocketException se = new SocketException();
                        se.initCause(ex);
                        throw se;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                if (Network.interrupted(ex)) continue;
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        Network.setBlock(fd, false);
        Network.setTcpBufSize(fd, this._instance.initializationData().properties, this._logger);
        try {
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        if (this._traceLevels.network >= 1) {
            String s = "accepted tcp connection\n" + Network.fdToString(fd);
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        return new TcpTransceiver(this._instance, fd);
    }

    public void connectToSelf() {
        SocketChannel fd = Network.createTcpSocket();
        Network.setBlock(fd, false);
        Network.doConnect(fd, this._addr, -1);
        Network.closeSocket(fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    final boolean equivalent(String host, int port) {
        InetSocketAddress addr = Network.getAddress(host, port);
        return addr.equals(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    TcpAcceptor(Instance instance, String host, int port) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._backlog = 0;
        if (this._backlog <= 0) {
            this._backlog = 5;
        }
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, this._instance.initializationData().properties, this._logger);
            this._addr = new InetSocketAddress(host, port);
            if (this._traceLevels.network >= 2) {
                String s = "attempting to bind to tcp socket " + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            this._addr = Network.doBind(this._fd, this._addr);
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

