/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import IceGridGUI.LiveDeployment.ShowLogDialog;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ShowLogPrefsDialog
extends JDialog {
    ShowLogPrefsDialog(final ShowLogDialog sld) {
        super(sld, "Preferences - IceGrid Admin", true);
        this.setDefaultCloseOperation(2);
        final JTextField maxLinesField = new JTextField(10);
        maxLinesField.setText(Integer.toString(sld.getMaxLines()));
        maxLinesField.setToolTipText("Maximum number of lines in this dialog's buffer");
        final JTextField maxSizeField = new JTextField(10);
        maxSizeField.setText(Integer.toString(sld.getMaxSize()));
        maxSizeField.setToolTipText("Maximum number of characters in this dialog's buffer");
        final JTextField initialLinesField = new JTextField(10);
        initialLinesField.setText(Integer.toString(sld.getInitialLines()));
        initialLinesField.setToolTipText("Start by retrieving <num> lines from the server; -1 means retrieve all");
        final JTextField maxReadSizeField = new JTextField(10);
        maxReadSizeField.setText(Integer.toString(sld.getMaxReadSize()));
        maxReadSizeField.setToolTipText("Maximum number of bytes read by each request");
        final JTextField periodField = new JTextField(10);
        periodField.setText(Float.toString((float)sld.getPeriod() / 1000.0f));
        periodField.setToolTipText("After reaching EOF, check every <num> seconds for new output");
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int maxLines = ShowLogPrefsDialog.this.parseInt(maxLinesField, "Max lines in buffer");
                    int maxSize = ShowLogPrefsDialog.this.parseInt(maxSizeField, "Max characters in buffer");
                    int initialLines = ShowLogPrefsDialog.this.parseInt(initialLinesField, "Initial tail (lines)");
                    int maxReadSize = ShowLogPrefsDialog.this.parseInt(maxReadSizeField, "Max bytes read per request");
                    int period = (int)(ShowLogPrefsDialog.this.parseFloat(periodField, "Poll period (seconds)") * 1000.0f);
                    sld.setPrefs(maxLines, maxSize, initialLines, maxReadSize, period);
                    ShowLogPrefsDialog.this.dispose();
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowLogPrefsDialog.this.dispose();
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.append("Max lines in buffer", (Component)maxLinesField);
        builder.nextLine();
        builder.append("Max characters in buffer", (Component)maxSizeField);
        builder.nextLine();
        builder.append("Initial tail (lines)", (Component)initialLinesField);
        builder.nextLine();
        builder.append("Max bytes read per request", (Component)maxReadSizeField);
        builder.nextLine();
        builder.append("Poll period (seconds)", (Component)periodField);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(sld);
        this.setVisible(true);
    }

    private int parseInt(JTextField field, String label) throws NumberFormatException {
        try {
            return Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, label + " must be an integer", "Invalid entry", 0);
            throw e;
        }
    }

    private float parseFloat(JTextField field, String label) throws NumberFormatException {
        try {
            return Float.parseFloat(field.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, label + " must be a decimal number", "Invalid entry", 0);
            throw e;
        }
    }
}

