/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import IceGrid.NodeInfo;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.TableField;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class NodeEditor
extends Editor {
    private JTextField _hostname = new JTextField(20);
    private JTextField _os = new JTextField(20);
    private JTextField _machineType = new JTextField(20);
    private JLabel _loadAverageLabel = new JLabel();
    private JTextField _loadAverage = new JTextField(20);
    private JButton _refreshButton;
    private TableField _loadFactor = new TableField("Application", "Value");
    private Node _target;

    NodeEditor() {
        this._hostname.setEditable(false);
        this._os.setEditable(false);
        this._machineType.setEditable(false);
        this._loadAverage.setEditable(false);
        AbstractAction refresh = new AbstractAction("Refresh"){

            public void actionPerformed(ActionEvent e) {
                NodeEditor.this._target.showLoad();
            }
        };
        refresh.putValue("ShortDescription", "Fetch the latest values from this IceGrid Node");
        this._refreshButton = new JButton(refresh);
    }

    void show(Node node) {
        this._target = node;
        NodeInfo info = node.getStaticInfo();
        if (info == null) {
            this._hostname.setText("Unknown");
            this._os.setText("Unknown");
            this._machineType.setText("Unknown");
            this._loadAverageLabel.setText("Load Average");
            this._loadAverage.setText("Unknown");
        } else {
            this._hostname.setText(info.hostname);
            this._os.setText(info.os + " " + info.release + " " + info.version);
            this._os.setCaretPosition(0);
            this._machineType.setText(info.machine + " with " + info.nProcessors + " CPU" + (info.nProcessors >= 2 ? "s" : ""));
            if (node.isRunningWindows()) {
                this._loadAverageLabel.setText("CPU Usage");
                this._loadAverage.setToolTipText("CPU usage in the past 1 min, 5 min and 15 min period");
            } else {
                this._loadAverageLabel.setText("Load Average");
                this._loadAverage.setToolTipText("Load average in the past 1 min, 5 min and 15 min period");
            }
            this._loadAverage.setText("Refreshing...");
            node.showLoad();
        }
        this._loadFactor.setSortedMap(node.getLoadFactors());
    }

    void setLoad(String load, Node node) {
        if (node == this._target) {
            this._loadAverage.setText(load);
        }
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("System Information");
        builder.append("Hostname");
        builder.append((Component)this._hostname, 3);
        builder.nextLine();
        builder.append("Operating System");
        builder.append((Component)this._os, 3);
        builder.nextLine();
        builder.append("Machine Type");
        builder.append((Component)this._machineType, 3);
        builder.append((Component)this._loadAverageLabel, (Component)this._loadAverage);
        builder.append(this._refreshButton);
        builder.nextLine();
        builder.appendSeparator("Configuration");
        builder.append("Load Factor");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._loadFactor);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Node Properties");
    }
}

