var webdeveloper_appliedStyles                   = new Array();
var webdeveloper_elementInformationBlockSelected = false;
var webdeveloper_informationElement              = null;
var webdeveloper_javaScriptCurrentTime           = null;
var webdeveloper_javaScriptPreviousTime          = null;
var webdeveloper_lineGuideSelected               = null;
var webdeveloper_outlineElement                  = null;
var webdeveloper_outlinedElements                = new Array();
var webdeveloper_rulerDrag                       = false;
var webdeveloper_rulerEndX                       = 0;
var webdeveloper_rulerEndY                       = 0;
var webdeveloper_rulerMove                       = false;
var webdeveloper_rulerMoveX                      = 0;
var webdeveloper_rulerMoveY                      = 0;
var webdeveloper_rulerResize                     = false;
var webdeveloper_rulerStartX                     = 0;
var webdeveloper_rulerStartY                     = 0;
var webdeveloper_selectedTab                     = -1;
var webdeveloper_userStyleSheet                  = null;

window.addEventListener("close", webdeveloper_uninitialize, true);
window.addEventListener("load", webdeveloper_initialize, true);

// Displays the about dialog
function webdeveloper_about()
{
    window.openDialog("chrome://webdeveloper/content/about/about.xul", "webdeveloper-about-dialog", "centerscreen,chrome,modal");
}

// Add applied style
function webdeveloper_addAppliedStyle(id)
{
    webdeveloper_appliedStyles.push(id);
}

// Adds the generated styles to a page
function webdeveloper_addGeneratedStyles(generatedDocument)
{
    var headElement  = generatedDocument.getElementsByTagName("head")[0];
    var linkElement  = generatedDocument.createElement("link");
    var styleElement = generatedDocument.createElement("style");

    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated/generated_content.css");
    linkElement.setAttribute("id", "webdeveloper-generated-content-stylesheet");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    headElement.appendChild(linkElement);

    styleElement.setAttribute("type", "text/css");
    styleElement.appendChild(generatedDocument.createTextNode("body, td, th { font-size: " + webdeveloper_getIntegerPreference("webdeveloper.generated.content.font.size", true) + "px !important; }"));
    headElement.appendChild(styleElement);
}

// Adds the style sheet at the given location with the given id
function webdeveloper_addStyleSheet(location, id, applyStyle)
{
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var headElementList = null;
    var linkElement     = null;
    var pageDocument    = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument    = documentList[i];
        headElementList = pageDocument.getElementsByTagName("head");
        linkElement     = pageDocument.createElement("link");

        linkElement.setAttribute("href", location);
        linkElement.setAttribute("id", id);
        linkElement.setAttribute("rel", "stylesheet");
        linkElement.setAttribute("type", "text/css");

        // If there is a head element
        if(headElementList.length > 0)
        {
            headElementList[0].appendChild(linkElement);
        }
        else
        {
            pageDocument.documentElement.appendChild(linkElement);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_addAppliedStyle(id);
    }
}

// Adjusts the position of the given element
function webdeveloper_adjustElementPosition(element, xPosition, yPosition, offset)
{
    // If the element is set
    if(element)
    {
        var clientHeight  = element.clientHeight;
        var clientWidth   = element.clientWidth;
        var contentWindow = getBrowser().contentWindow;
        var innerHeight   = contentWindow.innerHeight;
        var innerWidth    = contentWindow.innerWidth;
        var offsetX       = contentWindow.pageXOffset;
        var offsetY       = contentWindow.pageYOffset;

        // If the x position is less than 0
        if(xPosition < 0)
        {
            xPosition = 0;
        }

        // If the y position is less than 0
        if(yPosition < 0)
        {
            yPosition = 0;
        }

        // If the element will fit at the x position
        if((xPosition + clientWidth + offset + 5) < (innerWidth + offsetX))
        {
            element.style.left = xPosition + offset + "px";
        }
        else
        {
            element.style.left = (innerWidth + offsetX - clientWidth - offset) + "px";
        }

        // If the element will fit at the y position
        if((yPosition + clientHeight + offset + 5) < (innerHeight + offsetY))
        {
            element.style.top = yPosition + offset + "px";
        }
        else
        {
            element.style.top = (innerHeight + offsetY - clientHeight - offset) + "px";
        }
    }
}

// Applies all selected style sheets
function webdeveloper_applyStyleSheets(reset)
{
    var appliedStyle        = null;
    var appliedStylesLength = webdeveloper_appliedStyles.length;
    var element             = null;

    // Loop through the applied styles
    for(var i = 0; i < appliedStylesLength; i++)
    {
        appliedStyle = webdeveloper_appliedStyles[i];

        // Switch on the style
        switch(appliedStyle)
        {
            case "webdeveloper-add-user-style-sheet":
                element = document.getElementById("webdeveloper-add-user-style-sheet-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_addUserStyleSheet(element, false);
                break;
            case "webdeveloper-disable-all-styles":
                element = document.getElementById("webdeveloper-disable-all-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleStyles(element, false);
                break;
            case "webdeveloper-disable-browser-default-styles":
                element = document.getElementById("webdeveloper-disable-browser-default-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleBrowserDefaultStyles(element, false);
                break;
            case "webdeveloper-disable-embedded-styles":
                element = document.getElementById("webdeveloper-disable-embedded-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleEmbeddedStyles(element, false);
                break;
            case "webdeveloper-disable-inline-styles":
                element = document.getElementById("webdeveloper-disable-inline-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleInlineStyles(element, false);
                break;
            case "webdeveloper-disable-linked-styles":
                element = document.getElementById("webdeveloper-disable-linked-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleLinkedStyles(element, false);
                break;
            case "webdeveloper-disable-print-styles":
                element = document.getElementById("webdeveloper-disable-print-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_togglePrintStyles(element, false);
                break;
            case "webdeveloper-display-access-keys":
                element = document.getElementById("webdeveloper-display-access-keys-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAccessKeys(element, false);
                break;
            case "webdeveloper-display-alt-attributes":
                element = document.getElementById("webdeveloper-display-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAltAttributes(element, false);
                break;
            case "webdeveloper-display-anchors":
                element = document.getElementById("webdeveloper-display-anchors-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAnchors(element, false);
                break;
            case "webdeveloper-display-block-size":
                element = document.getElementById("webdeveloper-display-block-size-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayBlockSize(element, false);
                break;
            case "webdeveloper-display-div-order":
                element = document.getElementById("webdeveloper-display-div-order-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayDivOrder(element, false);
                break;
            case "webdeveloper-display-element-information":
                element = document.getElementById("webdeveloper-display-element-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayElementInformation(element, false);
                break;
            case "webdeveloper-display-current-size-title":
                element = document.getElementById("webdeveloper-display-current-size-title-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayWindowSizeInTitle(element, false);
                break;
            case "webdeveloper-display-form-details":
                element = document.getElementById("webdeveloper-display-form-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayFormDetails(element, false);
                break;
            case "webdeveloper-display-handheld-css":
                element = document.getElementById("webdeveloper-display-handheld-css-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayHandheldCSS(element, false);
                break;
            case "webdeveloper-display-id-class-details":
                element = document.getElementById("webdeveloper-display-id-class-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayIdClassDetails(element, false);
                break;
            case "webdeveloper-display-image-dimensions":
                element = document.getElementById("webdeveloper-display-image-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImageDimensions(element, false);
                break;
            case "webdeveloper-display-image-file-sizes":
                element = document.getElementById("webdeveloper-display-image-file-sizes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImageFileSizes(element, false);
                break;
            case "webdeveloper-display-image-paths":
                element = document.getElementById("webdeveloper-display-image-paths-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImagePaths(element, false);
                break;
            case "webdeveloper-display-link-details":
                element = document.getElementById("webdeveloper-display-link-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayLinkDetails(element, false);
                break;
            case "webdeveloper-display-object-information":
                element = document.getElementById("webdeveloper-display-object-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayObjectInformation(element, false);
                break;
            case "webdeveloper-display-print-css":
                element = document.getElementById("webdeveloper-display-print-css-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayPrintCSS(element, false);
                break;
            case "webdeveloper-display-ruler":
                element = document.getElementById("webdeveloper-display-ruler-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayRuler(element, false);
                break;
            case "webdeveloper-display-stack-levels":
                element = document.getElementById("webdeveloper-display-stack-levels-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayStackLevels(element, false);
                break;
            case "webdeveloper-display-tab-index":
                element = document.getElementById("webdeveloper-display-tab-index-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTabIndex(element, false);
                break;
            case "webdeveloper-display-table-depth":
                element = document.getElementById("webdeveloper-display-table-depth-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTableDepth(element, false);
                break;
            case "webdeveloper-display-table-information":
                element = document.getElementById("webdeveloper-display-table-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTableInformation(element, false);
                break;
            case "webdeveloper-display-title-attributes":
                element = document.getElementById("webdeveloper-display-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTitleAttributes(element, false);
                break;
            case "webdeveloper-display-topographic-information":
                element = document.getElementById("webdeveloper-display-topographic-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTopographicInformation(element, false);
                break;
            case "webdeveloper-hide-background-images":
                element = document.getElementById("webdeveloper-hide-background-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_hideBackgroundImages(element, false);
                break;
            case "webdeveloper-hide-images":
                element = document.getElementById("webdeveloper-hide-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_hideImages(element, "webdeveloper-hide-images", false);
                break;
            case "webdeveloper-linearize-page":
                element = document.getElementById("webdeveloper-linearize-page-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_linearizePage(element, false);
                break;
            case "webdeveloper-make-images-invisible":
                element = document.getElementById("webdeveloper-make-images-invisible-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_makeImagesInvisible(element, "webdeveloper-make-images-invisible", false);
                break;
            case "webdeveloper-outline-absolute-positioned-elements":
                element = document.getElementById("webdeveloper-outline-absolute-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("absolute", element, false);
                break;
            case "webdeveloper-outline-all-images":
                element = document.getElementById("webdeveloper-outline-all-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineAllImages(element, false);
                break;
            case "webdeveloper-outline-background-images":
                element = document.getElementById("webdeveloper-outline-background-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineBackgroundImages(element, true, false);
                break;
            case "webdeveloper-outline-block-level-elements":
                element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineBlockLevelElements(element, false);
                break;
            case "webdeveloper-outline-current-element":
                element = document.getElementById("webdeveloper-outline-current-element-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineCurrentElement(element, false);
                break;
            case "webdeveloper-outline-custom-elements":
                element = document.getElementById("webdeveloper-outline-custom-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineElements(element, false);
                break;
            case "webdeveloper-outline-deprecated-elements":
                element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineDeprecatedElements(element, false);
                break;
            case "webdeveloper-outline-external-links":
                element = document.getElementById("webdeveloper-outline-external-links-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineExternalLinks(element, false);
                break;
            case "webdeveloper-outline-fixed-positioned-elements":
                element = document.getElementById("webdeveloper-outline-fixed-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("fixed", element, false);
                break;
            case "webdeveloper-outline-floated-elements":
                element = document.getElementById("webdeveloper-outline-floated-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineFloatedElements(element, false);
                break;
            case "webdeveloper-outline-frames":
                element = document.getElementById("webdeveloper-outline-frames-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineFrames(element, false);
                break;
            case "webdeveloper-outline-headings":
                element = document.getElementById("webdeveloper-outline-headings-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineHeadings(element, false);
                break;
            case "webdeveloper-outline-images-with-adjusted-dimensions":
                element = document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithAdjustedDimensions(element, false);
                break;
            case "webdeveloper-outline-images-with-empty-alt-attributes":
                element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithEmptyAltAttributes(element, false);
                break;
            case "webdeveloper-outline-images-without-alt-attributes":
                element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutAltAttributes(element, false);
                break;
            case "webdeveloper-outline-images-without-dimensions":
                element = document.getElementById("webdeveloper-outline-images-without-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutDimensions(element, false);
                break;
            case "webdeveloper-outline-images-without-title-attributes":
                element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutTitleAttributes(element, false);
                break;
            case "webdeveloper-outline-links-without-title-attributes":
                element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineLinksWithoutTitleAttributes(element, false);
                break;
            case "webdeveloper-outline-relative-positioned-elements":
                element = document.getElementById("webdeveloper-outline-relative-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("relative", element, false);
                break;
            case "webdeveloper-outline-table-cells":
                element = document.getElementById("webdeveloper-outline-table-cells-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineTableCells(element, false);
                break;
            case "webdeveloper-outline-tables":
                element = document.getElementById("webdeveloper-outline-tables-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineTables(element, false);
                break;
            case "webdeveloper-replace-images-with-alt-attributes":
                element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_replaceImagesWithAltAttributes(element, false);
                break;
            case "webdeveloper-show-comments":
                element = document.getElementById("webdeveloper-show-comments-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleComments(element, false);
                break;
            case "webdeveloper-small-screen-rendering":
                element = document.getElementById("webdeveloper-small-screen-rendering-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_smallScreenRendering(element, false);
                break;
            case "webdeveloper-use-border-box-model":
                element = document.getElementById("webdeveloper-use-border-box-model-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleBorderBoxModel(element, false);
                break;
            case "webdeveloper-view-style-information":
                element = document.getElementById("webdeveloper-view-style-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_viewStyleInformation(element, false);
                break;
        }
    }
}

// Changes the options
function webdeveloper_changeOptions(currentDocument)
{
    var element                   = null;
    var hideContextMenuPreference = webdeveloper_getBooleanPreference("webdeveloper.context.hide", true);
    var hideMenuPreference        = webdeveloper_getBooleanPreference("webdeveloper.menu.hide", true);
    var toolbar                   = document.getElementById("webdeveloper-toolbar");

    // If the toolbar exists
    if(toolbar)
    {
        var toolbarVisible = window.toolbar.visible;

        // If the toolbar is visible
        if(toolbarVisible)
        {
            var toolbarButtons       = toolbar.getElementsByTagName("toolbarbutton");
            var toolbarButtonsLength = toolbarButtons.length;
            var toolbarPreference    = webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true);

            toolbar.setAttribute("mode", toolbarPreference);

            // If the toolbar preference is set to icons
            if(toolbarPreference == "icons")
            {
                toolbarPreference = "pictures";
            }

            toolbar.setAttribute("buttonstyle", toolbarPreference);

            // Loop through the toolbar buttons
            for(var i = 0; i < toolbarButtonsLength; i++)
            {
                toolbarButtons[i].setAttribute("buttonstyle", toolbarPreference);
            }

            // If the toolbar preference is not set to text
            if(toolbarPreference != "text")
            {
                element = document.getElementById("webdeveloper-javascript-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-render-mode-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }
            }
        }
    }

    element = document.getElementById("webdeveloper-menu");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideMenuPreference);
    }

    element = document.getElementById("webdeveloper-context");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }

    element = document.getElementById("webdeveloper-context-separator");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }
}

// Configures the element with the given attribute and value
function webdeveloper_configureElement(element, attribute, value)
{
    // If the element exists
    if(element)
    {
        // If the value is set
        if(value)
        {
            element.setAttribute(attribute, value);
        }
        else
        {
            element.removeAttribute(attribute);
        }
    }
}

// Configures the element based on whether another element exists
function webdeveloper_configureElementByElement(element, attribute, id)
{
    var currentDocument = webdeveloper_getContentDocument();
    var value           = false;

    // If the element exists
    if(currentDocument.getElementById(id))
    {
        value = true;
    }

    webdeveloper_configureElement(element, attribute, value);
}

// Configure the keyboard shortcuts
function webdeveloper_configureKeyboardShortcuts(reset)
{
    var bookmarklet         = null;
    var id                  = null;
    var key                 = null;
    var keyElement          = null;
    var keyPreference       = null;
    var keyPreferenceValue  = null;
    var keys                = null;
    var keySet              = null;
    var keysLength          = null;
    var mainDocument        = null;
    var path                = null;
    var success             = false;
    var toolCount           = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
    var url                 = null;
    var viewSourceWithCount = webdeveloper_getIntegerPreference("webdeveloper.view.source.with.count", true);
    var windowEnumeration   = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

    // Loop through the open windows
    while(windowEnumeration.hasMoreElements())
    {
        mainDocument = windowEnumeration.getNext().document;

        // If a main document was found
        if(mainDocument)
        {
            keySet = mainDocument.getElementById("mainKeyset");

            // If the key set was not found
            if(!keySet)
            {
                keySet = mainDocument.getElementById("navKeys");
            }

            // If the key set was found
            if(keySet)
            {
                keys       = keySet.childNodes;
                keysLength = keys.length;

                // Loop through the keys
                for(var i = 0; i < keysLength; i++)
                {
                    key = keys.item(i);

                    // If the key has an id starting with webdeveloper
                    if(key.hasAttribute("id") && key.getAttribute("id").indexOf("webdeveloper-") == 0)
                    {
                        id = key.getAttribute("id").split("-").join(".");

                        // If the key preference is set
                        if(webdeveloper_isPreferenceSet(id))
                        {
                            keyPreferenceValue = webdeveloper_getStringPreference(id, true);

                            key.setAttribute("key", keyPreferenceValue);

                            // If the key preference value is set
                            if(keyPreferenceValue)
                            {
                                key.setAttribute("disabled", false);
                            }
                            else
                            {
                                key.setAttribute("disabled", true);
                            }
                        }
                        else if(!reset)
                        {
                            webdeveloper_setStringPreference(id, key.getAttribute("key"));
                        }

                        success = true;
                    }
                }

                // Loop through the possible tools
                for(i = 1; i <= toolCount; i++)
                {
                    bookmarklet   = "webdeveloper.tool." + i + ".bookmarklet";
                    keyPreference = "webdeveloper.tool." + i + ".key";
                    keyElement    = mainDocument.getElementById(keyPreference);
                    path          = "webdeveloper.tool." + i + ".path";
                    url           = "webdeveloper.tool." + i + ".url";

                    // If the bookmarklet, path or URL preference and key preference is set
                    if((webdeveloper_isPreferenceSet(bookmarklet) || webdeveloper_isPreferenceSet(path) || webdeveloper_isPreferenceSet(url)) && webdeveloper_isPreferenceSet(keyPreference))
                    {
                        keyPreferenceValue = webdeveloper_getStringPreference(keyPreference, true);

                        // If the key preference value is set
                        if(keyPreferenceValue)
                        {
                            key = mainDocument.createElement("key");

                            key.setAttribute("id", keyPreference);
                            key.setAttribute("key", keyPreferenceValue);
                            key.setAttribute("modifiers", "accel,shift");

                            // If the bookmarklet preference is set
                            if(webdeveloper_getStringPreference(bookmarklet, true))
                            {
                                key.setAttribute("oncommand", "webdeveloper_runBookmarklet('" + encodeURIComponent(webdeveloper_getStringPreference(bookmarklet, true)).replace(new RegExp("'", "gi"), "\\'") + "')");
                            }
                            else if(webdeveloper_getStringPreference(path, true))
                            {
                                key.setAttribute("oncommand", "webdeveloper_loadApplicationWithURL('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "', getBrowser().currentURI.spec)");
                            }
                            else
                            {
                                key.setAttribute("oncommand", "webdeveloper_loadURL('" + webdeveloper_getStringPreference(url, true) + "' + encodeURIComponent(getBrowser().currentURI.spec))");
                            }

                            keySet.appendChild(key);
                        }
                    }
                    else if(keyElement)
                    {
                        keyElement.parentNode.removeChild(keyElement);
                    }
                }

                // Loop through the possible view source with options
                for(i = 1; i <= viewSourceWithCount; i++)
                {
                    keyPreference = "webdeveloper.view.source.with." + i + ".key";
                    keyElement    = mainDocument.getElementById(keyPreference);
                    path          = "webdeveloper.view.source.with." + i + ".path";

                    // If the path and key preferences are set
                    if(webdeveloper_isPreferenceSet(path) && webdeveloper_isPreferenceSet(keyPreference))
                    {
                        keyPreferenceValue = webdeveloper_getStringPreference(keyPreference, true);

                        // If the key preference value is set
                        if(keyPreferenceValue)
                        {
                            key = mainDocument.createElement("key");

                            key.setAttribute("id", keyPreference);
                            key.setAttribute("key", keyPreferenceValue);
                            key.setAttribute("modifiers", "accel,shift");
                            key.setAttribute("oncommand", "webdeveloper_loadApplicationWithSource('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "')");
                            keySet.appendChild(key);
                        }
                    }
                    else if(keyElement)
                    {
                        keyElement.parentNode.removeChild(keyElement);
                    }
                }
            }
        }
    }

    return success;
}

// Disables the given preference
function webdeveloper_disablePreference(element, preference)
{
    // If the element and preference are set
    if(element && preference)
    {
        webdeveloper_setBooleanPreference(preference, !element.getAttribute("checked"));
    }
}

// Displays the elements ancestors in the status bar
function webdeveloper_displayElementAncestors(event)
{
    var eventTarget = event.target;

    // If there is a target
    if(eventTarget)
    {
        var tagName = eventTarget.tagName;

        // If the tag name is set and does not equal scrollbar
        if(tagName && tagName != "scrollbar")
        {
            var ancestorList   = webdeveloper_getElementAncestors(eventTarget);
            var ancestorLength = ancestorList.length;
            var ancestorText   = "";

            // Loop through the ancestors
            for(var i = 0; i < ancestorLength; i++)
            {
                ancestorText += webdeveloper_getElementDescription(ancestorList[i]) + " > ";
            }

            ancestorText += webdeveloper_getElementDescription(eventTarget);

            getBrowser().contentWindow.status = ancestorText;

            event.preventDefault();
        }
    }
}

// Enables the given preference
function webdeveloper_enablePreference(element, preference)
{
    // If the element and preference are set
    if(element && preference)
    {
        var checked = element.getAttribute("checked");

        // If the element is checked (explicit check required)
        if(checked)
        {
            webdeveloper_setBooleanPreference(preference, true);
        }
        else
        {
            webdeveloper_setBooleanPreference(preference, false);
        }
    }
}

// Formats a file size
function webdeveloper_formatFileSize(fileSize)
{
    // If the file size is set
    if(fileSize)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        // If the file size is greater than a kilobyte
        if(fileSize > 1024)
        {
            return Math.round(fileSize / 1024) + " " + stringBundle.getString("webdeveloper_kilobytes");
        }
        else
        {
            return fileSize + " " + stringBundle.getString("webdeveloper_bytes");
        }
    }
    else
    {
        return "";
    }
}

// Generates a document in a new tab or window
function webdeveloper_generateDocument(url)
{
    var generatedPage = null;
    var request       = new XMLHttpRequest();

    // If the open tabs preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true))
    {
        getBrowser().selectedTab = getBrowser().addTab(url);

        generatedPage = window;
    }
    else
    {
        generatedPage = window.open(url);
    }

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send("");

    return generatedPage.content.document;
}

// Returns a description for an element
function webdeveloper_getElementDescription(element)
{
    var description = null;

    // If the element and tag name are set
    if(element && element.tagName)
    {
        description = element.tagName.toLowerCase();

        // If the element has an id attribute
        if(element.hasAttribute("id"))
        {
            description += " #" + element.getAttribute("id");
        }

        // If the element has a class attribute
        if(element.hasAttribute("class"))
        {
            description += " ." + element.getAttribute("class");
        }
    }

    return description;
}

// Opens the help
function webdeveloper_help()
{
    webdeveloper_loadURL("@home.page@documentation/");
}

// Initializes the extension
function webdeveloper_initialize(event)
{
    var windowContent = window.document.getElementById("content");

    // If the window content is set
    if(windowContent)
    {
        var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);
        var tabBox         = windowContent.mTabBox;

        webdeveloper_upgrade();
        webdeveloper_setupDefaultOptions();
        webdeveloper_setupLocalizedOptions();
        webdeveloper_configureKeyboardShortcuts(false);

        windowContent.addEventListener("load", webdeveloper_pageLoad, true);
        windowContent.addEventListener("unload", webdeveloper_pageUnload, true);

        // If the console service is set
        if(consoleService)
        {
            // Try to remove the console listener
            try
            {
                consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
            }
            catch(exception)
            {
                // Do nothing
            }

            consoleService.registerListener(WebDeveloperJavaScriptConsoleListener);
        }

        // If the tab box is set
        if(tabBox)
        {
            tabBox.addEventListener("select", webdeveloper_tabSelect, true);
        }

        // Try to remove the event listener
        try
        {
            window.removeEventListener("load", webdeveloper_initialize, true);
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Loads the given URL
function webdeveloper_loadURL(url)
{
    var oldTab = getBrowser().selectedTab;

    webdeveloper_generateDocument(url);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Logs a debug message to the JavaScript console
function webdeveloper_logDebug(message)
{
    // If the debug preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.debug", true))
    {
        var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);

        consoleService.logStringMessage("@name@: " + message);
        webdeveloper_openJavaScriptConsole();
    }
}

// Opens the JavaScript console
function webdeveloper_openJavaScriptConsole()
{
    // If the open JavaScript console in sidebar preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.javascript.console.sidebar", true))
    {
        window.openWebPanel(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_javascriptConsole"), "chrome://global/content/console.xul");
    }
    else
    {
        webdeveloper_javaScriptPreviousTime = webdeveloper_javaScriptCurrentTime;
        webdeveloper_javaScriptCurrentTime  = new Date().getTime();

        // If the previous time is not set or the current time is greater than a second different from the previous time
        if(!webdeveloper_javaScriptPreviousTime || webdeveloper_javaScriptCurrentTime - webdeveloper_javaScriptPreviousTime > 1500)
        {
            toJavaScriptConsole();
        }
    }
}

// Opens a toolbar button automatically if another toolbar button is open on the toolbar
function webdeveloper_openToolbarButton(currentToolbarButton)
{
    // If the toolbar button is set and is not open
    if(currentToolbarButton && !currentToolbarButton.open)
    {
        var toolbarButton        = null;
        var toolbarButtons       = currentToolbarButton.parentNode.getElementsByTagName("toolbarbutton");
        var toolbarButtonsLength = toolbarButtons.length;

        // Loop through the toolbar buttons
        for(var i = 0; i < toolbarButtonsLength; i++)
        {
            toolbarButton = toolbarButtons.item(i);

            // If the toolbar button is set, is not the same toolbar button and is open
            if(toolbarButton && toolbarButton != currentToolbarButton && toolbarButton.open)
            {
                toolbarButton.open        = false;
                currentToolbarButton.open = true;

                break;
            }
        }
    }
}

// Displays the options dialog
function webdeveloper_options()
{
    window.openDialog("chrome://webdeveloper/content/options/options.xul", "webdeveloper-options-dialog", "centerscreen,chrome,modal,resizable");

    webdeveloper_changeOptions();
}

// Handles the page being loaded
function webdeveloper_pageLoad(event)
{
    var eventTarget = event.target;

    // If the page is the target
    if(eventTarget && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content")
    {
        var contentDocument = eventTarget.contentDocument;
        var loadedDocument  = event.originalTarget;

        webdeveloper_changeOptions();

        // If the content document is set
        if(contentDocument)
        {
            webdeveloper_configureElement(document.getElementById("webdeveloper-line-guides-toolbar"), "hidden", true);
            webdeveloper_updateMetaRedirects();

            // If the loaded document is set and has the same URI as the content document
            if(loadedDocument && contentDocument.documentURI == loadedDocument.documentURI)
            {
                webdeveloper_updateRenderMode(contentDocument);
            }

            // If the persist styles preference is set and is true
            if(webdeveloper_getBooleanPreference("webdeveloper.styles.persist", true))
            {
                webdeveloper_applyStyleSheets(false);
            }
            else
            {
                webdeveloper_appliedStyles = new Array();
            }
        }
    }
}

// Handles the page being unloaded
function webdeveloper_pageUnload(event)
{
    var eventTarget    = event.target;
    var originalTarget = event.originalTarget;

    // If the page is the target and the URI matches
    if(eventTarget && originalTarget && eventTarget.contentDocument && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content" && eventTarget.contentDocument.documentURI == originalTarget.documentURI)
    {
        webdeveloper_resetJavaScriptStatus();
    }
}

// Remove applied style
function webdeveloper_removeAppliedStyle(id)
{
    // If the persist styles preference is set and is true
    if(webdeveloper_getBooleanPreference("webdeveloper.styles.persist", true))
    {
        // Loop through the applied styles
        for(var i = 0; i < webdeveloper_appliedStyles.length; i++)
        {
            // If this style sheet is in the applied styles
            if(webdeveloper_appliedStyles[i] == id)
            {
                webdeveloper_appliedStyles.splice(i, 1);
            }
        }
    }
}

// Removes the outline from an element
function webdeveloper_removeElementOutline(element)
{
    // If the element is set
    if(element)
    {
        element.style.MozOutline = "";

        // If the element has an empty style attribute
        if(element.hasAttribute("style") && element.getAttribute("style") == "")
        {
            element.removeAttribute("style");
        }
    }
}

// Removes all the generated menu items from the menu
function webdeveloper_removeGeneratedMenuItems(menu)
{
    var generatedMenuItems = new Array();
    var menuItem           = null;
    var menuItems          = menu.childNodes;
    var menuItemsLength    = menuItems.length;

    // Loop through the menu items
    for(var i = 0; i < menuItemsLength; i++)
    {
        menuItem = menuItems.item(i);

        // If this is a generated menu item
        if(menuItem && menuItem.hasAttribute("class") && menuItem.getAttribute("class") == "webdeveloper-generated-menu")
        {
            generatedMenuItems.push(menuItem);
        }
    }

    menuItemsLength = generatedMenuItems.length;

    // Loop through the generated menu items
    for(i = 0; i < menuItemsLength; i++)
    {
        menu.removeChild(generatedMenuItems[i]);
    }
}

// Removes the style sheet with the given id
function webdeveloper_removeStyleSheet(id, applyStyle)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var element        = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        element = documentList[i].getElementById(id);

        // If the element is set
        if(element)
        {
            element.parentNode.removeChild(element);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_removeAppliedStyle(id);
    }
}

// Resets the JavaScript status button
function webdeveloper_resetJavaScriptStatus()
{
    var javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    webdeveloper_javaScriptCurrentTime  = null;
    webdeveloper_javaScriptPreviousTime = null;

    // If the JavaScript button exists
    if(javaScriptButton)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        javaScriptButton.setAttribute("class", "webdeveloper-statusbar-button");
        javaScriptButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));

        // If the toolbar preference has a value and is set to text
        if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
        {
            javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
        }
    }
}

// Resets the page
function webdeveloper_resetPage()
{
    webdeveloper_applyStyleSheets(true);

    webdeveloper_appliedStyles    = new Array();
    webdeveloper_outlinedElements = new Array();
}

// Runs the given bookmarklet
function webdeveloper_runBookmarklet(bookmarklet)
{
    eval(decodeURIComponent(bookmarklet));
}

// Sets up the default options
function webdeveloper_setupDefaultOptions()
{
    // Set default custom colors
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.1.color", "#ff0000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.2.color", "#33ff33");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.3.color", "#3333ff");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.4.color", "#ff0000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.5.color", "#33ff33");

    // Set default edit CSS settings
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.edit.color.background", "#ffffff");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.edit.color.text", "#000000");
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.edit.font.size", 12);
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.edit.update.frequency", 2000);

    // Set default feature tooltip colors
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.background", "#ffff99");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.border", "#ffcc66");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.text", "#000000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.opacity", "0.9");

    // Set default generated content font size
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.generated.content.font.size", 12);

    // Set default information preference
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.information.tidy", true);

    // Set default open tabs preference
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.open.tabs", true);

    // Set default populate form fields email
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.populate.form.fields.email", "example@example.com");

    // Set default CSS profile setting
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.validate.local.css.profile", "css2");

    // Set default line guides settings
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.line.guides.color", "#000000");
}

// Sets up the localized options
function webdeveloper_setupLocalizedOptions()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the string bundle is set
    if(stringBundle)
    {
        // Set default resize sizes
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.resize.1.description", stringBundle.getString("webdeveloper_resize800x600"));
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.1.width", 800);
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.1.height", 600);
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.count", 1);

        // Set default tool count
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.tool.count", 8);

        // Set CSS validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.1.description", stringBundle.getString("webdeveloper_validateCSS"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.1.url", "http://jigsaw.w3.org/css-validator/validator?profile=css2&warning=2&uri=");

        // Set feed validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.2.description", stringBundle.getString("webdeveloper_validateFeed"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.2.url", "http://validator.w3.org/feed/check.cgi?url=");

        // Set HTML validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.description", stringBundle.getString("webdeveloper_validateHTML"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.key", "H");
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.url", "http://validator.w3.org/check?verbose=1&uri=");

        // Set links validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.4.description", stringBundle.getString("webdeveloper_validateLinks"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.4.url", "http://validator.w3.org/checklink?check=Check&hide_type=all&summary=on&uri=");

        // Set section 508 validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.5.description", stringBundle.getString("webdeveloper_validateSection508"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.5.url", "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=-1&url1=");

        // Set WAI validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.6.description", stringBundle.getString("webdeveloper_validateWAI"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.6.url", "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=2&url1=");

        // Set separator
        webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.tool.7.separator", true);

        // Set speed report
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.8.description", stringBundle.getString("webdeveloper_viewSpeedReport"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.8.url", "http://www.websiteoptimization.com/cgi-bin/wso/wso.pl?url=");

        webdeveloper_localizedOptionsSetup = true;
    }
}

// Sorts two images
function webdeveloper_sortImages(imageOne, imageTwo)
{
    // If both images are set
    if(imageOne && imageTwo)
    {
        var imageOneSrc = imageOne.src;
        var imageTwoSrc = imageTwo.src;

        // If the images are equal
        if(imageOneSrc == imageTwoSrc)
        {
            return 0;
        }
        else if(imageOneSrc < imageTwoSrc)
        {
            return -1;
        }
    }

    return 1;
}

// Handles a tab being selected
function webdeveloper_tabSelect(event)
{
    var selectedTab     = getBrowser().mTabBox.selectedIndex;
    var currentDocument = webdeveloper_getContentDocument();

    // If the selected tab is different
    if(selectedTab != webdeveloper_selectedTab)
    {
        webdeveloper_selectedTab = selectedTab;

        webdeveloper_updateRenderMode(currentDocument);
        webdeveloper_resetJavaScriptStatus();
    }
}

// Tidies a list of images by removing duplicates and sorting
function webdeveloper_tidyImages(imageList)
{
    var image              = null;
    var imageListLength    = imageList.length;
    var imageSrc           = null;
    var newImageList       = new Array();
    var newImageListLength = null;
    var tidiedImageList    = new Array();

    // Loop through the images
    for(var i = 0; i < imageListLength; i++)
    {
        image    = imageList[i];
        imageSrc = image.src;

        // If the image src is set and does not end in '.xul'
        if(imageSrc && !imageSrc.endsWith(".xul"))
        {
            newImageList.push(image);
        }
    }

    newImageList.sort(webdeveloper_sortImages);

    newImageListLength = newImageList.length;

    // Loop through the images
    for(i = 0; i < newImageListLength; i++)
    {
        image = newImageList[i];

        // If this is not the last image and the image is the same as the next image
        if(i + 1 < newImageListLength && image.src == newImageList[i + 1].src)
        {
            continue;
        }

        tidiedImageList.push(image);
    }

    return tidiedImageList;
}

// Toggles the feature tooltip styles
function webdeveloper_toggleFeatureTooltipStyles(element, styleSheetId, selectors)
{
    webdeveloper_removeStyleSheet(styleSheetId, false);

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        var colors          = " background-color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.background", true) + " !important; border-color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.border", true) + " !important; color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.text", true) + " !important; ";
        var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength  = documentList.length;
        var headElementList = null;
        var opacityValue    = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.opacity", true);
        var opacity         = " -moz-opacity: " + opacityValue + " !important;  opacity: " + opacityValue + " !important; ";
        var pageDocument    = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.appendChild(pageDocument.createTextNode(selectors + " {" + colors + opacity + "}"));
            styleElement.setAttribute("id", styleSheetId);
            styleElement.setAttribute("type", "text/css");

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.appendChild(styleElement);
            }
        }
    }
}

// Toggles an individual style sheet
function webdeveloper_toggleIndividualStyleSheet(selectedStyleSheetHref)
{
    var currentDocument  = webdeveloper_getContentDocument();
    var styleSheet       = null;
    var styleSheetHref   = null;
    var styleSheetList   = currentDocument.styleSheets;
    var styleSheetLength = styleSheetList.length;

    // Loop through the style sheets
    for(var i = 0; i < styleSheetLength; i++)
    {
        styleSheet     = styleSheetList[i];
        styleSheetHref = styleSheet.href;

        // If this is the selected style sheet
        if(styleSheetHref == selectedStyleSheetHref)
        {
            styleSheet.disabled = !styleSheet.disabled;
        }
    }
}

// Toggles the style sheet with the given id
function webdeveloper_toggleStyleSheet(element, location, id, applyStyle)
{
    webdeveloper_removeStyleSheet(id, applyStyle);

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        webdeveloper_addStyleSheet(location, id, applyStyle);
    }
}

// Toggles the toolbar
function webdeveloper_toggleToolbar()
{
    var toolbar = document.getElementById("webdeveloper-toolbar");

    toolbar.collapsed = !toolbar.collapsed;

    document.persist("webdeveloper-toolbar", "collapsed");
}

// Uninitializes the extension
function webdeveloper_uninitialize(event)
{
    var windowContent = window.document.getElementById("content");

    // If the window content is set
    if(windowContent)
    {
        var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);
        var tabBox         = windowContent.mTabBox;

        // Try to remove the event listener
        try
        {
            windowContent.removeEventListener("load", webdeveloper_pageLoad, true);
        }
        catch(exception)
        {
            // Do nothing
        }

        // Try to remove the event listener
        try
        {
            windowContent.removeEventListener("unload", webdeveloper_pageUnload, true);
        }
        catch(exception)
        {
            // Do nothing
        }

        // If the console service is set
        if(consoleService)
        {
            // Try to remove the console listener
            try
            {
                consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
            }
            catch(exception)
            {
                // Do nothing
            }
        }

        // If the tab box is set
        if(tabBox)
        {
            // Try to remove the event listener
            try
            {
                tabBox.removeEventListener("select", webdeveloper_tabSelect, true);
            }
            catch(exception)
            {
                // Do nothing
            }
        }

        // Try to remove the event listener
        try
        {
            window.removeEventListener("close", webdeveloper_uninitialize, true);
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Updates the meta redirects status
function webdeveloper_updateMetaRedirects()
{
    var allowMetaRedirects = !webdeveloper_getBooleanPreference("webdeveloper.meta.redirects.disable", true);
    var browsers           = getBrowser().browsers;
    var browserLength      = browsers.length;

    // Loop through the browsers
    for(var i = 0; i < browserLength; i++)
    {
        browsers[i].docShell.allowMetaRedirects = allowMetaRedirects;
    }
}

// Updates the options menu
function webdeveloper_updateOptionsMenu(suffix)
{
    webdeveloper_configureElement(document.getElementById("webdeveloper-persist-styles-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.styles.persist", true));
}

// Updates the render mode status button
function webdeveloper_updateRenderMode(currentDocument)
{
    var element = document.getElementById("webdeveloper-render-mode-statusbar");

    // If the render mode button exists
    if(element)
    {
        var renderMode   = currentDocument.compatMode;
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var textToolbar  = false;

        // If the toolbar preference has a value and is set to text
        if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
        {
            textToolbar = true;
        }

        // If the render mode is quirks mode
        if(renderMode == "BackCompat")
        {
            element.setAttribute("class", "quirks webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_quirksModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_quirksModeLabel"));
            }
        }
        else
        {
            element.setAttribute("class", "webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
            }
        }
    }
}

// JavaScript console listener
var WebDeveloperJavaScriptConsoleListener =
{
    // Observes changes in the console
    observe: function(error)
    {
        // If the document and error are set
        if(document && error)
        {
            var errorMessage     = error.message;
            var javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

            // If the error message and JavaScript button are set
            if(errorMessage && javaScriptButton)
            {
                // Try to convert the error to a script error
                try
                {
                    error = error.QueryInterface(Components.interfaces.nsIScriptError);

                    var errorCategory = error.category;
                    var sourceName    = error.sourceName;

                    // If the error category is set and is content javascript or DOM:HTML
                    if(errorCategory && (errorCategory == "content javascript" || errorCategory == "DOM:HTML"))
                    {
                        var stringBundle = document.getElementById("webdeveloper-string-bundle");
                        var textToolbar  = false;
                        var warning      = error.flags & error.warningFlag != 0;

                        // If the toolbar preference has a value and is set to text
                        if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
                        {
                            textToolbar = true;
                        }

                        // If this is a warning
                        if(warning)
                        {
                            javaScriptButton.setAttribute("class", "warning webdeveloper-statusbar-button");
                            javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptWarningTooltip", [errorMessage]));

                            // If the toolbar is in text mode
                            if(textToolbar)
                            {
                                javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptWarningLabel"));
                            }

                            // If the open JavaScript console warning preference is set
                            if(webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.warning", true))
                            {
                                webdeveloper_openJavaScriptConsole();
                            }
                        }
                        else
                        {
                            javaScriptButton.setAttribute("class", "error webdeveloper-statusbar-button");
                            javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptErrorTooltip", [errorMessage]));

                            // If the toolbar is in text mode
                            if(textToolbar)
                            {
                                javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptErrorLabel"));
                            }

                            // If the open JavaScript console error preference is set
                            if(webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.error", true))
                            {
                                webdeveloper_openJavaScriptConsole();
                            }
                        }
                    }
                    else if(sourceName && sourceName.indexOf("chrome://webdeveloper/") != -1 && webdeveloper_getBooleanPreference("webdeveloper.debug", true))
                    {
                        webdeveloper_openJavaScriptConsole();
                    }
                }
                catch(exception)
                {
                    // Do nothing
                }
            }
        }

        return false;
    }
}
