// Outlines all block level element names
function webdeveloper_outlineBlockLevelElementNames(element, applyStyle)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-block-level-elements-before", applyStyle);
    webdeveloper_removeStyleSheet("webdeveloper-outline-block-level-elements-before-tooltips", applyStyle);

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements_before.css", "webdeveloper-outline-block-level-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-block-level-elements-before-tooltips", "*:before");
    }
}

// Outlines all block level elements
function webdeveloper_outlineBlockLevelElements(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements.css", "webdeveloper-outline-block-level-elements", applyStyle);
    webdeveloper_outlineBlockLevelElementNames(element, applyStyle);
}

// Outlines the current element
function webdeveloper_outlineCurrentElement(element, applyStyle)
{
    var checked        = element.getAttribute("checked");
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If outlining the element
        if(checked)
        {
            pageDocument.addEventListener("mousemove", webdeveloper_outlineMouseOverElement, true);
            pageDocument.addEventListener("mouseover", webdeveloper_displayElementAncestors, true);
        }
        else
        {
            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mousemove", webdeveloper_outlineMouseOverElement, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mouseover", webdeveloper_displayElementAncestors, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            webdeveloper_removeElementOutline(webdeveloper_outlineElement);
        }
    }

    // If not outlining the element
    if(!checked)
    {
        webdeveloper_outlineElement       = null;
        getBrowser().contentWindow.status = null;
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_current_element.css", "webdeveloper-outline-current-element", applyStyle);
}

// Outlines the given element
function webdeveloper_outlineCustomElements(element)
{
    webdeveloper_outlinedElements = new Array();

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        window.openDialog("chrome://webdeveloper/content/dialogs/outline_elements.xul", "webdeveloper-outline-elements-dialog", "centerscreen,chrome,modal", webdeveloper_outlinedElements);

        // If the user clicked cancel in the dialog
        if(webdeveloper_outlinedElements.length == 0)
        {
           element.removeAttribute("checked");
        }
    }

    webdeveloper_outlineElements(element, true);
}

// Outlines all deprecated element names
function webdeveloper_outlineDeprecatedElementNames(element, applyStyle)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-deprecated-elements-before", applyStyle);
    webdeveloper_removeStyleSheet("webdeveloper-outline-deprecated-elements-before-tooltips", applyStyle);

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements_before.css", "webdeveloper-outline-deprecated-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-deprecated-elements-before-tooltips", "*:before");
    }
}

// Outlines all deprecated elements
function webdeveloper_outlineDeprecatedElements(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements.css", "webdeveloper-outline-deprecated-elements", applyStyle);
    webdeveloper_outlineDeprecatedElementNames(element, applyStyle);
}

// Outlines the given element
function webdeveloper_outlineElements(element, applyStyle)
{
    // If the menu is checked
    if(element.getAttribute("checked") && webdeveloper_outlinedElements.length > 0)
    {
        var documentList             = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength           = documentList.length;
        var headElementList          = null;
        var outlineColor             = null;
        var outlineColorPreference   = null;
        var outlineElement           = null;
        var outlineElementLength     = null;
        var outlineElementList       = null;
        var outlineElementPreference = null;
        var outlineElementValue      = null;
        var pageDocument             = null;
        var styleElement             = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-custom-elements");
            styleElement.setAttribute("type", "text/css");

            // Loop through outline colors and elements
            for(var j = 0; j <= 5; j++)
            {
                outlineColor             = "webdeveloper.custom." + j + ".color";
                outlineColorPreference   = webdeveloper_getStringPreference(outlineColor, true);
                outlineElement           = "webdeveloper.custom." + j + ".element";
                outlineElementPreference = webdeveloper_getStringPreference(outlineElement, true);

                // If the color and element are set and not blank
                if(outlineColorPreference && outlineElementPreference)
                {
                    outlineElementList   = outlineElementPreference.split(",");
                    outlineElementLength = outlineElementList.length;

                    // Loop through the elements
                    for(var k = 0; k < outlineElementLength; k++)
                    {
                        outlineElementValue = outlineElementList[k];

                        styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + " { -moz-outline: 1px solid " + outlineColorPreference + " !important; outline: 1px solid " + outlineColorPreference + " !important; }"));

                        // If the show outlined element names preference is set
                        if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
                        {
                            styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + ":before { content: \"<" + outlineElementValue + ">\" !important; }"));
                        }
                    }
                }
            }

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-outline-custom-elements");
        }
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-custom-elements", true);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/before.css", "webdeveloper-outline-custom-elements-before", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-custom-elements-before-tooltips", "*:before");
}

// Outlines all external links
function webdeveloper_outlineExternalLinks(element, applyStyle)
{
    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength  = documentList.length;
        var headElementList = null;
        var location        = null;
        var pageDocument    = null;
        var protocol        = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            location        = pageDocument.location;
            protocol        = location.protocol.replace(new RegExp(":", "gi"), "\\:");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-external-links");
            styleElement.setAttribute("type", "text/css");
            styleElement.appendChild(pageDocument.createTextNode("a:not([href^=" + protocol + "\\/\\/" + location.hostname.replace(new RegExp("\\.", "gi"), "\\.") + "]) { -moz-outline: 1px solid #ff0000 !important; outline: 1px solid #ff0000 !important; }"));
            styleElement.appendChild(pageDocument.createTextNode("a:not([href^=" + protocol + "]) { -moz-outline-style: none !important; outline-style: none !important; }"));

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-outline-external-links");
        }
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-external-links", true);
    }
}

// Outlines all floated elements
function webdeveloper_outlineFloatedElements(element, applyStyle)
{
    var checked        = element.getAttribute("checked");
    var className      = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var floatValue     = null;
    var pageDocument   = null;
    var pageElement    = null;
    var treeWalker     = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((pageElement = treeWalker.nextNode()) != null)
        {
            // If the element is checked
            if(checked)
            {
                floatValue = pageElement.ownerDocument.defaultView.getComputedStyle(pageElement, null).getPropertyCSSValue("float").cssText;

                // If this element is floated and it is not set to none
                if(floatValue && floatValue != "none")
                {
                    pageElement.className += " webdeveloper-floated-element";
                }
            }
            else
            {
                className = pageElement.className;

                // If the element has a class name and it contains webdeveloper-floated-element
                if(className && className.indexOf("webdeveloper-floated-element") != -1)
                {
                    pageElement.className = webdeveloper_removeSubstring(className, "webdeveloper-floated-element");
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_floated_elements.css", "webdeveloper-outline-floated-elements", applyStyle);
}

// Outlines all frames
function webdeveloper_outlineFrames(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_frames.css", "webdeveloper-outline-frames", applyStyle);
}

// Outlines all heading names
function webdeveloper_outlineHeadingNames(element, applyStyle)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-headings-before", applyStyle);
    webdeveloper_removeStyleSheet("webdeveloper-outline-headings-before-tooltips", applyStyle);

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_headings_before.css", "webdeveloper-outline-headings-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-headings-before-tooltips", "*:before");
    }
}

// Outlines all headings
function webdeveloper_outlineHeadings(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_headings.css", "webdeveloper-outline-headings", applyStyle);
    webdeveloper_outlineHeadingNames(element, applyStyle);
}

// Outlines all the links without title attributes
function webdeveloper_outlineLinksWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_links_without_title_attributes.css", "webdeveloper-outline-links-without-title-attributes", applyStyle);
}

// Outlines the mouse over element
function webdeveloper_outlineMouseOverElement(event)
{
    var element = event.target;

    // If the element is set and is not the same as the current outline element
    if(element && element != webdeveloper_outlineElement)
    {
        webdeveloper_removeElementOutline(webdeveloper_outlineElement);

        webdeveloper_outlineElement                  = element;
        webdeveloper_outlineElement.style.MozOutline = "1px solid #ff0000";
    }
}

// Outlines all positioned elements of the specified position on the page
function webdeveloper_outlinePositionedElements(position, element, applyStyle)
{
    var attributeName  = "webdeveloper-" + position + "-positioned-element";
    var checked        = element.getAttribute("checked");
    var className      = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;
    var pageElement    = null;
    var positionValue  = null;
    var treeWalker     = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((pageElement = treeWalker.nextNode()) != null)
        {
            // If the element is checked
            if(checked)
            {
                positionValue = pageElement.ownerDocument.defaultView.getComputedStyle(pageElement, null).getPropertyCSSValue("position").cssText;

                // If this element is positioned and it is the specified position
                if(positionValue && positionValue == position)
                {
                    pageElement.className += " " + attributeName;
                }
            }
            else if(pageElement.className.indexOf(attributeName) != -1)
            {
                pageElement.className = webdeveloper_removeSubstring(pageElement.className, attributeName);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_positioned_elements.css", "webdeveloper-outline-" + position + "-positioned-elements", applyStyle);
}

// Outlines all table cells
function webdeveloper_outlineTableCells(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_cells.css", "webdeveloper-outline-table-cells", applyStyle);
}

// Outlines all tables
function webdeveloper_outlineTables(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_tables.css", "webdeveloper-outline-tables", applyStyle);
}

// Toggle showing of element names when outlining
function webdeveloper_toggleShowElementNamesWhenOutlining(element)
{
    var menu = document.getElementById("webdeveloper-outline-block-level-elements-menu");

    webdeveloper_enablePreference(element, "webdeveloper.outline.show.element.names");

    webdeveloper_configureElementByElement(menu, "checked", "webdeveloper-outline-block-level-elements");
    webdeveloper_outlineBlockLevelElementNames(menu, true);

    menu = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureElementByElement(menu, "checked", "webdeveloper-outline-deprecated-elements");
    webdeveloper_outlineDeprecatedElementNames(menu, true);

    menu = document.getElementById("webdeveloper-outline-headings-menu");
    webdeveloper_configureElementByElement(menu, "checked", "webdeveloper-outline-headings");
    webdeveloper_outlineHeadingNames(menu, true);
}

// Updates the outline menu
function webdeveloper_updateOutlineMenu(suffix)
{
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-block-level-elements-" + suffix), "checked", "webdeveloper-outline-block-level-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-current-element-" + suffix), "checked", "webdeveloper-outline-current-element");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-custom-elements-" + suffix), "checked", "webdeveloper-outline-custom-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-deprecated-elements-" + suffix), "checked", "webdeveloper-outline-deprecated-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-external-links-" + suffix), "checked", "webdeveloper-outline-external-links");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-frames-" + suffix), "checked", "webdeveloper-outline-frames");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-headings-" + suffix), "checked", "webdeveloper-outline-headings");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-links-without-title-attributes-" + suffix), "checked", "webdeveloper-outline-links-without-title-attributes");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-table-cells-" + suffix), "checked", "webdeveloper-outline-table-cells");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-tables-" + suffix), "checked", "webdeveloper-outline-tables");
    webdeveloper_configureElement(document.getElementById("webdeveloper-outline-show-element-names-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true));
}

// Updates the outline positioned elements menu
function webdeveloper_updateOutlinePositionedElementsMenu(suffix)
{
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-absolute-positioned-elements-" + suffix), "checked", "webdeveloper-outline-absolute-positioned-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-fixed-positioned-elements-" + suffix), "checked", "webdeveloper-outline-fixed-positioned-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-floated-elements-" + suffix), "checked", "webdeveloper-outline-floated-elements");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-relative-positioned-elements-" + suffix), "checked", "webdeveloper-outline-relative-positioned-elements");
}
