// Creates the ruler block
function webdeveloper_createRuler(ownerDocument)
{
    var containerElement  = ownerDocument.createElement("div");
    var definitionElement = ownerDocument.createElement("dd");
    var divElement        = ownerDocument.createElement("div");
    var listElement       = ownerDocument.createElement("dl");
    var resizeElement     = ownerDocument.createElement("div");
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var termElement       = ownerDocument.createElement("dt");

    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_currentPosition")));
    definitionElement.setAttribute("id", "webdeveloper-ruler-current");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_startPosition")));
    definitionElement.setAttribute("id", "webdeveloper-ruler-start");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_endPosition")));
    definitionElement.setAttribute("id", "webdeveloper-ruler-end");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    definitionElement = ownerDocument.createElement("dd");
    listElement       = ownerDocument.createElement("dl");
    termElement       = ownerDocument.createElement("dt");

    termElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_dimensions")));
    definitionElement.setAttribute("id", "webdeveloper-ruler-dimensions");
    listElement.appendChild(termElement);
    listElement.appendChild(definitionElement);
    divElement.appendChild(listElement);

    divElement.setAttribute("id", "webdeveloper-ruler");
    ownerDocument.body.appendChild(divElement);

    resizeElement.setAttribute("id", "webdeveloper-ruler-north-west");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-north-east");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-south-east");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-south-west");
    containerElement.appendChild(resizeElement);

    divElement = ownerDocument.createElement("div");
    divElement.setAttribute("id", "webdeveloper-ruler-outline");

    containerElement.setAttribute("id", "webdeveloper-ruler-container");
    divElement.appendChild(containerElement);

    ownerDocument.body.appendChild(divElement);
}

// Called when the ruler is deselected
function webdeveloper_deselectRuler(event)
{
    var element = event.target;

    // If not moving the ruler
    if(!webdeveloper_rulerMove)
    {
        webdeveloper_rulerEndX  = event.pageX;
        webdeveloper_rulerEndY  = event.pageY;
    }

    webdeveloper_rulerDrag   = false;
    webdeveloper_rulerMove   = false;
    webdeveloper_rulerMoveX  = 0;
    webdeveloper_rulerMoveY  = 0;
    webdeveloper_rulerResize = false;

    // If the element is set
    if(element)
    {
        var ownerDocument = element.ownerDocument;

        // If the element has an owner document
        if(ownerDocument)
        {
            webdeveloper_updateRulerEnd(ownerDocument);
        }
    }
}

// Displays a ruler
function webdeveloper_displayRuler(element, applyStyle)
{
    var checked        = element.getAttribute("checked");
    var divElement     = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If displaying a ruler
        if(checked)
        {
            webdeveloper_createRuler(pageDocument);

            pageDocument.addEventListener("mousedown", webdeveloper_selectRuler, true);
            pageDocument.addEventListener("mousemove", webdeveloper_moveRuler, true);
            pageDocument.addEventListener("mouseup", webdeveloper_deselectRuler, true);
        }
        else
        {
            webdeveloper_removeRuler(pageDocument);

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mousedown", webdeveloper_startRuler, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mousemove", webdeveloper_moveRuler, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mouseup", webdeveloper_endRuler, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            webdeveloper_rulerDrag   = false;
            webdeveloper_rulerEndX   = 0;
            webdeveloper_rulerEndY   = 0;
            webdeveloper_rulerMove   = false;
            webdeveloper_rulerMoveX  = 0;
            webdeveloper_rulerMoveY  = 0;
            webdeveloper_rulerResize = false;
            webdeveloper_rulerStartX = 0;
            webdeveloper_rulerStartY = 0;
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_ruler.css", "webdeveloper-display-ruler", applyStyle);
}

// Called when the ruler is moved
function webdeveloper_moveRuler(event)
{
    var element = event.target;

    // If the element is set
    if(element)
    {
        var ownerDocument = element.ownerDocument;

        // If the element has an owner document
        if(ownerDocument)
        {
            var definitionElement = ownerDocument.getElementById("webdeveloper-ruler-current");
            var divElement        = ownerDocument.getElementById("webdeveloper-ruler");
            var outlineElement    = ownerDocument.getElementById("webdeveloper-ruler-outline");
            var xPosition         = event.pageX;
            var yPosition         = event.pageY;

            // If the outline element is set
            if(outlineElement)
            {
                // If the ruler is being dragged or resized
                if(webdeveloper_rulerDrag || webdeveloper_rulerResize)
                {
                    // If the start x position is greater than the current x position
                    if(webdeveloper_rulerStartX > xPosition)
                    {
                        outlineElement.style.left  = xPosition + "px";
                        outlineElement.style.width = (webdeveloper_rulerStartX - xPosition) + "px";
                    }
                    else
                    {
                        outlineElement.style.left  = webdeveloper_rulerStartX + "px";
                        outlineElement.style.width = (xPosition - webdeveloper_rulerStartX) + "px";
                    }

                    // If the start y position is greater than the end y position
                    if(webdeveloper_rulerStartY > yPosition)
                    {
                        outlineElement.style.top    = yPosition + "px";
                        outlineElement.style.height = (webdeveloper_rulerStartY - yPosition) + "px";
                    }
                    else
                    {
                        outlineElement.style.top    = webdeveloper_rulerStartY + "px";
                        outlineElement.style.height = (yPosition - webdeveloper_rulerStartY) + "px";
                    }
                }
                else if(webdeveloper_rulerMove)
                {
                    var newXPosition = xPosition - webdeveloper_rulerMoveX;
                    var newYPosition = yPosition - webdeveloper_rulerMoveY;

                    outlineElement.style.left = newXPosition + "px";
                    outlineElement.style.top  = newYPosition + "px";

                    webdeveloper_rulerEndX   = newXPosition + outlineElement.clientWidth;
                    webdeveloper_rulerEndY   = newYPosition + outlineElement.clientHeight;
                    webdeveloper_rulerStartX = newXPosition;
                    webdeveloper_rulerStartY = newYPosition;

                    webdeveloper_updateRulerStart(ownerDocument);
                    webdeveloper_updateRulerEnd(ownerDocument);
                }
            }

            // If the definition element is set
            if(definitionElement)
            {
                var pElement = ownerDocument.createElement("p");

                webdeveloper_removeAllChildNodes(definitionElement);

                pElement.appendChild(ownerDocument.createTextNode("X = " + xPosition));
                definitionElement.appendChild(pElement);

                pElement = ownerDocument.createElement("p");
                pElement.appendChild(ownerDocument.createTextNode("Y = " + yPosition));
                definitionElement.appendChild(pElement);
            }

            definitionElement = ownerDocument.getElementById("webdeveloper-ruler-dimensions");

            // If the definition element is set
            if(definitionElement)
            {
                var height       = null;
                var stringBundle = document.getElementById("webdeveloper-string-bundle");
                var width        = null;

                webdeveloper_removeAllChildNodes(definitionElement);

                // If the ruler is being dragged or resized
                if(webdeveloper_rulerDrag || webdeveloper_rulerResize)
                {
                    // If the start x position is greater than the current x position
                    if(webdeveloper_rulerStartX > xPosition)
                    {
                        width = webdeveloper_rulerStartX - xPosition;
                    }
                    else
                    {
                        width = xPosition - webdeveloper_rulerStartX;
                    }

                    // If the start y position is greater than the end y position
                    if(webdeveloper_rulerStartY > yPosition)
                    {
                        height = webdeveloper_rulerStartY - yPosition;
                    }
                    else
                    {
                        height = yPosition - webdeveloper_rulerStartY;
                    }
                }
                else
                {
                    // If the start x position is greater than the end x position
                    if(webdeveloper_rulerStartX > webdeveloper_rulerEndX)
                    {
                        width = webdeveloper_rulerStartX - webdeveloper_rulerEndX;
                    }
                    else
                    {
                        width = webdeveloper_rulerEndX - webdeveloper_rulerStartX;
                    }

                    // If the start y position is greater than the end y position
                    if(webdeveloper_rulerStartY > webdeveloper_rulerEndY)
                    {
                        height = webdeveloper_rulerStartY - webdeveloper_rulerEndY;
                    }
                    else
                    {
                        height = webdeveloper_rulerEndY - webdeveloper_rulerStartY;
                    }
                }

                pElement = ownerDocument.createElement("p");
                pElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_width") + " = " + width));
                definitionElement.appendChild(pElement);

                pElement = ownerDocument.createElement("p");
                pElement.appendChild(ownerDocument.createTextNode(stringBundle.getString("webdeveloper_height") + " = " + height));
                definitionElement.appendChild(pElement);
            }

            // If the div element was found
            if(divElement)
            {
                webdeveloper_adjustElementPosition(divElement, xPosition, yPosition, 10);
            }
        }
    }
}

// Remove the ruler from the document
function webdeveloper_removeRuler(ownerDocument)
{
    var divElement = ownerDocument.getElementById("webdeveloper-ruler");

    // If the div element was found
    if(divElement)
    {
        divElement.parentNode.removeChild(divElement);
    }

    divElement = ownerDocument.getElementById("webdeveloper-ruler-outline");

    // If the div element was found
    if(divElement)
    {
        divElement.parentNode.removeChild(divElement);
    }
}

// Called when the ruler is selected
function webdeveloper_selectRuler(event)
{
    // If the click was not a right click
    if(event.button != 2)
    {
        var element = event.target;

        // If the element is set
        if(element)
        {
            var ownerDocument = element.ownerDocument;

            // If the element has an owner document
            if(ownerDocument)
            {
                var outlineElement = ownerDocument.getElementById("webdeveloper-ruler-outline");
                var xPosition      = event.pageX;
                var yPosition      = event.pageY;

                // If element is the container element
                if(element == ownerDocument.getElementById("webdeveloper-ruler-container"))
                {
                    webdeveloper_rulerMove  = true;
                    webdeveloper_rulerMoveX = xPosition - outlineElement.offsetLeft;
                    webdeveloper_rulerMoveY = yPosition - outlineElement.offsetTop;
                }
                else if(element == ownerDocument.getElementById("webdeveloper-ruler-north-east"))
                {
                    webdeveloper_rulerResize = true;
                    webdeveloper_rulerStartX = outlineElement.offsetLeft;
                    webdeveloper_rulerStartY = outlineElement.offsetTop + outlineElement.clientHeight;
                }
                else if(element == ownerDocument.getElementById("webdeveloper-ruler-north-west"))
                {
                    webdeveloper_rulerResize = true;
                    webdeveloper_rulerStartX = outlineElement.offsetLeft + outlineElement.clientWidth;
                    webdeveloper_rulerStartY = outlineElement.offsetTop + outlineElement.clientHeight;
                }
                else if(element == ownerDocument.getElementById("webdeveloper-ruler-south-east"))
                {
                    webdeveloper_rulerResize = true;
                    webdeveloper_rulerStartX = outlineElement.offsetLeft;
                    webdeveloper_rulerStartY = outlineElement.offsetTop;
                }
                else if(element == ownerDocument.getElementById("webdeveloper-ruler-south-west"))
                {
                    webdeveloper_rulerResize = true;
                    webdeveloper_rulerStartX = outlineElement.offsetLeft + outlineElement.clientWidth;
                    webdeveloper_rulerStartY = outlineElement.offsetTop;
                }
                else
                {
                    var divElement = ownerDocument.getElementById("webdeveloper-ruler");

                    webdeveloper_rulerDrag   = true;
                    webdeveloper_rulerEndX   = 0;
                    webdeveloper_rulerEndY   = 0;
                    webdeveloper_rulerStartX = xPosition;
                    webdeveloper_rulerStartY = yPosition;

                    // If the div element was found
                    if(divElement)
                    {
                        webdeveloper_updateRulerStart(ownerDocument);
                        webdeveloper_updateRulerEnd(ownerDocument);
                    }
                }
            }
        }

        event.preventDefault();
    }
}

// Update the ruler end information
function webdeveloper_updateRulerEnd(ownerDocument)
{
    var definitionElement = ownerDocument.getElementById("webdeveloper-ruler-end");

    // If the definition element is set
    if(definitionElement)
    {
        var pElement = ownerDocument.createElement("p");

        webdeveloper_removeAllChildNodes(definitionElement);

        pElement.appendChild(ownerDocument.createTextNode("X = " + webdeveloper_rulerEndX));
        definitionElement.appendChild(pElement);

        pElement = ownerDocument.createElement("p");
        pElement.appendChild(ownerDocument.createTextNode("Y = " + webdeveloper_rulerEndY));
        definitionElement.appendChild(pElement);
    }
}

// Update the ruler start information
function webdeveloper_updateRulerStart(ownerDocument)
{
    var definitionElement = ownerDocument.getElementById("webdeveloper-ruler-start");

    // If the definition element is set
    if(definitionElement)
    {
        var pElement = ownerDocument.createElement("p");

        webdeveloper_removeAllChildNodes(definitionElement);

        pElement.appendChild(ownerDocument.createTextNode("X = " + webdeveloper_rulerStartX));
        definitionElement.appendChild(pElement);

        pElement = ownerDocument.createElement("p");
        pElement.appendChild(ownerDocument.createTextNode("Y = " + webdeveloper_rulerStartY));
        definitionElement.appendChild(pElement);
    }
}
