require 'runit/testcase'
require 'runit/cui/testrunner'

require 'runtest'

class ClassTEST_RUNNABLE
  include TEST_RUNNABLE
end

class TestTEST_RUNNABLE < RUNIT::TestCase
  def setup
    @t = ClassTEST_RUNNABLE.new
    $".delete_if{|i| i == "testtest_runnable.rb"}
  end

  def test_load_test
    assert(!$".include?("testtest_runnable.rb"))
    @t.load_test("testtest_runnable.rb")
    assert($".include?("testtest_runnable.rb"))
  end

  def test_suite
    suite = @t.suite
    assert(suite.count_test_cases>0)
  end

  def teardown
    $".delete_if{|i| i == "testtest_runnable.rb"}
  end

end

if $0 == __FILE__
  testrunner = RUNIT::CUI::TestRunner.new
  if ARGV.size == 0
    suite = TestTEST_RUNNABLE.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestTEST_RUNNABLE.new(testmethod))
    end
  end
  testrunner.run(suite)
end
