require 'find'
class RD2HTML
  RD2 = 'rd2 -o'
  def initialize(docdir)
    @docdir = docdir
    Dir.chdir(@docdir)
  end

  def out_file(in_file)
    in_file.sub(/\.rd$/, '')
  end

  def cmd_rd2html(in_file)
    RD2 + out_file(in_file) + " " + in_file
  end

  def create_html_files
    Find.find(".") {|f|
      if /\.rd$/ =~ f
        create(f)
      end
    }
  end

  def create(in_file)
    system cmd_rd2html(in_file)
  end

  def rm_html_files
    Find.find(".") do |f|
      if /\.html/ =~ f 
	File.unlink(f)
      end
    end
  end

end

if __FILE__ == $0
  $pwd = Dir.pwd
  ['doc_en', 'doc_ja'].each do |docdir|
    Dir.chdir($pwd)
    en_doc = RD2HTML.new(docdir)
    if ARGV[0] == 'clean'
      en_doc.rm_html_files
    else
      en_doc.create_html_files
    end
  end
end

