# encoding: binary

# THIS IS AN AUTOGENERATED FILE, DO NOT MODIFY
# IT DIRECTLY ! FOR CHANGES, PLEASE UPDATE FILES
# IN THE ./codegen DIRECTORY OF THE AMQ-PROTOCOL REPOSITORY.

require "amq/pack"

require "amq/protocol/table"
require "amq/protocol/frame"

require "amq/protocol/constants"
require "amq/protocol/exceptions"

module AMQ
  module Protocol
    PROTOCOL_VERSION = "0.9.1".freeze
    PREAMBLE         = "AMQP\x00\x00\x09\x01".freeze
    DEFAULT_PORT     = 5672

    # @return [Array] Collection of subclasses of AMQ::Protocol::Class.
    def self.classes
      Protocol::Class.classes
    end

    # @return [Array] Collection of subclasses of AMQ::Protocol::Method.
    def self.methods
      Protocol::Method.methods
    end

    class ContentTooLarge < SoftError
      VALUE = 311
    end

    class NoRoute < SoftError
      VALUE = 312
    end

    class NoConsumers < SoftError
      VALUE = 313
    end

    class AccessRefused < SoftError
      VALUE = 403
    end

    class NotFound < SoftError
      VALUE = 404
    end

    class ResourceLocked < SoftError
      VALUE = 405
    end

    class PreconditionFailed < SoftError
      VALUE = 406
    end

    class ConnectionForced < HardError
      VALUE = 320
    end

    class InvalidPath < HardError
      VALUE = 402
    end

    class FrameError < HardError
      VALUE = 501
    end

    class SyntaxError < HardError
      VALUE = 502
    end

    class CommandInvalid < HardError
      VALUE = 503
    end

    class ChannelError < HardError
      VALUE = 504
    end

    class UnexpectedFrame < HardError
      VALUE = 505
    end

    class ResourceError < HardError
      VALUE = 506
    end

    class NotAllowed < HardError
      VALUE = 530
    end

    class NotImplemented < HardError
      VALUE = 540
    end

    class InternalError < HardError
      VALUE = 541
    end


    class Class
      @classes = Array.new

      def self.method_id
        @method_id
      end

      def self.name
        @name
      end

      def self.inherited(base)
        if self == Protocol::Class
          @classes << base
        end
      end

      def self.classes
        @classes
      end
    end

    class Method
      @methods = Array.new
      def self.method_id
        @method_id
      end

      def self.name
        @name
      end

      def self.index
        @index
      end

      def self.inherited(base)
        if self == Protocol::Method
          @methods << base
        end
      end

      def self.methods
        @methods
      end

      def self.split_headers(user_headers)
        properties, headers = {}, {}
        user_headers.each do |key, value|
          # key MUST be a symbol since symbols are not garbage-collected
          if Basic::PROPERTIES.include?(key)
            properties[key] = value
          else
            headers[key] = value
          end
        end

        return [properties, headers]
      end

      def self.encode_body(body, channel, frame_size)
        return [] if body.empty?

        # 8 = 1 + 2 + 4 + 1
        # 1 byte of frame type
        # 2 bytes of channel number
        # 4 bytes of frame payload length
        # 1 byte of payload trailer FRAME_END byte
        limit        = frame_size - 8
        return [BodyFrame.new(body, channel)] if body.bytesize < limit

        # Otherwise String#slice on 1.9 will operate with code points,
        # and we need bytes. MK.
        body.force_encoding("ASCII-8BIT") if RUBY_VERSION.to_f >= 1.9

        array = Array.new
        while body && !body.empty?
          payload, body = body[0, limit], body[limit, body.length - limit]
          array << BodyFrame.new(payload, channel)
        end

        array
      end

      def self.instantiate(*args, &block)
        self.new(*args, &block)
      end
    end

    class Connection < Protocol::Class
      @name = "connection"
      @method_id = 10



      class Start < Protocol::Method
        @name = "connection.start"
        @method_id = 10
        @index = 0x000A000A # 10, 10, 655370
        @packed_indexes = [10, 10].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          version_major = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          version_minor = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          table_length = Table.length(data[offset, 4])
          server_properties = Table.decode(data[offset, table_length + 4])
          offset += table_length + 4
          length = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          mechanisms = data[offset, length]
          offset += length
          length = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          locales = data[offset, length]
          offset += length
          self.new(version_major, version_minor, server_properties, mechanisms, locales)
        end

        attr_reader :version_major, :version_minor, :server_properties, :mechanisms, :locales
        def initialize(version_major, version_minor, server_properties, mechanisms, locales)
          @version_major = version_major
          @version_minor = version_minor
          @server_properties = server_properties
          @mechanisms = mechanisms
          @locales = locales
        end

        def self.has_content?
          false
        end


      end

      class StartOk < Protocol::Method
        @name = "connection.start-ok"
        @method_id = 11
        @index = 0x000A000B # 10, 11, 655371
        @packed_indexes = [10, 11].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'client_properties = nil', u"mechanism = u'PLAIN'", u'response = nil', u"locale = u'en_US'"]
        def self.encode(client_properties, mechanism, response, locale)
          channel = 0
          buffer = @packed_indexes.dup
          buffer << AMQ::Protocol::Table.encode(client_properties)
          buffer << mechanism.to_s.bytesize.chr
          buffer << mechanism.to_s
          buffer << [response.to_s.bytesize].pack(PACK_UINT32)
          buffer << response.to_s
          buffer << locale.to_s.bytesize.chr
          buffer << locale.to_s
          MethodFrame.new(buffer, channel)
        end

      end

      class Secure < Protocol::Method
        @name = "connection.secure"
        @method_id = 20
        @index = 0x000A0014 # 10, 20, 655380
        @packed_indexes = [10, 20].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          challenge = data[offset, length]
          offset += length
          self.new(challenge)
        end

        attr_reader :challenge
        def initialize(challenge)
          @challenge = challenge
        end

        def self.has_content?
          false
        end


      end

      class SecureOk < Protocol::Method
        @name = "connection.secure-ok"
        @method_id = 21
        @index = 0x000A0015 # 10, 21, 655381
        @packed_indexes = [10, 21].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'response = nil']
        def self.encode(response)
          channel = 0
          buffer = @packed_indexes.dup
          buffer << [response.to_s.bytesize].pack(PACK_UINT32)
          buffer << response.to_s
          MethodFrame.new(buffer, channel)
        end

      end

      class Tune < Protocol::Method
        @name = "connection.tune"
        @method_id = 30
        @index = 0x000A001E # 10, 30, 655390
        @packed_indexes = [10, 30].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          channel_max = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          frame_max = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          heartbeat = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          self.new(channel_max, frame_max, heartbeat)
        end

        attr_reader :channel_max, :frame_max, :heartbeat
        def initialize(channel_max, frame_max, heartbeat)
          @channel_max = channel_max
          @frame_max = frame_max
          @heartbeat = heartbeat
        end

        def self.has_content?
          false
        end


      end

      class TuneOk < Protocol::Method
        @name = "connection.tune-ok"
        @method_id = 31
        @index = 0x000A001F # 10, 31, 655391
        @packed_indexes = [10, 31].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'channel_max = false', u'frame_max = false', u'heartbeat = false']
        def self.encode(channel_max, frame_max, heartbeat)
          channel = 0
          buffer = @packed_indexes.dup
          buffer << [channel_max].pack(PACK_UINT16)
          buffer << [frame_max].pack(PACK_UINT32)
          buffer << [heartbeat].pack(PACK_UINT16)
          MethodFrame.new(buffer, channel)
        end

      end

      class Open < Protocol::Method
        @name = "connection.open"
        @method_id = 40
        @index = 0x000A0028 # 10, 40, 655400
        @packed_indexes = [10, 40].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u"virtual_host = u'/'", u'capabilities = EMPTY_STRING', u'insist = false']
        def self.encode(virtual_host)
          capabilities = EMPTY_STRING
          insist = false
          channel = 0
          buffer = @packed_indexes.dup
          buffer << virtual_host.to_s.bytesize.chr
          buffer << virtual_host.to_s
          buffer << capabilities.to_s.bytesize.chr
          buffer << capabilities.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if insist
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class OpenOk < Protocol::Method
        @name = "connection.open-ok"
        @method_id = 41
        @index = 0x000A0029 # 10, 41, 655401
        @packed_indexes = [10, 41].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          known_hosts = data[offset, length]
          offset += length
          self.new(known_hosts)
        end

        attr_reader :known_hosts
        def initialize(known_hosts)
          @known_hosts = known_hosts
        end

        def self.has_content?
          false
        end


      end

      class Close < Protocol::Method
        @name = "connection.close"
        @method_id = 50
        @index = 0x000A0032 # 10, 50, 655410
        @packed_indexes = [10, 50].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          reply_code = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          reply_text = data[offset, length]
          offset += length
          class_id = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          method_id = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          self.new(reply_code, reply_text, class_id, method_id)
        end

        attr_reader :reply_code, :reply_text, :class_id, :method_id
        def initialize(reply_code, reply_text, class_id, method_id)
          @reply_code = reply_code
          @reply_text = reply_text
          @class_id = class_id
          @method_id = method_id
        end

        def self.has_content?
          false
        end

        # @return
        # [u'reply_code = nil', u'reply_text = EMPTY_STRING', u'class_id = nil', u'method_id = nil']
        def self.encode(reply_code, reply_text, class_id, method_id)
          channel = 0
          buffer = @packed_indexes.dup
          buffer << [reply_code].pack(PACK_UINT16)
          buffer << reply_text.to_s.bytesize.chr
          buffer << reply_text.to_s
          buffer << [class_id].pack(PACK_UINT16)
          buffer << [method_id].pack(PACK_UINT16)
          MethodFrame.new(buffer, channel)
        end

      end

      class CloseOk < Protocol::Method
        @name = "connection.close-ok"
        @method_id = 51
        @index = 0x000A0033 # 10, 51, 655411
        @packed_indexes = [10, 51].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode()
          channel = 0
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

      class Blocked < Protocol::Method
        @name = "connection.blocked"
        @method_id = 60
        @index = 0x000A003C # 10, 60, 655420
        @packed_indexes = [10, 60].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          reason = data[offset, length]
          offset += length
          self.new(reason)
        end

        attr_reader :reason
        def initialize(reason)
          @reason = reason
        end

        def self.has_content?
          false
        end

        # @return
        # [u'reason = EMPTY_STRING']
        def self.encode(reason)
          channel = 0
          buffer = @packed_indexes.dup
          buffer << reason.to_s.bytesize.chr
          buffer << reason.to_s
          MethodFrame.new(buffer, channel)
        end

      end

      class Unblocked < Protocol::Method
        @name = "connection.unblocked"
        @method_id = 61
        @index = 0x000A003D # 10, 61, 655421
        @packed_indexes = [10, 61].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode()
          channel = 0
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

    end

    class Channel < Protocol::Class
      @name = "channel"
      @method_id = 20



      class Open < Protocol::Method
        @name = "channel.open"
        @method_id = 10
        @index = 0x0014000A # 20, 10, 1310730
        @packed_indexes = [20, 10].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'out_of_band = EMPTY_STRING']
        def self.encode(channel, out_of_band)
          buffer = @packed_indexes.dup
          buffer << out_of_band.to_s.bytesize.chr
          buffer << out_of_band.to_s
          MethodFrame.new(buffer, channel)
        end

      end

      class OpenOk < Protocol::Method
        @name = "channel.open-ok"
        @method_id = 11
        @index = 0x0014000B # 20, 11, 1310731
        @packed_indexes = [20, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          channel_id = data[offset, length]
          offset += length
          self.new(channel_id)
        end

        attr_reader :channel_id
        def initialize(channel_id)
          @channel_id = channel_id
        end

        def self.has_content?
          false
        end


      end

      class Flow < Protocol::Method
        @name = "channel.flow"
        @method_id = 20
        @index = 0x00140014 # 20, 20, 1310740
        @packed_indexes = [20, 20].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          active = (bit_buffer & (1 << 0)) != 0
          self.new(active)
        end

        attr_reader :active
        def initialize(active)
          @active = active
        end

        def self.has_content?
          false
        end

        # @return
        # [u'active = nil']
        def self.encode(channel, active)
          buffer = @packed_indexes.dup
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if active
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class FlowOk < Protocol::Method
        @name = "channel.flow-ok"
        @method_id = 21
        @index = 0x00140015 # 20, 21, 1310741
        @packed_indexes = [20, 21].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          active = (bit_buffer & (1 << 0)) != 0
          self.new(active)
        end

        attr_reader :active
        def initialize(active)
          @active = active
        end

        def self.has_content?
          false
        end

        # @return
        # [u'active = nil']
        def self.encode(channel, active)
          buffer = @packed_indexes.dup
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if active
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class Close < Protocol::Method
        @name = "channel.close"
        @method_id = 40
        @index = 0x00140028 # 20, 40, 1310760
        @packed_indexes = [20, 40].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          reply_code = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          reply_text = data[offset, length]
          offset += length
          class_id = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          method_id = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          self.new(reply_code, reply_text, class_id, method_id)
        end

        attr_reader :reply_code, :reply_text, :class_id, :method_id
        def initialize(reply_code, reply_text, class_id, method_id)
          @reply_code = reply_code
          @reply_text = reply_text
          @class_id = class_id
          @method_id = method_id
        end

        def self.has_content?
          false
        end

        # @return
        # [u'reply_code = nil', u'reply_text = EMPTY_STRING', u'class_id = nil', u'method_id = nil']
        def self.encode(channel, reply_code, reply_text, class_id, method_id)
          buffer = @packed_indexes.dup
          buffer << [reply_code].pack(PACK_UINT16)
          buffer << reply_text.to_s.bytesize.chr
          buffer << reply_text.to_s
          buffer << [class_id].pack(PACK_UINT16)
          buffer << [method_id].pack(PACK_UINT16)
          MethodFrame.new(buffer, channel)
        end

      end

      class CloseOk < Protocol::Method
        @name = "channel.close-ok"
        @method_id = 41
        @index = 0x00140029 # 20, 41, 1310761
        @packed_indexes = [20, 41].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode(channel)
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

    end

    class Exchange < Protocol::Class
      @name = "exchange"
      @method_id = 40



      class Declare < Protocol::Method
        @name = "exchange.declare"
        @method_id = 10
        @index = 0x0028000A # 40, 10, 2621450
        @packed_indexes = [40, 10].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'exchange = nil', u"type = u'direct'", u'passive = false', u'durable = false', u'auto_delete = false', u'internal = false', u'nowait = false', u'arguments = {}']
        def self.encode(channel, exchange, type, passive, durable, auto_delete, internal, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << exchange.to_s.bytesize.chr
          buffer << exchange.to_s
          buffer << type.to_s.bytesize.chr
          buffer << type.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if passive
          bit_buffer = bit_buffer | (1 << 1) if durable
          bit_buffer = bit_buffer | (1 << 2) if auto_delete
          bit_buffer = bit_buffer | (1 << 3) if internal
          bit_buffer = bit_buffer | (1 << 4) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class DeclareOk < Protocol::Method
        @name = "exchange.declare-ok"
        @method_id = 11
        @index = 0x0028000B # 40, 11, 2621451
        @packed_indexes = [40, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Delete < Protocol::Method
        @name = "exchange.delete"
        @method_id = 20
        @index = 0x00280014 # 40, 20, 2621460
        @packed_indexes = [40, 20].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'exchange = nil', u'if_unused = false', u'nowait = false']
        def self.encode(channel, exchange, if_unused, nowait)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << exchange.to_s.bytesize.chr
          buffer << exchange.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if if_unused
          bit_buffer = bit_buffer | (1 << 1) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class DeleteOk < Protocol::Method
        @name = "exchange.delete-ok"
        @method_id = 21
        @index = 0x00280015 # 40, 21, 2621461
        @packed_indexes = [40, 21].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Bind < Protocol::Method
        @name = "exchange.bind"
        @method_id = 30
        @index = 0x0028001E # 40, 30, 2621470
        @packed_indexes = [40, 30].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'destination = nil', u'source = nil', u'routing_key = EMPTY_STRING', u'nowait = false', u'arguments = {}']
        def self.encode(channel, destination, source, routing_key, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << destination.to_s.bytesize.chr
          buffer << destination.to_s
          buffer << source.to_s.bytesize.chr
          buffer << source.to_s
          buffer << routing_key.to_s.bytesize.chr
          buffer << routing_key.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class BindOk < Protocol::Method
        @name = "exchange.bind-ok"
        @method_id = 31
        @index = 0x0028001F # 40, 31, 2621471
        @packed_indexes = [40, 31].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Unbind < Protocol::Method
        @name = "exchange.unbind"
        @method_id = 40
        @index = 0x00280028 # 40, 40, 2621480
        @packed_indexes = [40, 40].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'destination = nil', u'source = nil', u'routing_key = EMPTY_STRING', u'nowait = false', u'arguments = {}']
        def self.encode(channel, destination, source, routing_key, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << destination.to_s.bytesize.chr
          buffer << destination.to_s
          buffer << source.to_s.bytesize.chr
          buffer << source.to_s
          buffer << routing_key.to_s.bytesize.chr
          buffer << routing_key.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class UnbindOk < Protocol::Method
        @name = "exchange.unbind-ok"
        @method_id = 51
        @index = 0x00280033 # 40, 51, 2621491
        @packed_indexes = [40, 51].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

    end

    class Queue < Protocol::Class
      @name = "queue"
      @method_id = 50



      class Declare < Protocol::Method
        @name = "queue.declare"
        @method_id = 10
        @index = 0x0032000A # 50, 10, 3276810
        @packed_indexes = [50, 10].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'passive = false', u'durable = false', u'exclusive = false', u'auto_delete = false', u'nowait = false', u'arguments = {}']
        def self.encode(channel, queue, passive, durable, exclusive, auto_delete, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if passive
          bit_buffer = bit_buffer | (1 << 1) if durable
          bit_buffer = bit_buffer | (1 << 2) if exclusive
          bit_buffer = bit_buffer | (1 << 3) if auto_delete
          bit_buffer = bit_buffer | (1 << 4) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class DeclareOk < Protocol::Method
        @name = "queue.declare-ok"
        @method_id = 11
        @index = 0x0032000B # 50, 11, 3276811
        @packed_indexes = [50, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          queue = data[offset, length]
          offset += length
          message_count = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          consumer_count = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          self.new(queue, message_count, consumer_count)
        end

        attr_reader :queue, :message_count, :consumer_count
        def initialize(queue, message_count, consumer_count)
          @queue = queue
          @message_count = message_count
          @consumer_count = consumer_count
        end

        def self.has_content?
          false
        end


      end

      class Bind < Protocol::Method
        @name = "queue.bind"
        @method_id = 20
        @index = 0x00320014 # 50, 20, 3276820
        @packed_indexes = [50, 20].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'exchange = nil', u'routing_key = EMPTY_STRING', u'nowait = false', u'arguments = {}']
        def self.encode(channel, queue, exchange, routing_key, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          buffer << exchange.to_s.bytesize.chr
          buffer << exchange.to_s
          buffer << routing_key.to_s.bytesize.chr
          buffer << routing_key.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class BindOk < Protocol::Method
        @name = "queue.bind-ok"
        @method_id = 21
        @index = 0x00320015 # 50, 21, 3276821
        @packed_indexes = [50, 21].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Purge < Protocol::Method
        @name = "queue.purge"
        @method_id = 30
        @index = 0x0032001E # 50, 30, 3276830
        @packed_indexes = [50, 30].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'nowait = false']
        def self.encode(channel, queue, nowait)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class PurgeOk < Protocol::Method
        @name = "queue.purge-ok"
        @method_id = 31
        @index = 0x0032001F # 50, 31, 3276831
        @packed_indexes = [50, 31].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          message_count = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          self.new(message_count)
        end

        attr_reader :message_count
        def initialize(message_count)
          @message_count = message_count
        end

        def self.has_content?
          false
        end


      end

      class Delete < Protocol::Method
        @name = "queue.delete"
        @method_id = 40
        @index = 0x00320028 # 50, 40, 3276840
        @packed_indexes = [50, 40].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'if_unused = false', u'if_empty = false', u'nowait = false']
        def self.encode(channel, queue, if_unused, if_empty, nowait)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if if_unused
          bit_buffer = bit_buffer | (1 << 1) if if_empty
          bit_buffer = bit_buffer | (1 << 2) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class DeleteOk < Protocol::Method
        @name = "queue.delete-ok"
        @method_id = 41
        @index = 0x00320029 # 50, 41, 3276841
        @packed_indexes = [50, 41].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          message_count = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          self.new(message_count)
        end

        attr_reader :message_count
        def initialize(message_count)
          @message_count = message_count
        end

        def self.has_content?
          false
        end


      end

      class Unbind < Protocol::Method
        @name = "queue.unbind"
        @method_id = 50
        @index = 0x00320032 # 50, 50, 3276850
        @packed_indexes = [50, 50].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'exchange = nil', u'routing_key = EMPTY_STRING', u'arguments = {}']
        def self.encode(channel, queue, exchange, routing_key, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          buffer << exchange.to_s.bytesize.chr
          buffer << exchange.to_s
          buffer << routing_key.to_s.bytesize.chr
          buffer << routing_key.to_s
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class UnbindOk < Protocol::Method
        @name = "queue.unbind-ok"
        @method_id = 51
        @index = 0x00320033 # 50, 51, 3276851
        @packed_indexes = [50, 51].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

    end

    class Basic < Protocol::Class
      @name = "basic"
      @method_id = 60

      PROPERTIES = [
        :content_type, # shortstr
        :content_encoding, # shortstr
        :headers, # table
        :delivery_mode, # octet
        :priority, # octet
        :correlation_id, # shortstr
        :reply_to, # shortstr
        :expiration, # shortstr
        :message_id, # shortstr
        :timestamp, # timestamp
        :type, # shortstr
        :user_id, # shortstr
        :app_id, # shortstr
        :cluster_id, # shortstr
      ]

      # 1 << 15
      def self.encode_content_type(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [0, 0x8000, buffer]
      end

      # 1 << 14
      def self.encode_content_encoding(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [1, 0x4000, buffer]
      end

      # 1 << 13
      def self.encode_headers(value)
        buffer = ''
        buffer << AMQ::Protocol::Table.encode(value)
        [2, 0x2000, buffer]
      end

      # 1 << 12
      def self.encode_delivery_mode(value)
        buffer = ''
        buffer << [value].pack(PACK_CHAR)
        [3, 0x1000, buffer]
      end

      # 1 << 11
      def self.encode_priority(value)
        buffer = ''
        buffer << [value].pack(PACK_CHAR)
        [4, 0x0800, buffer]
      end

      # 1 << 10
      def self.encode_correlation_id(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [5, 0x0400, buffer]
      end

      # 1 << 9
      def self.encode_reply_to(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [6, 0x0200, buffer]
      end

      # 1 << 8
      def self.encode_expiration(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [7, 0x0100, buffer]
      end

      # 1 << 7
      def self.encode_message_id(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [8, 0x0080, buffer]
      end

      # 1 << 6
      def self.encode_timestamp(value)
        buffer = ''
        buffer << AMQ::Pack.pack_uint64_big_endian(value)
        [9, 0x0040, buffer]
      end

      # 1 << 5
      def self.encode_type(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [10, 0x0020, buffer]
      end

      # 1 << 4
      def self.encode_user_id(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [11, 0x0010, buffer]
      end

      # 1 << 3
      def self.encode_app_id(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [12, 0x0008, buffer]
      end

      # 1 << 2
      def self.encode_cluster_id(value)
        buffer = ''
        buffer << value.to_s.bytesize.chr
        buffer << value.to_s
        [13, 0x0004, buffer]
      end



      def self.encode_properties(body_size, properties)
        pieces, flags = [], 0

        properties.reject {|key, value| value.nil?}.each do |key, value|
          i, f, result = self.__send__(:"encode_#{key}", value)
          flags |= f
          pieces[i] = result
        end

        # result = [60, 0, body_size, flags].pack('n2Qn')
        result = [60, 0].pack(PACK_UINT16_X2)
        result += AMQ::Pack.pack_uint64_big_endian(body_size)
        result += [flags].pack(PACK_UINT16)
        result + pieces.join(EMPTY_STRING)
      end

      # THIS DECODES ONLY FLAGS
      DECODE_PROPERTIES = {
        0x8000 => :content_type,
        0x4000 => :content_encoding,
        0x2000 => :headers,
        0x1000 => :delivery_mode,
        0x0800 => :priority,
        0x0400 => :correlation_id,
        0x0200 => :reply_to,
        0x0100 => :expiration,
        0x0080 => :message_id,
        0x0040 => :timestamp,
        0x0020 => :type,
        0x0010 => :user_id,
        0x0008 => :app_id,
        0x0004 => :cluster_id,
      }

      DECODE_PROPERTIES_TYPE = {
        0x8000 => :shortstr,
        0x4000 => :shortstr,
        0x2000 => :table,
        0x1000 => :octet,
        0x0800 => :octet,
        0x0400 => :shortstr,
        0x0200 => :shortstr,
        0x0100 => :shortstr,
        0x0080 => :shortstr,
        0x0040 => :timestamp,
        0x0020 => :shortstr,
        0x0010 => :shortstr,
        0x0008 => :shortstr,
        0x0004 => :shortstr,
      }

      # Hash doesn't give any guarantees on keys order, we will do it in a
      # straightforward way
      DECODE_PROPERTIES_KEYS = [
        0x8000,
        0x4000,
        0x2000,
        0x1000,
        0x0800,
        0x0400,
        0x0200,
        0x0100,
        0x0080,
        0x0040,
        0x0020,
        0x0010,
        0x0008,
        0x0004,
      ]

      def self.decode_properties(data)
        offset, data_length, properties = 0, data.bytesize, {}

        compressed_index = data[offset, 2].unpack(PACK_UINT16)[0]
        offset += 2
        while data_length > offset
          DECODE_PROPERTIES_KEYS.each do |key|
            next unless compressed_index >= key
            compressed_index -= key
            name = DECODE_PROPERTIES[key] || raise(RuntimeError.new("No property found for index #{index.inspect}!"))
            case DECODE_PROPERTIES_TYPE[key]
            when :shortstr
              size = data[offset, 1].unpack(PACK_CHAR)[0]
              offset += 1
              result = data[offset, size]
            when :octet
              size = 1
              result = data[offset, size].unpack(PACK_CHAR).first
            when :timestamp
              size = 8
              result = Time.at(data[offset, size].unpack(PACK_UINT32_X2).last)
            when :table
              size = 4 + data[offset, 4].unpack(PACK_UINT32)[0]
              result = Table.decode(data[offset, size])
            end
            properties[name] = result
            offset += size
          end
        end

        properties
      end

      class Qos < Protocol::Method
        @name = "basic.qos"
        @method_id = 10
        @index = 0x003C000A # 60, 10, 3932170
        @packed_indexes = [60, 10].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'prefetch_size = false', u'prefetch_count = false', u'global = false']
        def self.encode(channel, prefetch_size, prefetch_count, global)
          buffer = @packed_indexes.dup
          buffer << [prefetch_size].pack(PACK_UINT32)
          buffer << [prefetch_count].pack(PACK_UINT16)
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if global
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class QosOk < Protocol::Method
        @name = "basic.qos-ok"
        @method_id = 11
        @index = 0x003C000B # 60, 11, 3932171
        @packed_indexes = [60, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Consume < Protocol::Method
        @name = "basic.consume"
        @method_id = 20
        @index = 0x003C0014 # 60, 20, 3932180
        @packed_indexes = [60, 20].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'consumer_tag = EMPTY_STRING', u'no_local = false', u'no_ack = false', u'exclusive = false', u'nowait = false', u'arguments = {}']
        def self.encode(channel, queue, consumer_tag, no_local, no_ack, exclusive, nowait, arguments)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          buffer << consumer_tag.to_s.bytesize.chr
          buffer << consumer_tag.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if no_local
          bit_buffer = bit_buffer | (1 << 1) if no_ack
          bit_buffer = bit_buffer | (1 << 2) if exclusive
          bit_buffer = bit_buffer | (1 << 3) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          buffer << AMQ::Protocol::Table.encode(arguments)
          MethodFrame.new(buffer, channel)
        end

      end

      class ConsumeOk < Protocol::Method
        @name = "basic.consume-ok"
        @method_id = 21
        @index = 0x003C0015 # 60, 21, 3932181
        @packed_indexes = [60, 21].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          consumer_tag = data[offset, length]
          offset += length
          self.new(consumer_tag)
        end

        attr_reader :consumer_tag
        def initialize(consumer_tag)
          @consumer_tag = consumer_tag
        end

        def self.has_content?
          false
        end


      end

      class Cancel < Protocol::Method
        @name = "basic.cancel"
        @method_id = 30
        @index = 0x003C001E # 60, 30, 3932190
        @packed_indexes = [60, 30].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          consumer_tag = data[offset, length]
          offset += length
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          nowait = (bit_buffer & (1 << 0)) != 0
          self.new(consumer_tag, nowait)
        end

        attr_reader :consumer_tag, :nowait
        def initialize(consumer_tag, nowait)
          @consumer_tag = consumer_tag
          @nowait = nowait
        end

        def self.has_content?
          false
        end

        # @return
        # [u'consumer_tag = nil', u'nowait = false']
        def self.encode(channel, consumer_tag, nowait)
          buffer = @packed_indexes.dup
          buffer << consumer_tag.to_s.bytesize.chr
          buffer << consumer_tag.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class CancelOk < Protocol::Method
        @name = "basic.cancel-ok"
        @method_id = 31
        @index = 0x003C001F # 60, 31, 3932191
        @packed_indexes = [60, 31].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          consumer_tag = data[offset, length]
          offset += length
          self.new(consumer_tag)
        end

        attr_reader :consumer_tag
        def initialize(consumer_tag)
          @consumer_tag = consumer_tag
        end

        def self.has_content?
          false
        end


      end

      class Publish < Protocol::Method
        @name = "basic.publish"
        @method_id = 40
        @index = 0x003C0028 # 60, 40, 3932200
        @packed_indexes = [60, 40].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          true
        end

        # @return
        # [u'ticket = 0', u'exchange = EMPTY_STRING', u'routing_key = EMPTY_STRING', u'mandatory = false', u'immediate = false', 'user_headers = nil', 'payload = ""', 'frame_size = nil']
        def self.encode(channel, payload, user_headers, exchange, routing_key, mandatory, immediate, frame_size)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << exchange.to_s.bytesize.chr
          buffer << exchange.to_s
          buffer << routing_key.to_s.bytesize.chr
          buffer << routing_key.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if mandatory
          bit_buffer = bit_buffer | (1 << 1) if immediate
          buffer << [bit_buffer].pack(PACK_CHAR)
          frames = [MethodFrame.new(buffer, channel)]
          properties, headers = self.split_headers(user_headers)
          if properties.nil? or properties.empty?
            raise RuntimeError.new("Properties can not be empty!")
          end
          properties_payload = Basic.encode_properties(payload.bytesize, properties)
          frames << HeaderFrame.new(properties_payload, channel)
          frames += self.encode_body(payload, channel, frame_size)
          frames
        end

      end

      class Return < Protocol::Method
        @name = "basic.return"
        @method_id = 50
        @index = 0x003C0032 # 60, 50, 3932210
        @packed_indexes = [60, 50].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          reply_code = data[offset, 2].unpack(PACK_UINT16).first
          offset += 2
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          reply_text = data[offset, length]
          offset += length
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          exchange = data[offset, length]
          offset += length
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          routing_key = data[offset, length]
          offset += length
          self.new(reply_code, reply_text, exchange, routing_key)
        end

        attr_reader :reply_code, :reply_text, :exchange, :routing_key
        def initialize(reply_code, reply_text, exchange, routing_key)
          @reply_code = reply_code
          @reply_text = reply_text
          @exchange = exchange
          @routing_key = routing_key
        end

        def self.has_content?
          true
        end


      end

      class Deliver < Protocol::Method
        @name = "basic.deliver"
        @method_id = 60
        @index = 0x003C003C # 60, 60, 3932220
        @packed_indexes = [60, 60].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          consumer_tag = data[offset, length]
          offset += length
          delivery_tag = AMQ::Pack.unpack_uint64_big_endian(data[offset, 8]).first
          offset += 8
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          redelivered = (bit_buffer & (1 << 0)) != 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          exchange = data[offset, length]
          offset += length
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          routing_key = data[offset, length]
          offset += length
          self.new(consumer_tag, delivery_tag, redelivered, exchange, routing_key)
        end

        attr_reader :consumer_tag, :delivery_tag, :redelivered, :exchange, :routing_key
        def initialize(consumer_tag, delivery_tag, redelivered, exchange, routing_key)
          @consumer_tag = consumer_tag
          @delivery_tag = delivery_tag
          @redelivered = redelivered
          @exchange = exchange
          @routing_key = routing_key
        end

        def self.has_content?
          true
        end


      end

      class Get < Protocol::Method
        @name = "basic.get"
        @method_id = 70
        @index = 0x003C0046 # 60, 70, 3932230
        @packed_indexes = [60, 70].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'ticket = 0', u'queue = EMPTY_STRING', u'no_ack = false']
        def self.encode(channel, queue, no_ack)
          ticket = 0
          buffer = @packed_indexes.dup
          buffer << [ticket].pack(PACK_UINT16)
          buffer << queue.to_s.bytesize.chr
          buffer << queue.to_s
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if no_ack
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class GetOk < Protocol::Method
        @name = "basic.get-ok"
        @method_id = 71
        @index = 0x003C0047 # 60, 71, 3932231
        @packed_indexes = [60, 71].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          delivery_tag = AMQ::Pack.unpack_uint64_big_endian(data[offset, 8]).first
          offset += 8
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          redelivered = (bit_buffer & (1 << 0)) != 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          exchange = data[offset, length]
          offset += length
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          routing_key = data[offset, length]
          offset += length
          message_count = data[offset, 4].unpack(PACK_UINT32).first
          offset += 4
          self.new(delivery_tag, redelivered, exchange, routing_key, message_count)
        end

        attr_reader :delivery_tag, :redelivered, :exchange, :routing_key, :message_count
        def initialize(delivery_tag, redelivered, exchange, routing_key, message_count)
          @delivery_tag = delivery_tag
          @redelivered = redelivered
          @exchange = exchange
          @routing_key = routing_key
          @message_count = message_count
        end

        def self.has_content?
          true
        end


      end

      class GetEmpty < Protocol::Method
        @name = "basic.get-empty"
        @method_id = 72
        @index = 0x003C0048 # 60, 72, 3932232
        @packed_indexes = [60, 72].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          length = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          cluster_id = data[offset, length]
          offset += length
          self.new(cluster_id)
        end

        attr_reader :cluster_id
        def initialize(cluster_id)
          @cluster_id = cluster_id
        end

        def self.has_content?
          false
        end


      end

      class Ack < Protocol::Method
        @name = "basic.ack"
        @method_id = 80
        @index = 0x003C0050 # 60, 80, 3932240
        @packed_indexes = [60, 80].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          delivery_tag = AMQ::Pack.unpack_uint64_big_endian(data[offset, 8]).first
          offset += 8
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          multiple = (bit_buffer & (1 << 0)) != 0
          self.new(delivery_tag, multiple)
        end

        attr_reader :delivery_tag, :multiple
        def initialize(delivery_tag, multiple)
          @delivery_tag = delivery_tag
          @multiple = multiple
        end

        def self.has_content?
          false
        end

        # @return
        # [u'delivery_tag = false', u'multiple = false']
        def self.encode(channel, delivery_tag, multiple)
          buffer = @packed_indexes.dup
          buffer << AMQ::Pack.pack_uint64_big_endian(delivery_tag)
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if multiple
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class Reject < Protocol::Method
        @name = "basic.reject"
        @method_id = 90
        @index = 0x003C005A # 60, 90, 3932250
        @packed_indexes = [60, 90].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'delivery_tag = nil', u'requeue = true']
        def self.encode(channel, delivery_tag, requeue)
          buffer = @packed_indexes.dup
          buffer << AMQ::Pack.pack_uint64_big_endian(delivery_tag)
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if requeue
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class RecoverAsync < Protocol::Method
        @name = "basic.recover-async"
        @method_id = 100
        @index = 0x003C0064 # 60, 100, 3932260
        @packed_indexes = [60, 100].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'requeue = false']
        def self.encode(channel, requeue)
          buffer = @packed_indexes.dup
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if requeue
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class Recover < Protocol::Method
        @name = "basic.recover"
        @method_id = 110
        @index = 0x003C006E # 60, 110, 3932270
        @packed_indexes = [60, 110].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # [u'requeue = false']
        def self.encode(channel, requeue)
          buffer = @packed_indexes.dup
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if requeue
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class RecoverOk < Protocol::Method
        @name = "basic.recover-ok"
        @method_id = 111
        @index = 0x003C006F # 60, 111, 3932271
        @packed_indexes = [60, 111].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Nack < Protocol::Method
        @name = "basic.nack"
        @method_id = 120
        @index = 0x003C0078 # 60, 120, 3932280
        @packed_indexes = [60, 120].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          delivery_tag = AMQ::Pack.unpack_uint64_big_endian(data[offset, 8]).first
          offset += 8
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          multiple = (bit_buffer & (1 << 0)) != 0
          requeue = (bit_buffer & (1 << 1)) != 0
          self.new(delivery_tag, multiple, requeue)
        end

        attr_reader :delivery_tag, :multiple, :requeue
        def initialize(delivery_tag, multiple, requeue)
          @delivery_tag = delivery_tag
          @multiple = multiple
          @requeue = requeue
        end

        def self.has_content?
          false
        end

        # @return
        # [u'delivery_tag = false', u'multiple = false', u'requeue = true']
        def self.encode(channel, delivery_tag, multiple, requeue)
          buffer = @packed_indexes.dup
          buffer << AMQ::Pack.pack_uint64_big_endian(delivery_tag)
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if multiple
          bit_buffer = bit_buffer | (1 << 1) if requeue
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

    end

    class Tx < Protocol::Class
      @name = "tx"
      @method_id = 90



      class Select < Protocol::Method
        @name = "tx.select"
        @method_id = 10
        @index = 0x005A000A # 90, 10, 5898250
        @packed_indexes = [90, 10].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode(channel)
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

      class SelectOk < Protocol::Method
        @name = "tx.select-ok"
        @method_id = 11
        @index = 0x005A000B # 90, 11, 5898251
        @packed_indexes = [90, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Commit < Protocol::Method
        @name = "tx.commit"
        @method_id = 20
        @index = 0x005A0014 # 90, 20, 5898260
        @packed_indexes = [90, 20].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode(channel)
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

      class CommitOk < Protocol::Method
        @name = "tx.commit-ok"
        @method_id = 21
        @index = 0x005A0015 # 90, 21, 5898261
        @packed_indexes = [90, 21].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

      class Rollback < Protocol::Method
        @name = "tx.rollback"
        @method_id = 30
        @index = 0x005A001E # 90, 30, 5898270
        @packed_indexes = [90, 30].pack(PACK_UINT16_X2).freeze


        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode(channel)
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

      class RollbackOk < Protocol::Method
        @name = "tx.rollback-ok"
        @method_id = 31
        @index = 0x005A001F # 90, 31, 5898271
        @packed_indexes = [90, 31].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end


      end

    end

    class Confirm < Protocol::Class
      @name = "confirm"
      @method_id = 85



      class Select < Protocol::Method
        @name = "confirm.select"
        @method_id = 10
        @index = 0x0055000A # 85, 10, 5570570
        @packed_indexes = [85, 10].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          bit_buffer = data[offset, 1].unpack(PACK_CHAR).first
          offset += 1
          nowait = (bit_buffer & (1 << 0)) != 0
          self.new(nowait)
        end

        attr_reader :nowait
        def initialize(nowait)
          @nowait = nowait
        end

        def self.has_content?
          false
        end

        # @return
        # [u'nowait = false']
        def self.encode(channel, nowait)
          buffer = @packed_indexes.dup
          bit_buffer = 0
          bit_buffer = bit_buffer | (1 << 0) if nowait
          buffer << [bit_buffer].pack(PACK_CHAR)
          MethodFrame.new(buffer, channel)
        end

      end

      class SelectOk < Protocol::Method
        @name = "confirm.select-ok"
        @method_id = 11
        @index = 0x0055000B # 85, 11, 5570571
        @packed_indexes = [85, 11].pack(PACK_UINT16_X2).freeze

        # @return
        def self.decode(data)
          offset = 0
          self.new()
        end

        def initialize()
        end

        def self.has_content?
          false
        end

        # @return
        # []
        def self.encode(channel)
          buffer = @packed_indexes.dup
          MethodFrame.new(buffer, channel)
        end

      end

    end


    METHODS = begin
      Method.methods.inject(Hash.new) do |hash, klass|
        hash.merge!(klass.index => klass)
      end
    end
  end
end

