/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: get_infilenames.c,v 1.2 1999/01/15 02:19:14 lance Exp $ */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>

#include "data.h"
#include "option.h"

static int argv_index;

/* HERE:  I should have used the GNU getopt_long() to do this 
   in the file get_options.c .
   It's Okay no big loss this works. */

static char *find_filename(int argc, char **argv)
{
  int i,j;

  while(argv_index < argc)
    {
      while(argv[argv_index] == NULL && argv_index < argc)
	argv_index++;
      if(argv[argv_index][0] == '-')
	{
	  if(argv[argv_index][1] == '-')
	    {
	      if(argv[argv_index][2] != '\0')
		{
		  for(i=0;long_options[i].name != 0 &&
			strncmp(&argv[argv_index][2],long_options[i].name,
				j = strlen(long_options[i].name));
		      i++);
		  if(long_options[i].name == 0)
		    {
		      fprintf(stderr,
			      "%s ERROR:  unknown option --%s\n",argv[0],
			      &argv[argv_index][2]);
		       exit(1);
		    }
		  else if(long_options[i].has_arg && 
		     argv[argv_index][2+j] == '\0')
		    argv_index +=2;
		  else
		    argv_index++;
		}
	    }
	  else if(argv[argv_index][1] == '\0')
	    {
	      fprintf(stderr,"%s ERROR: unknown option %s\n",argv[0],
		      &argv[argv_index][0]);
	      exit(1);
	    }
	  else
	    {
	      for(i=0;short_options[i] != '\0' &&
		    short_options[i] != argv[argv_index][1];i++);
	      if(short_options[i] == '\0')
		{
		  fprintf(stderr,"%s ERROR: unknown option -%s\n",argv[0],
			  &argv[argv_index][1]);
		  exit(1);
		}
	      if(short_options[i+1] == ':' && 
		 argv[argv_index][2] == '\0' )
		argv_index +=2;
	      else
		argv_index++;
	    }
	}
      else
	{
	  argv_index++;
	  return argv[argv_index -1];
	}
    }
  
  return NULL;

}

void get_infilenames(int argc, char **argv,Plot *plot)
{
  char *file;
  int num_files;

  argv_index = 1;

  if(plot->infiles == NULL)
    {
      assert(plot->infiles = (char **) malloc(sizeof(char *)));
      plot->infiles[0] = NULL;
    }
  for(num_files =0;plot->infiles[num_files] != NULL;num_files++);

  while((file = find_filename(argc, argv)) != NULL)
    {
      num_files++;
      assert(plot->infiles = (char **) realloc(
	      (void *) plot->infiles, sizeof(char *)*(num_files + 1)));

      assert(plot->infiles[num_files -1]  = (char *) malloc(
	      sizeof(char)*(strlen(file)+1)));
      sprintf(plot->infiles[num_files -1],"%s",file);
      plot->infiles[num_files] = NULL;
    }

}
