/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2000, 2001, 2002, 2003 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/reference/license.html>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

#include <ql/Pricers/fdbermudanoption.hpp>

namespace QuantLib {

    #ifndef QL_DISABLE_DEPRECATED

    FdBermudanOption::FdBermudanOption(Option::Type type, Real underlying,
                                       Real strike, Spread dividendYield,
                                       Rate riskFreeRate, Time residualTime,
                                       Volatility volatility,
                                       const std::vector<Time>& dates,
                                       Size timeSteps, Size gridPoints)
    : FdMultiPeriodOption(type, underlying, strike, dividendYield,
                          riskFreeRate, residualTime, volatility,
                          gridPoints, dates, timeSteps) {}

    void FdBermudanOption::initializeStepCondition() const{
        stepCondition_ = boost::shared_ptr<StandardStepCondition> ();
    }

    void FdBermudanOption::executeIntermediateStep(Size ) const{

        Size size = intrinsicValues_.size();
        for(Size j = 0; j < size; j++)
            prices_[j] = std::max(prices_[j], intrinsicValues_[j]);
    }

    boost::shared_ptr<SingleAssetOption> FdBermudanOption::clone() const {
        return boost::shared_ptr<SingleAssetOption>(new FdBermudanOption(
                       payoff_.optionType(), underlying_, payoff_.strike(),
                       dividendYield_, riskFreeRate_, residualTime_,
                       volatility_, dates_, timeStepPerPeriod_, gridPoints_));
    }

    #endif

}
