

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: QLArray.i,v 1.7 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_array_i
#define quantlib_array_i

%include String.i

%{
using QuantLib::Array;
typedef QuantLib::Math::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::Math::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;
%}

// array as python shadow class

class Array {
    %pragma(ruby) include = "Enumerable";
  public:
    ~Array();
};

%typemap(ruby,in) VALUE {
    $target = $source;
};

%addmethods Array {
    void crash() {}
    Array(VALUE v) {
        if (rb_obj_is_kind_of(v,rb_cArray)) {
            int size = RARRAY(v)->len;
            Array* temp = new Array(size);
            for (int i=0; i<size; i++) {
                VALUE o = RARRAY(v)->ptr[i];
                if (o == Qnil)
                    (*temp)[i] = Null<double>();
                else if (FIXNUM_P(o))
                    (*temp)[i] = double(FIX2INT(o));
                else if (TYPE(o) == T_FLOAT)
                    (*temp)[i] = NUM2DBL(o);
                else
                    rb_raise(rb_eTypeError,
                        "wrong argument type (expected numbers)");
            }
            return temp;
        } else {
            rb_raise(rb_eTypeError,
                "wrong argument type (expected array)");
        }
    }
    String __str__() {
        String s = "(";
        for (int i=0; i<self->size(); i++) {
        	if (i != 0)
        		s += ", ";
        	s += QuantLib::DoubleFormatter::toString((*self)[i]);
        }
        s += ")";
        return s;
    }
    int __len__() {
        return self->size();
    }
    double __getitem__(int i) {
        if (i>=0 && i<self->size()) {
            return (*self)[i];
        } else if (i<0 && -i<=self->size()) {
            return (*self)[self->size()+i];
        } else {
            throw IndexError("Array index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
    void __setitem__(int i, double x) {
        if (i>=0 && i<self->size()) {
            (*self)[i] = x;
        } else if (i<0 && -i<=self->size()) {
            (*self)[self->size()+i] = x;
        } else {
            throw IndexError("Array index out of range");
        }
    }
    void each() {
        for (int i=0; i<self->size(); i++)
            rb_yield(rb_float_new((*self)[i]));
    }
};


// 2-D view

class LexicographicalViewColumn {
  private:
    // access control - no constructor exported
    LexicographicalViewColumn();
  public:
    ~LexicographicalViewColumn();
};

%addmethods LexicographicalViewColumn {
    void crash() {}
    double __getitem__(int i) {
        return (*self)[i];
    }
    void __setitem__(int i, double x) {
        (*self)[i] = x;
    }
};

class LexicographicalView {
  public:
    ~LexicographicalView();
    int xSize() const;
    int ySize() const;
};

%addmethods LexicographicalView {
    void crash() {}
    LexicographicalView(Array& a, int xSize) {
        return new LexicographicalView(a.begin(),a.end(),xSize);
    }
    LexicographicalViewColumn __getitem__(int i) {
        return (*self)[i];
    }
    String __str__() {
        String s;
        for (int j=0; j<self->ySize(); j++) {
    	    s += "\n";
            for (int i=0; i<self->xSize(); i++) {
                if (i != 0)
                    s += ",";
                s += QuantLib::DoubleFormatter::toString((*self)[i][j]);
            }
        }
        s += "\n";
        return s;
    }
};


#endif
