

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

//  $Id: DayCounters.i,v 1.11 2002/01/16 14:51:30 nando Exp $

#ifndef quantlib_day_counters_i
#define quantlib_day_counters_i

%include Date.i
%include String.i
%include Types.i

%{
using QuantLib::DayCounter;
using QuantLib::DayCounters::Actual360;
using QuantLib::DayCounters::Actual365;
using QuantLib::DayCounters::ActualActual;
using QuantLib::DayCounters::Thirty360;
%}

class DayCounter {
    %pragma(ruby) include = "Comparable";
  public:
    // constructor redefined below as string-based factory
    ~DayCounter();
    int dayCount(Date d1, Date d2);
};

// replicate the DayCounter interface
%addmethods DayCounter {
    void crash() {}
    DayCounter(const String& name) {
        String s = StringFormatter::toLowercase(name);
        if (s == "actact" || s == "act/act" || s == "act/act(b)")
            return new ActualActual(ActualActual::Bond);
        else if (s == "actacte" || s == "act/act(e)")
            return new ActualActual(ActualActual::Euro);
        else if (s == "actacth" || s == "act/act(h)")
            return new ActualActual(ActualActual::Historical);
        else if (s == "act360" || s == "act/360")
            return new Actual360;
        else if (s == "act365" || s == "act/365")
            return new Actual365;
        else if (s == "30/360" || s == "30/360us")
            return new Thirty360(Thirty360::USA);
        else if (s == "30/360e" || s == "30/360eu")
            return new Thirty360(Thirty360::European);
        else if (s == "30/360i" || s == "30/360it")
            return new Thirty360(Thirty360::Italian);
        else
            throw Error("Unknown day counter: " + name);
        QL_DUMMY_RETURN((DayCounter*)(0));
    }
    Time _yearFractionWithoutReference(const Date& d1, const Date& d2) {
        return self->yearFraction(d1,d2);
    }
    Time _yearFractionWithReference(const Date& d1, const Date& d2,
                                    const Date& refStart, const Date& refEnd) {
        return self->yearFraction(d1,d2,refStart,refEnd);
    }
    String __str__() {
        return self->name()+" day counter";
    }
    int __cmp__(const DayCounter& other) {
        return (*self == other ? 0 : 1);
    }
}


#endif
