=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: QuantLib.rb,v 1.7 2002/03/07 14:06:47 lballabio Exp $

require 'QuantLibc'

module QuantLibc

    # default arguments - SWIG can't parse these ones

    class Calendar
        def roll(d,convention='Following')
            _rollWithConvention(d,convention)
        end
        def advance(d,n,unit,convention='Following')
            _advanceWithConvention(d,n,unit,convention)
        end
    end

    class DayCounter
        def yearFraction(d1,d2,refStart=nil,refEnd=nil)
            if refStart and refEnd
                _yearFractionWithReference(d1,d2,refStart,refEnd)
            else
                _yearFractionWithoutReference(d1,d2)
            end
        end
    end

    # overloaded methods

    class TermStructure
        def zeroYield(x,extrapolate=false)
            if x.type == Float or x.type == Fixnum
                _zeroYieldVsTime(x,extrapolate)
            else
                _zeroYieldVsDate(x,extrapolate)
            end
        end
        def discount(x,extrapolate=false)
            if x.type == Float or x.type == Fixnum
                _discountVsTime(x,extrapolate)
            else
                _discountVsDate(x,extrapolate)
            end
        end
        def forward(x,extrapolate=false)
            if x.type == Float or x.type == Fixnum
                _forwardVsTime(x,extrapolate)
            else
                _forwardVsDate(x,extrapolate)
            end
        end
    end

    # mixins - SWIG still doesn't provide this

    # Comparable classes
    class Date
        include Comparable
    end
    class Calendar
        include Comparable
    end
    class DayCounter
        include Comparable
    end
    class HistoryEntry
        include Comparable
    end
    class HistoryValidEntry
        include Comparable
    end

    # Enumerable classes
    class Array
        include Enumerable
    end
    class IntVector
        include Enumerable
    end
    class DoubleVector
        include Enumerable
    end
    class DateVector
        include Enumerable
    end
    class CashFlowVector
        include Enumerable
    end
    class History
        include Enumerable
    end


    # this one could not be exported directly - too many arguments
    class SimpleSwap < Swap
        # SWIG-Ruby exports new, not initialize
        def SimpleSwap.new(payFixed,startDate,n,units,calendar,
                           rollingConvention, nominal, fixedFrequency,
                           fixedRate, fixedIsAdjusted, fixedDayCount,
                           floatingFrequency, index, fixingDays, spread,
                           termStructure)
            maturity = calendar.advance(startDate,n,units,rollingConvention)
            fixedLeg = FixedRateCouponVector.new([nominal],[fixedRate],
                           startDate,maturity,fixedFrequency,calendar,
                           rollingConvention,fixedIsAdjusted,fixedDayCount)
            floatLeg = FloatingRateCouponVector.new([nominal],startDate,maturity,
                           floatingFrequency,calendar,rollingConvention,
                           termStructure,index,fixingDays,[spread])
            if payFixed
                s = Swap.new(fixedLeg,floatLeg,termStructure)
                class << s
                  def fixedLegBPS
                      firstLegBPS
                  end
                  def floatingLegBPS
                      secondLegBPS
                  end
                end
                s
            else
                s = Swap.new(floatLeg,fixedLeg,termStructure)
                class << s
                  def fixedLegBPS
                      secondLegBPS
                  end
                  def floatingLegBPS
                      firstLegBPS
                  end
                end
                s
            end
        end
    end

end

QuantLib = QuantLibc

