//
// Copyright (c) 2015 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// FindSymbol.cpp:
//     Utility for finding a symbol node inside an AST tree.

#include "compiler/translator/FindSymbolNode.h"

#include "compiler/translator/IntermTraverse.h"
#include "compiler/translator/Symbol.h"

namespace sh
{

namespace
{

class SymbolFinder : public TIntermTraverser
{
  public:
    SymbolFinder(const TString &symbolName)
        : TIntermTraverser(true, false, false), mSymbolName(symbolName), mNodeFound(nullptr)
    {
    }

    void visitSymbol(TIntermSymbol *node)
    {
        if (node->variable().symbolType() != SymbolType::Empty && node->getName() == mSymbolName)
        {
            mNodeFound = node;
        }
    }

    bool isFound() const { return mNodeFound != nullptr; }
    const TIntermSymbol *getNode() const { return mNodeFound; }

  private:
    TString mSymbolName;
    TIntermSymbol *mNodeFound;
};

}  // anonymous namespace

const TIntermSymbol *FindSymbolNode(TIntermNode *root, const TString &symbolName)
{
    SymbolFinder finder(symbolName);
    root->traverse(&finder);
    return finder.getNode();
}

}  // namespace sh
