/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  ORBit-C++: C++ bindings for ORBit.
 *
 *  Copyright (C) 2001 Phil Dawes
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author:	Phil Dawes <philipd@users.sourceforge.net>
 *
 *  Purpose: Test insertion and extraction of idl types into anys.
 *
 */


#include "any-cpp-stubs.hh"
#include <iostream>

using namespace std;


// tests memory management of exceptions in anys
void
testException(){
	cout << "Testing any insertion/extraction with exceptions ...\n";
	test::TestException ex_in;
    test::TestException ex_out;

    ex_in.reason = "foo";

    ex_in.aseq.length(2);
    ex_in.aseq[0]=2;
    ex_in.aseq[1]=4;
    
    CORBA::Any any;
	any <<= ex_in;
	any <<= ex_in;
	any <<= ex_in;
    
	any >>= ex_out;
    
    g_assert(strcmp(ex_in.reason,ex_out.reason)==0);
    g_assert(ex_in.aseq.length() == ex_out.aseq.length());
    g_assert(ex_in.aseq[0] == ex_out.aseq[0]);
    g_assert(ex_in.aseq[1] == ex_out.aseq[1]);
    
}



int
main(int argc, char *argv[]) {

    //while(1)
    testException();
}
