// progressaction.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993 - 2003 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// ProgressAction is the base class for a heirarchy of classes which contain a
// pointer to an object and a method pointer for that object, and which takes
// a double value for the current percentage done, and returns TRUE if operation.
// should be cancelled.  See InterViews/action.h for the model on which this was based.

#ifndef PROGRESSACTION_H
#define PROGRESSACTION_H

#include <InterViews/resource.h>

class ProgressAction : virtual public Resource {
public:
	ProgressAction() {}
	virtual ~ProgressAction() {}
	virtual int operator () (double fractionDone) = 0;
};

template <class T>
class ProgressCallback : public ProgressAction {
public:
    ProgressCallback(T* t, int (T::*fun)(double)) : myObject(t), myFunction(fun) {}
    virtual int operator () (double fractionDone) {
		return (myObject->*myFunction)(fractionDone);
	}
private:
    T* myObject;
    int (T::*myFunction)(double);
};

#endif
