------------------------------------------------------------------------------
-- COMMON (C++ Interface)                                                   --
--                                                                          --
-- Part of TextTools                                                        --
-- Designed and Programmed by Ken O. Burtch                                 --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--                 Copyright (C) 1999-2003 Ken O. Burtch                    --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- This is maintained at http://www.vaxxine.com/pegasoft                    --
--                                                                          --
------------------------------------------------------------------------------
--with Gen_List;
--  pragma Elaborate( Gen_List ); -- remind Ada to elaborate generics first
--with Ada; use Ada;
--with Ada.Strings; use Ada.Strings; -- overrides our "strings" package
--with Ada.Strings.Bounded;
--with Ada.Strings.Maps;
--
with Interfaces.C;
use  Interfaces.C;
-- C language support

package body Common.CPP is


-- Str255 Bounded String: C++ wrapper functions

--type Str255List_List is record
--     list : Str255List.List;
--end record;
--pragma export( CPP, Str255List_List, "str255list_list" );

--procedure Str255List_Init( TheList : in out Str255List_List ) is
--begin
--  TheList.List.First := null;
--  TheList.List.Last := null;
--  TheList.List.Count := 0;
--  TheList.List.FreeCache := null;
--  TheList.List.LastRec := 0;
--  TheList.List.LastPtr := null;
--end Str255List_Init;

procedure Str255List_GetAllocation( allocation : out Str255List.AListIndex ) is
begin
  Str255List.GetAllocation( allocation );
end Str255List_GetAllocation;

function Str255List_MemoryLeak( allocation : in Str255List.AListIndex ) return boolean is
begin
  return Str255List.MemoryLeak( allocation );
end Str255List_MemoryLeak;

procedure Str255List_Compact( TheList : in out Str255List_List ) is
begin
  Str255List.Compact( TheList.List );
end Str255List_Compact;

procedure Str255List_Clear( TheList : in out Str255List_List ) is
begin
  Str255List.Clear( TheList.List );
end Str255List_Clear;

procedure Str255List_Copy( FromList, ToList : in out Str255List_List ) is
begin
  Str255List.Copy( FromList.List, ToList.List );
end Str255List_Copy;

procedure Str255List_Copy2( FromList, ToList1, ToList2 : in out Str255List_List ) is
begin
  Str255List.Copy( FromList.List, ToList1.List, ToList2.List );
end Str255List_Copy2;

procedure Str255List_Move( FromList, ToList : in out Str255List_List ) is
begin
  Str255List.Move( FromList.List, ToList.List );
end Str255List_Move;

procedure Str255List_Swap( List1, List2 : in out Str255List_List ) is
begin
  Str255List.Move( List1.List, List2.List );
end Str255List_Swap;

procedure Str255List_Push( TheList : in out Str255List_List; NewData : Str255 ) is
begin
  Str255List.Push( TheList.List, NewData );
end Str255List_Push;

procedure Str255List_Queue( TheList : in out Str255List_List ; Data : Str255 ) is
begin
  Str255List.Queue( TheList.List, Data );
end Str255List_Queue;

procedure Str255List_Insert( TheList : in out Str255List_List ; Data : Str255 ) is
begin
  Str255List.Insert( TheList.List, Data );
end Str255List_Insert;

procedure Str255List_Insert2( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex; Data : Str255 ) is
begin
  Str255List.Insert( TheList.List, atIndex, Data );
end Str255List_Insert2;

procedure Str255List_Pull( TheList : in out Str255List_List ; data : in out Str255 ) is
begin
  Str255List.Pull( TheList.List, data );
end Str255List_Pull;

procedure Str255List_Discard( TheList : in out Str255List_List ) is
begin
  Str255List.Pull( TheList.List );
end Str255List_Discard;

procedure Str255List_Cut( TheList : in out Str255List_List; atIndex : Str255List.AListIndex; data : in out Str255 ) is
begin
  Str255List.Cut( TheList.List, atIndex, data );
end Str255List_Cut;

procedure Str255List_ClearItem( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex ) is
begin
   Str255List.Clear( TheList.List, atIndex );
end Str255List_ClearItem;

procedure Str255List_Replace( TheList : in out Str255List_List; atIndex : Str255List.AListIndex; data : Str255 ) is
begin
   Str255List.Replace( TheList.List, atIndex, data );
end Str255List_Replace;

procedure Str255List_Find( TheList : in out Str255List_List ; atIndex : Str255List.AListIndex ; data : in out Str255 ) is
begin
   Str255List.Find( TheList.List, atIndex, data );
end Str255List_Find;

procedure Str255List_Lookup( TheList : in out Str255List_List ; data : Str255; start : Str255List.AListIndex; FoundAt : in out Str255List.AListIndex ) is
begin
   Str255List.Find( TheList.List, data, start, FoundAt );
end Str255List_Lookup;

function Str255List_Length( TheList : in Str255List_List ) return Str255List.AListIndex is
begin
   return Str255List.Length( TheList.List );
end Str255List_Length;

function Str255List_IsEmpty( TheList : in Str255List_List ) return boolean is
begin
   return Str255List.IsEmpty( TheList.List );
end Str255List_IsEmpty;

procedure Str255List_SubList( TheList : in out Str255List_List; index, len : Str255List.AListIndex; Result : in out Str255List_List ) is
begin
   Str255List.SubList( TheList.List, index, len, Result.List );
end Str255List_SubList;

procedure Str255List_Concat( List1, List2 : Str255List_List; Result : in out Str255List_List ) is
begin
   Str255List.Concat( List1.List, List2.List, Result.List );
end Str255List_Concat;


-- Boolean List: C++ wrapper functions


--procedure BooleanList_Init( TheList : in out BooleanList_List ) is
--begin
--  TheList.List.First := null;
--  TheList.List.Last := null;
--  TheList.List.Count := 0;
--  TheList.List.FreeCache := null;
--  TheList.List.LastRec := 0;
--  TheList.List.LastPtr := null;
--end BooleanList_Init;

procedure BooleanList_GetAllocation( allocation : out BooleanList.AListIndex ) is
begin
  BooleanList.GetAllocation( allocation );
end BooleanList_GetAllocation;

function BooleanList_MemoryLeak( allocation : in BooleanList.AListIndex ) return boolean is
begin
  return BooleanList.MemoryLeak( allocation );
end BooleanList_MemoryLeak;

procedure BooleanList_Compact( TheList : in out BooleanList_List ) is
begin
  BooleanList.Compact( TheList.List );
end BooleanList_Compact;

procedure BooleanList_Clear( TheList : in out BooleanList_List ) is
begin
  BooleanList.Clear( TheList.List );
end BooleanList_Clear;

procedure BooleanList_Copy( FromList, ToList : in out BooleanList_List ) is
begin
  BooleanList.Copy( FromList.List, ToList.List );
end BooleanList_Copy;

procedure BooleanList_Copy2( FromList, ToList1, ToList2 : in out BooleanList_List ) is
begin
  BooleanList.Copy( FromList.List, ToList1.List, ToList2.List );
end BooleanList_Copy2;

procedure BooleanList_Move( FromList, ToList : in out BooleanList_List ) is
begin
  BooleanList.Move( FromList.List, ToList.List );
end BooleanList_Move;

procedure BooleanList_Swap( List1, List2 : in out BooleanList_List ) is
begin
  BooleanList.Swap( List1.List, List2.List );
end BooleanList_Swap;

procedure BooleanList_Push( TheList : in out BooleanList_List; NewData : boolean ) is
begin
  BooleanList.Push( TheList.List, NewData );
end BooleanList_Push;

procedure BooleanList_Queue( TheList : in out BooleanList_List ; Data : boolean ) is
begin
  BooleanList.Queue( TheList.List, Data );
end BooleanList_Queue;

procedure BooleanList_Insert( TheList : in out BooleanList_List ; Data : boolean ) is
begin
  BooleanList.Insert( TheList.List, Data );
end BooleanList_Insert;

procedure BooleanList_Insert2( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex; Data : boolean ) is
begin
  BooleanList.Insert( TheList.List, atIndex, Data );
end BooleanList_Insert2;

procedure BooleanList_Pull( TheList : in out BooleanList_List ; data : in out boolean ) is
begin
  BooleanList.Pull( TheList.List, data );
end BooleanList_Pull;

procedure BooleanList_Discard( TheList : in out BooleanList_List ) is
begin
  BooleanList.Pull( TheList.List );
end BooleanList_Discard;

procedure BooleanList_Cut( TheList : in out BooleanList_List; atIndex : BooleanList.AListIndex; data : in out boolean ) is
begin
  BooleanList.Cut( TheList.List, atIndex, data );
end BooleanList_Cut;

procedure BooleanList_ClearItem( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex ) is
begin
  BooleanList.Clear( TheList.List, atIndex );
end BooleanList_ClearItem;

procedure BooleanList_Replace( TheList : in out BooleanList_List; atIndex : BooleanList.AListIndex; data : boolean ) is
begin
  BooleanList.Replace( TheList.List, atIndex, data );
end BooleanList_Replace;

procedure BooleanList_Find( TheList : in out BooleanList_List ; atIndex : BooleanList.AListIndex ; data : in out boolean ) is
begin
  BooleanList.Find( TheList.List, atIndex, data );
end BooleanList_Find;

procedure BooleanList_Lookup( TheList : in out BooleanList_List ; data : boolean; start : BooleanList.AListIndex; FoundAt : in out BooleanList.AListIndex ) is
begin
  BooleanList.Find( TheList.List, data, start, FoundAt );
end BooleanList_Lookup;

function BooleanList_Length( TheList : in BooleanList_List ) return BooleanList.AListIndex is
begin
  return BooleanList.Length( TheList.List );
end BooleanList_Length;

function BooleanList_IsEmpty( TheList : in BooleanList_List ) return boolean is
begin
  return BooleanList.IsEmpty( TheList.List );
end BooleanList_IsEmpty;

procedure BooleanList_SubList( TheList : in out BooleanList_List; index, len : BooleanList.AListIndex; Result : in out BooleanList_List ) is
begin
  BooleanList.SubList( TheList.List, index, len, Result.List );
end BooleanList_SubList;

procedure BooleanList_Concat( List1, List2 : BooleanList_List; Result : in out BooleanList_List ) is
begin
  BooleanList.Concat( List1.List, List2.List, Result.List );
end BooleanList_Concat;

end Common.CPP;


