/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.jaxws.wizards;

import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.xml.jaxb.spi.SchemaCompiler;
import org.netbeans.modules.xml.jaxb.spi.SchemaCompilerProvider;

/**
 *
 * @author mkuchtiak
 */
@org.openide.util.lookup.ServiceProvider(service=org.netbeans.modules.xml.jaxb.spi.SchemaCompilerProvider.class)
public class MavenSchemaCompilerProvider implements SchemaCompilerProvider {

    @Override
    public SchemaCompiler getSchemaCompiler(Project project) {
        if (project.getLookup().lookup(NbMavenProject.class) != null) {
            return new MavenSchemaCompiler(project);
        } else {
            return null;
        }
    }

}
