/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.BasicStroke;
import java.io.IOException;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class BasicStrokeWriteHandler
extends AbstractXmlWriteHandler {
    private String toString(float[] dashArray) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < dashArray.length) {
            float f = dashArray[i];
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append(f);
            ++i;
        }
        return buffer.toString();
    }

    public void write(String tagName, Object object, XMLWriter writer, String mPlexAttribute, String mPlexValue) throws IOException, XMLWriterException {
        BasicStroke stroke = (BasicStroke)object;
        float[] dashArray = stroke.getDashArray();
        float dashPhase = stroke.getDashPhase();
        int endCap = stroke.getEndCap();
        int lineJoin = stroke.getLineJoin();
        float lineWidth = stroke.getLineWidth();
        float miterLimit = stroke.getMiterLimit();
        AttributeList attribs = new AttributeList();
        if (mPlexAttribute != null) {
            attribs.setAttribute(mPlexAttribute, mPlexValue);
        }
        attribs.setAttribute("type", "basic");
        attribs.setAttribute("endCap", String.valueOf(endCap));
        attribs.setAttribute("lineJoin", String.valueOf(lineJoin));
        attribs.setAttribute("lineWidth", String.valueOf(lineWidth));
        attribs.setAttribute("miterLimit", String.valueOf(miterLimit));
        if (dashArray != null) {
            attribs.setAttribute("dashArray", this.toString(dashArray));
            attribs.setAttribute("dashPhase", String.valueOf(dashPhase));
        }
        writer.writeTag(tagName, attribs, true);
    }
}

