/*
 * ept-cache - Commandline interface to the ept library
 *
 * Copyright (C) 2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EPTCACHE_INFO_H
#define EPTCACHE_INFO_H

#include <ept/debtags/tag.h>

#include <string>
#include <set>

namespace ept {
namespace apt {
class PackageRecord;
}
}

/**
 * Information about a package.
 *
 * This allows to have a stream of:
 * \l names
 * \l package records
 * \l tags
 * \l popcon scores
 * \l xapian scores
 *
 * All optional and only retrieved on demand
 */
struct Info
{
	std::string name;

	// This is only available if the info stream is generated by a Xapian
	// search.  Therefore there is no wantXapian() method.
	bool has_xapian;
	int xapian_score;

	bool deallocate_record;
	ept::apt::PackageRecord* record;

	bool has_tags;
	std::set<ept::debtags::Tag> tags;

	bool has_popcon;
	float popcon;

	bool has_local;
	float tfidf;

	Info(const std::string& name);
	Info(const Info& i);
	~Info();

	Info& operator=(const Info& i);

	void wantRecord();
	void wantTags();
	void wantPopcon();
	void wantPopconLocal();
};

#endif
// vim:set ts=4 sw=4:
