// Author: Enrico Zini with help from Peter Rockai
// License: GPL

#include <ept/forward.h>
#include <ept/configuration/apt.h>
#include <ept/init.h>
#include <ept/cache/apt/packages.h>
#include <ept/cache/apt/packages.tcc>
#include <ept/predicate/factory.h>
#include <ept/predicate/combinators.h>
#include <ept/predicate/matchers.h>

#include <iostream>
#include <ctype.h>
#include <time.h>

void printClocks(const char *msg) {
    static clock_t t = 0;
    clock_t x = clock();
    std::cerr << msg << "; last = " << t / 1000.0
              << ", current = " << x / 1000.0
              << ", diff = " << (x - t) / 1000.0 << std::endl;
    t = x;
}

using namespace ept;
using namespace configuration::apt;
// using namespace ept::t::predicate;

#define AUTO(y, x...) typeof(x) y = x

int main(int argc, char* argv[])
{
	using namespace ept::configuration;
	using namespace std;

	ept::init();
	printClocks( "init" );

	std::string pat = argv[1];

	// Access the package cache
    cache::Aggregator agg;

    cache::Package p;
    AUTO( fr, filteredRange(
        agg.index().range(),
        match::Package::longDescription( pat )
        or match::Package::name( pat ) ) );
    /* wibble::Range< cache::Package<> > fr = filteredRange(
        pc.range(),
        predicate::Package::description( pat )
        or predicate::Package::name( pat ) ); */

	for( AUTO( i, fr.begin() ); i != fr.end(); ++ i )
		std::cout << i->name( std::string( "[null]" ) )
			<< " - " << i->shortDescription( std::string( "[null]" ) ) << std::endl;

	printClocks( "done" );

	/* for( AUTO( i, fr.begin() ); i != fr.end(); ++ i )
		std::cout << i->name( std::string( "[null]" ) )
			<< " - " << i->shortDescription( std::string( "[null]" ) ) << std::endl;

            printClocks( "reiterated" ); */

	return 0;
}

