/**
   @file cache/component/state.cpp
   @author Peter Rockai <me@mornfall.net>
*/

#include <ept/tests/test-utils.h>
#include <ept/cache/cache.h>

namespace tut {

using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_apt_state_shar : common {};
TESTGRP( cache_apt_state );

template<> template<>
void to::test<1>()
{
    State *s1 = &apt.state();
    State *s2 = new State( *s1 );
}

template<> template<>
void to::test<2>()
{
    cache::Package gcide = apt.index().packageByName("dict-gcide"),
                   dictd = apt.index().packageByName("dictd");
    ensure( dictd.isInstalled() );
    ensure( gcide.isInstalled() );
    dictd.editor( apt ).markRemove();
    ensure( dictd.markedRemove() );
    ensure( gcide.markedRemove() );
}

template<> template<>
void to::test<3>()
{
    cache::Package gcide = apt.index().packageByName("dict-gcide"),
                   dictd = apt.index().packageByName("dictd");
    ensure( dictd.isInstalled() );
    ensure( gcide.isInstalled() );
    dictd.editor( apt ).markRemove();
    ensure( dictd.markedRemove() );
    ensure( gcide.markedRemove() );
    gcide.editor( apt ).markKeep();
    ensure( gcide.markedKeep() );
    ensure( dictd.markedKeep() );
}

template<> template<>
void to::test<4>()
{
    cache::Package gcide = apt.index().packageByName("dict-gcide"),
                   dictd = apt.index().packageByName("dictd");
    ensure( dictd.isInstalled() );
    ensure( gcide.isInstalled() );
    dictd.editor( apt ).markPurge();
    ensure( gcide.markedRemove() );
    ensure( dictd.markedPurge() );
}

template<> template<>
void to::test<5>()
{
    cache::Package dictd = apt.index().packageByName("dictd");
    ensure( dictd.isInstalled() );
    dictd.editor( apt ).markReInstall();
    ensure( dictd.markedReInstall() );
}

template<> template<>
void to::test<6>()
{
    ensure_equals( State::sizeString( 8192 ), "8K" );
    ensure_equals( State::sizeString( -8192 ), "-8K" );
    ensure_equals( State::sizeString( 8192 * 1024 ), "8M" );
    ensure_equals( State::sizeString( 8192.0 * 1024 * 1024 ), "8G" );
    ensure_equals( State::sizeString( 8192.0 * 1024 * 1024 * 1024 ), "8192G" );
    ensure_equals( State::sizeString( -8192 * 1024 ), "-8M" );
    ensure_equals( State::sizeString( -(8192 + 700) * 1024  ), "-9M" );
    ensure_equals( State::sizeString( -(8192 + 300) * 1024  ), "-8M" );
}

template<> template<>
void to::test<7>()
{
    Version v = apt.index().packageByName( "exim4" ).candidateVersion();
    ensure( v.valid() );
}

template<> template<>
void to::test<8>()
{
    Package p = apt.index().packageByName( "gnupg" );
    ensure( p.isInstalled() );
    ensure( p.isUpgradable() );
}

template<> template<>
void to::test<9>()
{
    cache::Package dictd = apt.index().packageByName("dictd");
    ensure( dictd.isInstalled() );
    dictd.editor( apt ).markRemove();
    ensure( dictd.markedRemove() );
    apt.reload();
    ensure( !dictd.markedRemove() );
}

}

#include <ept/cache/apt/state.tcc>
#include <ept/cache/apt/packages.tcc>
